// Copyright 2017 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package template

import (
	"context"
	"errors"
	"fmt"
	"net"
	"strings"

	"github.com/gogo/protobuf/proto"

	istio_adapter_model_v1beta1 "istio.io/api/mixer/adapter/model/v1beta1"
	istio_policy_v1beta1 "istio.io/api/policy/v1beta1"
	"istio.io/istio/mixer/pkg/adapter"
	"istio.io/istio/mixer/pkg/attribute"
	"istio.io/istio/mixer/pkg/expr"
	"istio.io/istio/mixer/pkg/il/compiled"
	"istio.io/istio/mixer/pkg/template"
	"istio.io/istio/pkg/log"

	"istio.io/istio/mixer/adapter/kubernetesenv/template"

	"istio.io/istio/mixer/adapter/servicecontrol/template/servicecontrolreport"

	"istio.io/istio/mixer/template/apikey"

	"istio.io/istio/mixer/template/authorization"

	"istio.io/istio/mixer/template/checknothing"

	"istio.io/istio/mixer/template/listentry"

	"istio.io/istio/mixer/template/logentry"

	"istio.io/istio/mixer/template/metric"

	"istio.io/istio/mixer/template/quota"

	"istio.io/istio/mixer/template/reportnothing"

	"istio.io/istio/mixer/template/tracespan"

	"time"
)

// Add void usages for some imports so that go linter does not complain in case the imports does not get used in the
// below codegen.
var (
	_ net.IP
	_ istio_policy_v1beta1.AttributeManifest
	_ = strings.Reader{}
)

type (
	getFn         func(name string) (value interface{}, found bool)
	namesFn       func() []string
	doneFn        func()
	debugStringFn func() string
	wrapperAttr   struct {
		get         getFn
		names       namesFn
		done        doneFn
		debugString debugStringFn
	}
)

func newWrapperAttrBag(get getFn, names namesFn, done doneFn, debugString debugStringFn) attribute.Bag {
	return &wrapperAttr{
		debugString: debugString,
		done:        done,
		get:         get,
		names:       names,
	}
}

// Get returns an attribute value.
func (w *wrapperAttr) Get(name string) (value interface{}, found bool) {
	return w.get(name)
}

// Names returns the names of all the attributes known to this bag.
func (w *wrapperAttr) Names() []string {
	return w.names()
}

// Done indicates the bag can be reclaimed.
func (w *wrapperAttr) Done() {
	w.done()
}

// String provides a dump of an attribute Bag that avoids affecting the
// calculation of referenced attributes.
func (w *wrapperAttr) String() string {
	return w.debugString()
}

var (
	SupportedTmplInfo = map[string]template.Info{

		adapter_template_kubernetes.TemplateName: {
			Name:               adapter_template_kubernetes.TemplateName,
			Impl:               "adapter.template.kubernetes",
			CtrCfg:             &adapter_template_kubernetes.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_ATTRIBUTE_GENERATOR,
			BldrInterfaceName:  adapter_template_kubernetes.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: adapter_template_kubernetes.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(adapter_template_kubernetes.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(adapter_template_kubernetes.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *adapter_template_kubernetes.InstanceParam,
					path string) (proto.Message, error)

				_ = BuildTemplate

				BuildTemplate = func(param *adapter_template_kubernetes.InstanceParam,
					path string) (proto.Message, error) {

					if param == nil {
						return nil, nil
					}

					var err error = nil

					if param.SourceUid != "" {
						if t, e := tEvalFn(param.SourceUid); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"SourceUid", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"SourceUid", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.SourceIp != "" {
						if t, e := tEvalFn(param.SourceIp); e != nil || t != istio_policy_v1beta1.IP_ADDRESS {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"SourceIp", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"SourceIp", t, istio_policy_v1beta1.IP_ADDRESS)
						}
					}

					if param.DestinationUid != "" {
						if t, e := tEvalFn(param.DestinationUid); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"DestinationUid", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"DestinationUid", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.DestinationIp != "" {
						if t, e := tEvalFn(param.DestinationIp); e != nil || t != istio_policy_v1beta1.IP_ADDRESS {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"DestinationIp", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"DestinationIp", t, istio_policy_v1beta1.IP_ADDRESS)
						}
					}

					if param.OriginUid != "" {
						if t, e := tEvalFn(param.OriginUid); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"OriginUid", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"OriginUid", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.OriginIp != "" {
						if t, e := tEvalFn(param.OriginIp); e != nil || t != istio_policy_v1beta1.IP_ADDRESS {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"OriginIp", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"OriginIp", t, istio_policy_v1beta1.IP_ADDRESS)
						}
					}

					return nil, err

				}

				instParam := cp.(*adapter_template_kubernetes.InstanceParam)

				const fullOutName = "adapter_template_kubernetes.output."
				for attr, exp := range instParam.AttributeBindings {
					expr := strings.Replace(exp, "$out.", fullOutName, -1)
					t1, err := tEvalFn(expr)
					if err != nil {
						return nil, fmt.Errorf("error evaluating AttributeBinding expression '%s' for attribute '%s': %v", expr, attr, err)
					}
					t2, err := tEvalFn(attr)
					if err != nil {
						return nil, fmt.Errorf("error evaluating AttributeBinding expression for attribute key '%s': %v", attr, err)
					}
					if t1 != t2 {
						return nil, fmt.Errorf(
							"error evaluating AttributeBinding: type '%v' for attribute '%s' does not match type '%s' for expression '%s'",
							t2, attr, t1, expr)
					}
				}

				return BuildTemplate(instParam, "")
			},

			AttributeManifests: []*istio_policy_v1beta1.AttributeManifest{
				{
					Attributes: map[string]*istio_policy_v1beta1.AttributeManifest_AttributeInfo{

						"adapter_template_kubernetes.output.source_pod_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},

						"adapter_template_kubernetes.output.source_pod_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.source_labels": {
							ValueType: istio_policy_v1beta1.STRING_MAP,
						},

						"adapter_template_kubernetes.output.source_namespace": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.source_service": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.source_service_account_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.source_host_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},

						"adapter_template_kubernetes.output.destination_pod_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},

						"adapter_template_kubernetes.output.destination_pod_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.destination_labels": {
							ValueType: istio_policy_v1beta1.STRING_MAP,
						},

						"adapter_template_kubernetes.output.destination_namespace": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.destination_service": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.destination_service_account_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.destination_host_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},

						"adapter_template_kubernetes.output.origin_pod_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},

						"adapter_template_kubernetes.output.origin_pod_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.origin_labels": {
							ValueType: istio_policy_v1beta1.STRING_MAP,
						},

						"adapter_template_kubernetes.output.origin_namespace": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.origin_service": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.origin_service_account_name": {
							ValueType: istio_policy_v1beta1.STRING,
						},

						"adapter_template_kubernetes.output.origin_host_ip": {
							ValueType: istio_policy_v1beta1.IP_ADDRESS,
						},
					},
				},
			},

			ProcessGenAttrs: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler) (*attribute.MutableBag, error) {

				var BuildTemplate func(instName string,
					param *adapter_template_kubernetes.InstanceParam, path string) (
					*adapter_template_kubernetes.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *adapter_template_kubernetes.InstanceParam, path string) (
					*adapter_template_kubernetes.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var SourceUidInterface interface{}
					var SourceUid string
					if param.SourceUid != "" {
						if SourceUidInterface, err = mapper.Eval(param.SourceUid, attrs); err == nil {
							SourceUid = SourceUidInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"SourceUid", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var SourceIpInterface interface{}
					var SourceIp net.IP
					if param.SourceIp != "" {
						if SourceIpInterface, err = mapper.Eval(param.SourceIp, attrs); err == nil {
							SourceIp = SourceIpInterface.(net.IP)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"SourceIp", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var DestinationUidInterface interface{}
					var DestinationUid string
					if param.DestinationUid != "" {
						if DestinationUidInterface, err = mapper.Eval(param.DestinationUid, attrs); err == nil {
							DestinationUid = DestinationUidInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"DestinationUid", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var DestinationIpInterface interface{}
					var DestinationIp net.IP
					if param.DestinationIp != "" {
						if DestinationIpInterface, err = mapper.Eval(param.DestinationIp, attrs); err == nil {
							DestinationIp = DestinationIpInterface.(net.IP)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"DestinationIp", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var OriginUidInterface interface{}
					var OriginUid string
					if param.OriginUid != "" {
						if OriginUidInterface, err = mapper.Eval(param.OriginUid, attrs); err == nil {
							OriginUid = OriginUidInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"OriginUid", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var OriginIpInterface interface{}
					var OriginIp net.IP
					if param.OriginIp != "" {
						if OriginIpInterface, err = mapper.Eval(param.OriginIp, attrs); err == nil {
							OriginIp = OriginIpInterface.(net.IP)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"OriginIp", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &adapter_template_kubernetes.Instance{

						Name: instName,

						SourceUid: SourceUid,

						SourceIp: SourceIp,

						DestinationUid: DestinationUid,

						DestinationIp: DestinationIp,

						OriginUid: OriginUid,

						OriginIp: OriginIp,
					}, nil
				}

				instParam := inst.(*adapter_template_kubernetes.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {
					return nil, err

				}

				out, err := handler.(adapter_template_kubernetes.Handler).GenerateKubernetesAttributes(ctx, instance)
				if err != nil {
					return nil, err
				}
				abag := attrs
				const fullOutName = "adapter_template_kubernetes.output."
				if out == nil {
					log.Debugf("Preprocess adapter returned nil output for instance name '%s'", instName)
				} else {
					abag = newWrapperAttrBag(
						func(name string) (value interface{}, found bool) {
							field := strings.TrimPrefix(name, fullOutName)
							if len(field) != len(name) && out.WasSet(field) {
								switch field {

								case "source_pod_ip":

									return []uint8(out.SourcePodIp), true

								case "source_pod_name":

									return out.SourcePodName, true

								case "source_labels":

									return out.SourceLabels, true

								case "source_namespace":

									return out.SourceNamespace, true

								case "source_service":

									return out.SourceService, true

								case "source_service_account_name":

									return out.SourceServiceAccountName, true

								case "source_host_ip":

									return []uint8(out.SourceHostIp), true

								case "destination_pod_ip":

									return []uint8(out.DestinationPodIp), true

								case "destination_pod_name":

									return out.DestinationPodName, true

								case "destination_labels":

									return out.DestinationLabels, true

								case "destination_namespace":

									return out.DestinationNamespace, true

								case "destination_service":

									return out.DestinationService, true

								case "destination_service_account_name":

									return out.DestinationServiceAccountName, true

								case "destination_host_ip":

									return []uint8(out.DestinationHostIp), true

								case "origin_pod_ip":

									return []uint8(out.OriginPodIp), true

								case "origin_pod_name":

									return out.OriginPodName, true

								case "origin_labels":

									return out.OriginLabels, true

								case "origin_namespace":

									return out.OriginNamespace, true

								case "origin_service":

									return out.OriginService, true

								case "origin_service_account_name":

									return out.OriginServiceAccountName, true

								case "origin_host_ip":

									return []uint8(out.OriginHostIp), true

								default:
									return nil, false
								}
							}
							return attrs.Get(name)
						},
						func() []string { return attrs.Names() },
						func() { attrs.Done() },
						func() string { return attrs.String() },
					)
				}
				resultBag := attribute.GetMutableBag(nil)
				for attrName, outExpr := range instParam.AttributeBindings {
					ex := strings.Replace(outExpr, "$out.", fullOutName, -1)
					val, err := mapper.Eval(ex, abag)
					if err != nil {
						return nil, err
					}
					switch v := val.(type) {
					case net.IP:
						// conversion to []byte necessary based on current IP_ADDRESS handling within Mixer
						// TODO: remove
						if v4 := v.To4(); v4 != nil {
							resultBag.Set(attrName, []byte(v4))
							continue
						}
						resultBag.Set(attrName, []byte(v.To16()))
					default:
						resultBag.Set(attrName, val)
					}
				}
				return resultBag, nil

			},

			/* runtime2 bindings */

			// DispathGenAttrs dispatches the instance to the attribute producing handler.
			DispatchGenAttrs: func(ctx context.Context, handler adapter.Handler, inst interface{}, attrs attribute.Bag,
				mapper template.OutputMapperFn) (*attribute.MutableBag, error) {

				// Convert the instance from the generic interface{}, to their specialized type.
				instance := inst.(*adapter_template_kubernetes.Instance)

				// Invoke the handler.
				out, err := handler.(adapter_template_kubernetes.Handler).GenerateKubernetesAttributes(ctx, instance)
				if err != nil {
					return nil, err
				}

				// Construct a wrapper bag around the returned output message and pass it to the output mapper
				// to map $out values back to the destination attributes in the ambient context.
				const fullOutName = "adapter_template_kubernetes.output."
				outBag := newWrapperAttrBag(
					func(name string) (value interface{}, found bool) {
						field := strings.TrimPrefix(name, fullOutName)
						if len(field) != len(name) && out.WasSet(field) {
							switch field {

							case "source_pod_ip":

								return []uint8(out.SourcePodIp), true

							case "source_pod_name":

								return out.SourcePodName, true

							case "source_labels":

								return out.SourceLabels, true

							case "source_namespace":

								return out.SourceNamespace, true

							case "source_service":

								return out.SourceService, true

							case "source_service_account_name":

								return out.SourceServiceAccountName, true

							case "source_host_ip":

								return []uint8(out.SourceHostIp), true

							case "destination_pod_ip":

								return []uint8(out.DestinationPodIp), true

							case "destination_pod_name":

								return out.DestinationPodName, true

							case "destination_labels":

								return out.DestinationLabels, true

							case "destination_namespace":

								return out.DestinationNamespace, true

							case "destination_service":

								return out.DestinationService, true

							case "destination_service_account_name":

								return out.DestinationServiceAccountName, true

							case "destination_host_ip":

								return []uint8(out.DestinationHostIp), true

							case "origin_pod_ip":

								return []uint8(out.OriginPodIp), true

							case "origin_pod_name":

								return out.OriginPodName, true

							case "origin_labels":

								return out.OriginLabels, true

							case "origin_namespace":

								return out.OriginNamespace, true

							case "origin_service":

								return out.OriginService, true

							case "origin_service_account_name":

								return out.OriginServiceAccountName, true

							case "origin_host_ip":

								return []uint8(out.OriginHostIp), true

							default:
								return nil, false
							}
						}
						return attrs.Get(name)
					},
					func() []string { return attrs.Names() },
					func() { attrs.Done() },
					func() string { return attrs.String() },
				)

				// Mapper will map back $out values in the outBag into ambient attribute names, and return
				// a bag with these additional attributes.
				return mapper(outBag)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_adapter_template_kubernetes_Template(expb, param.(*adapter_template_kubernetes.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},

			// CreateOutputExpressions creates a set of compiled expressions based on the supplied instance parameters.
			//
			// See template.CreateOutputExpressionsFn for more details.
			CreateOutputExpressions: func(
				instanceParam proto.Message,
				finder expr.AttributeDescriptorFinder,
				expb *compiled.ExpressionBuilder) (map[string]compiled.Expression, error) {
				var err error
				var expType istio_policy_v1beta1.ValueType

				// Convert the generic instanceParam to its specialized type.
				param := instanceParam.(*adapter_template_kubernetes.InstanceParam)

				// Create a mapping of expressions back to the attribute names.
				expressions := make(map[string]compiled.Expression, len(param.AttributeBindings))

				const fullOutName = "adapter_template_kubernetes.output."
				for attrName, outExpr := range param.AttributeBindings {
					attrInfo := finder.GetAttribute(attrName)
					if attrInfo == nil {
						log.Warnf("attribute not found when mapping outputs: attr='%s', expr='%s'", attrName, outExpr)
						continue
					}

					ex := strings.Replace(outExpr, "$out.", fullOutName, -1)

					if expressions[attrName], expType, err = expb.Compile(ex); err != nil {
						return nil, err
					}

					if attrInfo.ValueType != expType {
						log.Warnf("attribute type mismatch: attr='%s', attrType='%v', expr='%s', exprType='%v'", attrName, attrInfo.ValueType, outExpr, expType)
						continue
					}
				}

				return expressions, nil
			},
		},

		servicecontrolreport.TemplateName: {
			Name:               servicecontrolreport.TemplateName,
			Impl:               "servicecontrolreport",
			CtrCfg:             &servicecontrolreport.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_REPORT,
			BldrInterfaceName:  servicecontrolreport.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: servicecontrolreport.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(servicecontrolreport.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(servicecontrolreport.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *servicecontrolreport.InstanceParam,
					path string) (*servicecontrolreport.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *servicecontrolreport.InstanceParam,
					path string) (*servicecontrolreport.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &servicecontrolreport.Type{}

					var err error = nil

					if param.ApiVersion != "" {
						if t, e := tEvalFn(param.ApiVersion); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiVersion", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiVersion", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiOperation != "" {
						if t, e := tEvalFn(param.ApiOperation); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiOperation", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiOperation", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiProtocol != "" {
						if t, e := tEvalFn(param.ApiProtocol); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiProtocol", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiProtocol", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiService != "" {
						if t, e := tEvalFn(param.ApiService); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiService", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiService", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiKey != "" {
						if t, e := tEvalFn(param.ApiKey); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiKey", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiKey", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.RequestTime != "" {
						if t, e := tEvalFn(param.RequestTime); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"RequestTime", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"RequestTime", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					if param.RequestMethod != "" {
						if t, e := tEvalFn(param.RequestMethod); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"RequestMethod", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"RequestMethod", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.RequestPath != "" {
						if t, e := tEvalFn(param.RequestPath); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"RequestPath", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"RequestPath", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.RequestBytes != "" {
						if t, e := tEvalFn(param.RequestBytes); e != nil || t != istio_policy_v1beta1.INT64 {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"RequestBytes", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"RequestBytes", t, istio_policy_v1beta1.INT64)
						}
					}

					if param.ResponseTime != "" {
						if t, e := tEvalFn(param.ResponseTime); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ResponseTime", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ResponseTime", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					if param.ResponseCode != "" {
						if t, e := tEvalFn(param.ResponseCode); e != nil || t != istio_policy_v1beta1.INT64 {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ResponseCode", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ResponseCode", t, istio_policy_v1beta1.INT64)
						}
					}

					if param.ResponseBytes != "" {
						if t, e := tEvalFn(param.ResponseBytes); e != nil || t != istio_policy_v1beta1.INT64 {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ResponseBytes", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ResponseBytes", t, istio_policy_v1beta1.INT64)
						}
					}

					if param.ResponseLatency != "" {
						if t, e := tEvalFn(param.ResponseLatency); e != nil || t != istio_policy_v1beta1.DURATION {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ResponseLatency", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ResponseLatency", t, istio_policy_v1beta1.DURATION)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*servicecontrolreport.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(servicecontrolreport.HandlerBuilder)
				castedTypes := make(map[string]*servicecontrolreport.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*servicecontrolreport.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetServicecontrolReportTypes(castedTypes)
			},

			ProcessReport: func(ctx context.Context, insts map[string]proto.Message, attrs attribute.Bag, mapper expr.Evaluator, handler adapter.Handler) error {

				var BuildTemplate func(instName string,
					param *servicecontrolreport.InstanceParam, path string) (
					*servicecontrolreport.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *servicecontrolreport.InstanceParam, path string) (
					*servicecontrolreport.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var ApiVersionInterface interface{}
					var ApiVersion string
					if param.ApiVersion != "" {
						if ApiVersionInterface, err = mapper.Eval(param.ApiVersion, attrs); err == nil {
							ApiVersion = ApiVersionInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiVersion", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiOperationInterface interface{}
					var ApiOperation string
					if param.ApiOperation != "" {
						if ApiOperationInterface, err = mapper.Eval(param.ApiOperation, attrs); err == nil {
							ApiOperation = ApiOperationInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiOperation", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiProtocolInterface interface{}
					var ApiProtocol string
					if param.ApiProtocol != "" {
						if ApiProtocolInterface, err = mapper.Eval(param.ApiProtocol, attrs); err == nil {
							ApiProtocol = ApiProtocolInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiProtocol", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiServiceInterface interface{}
					var ApiService string
					if param.ApiService != "" {
						if ApiServiceInterface, err = mapper.Eval(param.ApiService, attrs); err == nil {
							ApiService = ApiServiceInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiService", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiKeyInterface interface{}
					var ApiKey string
					if param.ApiKey != "" {
						if ApiKeyInterface, err = mapper.Eval(param.ApiKey, attrs); err == nil {
							ApiKey = ApiKeyInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiKey", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var RequestTimeInterface interface{}
					var RequestTime time.Time
					if param.RequestTime != "" {
						if RequestTimeInterface, err = mapper.Eval(param.RequestTime, attrs); err == nil {
							RequestTime = RequestTimeInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"RequestTime", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var RequestMethodInterface interface{}
					var RequestMethod string
					if param.RequestMethod != "" {
						if RequestMethodInterface, err = mapper.Eval(param.RequestMethod, attrs); err == nil {
							RequestMethod = RequestMethodInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"RequestMethod", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var RequestPathInterface interface{}
					var RequestPath string
					if param.RequestPath != "" {
						if RequestPathInterface, err = mapper.Eval(param.RequestPath, attrs); err == nil {
							RequestPath = RequestPathInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"RequestPath", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var RequestBytesInterface interface{}
					var RequestBytes int64
					if param.RequestBytes != "" {
						if RequestBytesInterface, err = mapper.Eval(param.RequestBytes, attrs); err == nil {
							RequestBytes = RequestBytesInterface.(int64)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"RequestBytes", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ResponseTimeInterface interface{}
					var ResponseTime time.Time
					if param.ResponseTime != "" {
						if ResponseTimeInterface, err = mapper.Eval(param.ResponseTime, attrs); err == nil {
							ResponseTime = ResponseTimeInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ResponseTime", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ResponseCodeInterface interface{}
					var ResponseCode int64
					if param.ResponseCode != "" {
						if ResponseCodeInterface, err = mapper.Eval(param.ResponseCode, attrs); err == nil {
							ResponseCode = ResponseCodeInterface.(int64)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ResponseCode", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ResponseBytesInterface interface{}
					var ResponseBytes int64
					if param.ResponseBytes != "" {
						if ResponseBytesInterface, err = mapper.Eval(param.ResponseBytes, attrs); err == nil {
							ResponseBytes = ResponseBytesInterface.(int64)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ResponseBytes", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ResponseLatencyInterface interface{}
					var ResponseLatency time.Duration
					if param.ResponseLatency != "" {
						if ResponseLatencyInterface, err = mapper.Eval(param.ResponseLatency, attrs); err == nil {
							ResponseLatency = ResponseLatencyInterface.(time.Duration)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ResponseLatency", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &servicecontrolreport.Instance{

						Name: instName,

						ApiVersion: ApiVersion,

						ApiOperation: ApiOperation,

						ApiProtocol: ApiProtocol,

						ApiService: ApiService,

						ApiKey: ApiKey,

						RequestTime: RequestTime,

						RequestMethod: RequestMethod,

						RequestPath: RequestPath,

						RequestBytes: RequestBytes,

						ResponseTime: ResponseTime,

						ResponseCode: ResponseCode,

						ResponseBytes: ResponseBytes,

						ResponseLatency: ResponseLatency,
					}, nil
				}

				var instances []*servicecontrolreport.Instance
				for instName, inst := range insts {
					instance, err := BuildTemplate(instName, inst.(*servicecontrolreport.InstanceParam), "")
					if err != nil {
						return err
					}
					instances = append(instances, instance)
				}

				if err := handler.(servicecontrolreport.Handler).HandleServicecontrolReport(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			/* runtime2 bindings */

			// DispatchReport dispatches the instances to the handler.
			DispatchReport: func(ctx context.Context, handler adapter.Handler, inst []interface{}) error {

				// Convert the instances from the generic []interface{}, to their specialized type.
				instances := make([]*servicecontrolreport.Instance, len(inst))
				for i, instance := range inst {
					instances[i] = instance.(*servicecontrolreport.Instance)
				}

				// Invoke the handler.
				if err := handler.(servicecontrolreport.Handler).HandleServicecontrolReport(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_servicecontrolreport_Template(expb, param.(*servicecontrolreport.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		apikey.TemplateName: {
			Name:               apikey.TemplateName,
			Impl:               "apikey",
			CtrCfg:             &apikey.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_CHECK,
			BldrInterfaceName:  apikey.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: apikey.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(apikey.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(apikey.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *apikey.InstanceParam,
					path string) (*apikey.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *apikey.InstanceParam,
					path string) (*apikey.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &apikey.Type{}

					var err error = nil

					if param.Api != "" {
						if t, e := tEvalFn(param.Api); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Api", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Api", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiVersion != "" {
						if t, e := tEvalFn(param.ApiVersion); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiVersion", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiVersion", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiOperation != "" {
						if t, e := tEvalFn(param.ApiOperation); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiOperation", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiOperation", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ApiKey != "" {
						if t, e := tEvalFn(param.ApiKey); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ApiKey", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ApiKey", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.Timestamp != "" {
						if t, e := tEvalFn(param.Timestamp); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Timestamp", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Timestamp", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*apikey.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(apikey.HandlerBuilder)
				castedTypes := make(map[string]*apikey.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*apikey.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetApiKeyTypes(castedTypes)
			},

			ProcessCheck: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler) (adapter.CheckResult, error) {

				var BuildTemplate func(instName string,
					param *apikey.InstanceParam, path string) (
					*apikey.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *apikey.InstanceParam, path string) (
					*apikey.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var ApiInterface interface{}
					var Api string
					if param.Api != "" {
						if ApiInterface, err = mapper.Eval(param.Api, attrs); err == nil {
							Api = ApiInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Api", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiVersionInterface interface{}
					var ApiVersion string
					if param.ApiVersion != "" {
						if ApiVersionInterface, err = mapper.Eval(param.ApiVersion, attrs); err == nil {
							ApiVersion = ApiVersionInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiVersion", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiOperationInterface interface{}
					var ApiOperation string
					if param.ApiOperation != "" {
						if ApiOperationInterface, err = mapper.Eval(param.ApiOperation, attrs); err == nil {
							ApiOperation = ApiOperationInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiOperation", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ApiKeyInterface interface{}
					var ApiKey string
					if param.ApiKey != "" {
						if ApiKeyInterface, err = mapper.Eval(param.ApiKey, attrs); err == nil {
							ApiKey = ApiKeyInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ApiKey", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var TimestampInterface interface{}
					var Timestamp time.Time
					if param.Timestamp != "" {
						if TimestampInterface, err = mapper.Eval(param.Timestamp, attrs); err == nil {
							Timestamp = TimestampInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Timestamp", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &apikey.Instance{

						Name: instName,

						Api: Api,

						ApiVersion: ApiVersion,

						ApiOperation: ApiOperation,

						ApiKey: ApiKey,

						Timestamp: Timestamp,
					}, nil
				}

				instParam := inst.(*apikey.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {

					return adapter.CheckResult{}, err

				}
				return handler.(apikey.Handler).HandleApiKey(ctx, instance)

			},

			/* runtime2 bindings */

			// DispatchCheck dispatches the instance to the handler.
			DispatchCheck: func(ctx context.Context, handler adapter.Handler, inst interface{}) (adapter.CheckResult, error) {

				// Convert the instance from the generic interface{}, to its specialized type.
				instance := inst.(*apikey.Instance)

				// Invoke the handler.
				return handler.(apikey.Handler).HandleApiKey(ctx, instance)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_apikey_Template(expb, param.(*apikey.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		authorization.TemplateName: {
			Name:               authorization.TemplateName,
			Impl:               "authorization",
			CtrCfg:             &authorization.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_CHECK,
			BldrInterfaceName:  authorization.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: authorization.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(authorization.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(authorization.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *authorization.InstanceParam,
					path string) (*authorization.Type, error)

				_ = BuildTemplate

				var BuildSubject func(param *authorization.SubjectInstanceParam,
					path string) (*authorization.SubjectType, error)

				_ = BuildSubject

				var BuildAction func(param *authorization.ActionInstanceParam,
					path string) (*authorization.ActionType, error)

				_ = BuildAction

				BuildTemplate = func(param *authorization.InstanceParam,
					path string) (*authorization.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &authorization.Type{}

					var err error = nil

					if param.Subject != nil {

						if infrdType.Subject, err = BuildSubject(param.Subject, path+"Subject."); err != nil {
							return nil, fmt.Errorf("failed to evaluate expression for field '%s'; %v", path+"Subject", err)
						}
					}

					if param.Action != nil {

						if infrdType.Action, err = BuildAction(param.Action, path+"Action."); err != nil {
							return nil, fmt.Errorf("failed to evaluate expression for field '%s'; %v", path+"Action", err)
						}
					}

					return infrdType, err

				}

				BuildSubject = func(param *authorization.SubjectInstanceParam,
					path string) (*authorization.SubjectType, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &authorization.SubjectType{}

					var err error = nil

					if param.User != "" {
						if t, e := tEvalFn(param.User); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"User", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"User", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.Groups != "" {
						if t, e := tEvalFn(param.Groups); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Groups", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Groups", t, istio_policy_v1beta1.STRING)
						}
					}

					infrdType.Properties = make(map[string]istio_policy_v1beta1.ValueType, len(param.Properties))

					for k, v := range param.Properties {

						if infrdType.Properties[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "Properties", k, err)
						}
					}

					return infrdType, err

				}

				BuildAction = func(param *authorization.ActionInstanceParam,
					path string) (*authorization.ActionType, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &authorization.ActionType{}

					var err error = nil

					if param.Namespace != "" {
						if t, e := tEvalFn(param.Namespace); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Namespace", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Namespace", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.Service != "" {
						if t, e := tEvalFn(param.Service); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Service", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Service", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.Method != "" {
						if t, e := tEvalFn(param.Method); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Method", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Method", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.Path != "" {
						if t, e := tEvalFn(param.Path); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Path", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Path", t, istio_policy_v1beta1.STRING)
						}
					}

					infrdType.Properties = make(map[string]istio_policy_v1beta1.ValueType, len(param.Properties))

					for k, v := range param.Properties {

						if infrdType.Properties[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "Properties", k, err)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*authorization.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(authorization.HandlerBuilder)
				castedTypes := make(map[string]*authorization.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*authorization.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetAuthorizationTypes(castedTypes)
			},

			ProcessCheck: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler) (adapter.CheckResult, error) {

				var BuildTemplate func(instName string,
					param *authorization.InstanceParam, path string) (
					*authorization.Instance, error)
				_ = BuildTemplate

				var BuildSubject func(instName string,
					param *authorization.SubjectInstanceParam, path string) (
					*authorization.Subject, error)
				_ = BuildSubject

				var BuildAction func(instName string,
					param *authorization.ActionInstanceParam, path string) (
					*authorization.Action, error)
				_ = BuildAction

				BuildTemplate = func(instName string,
					param *authorization.InstanceParam, path string) (
					*authorization.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					Subject, err := BuildSubject(instName, param.Subject, path+"Subject.")

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Subject", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					Action, err := BuildAction(instName, param.Action, path+"Action.")

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Action", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &authorization.Instance{

						Name: instName,

						Subject: Subject,

						Action: Action,
					}, nil
				}

				BuildSubject = func(instName string,
					param *authorization.SubjectInstanceParam, path string) (
					*authorization.Subject, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var UserInterface interface{}
					var User string
					if param.User != "" {
						if UserInterface, err = mapper.Eval(param.User, attrs); err == nil {
							User = UserInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"User", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var GroupsInterface interface{}
					var Groups string
					if param.Groups != "" {
						if GroupsInterface, err = mapper.Eval(param.Groups, attrs); err == nil {
							Groups = GroupsInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Groups", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					Properties, err := template.EvalAll(param.Properties, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Properties", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &authorization.Subject{

						User: User,

						Groups: Groups,

						Properties: Properties,
					}, nil
				}

				BuildAction = func(instName string,
					param *authorization.ActionInstanceParam, path string) (
					*authorization.Action, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var NamespaceInterface interface{}
					var Namespace string
					if param.Namespace != "" {
						if NamespaceInterface, err = mapper.Eval(param.Namespace, attrs); err == nil {
							Namespace = NamespaceInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Namespace", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ServiceInterface interface{}
					var Service string
					if param.Service != "" {
						if ServiceInterface, err = mapper.Eval(param.Service, attrs); err == nil {
							Service = ServiceInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Service", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var MethodInterface interface{}
					var Method string
					if param.Method != "" {
						if MethodInterface, err = mapper.Eval(param.Method, attrs); err == nil {
							Method = MethodInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Method", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var PathInterface interface{}
					var Path string
					if param.Path != "" {
						if PathInterface, err = mapper.Eval(param.Path, attrs); err == nil {
							Path = PathInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Path", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					Properties, err := template.EvalAll(param.Properties, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Properties", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &authorization.Action{

						Namespace: Namespace,

						Service: Service,

						Method: Method,

						Path: Path,

						Properties: Properties,
					}, nil
				}

				instParam := inst.(*authorization.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {

					return adapter.CheckResult{}, err

				}
				return handler.(authorization.Handler).HandleAuthorization(ctx, instance)

			},

			/* runtime2 bindings */

			// DispatchCheck dispatches the instance to the handler.
			DispatchCheck: func(ctx context.Context, handler adapter.Handler, inst interface{}) (adapter.CheckResult, error) {

				// Convert the instance from the generic interface{}, to its specialized type.
				instance := inst.(*authorization.Instance)

				// Invoke the handler.
				return handler.(authorization.Handler).HandleAuthorization(ctx, instance)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_authorization_Template(expb, param.(*authorization.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		checknothing.TemplateName: {
			Name:               checknothing.TemplateName,
			Impl:               "checknothing",
			CtrCfg:             &checknothing.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_CHECK,
			BldrInterfaceName:  checknothing.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: checknothing.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(checknothing.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(checknothing.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *checknothing.InstanceParam,
					path string) (*checknothing.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *checknothing.InstanceParam,
					path string) (*checknothing.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &checknothing.Type{}

					var err error = nil

					return infrdType, err

				}

				instParam := cp.(*checknothing.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(checknothing.HandlerBuilder)
				castedTypes := make(map[string]*checknothing.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*checknothing.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetCheckNothingTypes(castedTypes)
			},

			ProcessCheck: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler) (adapter.CheckResult, error) {

				var BuildTemplate func(instName string,
					param *checknothing.InstanceParam, path string) (
					*checknothing.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *checknothing.InstanceParam, path string) (
					*checknothing.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					_ = param
					return &checknothing.Instance{

						Name: instName,
					}, nil
				}

				instParam := inst.(*checknothing.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {

					return adapter.CheckResult{}, err

				}
				return handler.(checknothing.Handler).HandleCheckNothing(ctx, instance)

			},

			/* runtime2 bindings */

			// DispatchCheck dispatches the instance to the handler.
			DispatchCheck: func(ctx context.Context, handler adapter.Handler, inst interface{}) (adapter.CheckResult, error) {

				// Convert the instance from the generic interface{}, to its specialized type.
				instance := inst.(*checknothing.Instance)

				// Invoke the handler.
				return handler.(checknothing.Handler).HandleCheckNothing(ctx, instance)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_checknothing_Template(expb, param.(*checknothing.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		listentry.TemplateName: {
			Name:               listentry.TemplateName,
			Impl:               "listentry",
			CtrCfg:             &listentry.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_CHECK,
			BldrInterfaceName:  listentry.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: listentry.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(listentry.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(listentry.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *listentry.InstanceParam,
					path string) (*listentry.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *listentry.InstanceParam,
					path string) (*listentry.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &listentry.Type{}

					var err error = nil

					if param.Value != "" {
						if t, e := tEvalFn(param.Value); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Value", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Value", t, istio_policy_v1beta1.STRING)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*listentry.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(listentry.HandlerBuilder)
				castedTypes := make(map[string]*listentry.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*listentry.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetListEntryTypes(castedTypes)
			},

			ProcessCheck: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler) (adapter.CheckResult, error) {

				var BuildTemplate func(instName string,
					param *listentry.InstanceParam, path string) (
					*listentry.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *listentry.InstanceParam, path string) (
					*listentry.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var ValueInterface interface{}
					var Value string
					if param.Value != "" {
						if ValueInterface, err = mapper.Eval(param.Value, attrs); err == nil {
							Value = ValueInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Value", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &listentry.Instance{

						Name: instName,

						Value: Value,
					}, nil
				}

				instParam := inst.(*listentry.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {

					return adapter.CheckResult{}, err

				}
				return handler.(listentry.Handler).HandleListEntry(ctx, instance)

			},

			/* runtime2 bindings */

			// DispatchCheck dispatches the instance to the handler.
			DispatchCheck: func(ctx context.Context, handler adapter.Handler, inst interface{}) (adapter.CheckResult, error) {

				// Convert the instance from the generic interface{}, to its specialized type.
				instance := inst.(*listentry.Instance)

				// Invoke the handler.
				return handler.(listentry.Handler).HandleListEntry(ctx, instance)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_listentry_Template(expb, param.(*listentry.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		logentry.TemplateName: {
			Name:               logentry.TemplateName,
			Impl:               "logentry",
			CtrCfg:             &logentry.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_REPORT,
			BldrInterfaceName:  logentry.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: logentry.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(logentry.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(logentry.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *logentry.InstanceParam,
					path string) (*logentry.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *logentry.InstanceParam,
					path string) (*logentry.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &logentry.Type{}

					var err error = nil

					infrdType.Variables = make(map[string]istio_policy_v1beta1.ValueType, len(param.Variables))

					for k, v := range param.Variables {

						if infrdType.Variables[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "Variables", k, err)
						}
					}

					if param.Timestamp != "" {
						if t, e := tEvalFn(param.Timestamp); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Timestamp", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Timestamp", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					if param.Severity != "" {
						if t, e := tEvalFn(param.Severity); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"Severity", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"Severity", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.MonitoredResourceType != "" {
						if t, e := tEvalFn(param.MonitoredResourceType); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"MonitoredResourceType", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"MonitoredResourceType", t, istio_policy_v1beta1.STRING)
						}
					}

					infrdType.MonitoredResourceDimensions = make(map[string]istio_policy_v1beta1.ValueType, len(param.MonitoredResourceDimensions))

					for k, v := range param.MonitoredResourceDimensions {

						if infrdType.MonitoredResourceDimensions[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "MonitoredResourceDimensions", k, err)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*logentry.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(logentry.HandlerBuilder)
				castedTypes := make(map[string]*logentry.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*logentry.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetLogEntryTypes(castedTypes)
			},

			ProcessReport: func(ctx context.Context, insts map[string]proto.Message, attrs attribute.Bag, mapper expr.Evaluator, handler adapter.Handler) error {

				var BuildTemplate func(instName string,
					param *logentry.InstanceParam, path string) (
					*logentry.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *logentry.InstanceParam, path string) (
					*logentry.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					Variables, err := template.EvalAll(param.Variables, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Variables", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var TimestampInterface interface{}
					var Timestamp time.Time
					if param.Timestamp != "" {
						if TimestampInterface, err = mapper.Eval(param.Timestamp, attrs); err == nil {
							Timestamp = TimestampInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Timestamp", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var SeverityInterface interface{}
					var Severity string
					if param.Severity != "" {
						if SeverityInterface, err = mapper.Eval(param.Severity, attrs); err == nil {
							Severity = SeverityInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Severity", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var MonitoredResourceTypeInterface interface{}
					var MonitoredResourceType string
					if param.MonitoredResourceType != "" {
						if MonitoredResourceTypeInterface, err = mapper.Eval(param.MonitoredResourceType, attrs); err == nil {
							MonitoredResourceType = MonitoredResourceTypeInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"MonitoredResourceType", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					MonitoredResourceDimensions, err := template.EvalAll(param.MonitoredResourceDimensions, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"MonitoredResourceDimensions", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &logentry.Instance{

						Name: instName,

						Variables: Variables,

						Timestamp: Timestamp,

						Severity: Severity,

						MonitoredResourceType: MonitoredResourceType,

						MonitoredResourceDimensions: MonitoredResourceDimensions,
					}, nil
				}

				var instances []*logentry.Instance
				for instName, inst := range insts {
					instance, err := BuildTemplate(instName, inst.(*logentry.InstanceParam), "")
					if err != nil {
						return err
					}
					instances = append(instances, instance)
				}

				if err := handler.(logentry.Handler).HandleLogEntry(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			/* runtime2 bindings */

			// DispatchReport dispatches the instances to the handler.
			DispatchReport: func(ctx context.Context, handler adapter.Handler, inst []interface{}) error {

				// Convert the instances from the generic []interface{}, to their specialized type.
				instances := make([]*logentry.Instance, len(inst))
				for i, instance := range inst {
					instances[i] = instance.(*logentry.Instance)
				}

				// Invoke the handler.
				if err := handler.(logentry.Handler).HandleLogEntry(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_logentry_Template(expb, param.(*logentry.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		metric.TemplateName: {
			Name:               metric.TemplateName,
			Impl:               "metric",
			CtrCfg:             &metric.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_REPORT,
			BldrInterfaceName:  metric.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: metric.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(metric.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(metric.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *metric.InstanceParam,
					path string) (*metric.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *metric.InstanceParam,
					path string) (*metric.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &metric.Type{}

					var err error = nil

					if param.Value == "" {
						infrdType.Value = istio_policy_v1beta1.VALUE_TYPE_UNSPECIFIED
					} else if infrdType.Value, err = tEvalFn(param.Value); err != nil {
						return nil, fmt.Errorf("failed to evaluate expression for field '%s'; %v", path+"Value", err)
					}

					infrdType.Dimensions = make(map[string]istio_policy_v1beta1.ValueType, len(param.Dimensions))

					for k, v := range param.Dimensions {

						if infrdType.Dimensions[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "Dimensions", k, err)
						}
					}

					if param.MonitoredResourceType != "" {
						if t, e := tEvalFn(param.MonitoredResourceType); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"MonitoredResourceType", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"MonitoredResourceType", t, istio_policy_v1beta1.STRING)
						}
					}

					infrdType.MonitoredResourceDimensions = make(map[string]istio_policy_v1beta1.ValueType, len(param.MonitoredResourceDimensions))

					for k, v := range param.MonitoredResourceDimensions {

						if infrdType.MonitoredResourceDimensions[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "MonitoredResourceDimensions", k, err)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*metric.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(metric.HandlerBuilder)
				castedTypes := make(map[string]*metric.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*metric.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetMetricTypes(castedTypes)
			},

			ProcessReport: func(ctx context.Context, insts map[string]proto.Message, attrs attribute.Bag, mapper expr.Evaluator, handler adapter.Handler) error {

				var BuildTemplate func(instName string,
					param *metric.InstanceParam, path string) (
					*metric.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *metric.InstanceParam, path string) (
					*metric.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var Value interface{}
					if param.Value != "" {
						Value, err = mapper.Eval(param.Value, attrs)
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Value", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					Dimensions, err := template.EvalAll(param.Dimensions, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Dimensions", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var MonitoredResourceTypeInterface interface{}
					var MonitoredResourceType string
					if param.MonitoredResourceType != "" {
						if MonitoredResourceTypeInterface, err = mapper.Eval(param.MonitoredResourceType, attrs); err == nil {
							MonitoredResourceType = MonitoredResourceTypeInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"MonitoredResourceType", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					MonitoredResourceDimensions, err := template.EvalAll(param.MonitoredResourceDimensions, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"MonitoredResourceDimensions", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &metric.Instance{

						Name: instName,

						Value: Value,

						Dimensions: Dimensions,

						MonitoredResourceType: MonitoredResourceType,

						MonitoredResourceDimensions: MonitoredResourceDimensions,
					}, nil
				}

				var instances []*metric.Instance
				for instName, inst := range insts {
					instance, err := BuildTemplate(instName, inst.(*metric.InstanceParam), "")
					if err != nil {
						return err
					}
					instances = append(instances, instance)
				}

				if err := handler.(metric.Handler).HandleMetric(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			/* runtime2 bindings */

			// DispatchReport dispatches the instances to the handler.
			DispatchReport: func(ctx context.Context, handler adapter.Handler, inst []interface{}) error {

				// Convert the instances from the generic []interface{}, to their specialized type.
				instances := make([]*metric.Instance, len(inst))
				for i, instance := range inst {
					instances[i] = instance.(*metric.Instance)
				}

				// Invoke the handler.
				if err := handler.(metric.Handler).HandleMetric(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_metric_Template(expb, param.(*metric.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		quota.TemplateName: {
			Name:               quota.TemplateName,
			Impl:               "quota",
			CtrCfg:             &quota.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_QUOTA,
			BldrInterfaceName:  quota.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: quota.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(quota.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(quota.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *quota.InstanceParam,
					path string) (*quota.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *quota.InstanceParam,
					path string) (*quota.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &quota.Type{}

					var err error = nil

					infrdType.Dimensions = make(map[string]istio_policy_v1beta1.ValueType, len(param.Dimensions))

					for k, v := range param.Dimensions {

						if infrdType.Dimensions[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "Dimensions", k, err)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*quota.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(quota.HandlerBuilder)
				castedTypes := make(map[string]*quota.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*quota.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetQuotaTypes(castedTypes)
			},

			ProcessQuota: func(ctx context.Context, instName string, inst proto.Message, attrs attribute.Bag,
				mapper expr.Evaluator, handler adapter.Handler, args adapter.QuotaArgs) (adapter.QuotaResult, error) {

				var BuildTemplate func(instName string,
					param *quota.InstanceParam, path string) (
					*quota.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *quota.InstanceParam, path string) (
					*quota.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					Dimensions, err := template.EvalAll(param.Dimensions, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"Dimensions", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &quota.Instance{

						Name: instName,

						Dimensions: Dimensions,
					}, nil
				}

				instParam := inst.(*quota.InstanceParam)
				instance, err := BuildTemplate(instName, instParam, "")
				if err != nil {
					return adapter.QuotaResult{}, err

				}
				return handler.(quota.Handler).HandleQuota(ctx, instance, args)

			},

			/* runtime2 bindings */

			// DispatchQuota dispatches the instance to the handler.
			DispatchQuota: func(ctx context.Context, handler adapter.Handler, inst interface{}, args adapter.QuotaArgs) (adapter.QuotaResult, error) {

				// Convert the instance from the generic interface{}, to its specialized type.
				instance := inst.(*quota.Instance)

				// Invoke the handler.
				return handler.(quota.Handler).HandleQuota(ctx, instance, args)
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_quota_Template(expb, param.(*quota.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		reportnothing.TemplateName: {
			Name:               reportnothing.TemplateName,
			Impl:               "reportnothing",
			CtrCfg:             &reportnothing.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_REPORT,
			BldrInterfaceName:  reportnothing.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: reportnothing.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(reportnothing.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(reportnothing.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *reportnothing.InstanceParam,
					path string) (*reportnothing.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *reportnothing.InstanceParam,
					path string) (*reportnothing.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &reportnothing.Type{}

					var err error = nil

					return infrdType, err

				}

				instParam := cp.(*reportnothing.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(reportnothing.HandlerBuilder)
				castedTypes := make(map[string]*reportnothing.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*reportnothing.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetReportNothingTypes(castedTypes)
			},

			ProcessReport: func(ctx context.Context, insts map[string]proto.Message, attrs attribute.Bag, mapper expr.Evaluator, handler adapter.Handler) error {

				var BuildTemplate func(instName string,
					param *reportnothing.InstanceParam, path string) (
					*reportnothing.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *reportnothing.InstanceParam, path string) (
					*reportnothing.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					_ = param
					return &reportnothing.Instance{

						Name: instName,
					}, nil
				}

				var instances []*reportnothing.Instance
				for instName, inst := range insts {
					instance, err := BuildTemplate(instName, inst.(*reportnothing.InstanceParam), "")
					if err != nil {
						return err
					}
					instances = append(instances, instance)
				}

				if err := handler.(reportnothing.Handler).HandleReportNothing(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			/* runtime2 bindings */

			// DispatchReport dispatches the instances to the handler.
			DispatchReport: func(ctx context.Context, handler adapter.Handler, inst []interface{}) error {

				// Convert the instances from the generic []interface{}, to their specialized type.
				instances := make([]*reportnothing.Instance, len(inst))
				for i, instance := range inst {
					instances[i] = instance.(*reportnothing.Instance)
				}

				// Invoke the handler.
				if err := handler.(reportnothing.Handler).HandleReportNothing(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_reportnothing_Template(expb, param.(*reportnothing.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},

		tracespan.TemplateName: {
			Name:               tracespan.TemplateName,
			Impl:               "tracespan",
			CtrCfg:             &tracespan.InstanceParam{},
			Variety:            istio_adapter_model_v1beta1.TEMPLATE_VARIETY_REPORT,
			BldrInterfaceName:  tracespan.TemplateName + "." + "HandlerBuilder",
			HndlrInterfaceName: tracespan.TemplateName + "." + "Handler",
			BuilderSupportsTemplate: func(hndlrBuilder adapter.HandlerBuilder) bool {
				_, ok := hndlrBuilder.(tracespan.HandlerBuilder)
				return ok
			},
			HandlerSupportsTemplate: func(hndlr adapter.Handler) bool {
				_, ok := hndlr.(tracespan.Handler)
				return ok
			},
			InferType: func(cp proto.Message, tEvalFn template.TypeEvalFn) (proto.Message, error) {

				var BuildTemplate func(param *tracespan.InstanceParam,
					path string) (*tracespan.Type, error)

				_ = BuildTemplate

				BuildTemplate = func(param *tracespan.InstanceParam,
					path string) (*tracespan.Type, error) {

					if param == nil {
						return nil, nil
					}

					infrdType := &tracespan.Type{}

					var err error = nil

					if param.TraceId != "" {
						if t, e := tEvalFn(param.TraceId); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"TraceId", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"TraceId", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.SpanId != "" {
						if t, e := tEvalFn(param.SpanId); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"SpanId", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"SpanId", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.ParentSpanId != "" {
						if t, e := tEvalFn(param.ParentSpanId); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"ParentSpanId", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"ParentSpanId", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.SpanName != "" {
						if t, e := tEvalFn(param.SpanName); e != nil || t != istio_policy_v1beta1.STRING {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"SpanName", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"SpanName", t, istio_policy_v1beta1.STRING)
						}
					}

					if param.StartTime != "" {
						if t, e := tEvalFn(param.StartTime); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"StartTime", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"StartTime", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					if param.EndTime != "" {
						if t, e := tEvalFn(param.EndTime); e != nil || t != istio_policy_v1beta1.TIMESTAMP {
							if e != nil {
								return nil, fmt.Errorf("failed to evaluate expression for field '%s': %v", path+"EndTime", e)
							}
							return nil, fmt.Errorf("error type checking for field '%s': Evaluated expression type %v want %v", path+"EndTime", t, istio_policy_v1beta1.TIMESTAMP)
						}
					}

					infrdType.SpanTags = make(map[string]istio_policy_v1beta1.ValueType, len(param.SpanTags))

					for k, v := range param.SpanTags {

						if infrdType.SpanTags[k], err = tEvalFn(v); err != nil {

							return nil, fmt.Errorf("failed to evaluate expression for field '%s%s[%s]'; %v", path, "SpanTags", k, err)
						}
					}

					return infrdType, err

				}

				instParam := cp.(*tracespan.InstanceParam)

				return BuildTemplate(instParam, "")
			},

			SetType: func(types map[string]proto.Message, builder adapter.HandlerBuilder) {
				// Mixer framework should have ensured the type safety.
				castedBuilder := builder.(tracespan.HandlerBuilder)
				castedTypes := make(map[string]*tracespan.Type, len(types))
				for k, v := range types {
					// Mixer framework should have ensured the type safety.
					v1 := v.(*tracespan.Type)
					castedTypes[k] = v1
				}
				castedBuilder.SetTraceSpanTypes(castedTypes)
			},

			ProcessReport: func(ctx context.Context, insts map[string]proto.Message, attrs attribute.Bag, mapper expr.Evaluator, handler adapter.Handler) error {

				var BuildTemplate func(instName string,
					param *tracespan.InstanceParam, path string) (
					*tracespan.Instance, error)
				_ = BuildTemplate

				BuildTemplate = func(instName string,
					param *tracespan.InstanceParam, path string) (
					*tracespan.Instance, error) {
					if param == nil {
						return nil, nil
					}
					var err error
					_ = err

					var TraceIdInterface interface{}
					var TraceId string
					if param.TraceId != "" {
						if TraceIdInterface, err = mapper.Eval(param.TraceId, attrs); err == nil {
							TraceId = TraceIdInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"TraceId", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var SpanIdInterface interface{}
					var SpanId string
					if param.SpanId != "" {
						if SpanIdInterface, err = mapper.Eval(param.SpanId, attrs); err == nil {
							SpanId = SpanIdInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"SpanId", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var ParentSpanIdInterface interface{}
					var ParentSpanId string
					if param.ParentSpanId != "" {
						if ParentSpanIdInterface, err = mapper.Eval(param.ParentSpanId, attrs); err == nil {
							ParentSpanId = ParentSpanIdInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"ParentSpanId", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var SpanNameInterface interface{}
					var SpanName string
					if param.SpanName != "" {
						if SpanNameInterface, err = mapper.Eval(param.SpanName, attrs); err == nil {
							SpanName = SpanNameInterface.(string)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"SpanName", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var StartTimeInterface interface{}
					var StartTime time.Time
					if param.StartTime != "" {
						if StartTimeInterface, err = mapper.Eval(param.StartTime, attrs); err == nil {
							StartTime = StartTimeInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"StartTime", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					var EndTimeInterface interface{}
					var EndTime time.Time
					if param.EndTime != "" {
						if EndTimeInterface, err = mapper.Eval(param.EndTime, attrs); err == nil {
							EndTime = EndTimeInterface.(time.Time)
						}
					}

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"EndTime", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					SpanTags, err := template.EvalAll(param.SpanTags, attrs, mapper)

					if err != nil {
						msg := fmt.Sprintf("failed to evaluate field '%s' for instance '%s': %v", path+"SpanTags", instName, err)
						log.Error(msg)
						return nil, errors.New(msg)
					}

					_ = param
					return &tracespan.Instance{

						Name: instName,

						TraceId: TraceId,

						SpanId: SpanId,

						ParentSpanId: ParentSpanId,

						SpanName: SpanName,

						StartTime: StartTime,

						EndTime: EndTime,

						SpanTags: SpanTags,
					}, nil
				}

				var instances []*tracespan.Instance
				for instName, inst := range insts {
					instance, err := BuildTemplate(instName, inst.(*tracespan.InstanceParam), "")
					if err != nil {
						return err
					}
					instances = append(instances, instance)
				}

				if err := handler.(tracespan.Handler).HandleTraceSpan(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			/* runtime2 bindings */

			// DispatchReport dispatches the instances to the handler.
			DispatchReport: func(ctx context.Context, handler adapter.Handler, inst []interface{}) error {

				// Convert the instances from the generic []interface{}, to their specialized type.
				instances := make([]*tracespan.Instance, len(inst))
				for i, instance := range inst {
					instances[i] = instance.(*tracespan.Instance)
				}

				// Invoke the handler.
				if err := handler.(tracespan.Handler).HandleTraceSpan(ctx, instances); err != nil {
					return fmt.Errorf("failed to report all values: %v", err)
				}
				return nil
			},

			// CreateInstanceBuilder creates a new template.InstanceBuilderFN based on the supplied instance parameters. It uses
			// the expression builder to create a new instance of a builder struct for the instance type. Created
			// InstanceBuilderFn closes over this struct. When InstanceBuilderFn is called it, in turn, calls into
			// the builder with an attribute bag.
			//
			// See template.CreateInstanceBuilderFn for more details.
			CreateInstanceBuilder: func(instanceName string, param proto.Message, expb *compiled.ExpressionBuilder) (template.InstanceBuilderFn, error) {

				// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
				if param == nil {
					return func(attr attribute.Bag) (interface{}, error) {
						return nil, nil
					}, nil
				}

				// Instantiate a new builder for the instance.
				builder, errp := newBuilder_tracespan_Template(expb, param.(*tracespan.InstanceParam))
				if !errp.IsNil() {
					return nil, errp.AsCompilationError(instanceName)
				}

				return func(attr attribute.Bag) (interface{}, error) {
					// Use the instantiated builder (that this fn closes over) to construct an instance.
					e, errp := builder.build(attr)
					if !errp.IsNil() {
						err := errp.AsEvaluationError(instanceName)
						log.Error(err.Error())
						return nil, err
					}

					e.Name = instanceName
					return e, nil
				}, nil
			},
		},
	}
)

// Builders for all known message types.

// builder struct for constructing an instance of Template.
type builder_adapter_template_kubernetes_Template struct {

	// builder for field source_uid: string.

	bldSourceUid compiled.Expression

	// builder for field source_ip: net.IP.

	bldSourceIp compiled.Expression

	// builder for field destination_uid: string.

	bldDestinationUid compiled.Expression

	// builder for field destination_ip: net.IP.

	bldDestinationIp compiled.Expression

	// builder for field origin_uid: string.

	bldOriginUid compiled.Expression

	// builder for field origin_ip: net.IP.

	bldOriginIp compiled.Expression
} // builder_adapter_template_kubernetes_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_adapter_template_kubernetes_Template(
	expb *compiled.ExpressionBuilder,
	param *adapter_template_kubernetes.InstanceParam) (*builder_adapter_template_kubernetes_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_adapter_template_kubernetes_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.SourceUid == "" {
		b.bldSourceUid = nil
	} else {
		b.bldSourceUid, expType, err = expb.Compile(param.SourceUid)
		if err != nil {
			return nil, template.NewErrorPath("SourceUid", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.SourceUid)
			return nil, template.NewErrorPath("SourceUid", err)
		}

	}

	if param.SourceIp == "" {
		b.bldSourceIp = nil
	} else {
		b.bldSourceIp, expType, err = expb.Compile(param.SourceIp)
		if err != nil {
			return nil, template.NewErrorPath("SourceIp", err)
		}

	}

	if param.DestinationUid == "" {
		b.bldDestinationUid = nil
	} else {
		b.bldDestinationUid, expType, err = expb.Compile(param.DestinationUid)
		if err != nil {
			return nil, template.NewErrorPath("DestinationUid", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.DestinationUid)
			return nil, template.NewErrorPath("DestinationUid", err)
		}

	}

	if param.DestinationIp == "" {
		b.bldDestinationIp = nil
	} else {
		b.bldDestinationIp, expType, err = expb.Compile(param.DestinationIp)
		if err != nil {
			return nil, template.NewErrorPath("DestinationIp", err)
		}

	}

	if param.OriginUid == "" {
		b.bldOriginUid = nil
	} else {
		b.bldOriginUid, expType, err = expb.Compile(param.OriginUid)
		if err != nil {
			return nil, template.NewErrorPath("OriginUid", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.OriginUid)
			return nil, template.NewErrorPath("OriginUid", err)
		}

	}

	if param.OriginIp == "" {
		b.bldOriginIp = nil
	} else {
		b.bldOriginIp, expType, err = expb.Compile(param.OriginIp)
		if err != nil {
			return nil, template.NewErrorPath("OriginIp", err)
		}

	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_adapter_template_kubernetes_Template) build(
	attrs attribute.Bag) (*adapter_template_kubernetes.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &adapter_template_kubernetes.Instance{}

	if b.bldSourceUid != nil {

		vString, err = b.bldSourceUid.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("SourceUid", err)
		}
		r.SourceUid = vString

	}

	if b.bldSourceIp != nil {

		if vIface, err = b.bldSourceIp.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("SourceIp", err)
		}

		r.SourceIp = vIface.(net.IP)

	}

	if b.bldDestinationUid != nil {

		vString, err = b.bldDestinationUid.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("DestinationUid", err)
		}
		r.DestinationUid = vString

	}

	if b.bldDestinationIp != nil {

		if vIface, err = b.bldDestinationIp.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("DestinationIp", err)
		}

		r.DestinationIp = vIface.(net.IP)

	}

	if b.bldOriginUid != nil {

		vString, err = b.bldOriginUid.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("OriginUid", err)
		}
		r.OriginUid = vString

	}

	if b.bldOriginIp != nil {

		if vIface, err = b.bldOriginIp.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("OriginIp", err)
		}

		r.OriginIp = vIface.(net.IP)

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_servicecontrolreport_Template struct {

	// builder for field api_version: string.

	bldApiVersion compiled.Expression

	// builder for field api_operation: string.

	bldApiOperation compiled.Expression

	// builder for field api_protocol: string.

	bldApiProtocol compiled.Expression

	// builder for field api_service: string.

	bldApiService compiled.Expression

	// builder for field api_key: string.

	bldApiKey compiled.Expression

	// builder for field request_time: time.Time.

	bldRequestTime compiled.Expression

	// builder for field request_method: string.

	bldRequestMethod compiled.Expression

	// builder for field request_path: string.

	bldRequestPath compiled.Expression

	// builder for field request_bytes: int64.

	bldRequestBytes compiled.Expression

	// builder for field response_time: time.Time.

	bldResponseTime compiled.Expression

	// builder for field response_code: int64.

	bldResponseCode compiled.Expression

	// builder for field response_bytes: int64.

	bldResponseBytes compiled.Expression

	// builder for field response_latency: time.Duration.

	bldResponseLatency compiled.Expression
} // builder_servicecontrolreport_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_servicecontrolreport_Template(
	expb *compiled.ExpressionBuilder,
	param *servicecontrolreport.InstanceParam) (*builder_servicecontrolreport_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_servicecontrolreport_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.ApiVersion == "" {
		b.bldApiVersion = nil
	} else {
		b.bldApiVersion, expType, err = expb.Compile(param.ApiVersion)
		if err != nil {
			return nil, template.NewErrorPath("ApiVersion", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiVersion)
			return nil, template.NewErrorPath("ApiVersion", err)
		}

	}

	if param.ApiOperation == "" {
		b.bldApiOperation = nil
	} else {
		b.bldApiOperation, expType, err = expb.Compile(param.ApiOperation)
		if err != nil {
			return nil, template.NewErrorPath("ApiOperation", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiOperation)
			return nil, template.NewErrorPath("ApiOperation", err)
		}

	}

	if param.ApiProtocol == "" {
		b.bldApiProtocol = nil
	} else {
		b.bldApiProtocol, expType, err = expb.Compile(param.ApiProtocol)
		if err != nil {
			return nil, template.NewErrorPath("ApiProtocol", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiProtocol)
			return nil, template.NewErrorPath("ApiProtocol", err)
		}

	}

	if param.ApiService == "" {
		b.bldApiService = nil
	} else {
		b.bldApiService, expType, err = expb.Compile(param.ApiService)
		if err != nil {
			return nil, template.NewErrorPath("ApiService", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiService)
			return nil, template.NewErrorPath("ApiService", err)
		}

	}

	if param.ApiKey == "" {
		b.bldApiKey = nil
	} else {
		b.bldApiKey, expType, err = expb.Compile(param.ApiKey)
		if err != nil {
			return nil, template.NewErrorPath("ApiKey", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiKey)
			return nil, template.NewErrorPath("ApiKey", err)
		}

	}

	if param.RequestTime == "" {
		b.bldRequestTime = nil
	} else {
		b.bldRequestTime, expType, err = expb.Compile(param.RequestTime)
		if err != nil {
			return nil, template.NewErrorPath("RequestTime", err)
		}

	}

	if param.RequestMethod == "" {
		b.bldRequestMethod = nil
	} else {
		b.bldRequestMethod, expType, err = expb.Compile(param.RequestMethod)
		if err != nil {
			return nil, template.NewErrorPath("RequestMethod", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.RequestMethod)
			return nil, template.NewErrorPath("RequestMethod", err)
		}

	}

	if param.RequestPath == "" {
		b.bldRequestPath = nil
	} else {
		b.bldRequestPath, expType, err = expb.Compile(param.RequestPath)
		if err != nil {
			return nil, template.NewErrorPath("RequestPath", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.RequestPath)
			return nil, template.NewErrorPath("RequestPath", err)
		}

	}

	if param.RequestBytes == "" {
		b.bldRequestBytes = nil
	} else {
		b.bldRequestBytes, expType, err = expb.Compile(param.RequestBytes)
		if err != nil {
			return nil, template.NewErrorPath("RequestBytes", err)
		}

		if expType != istio_policy_v1beta1.INT64 {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.INT64, expType, param.RequestBytes)
			return nil, template.NewErrorPath("RequestBytes", err)
		}

	}

	if param.ResponseTime == "" {
		b.bldResponseTime = nil
	} else {
		b.bldResponseTime, expType, err = expb.Compile(param.ResponseTime)
		if err != nil {
			return nil, template.NewErrorPath("ResponseTime", err)
		}

	}

	if param.ResponseCode == "" {
		b.bldResponseCode = nil
	} else {
		b.bldResponseCode, expType, err = expb.Compile(param.ResponseCode)
		if err != nil {
			return nil, template.NewErrorPath("ResponseCode", err)
		}

		if expType != istio_policy_v1beta1.INT64 {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.INT64, expType, param.ResponseCode)
			return nil, template.NewErrorPath("ResponseCode", err)
		}

	}

	if param.ResponseBytes == "" {
		b.bldResponseBytes = nil
	} else {
		b.bldResponseBytes, expType, err = expb.Compile(param.ResponseBytes)
		if err != nil {
			return nil, template.NewErrorPath("ResponseBytes", err)
		}

		if expType != istio_policy_v1beta1.INT64 {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.INT64, expType, param.ResponseBytes)
			return nil, template.NewErrorPath("ResponseBytes", err)
		}

	}

	if param.ResponseLatency == "" {
		b.bldResponseLatency = nil
	} else {
		b.bldResponseLatency, expType, err = expb.Compile(param.ResponseLatency)
		if err != nil {
			return nil, template.NewErrorPath("ResponseLatency", err)
		}

	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_servicecontrolreport_Template) build(
	attrs attribute.Bag) (*servicecontrolreport.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &servicecontrolreport.Instance{}

	if b.bldApiVersion != nil {

		vString, err = b.bldApiVersion.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiVersion", err)
		}
		r.ApiVersion = vString

	}

	if b.bldApiOperation != nil {

		vString, err = b.bldApiOperation.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiOperation", err)
		}
		r.ApiOperation = vString

	}

	if b.bldApiProtocol != nil {

		vString, err = b.bldApiProtocol.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiProtocol", err)
		}
		r.ApiProtocol = vString

	}

	if b.bldApiService != nil {

		vString, err = b.bldApiService.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiService", err)
		}
		r.ApiService = vString

	}

	if b.bldApiKey != nil {

		vString, err = b.bldApiKey.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiKey", err)
		}
		r.ApiKey = vString

	}

	if b.bldRequestTime != nil {

		if vIface, err = b.bldRequestTime.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("RequestTime", err)
		}

		r.RequestTime = vIface.(time.Time)

	}

	if b.bldRequestMethod != nil {

		vString, err = b.bldRequestMethod.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("RequestMethod", err)
		}
		r.RequestMethod = vString

	}

	if b.bldRequestPath != nil {

		vString, err = b.bldRequestPath.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("RequestPath", err)
		}
		r.RequestPath = vString

	}

	if b.bldRequestBytes != nil {

		vInt, err = b.bldRequestBytes.EvaluateInteger(attrs)
		if err != nil {
			return nil, template.NewErrorPath("RequestBytes", err)
		}
		r.RequestBytes = vInt

	}

	if b.bldResponseTime != nil {

		if vIface, err = b.bldResponseTime.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("ResponseTime", err)
		}

		r.ResponseTime = vIface.(time.Time)

	}

	if b.bldResponseCode != nil {

		vInt, err = b.bldResponseCode.EvaluateInteger(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ResponseCode", err)
		}
		r.ResponseCode = vInt

	}

	if b.bldResponseBytes != nil {

		vInt, err = b.bldResponseBytes.EvaluateInteger(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ResponseBytes", err)
		}
		r.ResponseBytes = vInt

	}

	if b.bldResponseLatency != nil {

		if vIface, err = b.bldResponseLatency.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("ResponseLatency", err)
		}

		r.ResponseLatency = vIface.(time.Duration)

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_apikey_Template struct {

	// builder for field api: string.

	bldApi compiled.Expression

	// builder for field api_version: string.

	bldApiVersion compiled.Expression

	// builder for field api_operation: string.

	bldApiOperation compiled.Expression

	// builder for field api_key: string.

	bldApiKey compiled.Expression

	// builder for field timestamp: time.Time.

	bldTimestamp compiled.Expression
} // builder_apikey_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_apikey_Template(
	expb *compiled.ExpressionBuilder,
	param *apikey.InstanceParam) (*builder_apikey_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_apikey_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.Api == "" {
		b.bldApi = nil
	} else {
		b.bldApi, expType, err = expb.Compile(param.Api)
		if err != nil {
			return nil, template.NewErrorPath("Api", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Api)
			return nil, template.NewErrorPath("Api", err)
		}

	}

	if param.ApiVersion == "" {
		b.bldApiVersion = nil
	} else {
		b.bldApiVersion, expType, err = expb.Compile(param.ApiVersion)
		if err != nil {
			return nil, template.NewErrorPath("ApiVersion", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiVersion)
			return nil, template.NewErrorPath("ApiVersion", err)
		}

	}

	if param.ApiOperation == "" {
		b.bldApiOperation = nil
	} else {
		b.bldApiOperation, expType, err = expb.Compile(param.ApiOperation)
		if err != nil {
			return nil, template.NewErrorPath("ApiOperation", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiOperation)
			return nil, template.NewErrorPath("ApiOperation", err)
		}

	}

	if param.ApiKey == "" {
		b.bldApiKey = nil
	} else {
		b.bldApiKey, expType, err = expb.Compile(param.ApiKey)
		if err != nil {
			return nil, template.NewErrorPath("ApiKey", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ApiKey)
			return nil, template.NewErrorPath("ApiKey", err)
		}

	}

	if param.Timestamp == "" {
		b.bldTimestamp = nil
	} else {
		b.bldTimestamp, expType, err = expb.Compile(param.Timestamp)
		if err != nil {
			return nil, template.NewErrorPath("Timestamp", err)
		}

	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_apikey_Template) build(
	attrs attribute.Bag) (*apikey.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &apikey.Instance{}

	if b.bldApi != nil {

		vString, err = b.bldApi.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Api", err)
		}
		r.Api = vString

	}

	if b.bldApiVersion != nil {

		vString, err = b.bldApiVersion.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiVersion", err)
		}
		r.ApiVersion = vString

	}

	if b.bldApiOperation != nil {

		vString, err = b.bldApiOperation.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiOperation", err)
		}
		r.ApiOperation = vString

	}

	if b.bldApiKey != nil {

		vString, err = b.bldApiKey.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ApiKey", err)
		}
		r.ApiKey = vString

	}

	if b.bldTimestamp != nil {

		if vIface, err = b.bldTimestamp.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Timestamp", err)
		}

		r.Timestamp = vIface.(time.Time)

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_authorization_Template struct {

	// builder for field subject: *Subject.

	bldSubject *builder_authorization_Subject

	// builder for field action: *Action.

	bldAction *builder_authorization_Action
} // builder_authorization_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_authorization_Template(
	expb *compiled.ExpressionBuilder,
	param *authorization.InstanceParam) (*builder_authorization_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_authorization_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if b.bldSubject, errp = newBuilder_authorization_Subject(expb, param.Subject); !errp.IsNil() {
		return nil, errp.WithPrefix("Subject")
	}

	if b.bldAction, errp = newBuilder_authorization_Action(expb, param.Action); !errp.IsNil() {
		return nil, errp.WithPrefix("Action")
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_authorization_Template) build(
	attrs attribute.Bag) (*authorization.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &authorization.Instance{}

	if b.bldSubject != nil {

		if r.Subject, errp = b.bldSubject.build(attrs); !errp.IsNil() {
			return nil, errp.WithPrefix("Subject")
		}

	}

	if b.bldAction != nil {

		if r.Action, errp = b.bldAction.build(attrs); !errp.IsNil() {
			return nil, errp.WithPrefix("Action")
		}

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Subject.
type builder_authorization_Subject struct {

	// builder for field user: string.

	bldUser compiled.Expression

	// builder for field groups: string.

	bldGroups compiled.Expression

	// builder for field properties: map[string]interface{}.

	bldProperties map[string]compiled.Expression
} // builder_authorization_Subject

// Instantiates and returns a new builder for Subject, based on the provided instance parameter.
func newBuilder_authorization_Subject(
	expb *compiled.ExpressionBuilder,
	param *authorization.SubjectInstanceParam) (*builder_authorization_Subject, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_authorization_Subject{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.User == "" {
		b.bldUser = nil
	} else {
		b.bldUser, expType, err = expb.Compile(param.User)
		if err != nil {
			return nil, template.NewErrorPath("User", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.User)
			return nil, template.NewErrorPath("User", err)
		}

	}

	if param.Groups == "" {
		b.bldGroups = nil
	} else {
		b.bldGroups, expType, err = expb.Compile(param.Groups)
		if err != nil {
			return nil, template.NewErrorPath("Groups", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Groups)
			return nil, template.NewErrorPath("Groups", err)
		}

	}

	b.bldProperties = make(map[string]compiled.Expression, len(param.Properties))
	for k, v := range param.Properties {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("Properties["+k+"]", err)
		}

		b.bldProperties[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_authorization_Subject) build(
	attrs attribute.Bag) (*authorization.Subject, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &authorization.Subject{}

	if b.bldUser != nil {

		vString, err = b.bldUser.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("User", err)
		}
		r.User = vString

	}

	if b.bldGroups != nil {

		vString, err = b.bldGroups.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Groups", err)
		}
		r.Groups = vString

	}

	r.Properties = make(map[string]interface{}, len(b.bldProperties))

	for k, v := range b.bldProperties {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Properties["+k+"]", err)
		}

		r.Properties[k] = vIface

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Action.
type builder_authorization_Action struct {

	// builder for field namespace: string.

	bldNamespace compiled.Expression

	// builder for field service: string.

	bldService compiled.Expression

	// builder for field method: string.

	bldMethod compiled.Expression

	// builder for field path: string.

	bldPath compiled.Expression

	// builder for field properties: map[string]interface{}.

	bldProperties map[string]compiled.Expression
} // builder_authorization_Action

// Instantiates and returns a new builder for Action, based on the provided instance parameter.
func newBuilder_authorization_Action(
	expb *compiled.ExpressionBuilder,
	param *authorization.ActionInstanceParam) (*builder_authorization_Action, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_authorization_Action{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.Namespace == "" {
		b.bldNamespace = nil
	} else {
		b.bldNamespace, expType, err = expb.Compile(param.Namespace)
		if err != nil {
			return nil, template.NewErrorPath("Namespace", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Namespace)
			return nil, template.NewErrorPath("Namespace", err)
		}

	}

	if param.Service == "" {
		b.bldService = nil
	} else {
		b.bldService, expType, err = expb.Compile(param.Service)
		if err != nil {
			return nil, template.NewErrorPath("Service", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Service)
			return nil, template.NewErrorPath("Service", err)
		}

	}

	if param.Method == "" {
		b.bldMethod = nil
	} else {
		b.bldMethod, expType, err = expb.Compile(param.Method)
		if err != nil {
			return nil, template.NewErrorPath("Method", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Method)
			return nil, template.NewErrorPath("Method", err)
		}

	}

	if param.Path == "" {
		b.bldPath = nil
	} else {
		b.bldPath, expType, err = expb.Compile(param.Path)
		if err != nil {
			return nil, template.NewErrorPath("Path", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Path)
			return nil, template.NewErrorPath("Path", err)
		}

	}

	b.bldProperties = make(map[string]compiled.Expression, len(param.Properties))
	for k, v := range param.Properties {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("Properties["+k+"]", err)
		}

		b.bldProperties[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_authorization_Action) build(
	attrs attribute.Bag) (*authorization.Action, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &authorization.Action{}

	if b.bldNamespace != nil {

		vString, err = b.bldNamespace.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Namespace", err)
		}
		r.Namespace = vString

	}

	if b.bldService != nil {

		vString, err = b.bldService.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Service", err)
		}
		r.Service = vString

	}

	if b.bldMethod != nil {

		vString, err = b.bldMethod.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Method", err)
		}
		r.Method = vString

	}

	if b.bldPath != nil {

		vString, err = b.bldPath.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Path", err)
		}
		r.Path = vString

	}

	r.Properties = make(map[string]interface{}, len(b.bldProperties))

	for k, v := range b.bldProperties {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Properties["+k+"]", err)
		}

		r.Properties[k] = vIface

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_checknothing_Template struct {
} // builder_checknothing_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_checknothing_Template(
	expb *compiled.ExpressionBuilder,
	param *checknothing.InstanceParam) (*builder_checknothing_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_checknothing_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_checknothing_Template) build(
	attrs attribute.Bag) (*checknothing.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &checknothing.Instance{}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_listentry_Template struct {

	// builder for field value: string.

	bldValue compiled.Expression
} // builder_listentry_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_listentry_Template(
	expb *compiled.ExpressionBuilder,
	param *listentry.InstanceParam) (*builder_listentry_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_listentry_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.Value == "" {
		b.bldValue = nil
	} else {
		b.bldValue, expType, err = expb.Compile(param.Value)
		if err != nil {
			return nil, template.NewErrorPath("Value", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Value)
			return nil, template.NewErrorPath("Value", err)
		}

	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_listentry_Template) build(
	attrs attribute.Bag) (*listentry.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &listentry.Instance{}

	if b.bldValue != nil {

		vString, err = b.bldValue.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Value", err)
		}
		r.Value = vString

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_logentry_Template struct {

	// builder for field variables: map[string]interface{}.

	bldVariables map[string]compiled.Expression

	// builder for field timestamp: time.Time.

	bldTimestamp compiled.Expression

	// builder for field severity: string.

	bldSeverity compiled.Expression

	// builder for field monitored_resource_type: string.

	bldMonitoredResourceType compiled.Expression

	// builder for field monitored_resource_dimensions: map[string]interface{}.

	bldMonitoredResourceDimensions map[string]compiled.Expression
} // builder_logentry_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_logentry_Template(
	expb *compiled.ExpressionBuilder,
	param *logentry.InstanceParam) (*builder_logentry_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_logentry_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	b.bldVariables = make(map[string]compiled.Expression, len(param.Variables))
	for k, v := range param.Variables {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("Variables["+k+"]", err)
		}

		b.bldVariables[k] = exp
	}

	if param.Timestamp == "" {
		b.bldTimestamp = nil
	} else {
		b.bldTimestamp, expType, err = expb.Compile(param.Timestamp)
		if err != nil {
			return nil, template.NewErrorPath("Timestamp", err)
		}

	}

	if param.Severity == "" {
		b.bldSeverity = nil
	} else {
		b.bldSeverity, expType, err = expb.Compile(param.Severity)
		if err != nil {
			return nil, template.NewErrorPath("Severity", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.Severity)
			return nil, template.NewErrorPath("Severity", err)
		}

	}

	if param.MonitoredResourceType == "" {
		b.bldMonitoredResourceType = nil
	} else {
		b.bldMonitoredResourceType, expType, err = expb.Compile(param.MonitoredResourceType)
		if err != nil {
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.MonitoredResourceType)
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}

	}

	b.bldMonitoredResourceDimensions = make(map[string]compiled.Expression, len(param.MonitoredResourceDimensions))
	for k, v := range param.MonitoredResourceDimensions {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("MonitoredResourceDimensions["+k+"]", err)
		}

		b.bldMonitoredResourceDimensions[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_logentry_Template) build(
	attrs attribute.Bag) (*logentry.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &logentry.Instance{}

	r.Variables = make(map[string]interface{}, len(b.bldVariables))

	for k, v := range b.bldVariables {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Variables["+k+"]", err)
		}

		r.Variables[k] = vIface

	}

	if b.bldTimestamp != nil {

		if vIface, err = b.bldTimestamp.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Timestamp", err)
		}

		r.Timestamp = vIface.(time.Time)

	}

	if b.bldSeverity != nil {

		vString, err = b.bldSeverity.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("Severity", err)
		}
		r.Severity = vString

	}

	if b.bldMonitoredResourceType != nil {

		vString, err = b.bldMonitoredResourceType.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}
		r.MonitoredResourceType = vString

	}

	r.MonitoredResourceDimensions = make(map[string]interface{}, len(b.bldMonitoredResourceDimensions))

	for k, v := range b.bldMonitoredResourceDimensions {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("MonitoredResourceDimensions["+k+"]", err)
		}

		r.MonitoredResourceDimensions[k] = vIface

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_metric_Template struct {

	// builder for field value: interface{}.

	bldValue compiled.Expression

	// builder for field dimensions: map[string]interface{}.

	bldDimensions map[string]compiled.Expression

	// builder for field monitored_resource_type: string.

	bldMonitoredResourceType compiled.Expression

	// builder for field monitored_resource_dimensions: map[string]interface{}.

	bldMonitoredResourceDimensions map[string]compiled.Expression
} // builder_metric_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_metric_Template(
	expb *compiled.ExpressionBuilder,
	param *metric.InstanceParam) (*builder_metric_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_metric_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.Value == "" {
		b.bldValue = nil
	} else {
		b.bldValue, expType, err = expb.Compile(param.Value)
		if err != nil {
			return nil, template.NewErrorPath("Value", err)
		}

	}

	b.bldDimensions = make(map[string]compiled.Expression, len(param.Dimensions))
	for k, v := range param.Dimensions {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("Dimensions["+k+"]", err)
		}

		b.bldDimensions[k] = exp
	}

	if param.MonitoredResourceType == "" {
		b.bldMonitoredResourceType = nil
	} else {
		b.bldMonitoredResourceType, expType, err = expb.Compile(param.MonitoredResourceType)
		if err != nil {
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.MonitoredResourceType)
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}

	}

	b.bldMonitoredResourceDimensions = make(map[string]compiled.Expression, len(param.MonitoredResourceDimensions))
	for k, v := range param.MonitoredResourceDimensions {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("MonitoredResourceDimensions["+k+"]", err)
		}

		b.bldMonitoredResourceDimensions[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_metric_Template) build(
	attrs attribute.Bag) (*metric.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &metric.Instance{}

	if b.bldValue != nil {

		if vIface, err = b.bldValue.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Value", err)
		}

		r.Value = vIface

	}

	r.Dimensions = make(map[string]interface{}, len(b.bldDimensions))

	for k, v := range b.bldDimensions {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Dimensions["+k+"]", err)
		}

		r.Dimensions[k] = vIface

	}

	if b.bldMonitoredResourceType != nil {

		vString, err = b.bldMonitoredResourceType.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("MonitoredResourceType", err)
		}
		r.MonitoredResourceType = vString

	}

	r.MonitoredResourceDimensions = make(map[string]interface{}, len(b.bldMonitoredResourceDimensions))

	for k, v := range b.bldMonitoredResourceDimensions {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("MonitoredResourceDimensions["+k+"]", err)
		}

		r.MonitoredResourceDimensions[k] = vIface

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_quota_Template struct {

	// builder for field dimensions: map[string]interface{}.

	bldDimensions map[string]compiled.Expression
} // builder_quota_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_quota_Template(
	expb *compiled.ExpressionBuilder,
	param *quota.InstanceParam) (*builder_quota_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_quota_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	b.bldDimensions = make(map[string]compiled.Expression, len(param.Dimensions))
	for k, v := range param.Dimensions {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("Dimensions["+k+"]", err)
		}

		b.bldDimensions[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_quota_Template) build(
	attrs attribute.Bag) (*quota.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &quota.Instance{}

	r.Dimensions = make(map[string]interface{}, len(b.bldDimensions))

	for k, v := range b.bldDimensions {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("Dimensions["+k+"]", err)
		}

		r.Dimensions[k] = vIface

	}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_reportnothing_Template struct {
} // builder_reportnothing_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_reportnothing_Template(
	expb *compiled.ExpressionBuilder,
	param *reportnothing.InstanceParam) (*builder_reportnothing_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_reportnothing_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_reportnothing_Template) build(
	attrs attribute.Bag) (*reportnothing.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &reportnothing.Instance{}

	return r, template.ErrorPath{}
}

// builder struct for constructing an instance of Template.
type builder_tracespan_Template struct {

	// builder for field trace_id: string.

	bldTraceId compiled.Expression

	// builder for field span_id: string.

	bldSpanId compiled.Expression

	// builder for field parent_span_id: string.

	bldParentSpanId compiled.Expression

	// builder for field span_name: string.

	bldSpanName compiled.Expression

	// builder for field start_time: time.Time.

	bldStartTime compiled.Expression

	// builder for field end_time: time.Time.

	bldEndTime compiled.Expression

	// builder for field span_tags: map[string]interface{}.

	bldSpanTags map[string]compiled.Expression
} // builder_tracespan_Template

// Instantiates and returns a new builder for Template, based on the provided instance parameter.
func newBuilder_tracespan_Template(
	expb *compiled.ExpressionBuilder,
	param *tracespan.InstanceParam) (*builder_tracespan_Template, template.ErrorPath) {

	// If the parameter is nil. Simply return nil. The builder, then, will also return nil.
	if param == nil {
		return nil, template.ErrorPath{}
	}

	b := &builder_tracespan_Template{}

	var exp compiled.Expression
	_ = exp
	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var expType istio_policy_v1beta1.ValueType
	_ = expType

	if param.TraceId == "" {
		b.bldTraceId = nil
	} else {
		b.bldTraceId, expType, err = expb.Compile(param.TraceId)
		if err != nil {
			return nil, template.NewErrorPath("TraceId", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.TraceId)
			return nil, template.NewErrorPath("TraceId", err)
		}

	}

	if param.SpanId == "" {
		b.bldSpanId = nil
	} else {
		b.bldSpanId, expType, err = expb.Compile(param.SpanId)
		if err != nil {
			return nil, template.NewErrorPath("SpanId", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.SpanId)
			return nil, template.NewErrorPath("SpanId", err)
		}

	}

	if param.ParentSpanId == "" {
		b.bldParentSpanId = nil
	} else {
		b.bldParentSpanId, expType, err = expb.Compile(param.ParentSpanId)
		if err != nil {
			return nil, template.NewErrorPath("ParentSpanId", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.ParentSpanId)
			return nil, template.NewErrorPath("ParentSpanId", err)
		}

	}

	if param.SpanName == "" {
		b.bldSpanName = nil
	} else {
		b.bldSpanName, expType, err = expb.Compile(param.SpanName)
		if err != nil {
			return nil, template.NewErrorPath("SpanName", err)
		}

		if expType != istio_policy_v1beta1.STRING {
			err = fmt.Errorf("instance field type mismatch: expected='%v', actual='%v', expression='%s'", istio_policy_v1beta1.STRING, expType, param.SpanName)
			return nil, template.NewErrorPath("SpanName", err)
		}

	}

	if param.StartTime == "" {
		b.bldStartTime = nil
	} else {
		b.bldStartTime, expType, err = expb.Compile(param.StartTime)
		if err != nil {
			return nil, template.NewErrorPath("StartTime", err)
		}

	}

	if param.EndTime == "" {
		b.bldEndTime = nil
	} else {
		b.bldEndTime, expType, err = expb.Compile(param.EndTime)
		if err != nil {
			return nil, template.NewErrorPath("EndTime", err)
		}

	}

	b.bldSpanTags = make(map[string]compiled.Expression, len(param.SpanTags))
	for k, v := range param.SpanTags {
		var exp compiled.Expression
		if exp, expType, err = expb.Compile(v); err != nil {
			return nil, template.NewErrorPath("SpanTags["+k+"]", err)
		}

		b.bldSpanTags[k] = exp
	}

	return b, template.ErrorPath{}
}

// build and return the instance, given a set of attributes.
func (b *builder_tracespan_Template) build(
	attrs attribute.Bag) (*tracespan.Instance, template.ErrorPath) {

	if b == nil {
		return nil, template.ErrorPath{}
	}

	var err error
	_ = err
	var errp template.ErrorPath
	_ = errp
	var vBool bool
	_ = vBool
	var vInt int64
	_ = vInt
	var vString string
	_ = vString
	var vDouble float64
	_ = vDouble
	var vIface interface{}
	_ = vIface

	r := &tracespan.Instance{}

	if b.bldTraceId != nil {

		vString, err = b.bldTraceId.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("TraceId", err)
		}
		r.TraceId = vString

	}

	if b.bldSpanId != nil {

		vString, err = b.bldSpanId.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("SpanId", err)
		}
		r.SpanId = vString

	}

	if b.bldParentSpanId != nil {

		vString, err = b.bldParentSpanId.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("ParentSpanId", err)
		}
		r.ParentSpanId = vString

	}

	if b.bldSpanName != nil {

		vString, err = b.bldSpanName.EvaluateString(attrs)
		if err != nil {
			return nil, template.NewErrorPath("SpanName", err)
		}
		r.SpanName = vString

	}

	if b.bldStartTime != nil {

		if vIface, err = b.bldStartTime.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("StartTime", err)
		}

		r.StartTime = vIface.(time.Time)

	}

	if b.bldEndTime != nil {

		if vIface, err = b.bldEndTime.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("EndTime", err)
		}

		r.EndTime = vIface.(time.Time)

	}

	r.SpanTags = make(map[string]interface{}, len(b.bldSpanTags))

	for k, v := range b.bldSpanTags {

		if vIface, err = v.Evaluate(attrs); err != nil {
			return nil, template.NewErrorPath("SpanTags["+k+"]", err)
		}

		r.SpanTags[k] = vIface

	}

	return r, template.ErrorPath{}
}
