// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/stackdriver/config/config.proto

/*
	Package config is a generated protocol buffer package.

	The `stackdriver` adapter enables Istio to deliver log and metric data to the
	[Stackdriver](https://cloud.google.com/stackdriver/) logging and monitoring backend.

	It is generated from these files:
		mixer/adapter/stackdriver/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import google_api1 "google.golang.org/genproto/googleapis/api/metric"
import _ "github.com/gogo/protobuf/types"

import time "time"

import encoding_binary "encoding/binary"
import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration format for the `stackdriver` adapter.
type Params struct {
	// Endpoint URL to send stackdriver data - leave empty to use the
	// StackDriver SDK's default value (monitoring.googleapis.com).
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// GCP Project to attach metrics to.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// This adapter batches the data it sends to Stackdriver; we will push to stackdriver every push_interval.
	// If no value is provided we default to once per minute.
	PushInterval time.Duration `protobuf:"bytes,3,opt,name=push_interval,json=pushInterval,stdduration" json:"push_interval"`
	// Credentials must be attached to every call made to StackDriver. This
	// can be an API key, a service account secret key, or Oauth2 tokens.
	//
	// TODO: do we want to support oauth?
	//
	// Types that are valid to be assigned to Creds:
	//	*Params_AppCredentials
	//	*Params_ApiKey
	//	*Params_ServiceAccountPath
	Creds isParams_Creds `protobuf_oneof:"creds"`
	// A map of Istio metric name to Stackdriver metric info.
	MetricInfo map[string]*Params_MetricInfo `protobuf:"bytes,8,rep,name=metric_info,json=metricInfo" json:"metric_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// A map of Istio LogEntry name to Stackdriver log info.
	LogInfo map[string]*Params_LogInfo `protobuf:"bytes,9,rep,name=log_info,json=logInfo" json:"log_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

type isParams_Creds interface {
	isParams_Creds()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Params_AppCredentials struct {
	AppCredentials bool `protobuf:"varint,4,opt,name=app_credentials,json=appCredentials,proto3,oneof"`
}
type Params_ApiKey struct {
	ApiKey string `protobuf:"bytes,5,opt,name=api_key,json=apiKey,proto3,oneof"`
}
type Params_ServiceAccountPath struct {
	ServiceAccountPath string `protobuf:"bytes,6,opt,name=service_account_path,json=serviceAccountPath,proto3,oneof"`
}

func (*Params_AppCredentials) isParams_Creds()     {}
func (*Params_ApiKey) isParams_Creds()             {}
func (*Params_ServiceAccountPath) isParams_Creds() {}

func (m *Params) GetCreds() isParams_Creds {
	if m != nil {
		return m.Creds
	}
	return nil
}

func (m *Params) GetAppCredentials() bool {
	if x, ok := m.GetCreds().(*Params_AppCredentials); ok {
		return x.AppCredentials
	}
	return false
}

func (m *Params) GetApiKey() string {
	if x, ok := m.GetCreds().(*Params_ApiKey); ok {
		return x.ApiKey
	}
	return ""
}

func (m *Params) GetServiceAccountPath() string {
	if x, ok := m.GetCreds().(*Params_ServiceAccountPath); ok {
		return x.ServiceAccountPath
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Params) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Params_OneofMarshaler, _Params_OneofUnmarshaler, _Params_OneofSizer, []interface{}{
		(*Params_AppCredentials)(nil),
		(*Params_ApiKey)(nil),
		(*Params_ServiceAccountPath)(nil),
	}
}

func _Params_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Params)
	// creds
	switch x := m.Creds.(type) {
	case *Params_AppCredentials:
		t := uint64(0)
		if x.AppCredentials {
			t = 1
		}
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Params_ApiKey:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ApiKey)
	case *Params_ServiceAccountPath:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ServiceAccountPath)
	case nil:
	default:
		return fmt.Errorf("Params.Creds has unexpected type %T", x)
	}
	return nil
}

func _Params_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Params)
	switch tag {
	case 4: // creds.app_credentials
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Creds = &Params_AppCredentials{x != 0}
		return true, err
	case 5: // creds.api_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Creds = &Params_ApiKey{x}
		return true, err
	case 6: // creds.service_account_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Creds = &Params_ServiceAccountPath{x}
		return true, err
	default:
		return false, nil
	}
}

func _Params_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Params)
	// creds
	switch x := m.Creds.(type) {
	case *Params_AppCredentials:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += 1
	case *Params_ApiKey:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ApiKey)))
		n += len(x.ApiKey)
	case *Params_ServiceAccountPath:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ServiceAccountPath)))
		n += len(x.ServiceAccountPath)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes how to represent an Istio metric in Stackdriver.
// See https://github.com/googleapis/googleapis/blob/master/google/api/metric.proto
type Params_MetricInfo struct {
	Kind  google_api1.MetricDescriptor_MetricKind `protobuf:"varint,1,opt,name=kind,proto3,enum=google.api.MetricDescriptor_MetricKind" json:"kind,omitempty"`
	Value google_api1.MetricDescriptor_ValueType  `protobuf:"varint,2,opt,name=value,proto3,enum=google.api.MetricDescriptor_ValueType" json:"value,omitempty"`
	// For metrics with a metric value of DISTRIBUTION, this provides a mechanism
	// for configuring the buckets that will be used to store the aggregated values.
	// This field must be provided for metrics declared to be of type DISTRIBUTION.
	// This field will be ignored for non-distribution metric kinds.
	Buckets *Params_MetricInfo_BucketsDefinition `protobuf:"bytes,3,opt,name=buckets" json:"buckets,omitempty"`
}

func (m *Params_MetricInfo) Reset()                    { *m = Params_MetricInfo{} }
func (*Params_MetricInfo) ProtoMessage()               {}
func (*Params_MetricInfo) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0, 0} }

// Describes buckets for DISTRIBUTION valued metrics.
// TODO: look into using google.api.distribution.proto instead - we would pull it in but it has a ton of
// dependencies it doesn't actually use.
type Params_MetricInfo_BucketsDefinition struct {
	// Exactly one of these three fields must be set.
	//
	// Types that are valid to be assigned to Definition:
	//	*Params_MetricInfo_BucketsDefinition_LinearBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExponentialBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExplicitBuckets
	Definition isParams_MetricInfo_BucketsDefinition_Definition `protobuf_oneof:"definition"`
}

func (m *Params_MetricInfo_BucketsDefinition) Reset()      { *m = Params_MetricInfo_BucketsDefinition{} }
func (*Params_MetricInfo_BucketsDefinition) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0}
}

type isParams_MetricInfo_BucketsDefinition_Definition interface {
	isParams_MetricInfo_BucketsDefinition_Definition()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Params_MetricInfo_BucketsDefinition_LinearBuckets struct {
	LinearBuckets *Params_MetricInfo_BucketsDefinition_Linear `protobuf:"bytes,1,opt,name=linear_buckets,json=linearBuckets,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExponentialBuckets struct {
	ExponentialBuckets *Params_MetricInfo_BucketsDefinition_Exponential `protobuf:"bytes,2,opt,name=exponential_buckets,json=exponentialBuckets,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExplicitBuckets struct {
	ExplicitBuckets *Params_MetricInfo_BucketsDefinition_Explicit `protobuf:"bytes,3,opt,name=explicit_buckets,json=explicitBuckets,oneof"`
}

func (*Params_MetricInfo_BucketsDefinition_LinearBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExponentialBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExplicitBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}

func (m *Params_MetricInfo_BucketsDefinition) GetDefinition() isParams_MetricInfo_BucketsDefinition_Definition {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetLinearBuckets() *Params_MetricInfo_BucketsDefinition_Linear {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_LinearBuckets); ok {
		return x.LinearBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExponentialBuckets() *Params_MetricInfo_BucketsDefinition_Exponential {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets); ok {
		return x.ExponentialBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExplicitBuckets() *Params_MetricInfo_BucketsDefinition_Explicit {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets); ok {
		return x.ExplicitBuckets
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Params_MetricInfo_BucketsDefinition) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Params_MetricInfo_BucketsDefinition_OneofMarshaler, _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler, _Params_MetricInfo_BucketsDefinition_OneofSizer, []interface{}{
		(*Params_MetricInfo_BucketsDefinition_LinearBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets)(nil),
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LinearBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExponentialBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExplicitBuckets); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Params_MetricInfo_BucketsDefinition.Definition has unexpected type %T", x)
	}
	return nil
}

func _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	switch tag {
	case 1: // definition.linear_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Linear)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{msg}
		return true, err
	case 2: // definition.exponential_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Exponential)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{msg}
		return true, err
	case 3: // definition.explicit_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Explicit)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		s := proto.Size(x.LinearBuckets)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		s := proto.Size(x.ExponentialBuckets)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		s := proto.Size(x.ExplicitBuckets)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a linear sequence of buckets that all have the same width
// (except overflow and underflow). Each bucket represents a constant
// absolute uncertainty on the specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (`0 <= i < N-1`): `offset + (width * i)`
// * Lower bound (`1 <= i < N`): `offset + (width * (i - 1))`
type Params_MetricInfo_BucketsDefinition_Linear struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 0.
	Width float64 `protobuf:"fixed64,2,opt,name=width,proto3" json:"width,omitempty"`
	// Lower bound of the first bucket.
	Offset float64 `protobuf:"fixed64,3,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Linear{}
}
func (*Params_MetricInfo_BucketsDefinition_Linear) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Linear) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 0}
}

// Specifies an exponential sequence of buckets that have a width that is
// proportional to the value of the lower bound. Each bucket represents a
// constant relative uncertainty on a specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (0 <= i < N-1): `scale * (growth_factor ^ i)`
// * Lower bound (1 <= i < N): `scale * (growth_factor ^ (i - 1))`
type Params_MetricInfo_BucketsDefinition_Exponential struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 1.
	GrowthFactor float64 `protobuf:"fixed64,2,opt,name=growth_factor,json=growthFactor,proto3" json:"growth_factor,omitempty"`
	// Must be greater than 0.
	Scale float64 `protobuf:"fixed64,3,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Exponential{}
}
func (*Params_MetricInfo_BucketsDefinition_Exponential) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Exponential) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 1}
}

// Specifies a set of buckets with arbitrary widths.
//
// There are `size(bounds) + 1` (= `N`) buckets. Bucket `i` has the following
// boundaries:
//
// * Upper bound (`0 <= i < N-1`): `bounds[i]`
// * Lower bound (`1 <= i < N`): `bounds[i - 1]`
//
// The `bounds` field must contain at least one element. If `bounds` has
// only one element, then there are no finite buckets, and that single
// element is the common boundary of the overflow and underflow buckets.
type Params_MetricInfo_BucketsDefinition_Explicit struct {
	// The values must be monotonically increasing.
	Bounds []float64 `protobuf:"fixed64,1,rep,packed,name=bounds" json:"bounds,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Explicit{}
}
func (*Params_MetricInfo_BucketsDefinition_Explicit) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Explicit) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 2}
}

// Describes how to represent an Istio Log in Stackdriver.
type Params_LogInfo struct {
	// The logging template provides a set of variables; these list the subset of variables that should be used to
	// form Stackdriver labels for the log entry.
	LabelNames []string `protobuf:"bytes,1,rep,name=label_names,json=labelNames" json:"label_names,omitempty"`
	// A golang text/template template that will be executed to construct the payload for this log entry.
	// It will be given the full set of variables for the log to use to construct its result.
	PayloadTemplate string `protobuf:"bytes,2,opt,name=payload_template,json=payloadTemplate,proto3" json:"payload_template,omitempty"`
	// If an HttpRequestMapping is provided, a HttpRequest object will be filled out for this log entry using the
	// variables named in the mapping to populate the fields of the request struct from the instance's variables.
	HttpMapping *Params_LogInfo_HttpRequestMapping `protobuf:"bytes,3,opt,name=http_mapping,json=httpMapping" json:"http_mapping,omitempty"`
}

func (m *Params_LogInfo) Reset()                    { *m = Params_LogInfo{} }
func (*Params_LogInfo) ProtoMessage()               {}
func (*Params_LogInfo) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0, 2} }

// Maps from template variable names to the various fields of Stackdriver's HTTP request struct.
// See https://godoc.org/cloud.google.com/go/logging#HTTPRequest
type Params_LogInfo_HttpRequestMapping struct {
	// template variable name to map into HTTPRequest.Status
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// template variable name to map into HTTPRequest.RequestSize
	RequestSize string `protobuf:"bytes,2,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// template variable name to map into HTTPRequest.ResponseSize
	ResponseSize string `protobuf:"bytes,3,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// template variable name to map into HTTPRequest.Latency
	Latency string `protobuf:"bytes,4,opt,name=latency,proto3" json:"latency,omitempty"`
	// template variable name to map into HTTPRequest.LocalIP
	LocalIp string `protobuf:"bytes,5,opt,name=local_ip,json=localIp,proto3" json:"local_ip,omitempty"`
	// template variable name to map into HTTPRequest.RemoteIP
	RemoteIp string `protobuf:"bytes,6,opt,name=remote_ip,json=remoteIp,proto3" json:"remote_ip,omitempty"`
}

func (m *Params_LogInfo_HttpRequestMapping) Reset()      { *m = Params_LogInfo_HttpRequestMapping{} }
func (*Params_LogInfo_HttpRequestMapping) ProtoMessage() {}
func (*Params_LogInfo_HttpRequestMapping) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 2, 0}
}

func init() {
	proto.RegisterType((*Params)(nil), "adapter.stackdriver.config.Params")
	proto.RegisterType((*Params_MetricInfo)(nil), "adapter.stackdriver.config.Params.MetricInfo")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Linear)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Linear")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Exponential)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Exponential")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Explicit)(nil), "adapter.stackdriver.config.Params.MetricInfo.BucketsDefinition.Explicit")
	proto.RegisterType((*Params_LogInfo)(nil), "adapter.stackdriver.config.Params.LogInfo")
	proto.RegisterType((*Params_LogInfo_HttpRequestMapping)(nil), "adapter.stackdriver.config.Params.LogInfo.HttpRequestMapping")
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.ProjectId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ProjectId)))
		i += copy(dAtA[i:], m.ProjectId)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintConfig(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushInterval)))
	n1, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.PushInterval, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.Creds != nil {
		nn2, err := m.Creds.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	if len(m.MetricInfo) > 0 {
		for k, _ := range m.MetricInfo {
			dAtA[i] = 0x42
			i++
			v := m.MetricInfo[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovConfig(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovConfig(uint64(len(k))) + msgSize
			i = encodeVarintConfig(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintConfig(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	if len(m.LogInfo) > 0 {
		for k, _ := range m.LogInfo {
			dAtA[i] = 0x4a
			i++
			v := m.LogInfo[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovConfig(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovConfig(uint64(len(k))) + msgSize
			i = encodeVarintConfig(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintConfig(dAtA, i, uint64(v.Size()))
				n4, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n4
			}
		}
	}
	return i, nil
}

func (m *Params_AppCredentials) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x20
	i++
	if m.AppCredentials {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Params_ApiKey) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintConfig(dAtA, i, uint64(len(m.ApiKey)))
	i += copy(dAtA[i:], m.ApiKey)
	return i, nil
}
func (m *Params_ServiceAccountPath) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x32
	i++
	i = encodeVarintConfig(dAtA, i, uint64(len(m.ServiceAccountPath)))
	i += copy(dAtA[i:], m.ServiceAccountPath)
	return i, nil
}
func (m *Params_MetricInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Kind != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Kind))
	}
	if m.Value != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Value))
	}
	if m.Buckets != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Buckets.Size()))
		n5, err := m.Buckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Definition != nil {
		nn6, err := m.Definition.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LinearBuckets != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.LinearBuckets.Size()))
		n7, err := m.LinearBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ExponentialBuckets != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ExponentialBuckets.Size()))
		n8, err := m.ExponentialBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ExplicitBuckets != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ExplicitBuckets.Size()))
		n9, err := m.ExplicitBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
	}
	if m.Width != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Width))))
		i += 8
	}
	if m.Offset != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Offset))))
		i += 8
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
	}
	if m.GrowthFactor != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.GrowthFactor))))
		i += 8
	}
	if m.Scale != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Scale))))
		i += 8
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Bounds)*8))
		for _, num := range m.Bounds {
			f10 := math.Float64bits(float64(num))
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f10))
			i += 8
		}
	}
	return i, nil
}

func (m *Params_LogInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LabelNames) > 0 {
		for _, s := range m.LabelNames {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PayloadTemplate) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PayloadTemplate)))
		i += copy(dAtA[i:], m.PayloadTemplate)
	}
	if m.HttpMapping != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.HttpMapping.Size()))
		n11, err := m.HttpMapping.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *Params_LogInfo_HttpRequestMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_LogInfo_HttpRequestMapping) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Status) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Status)))
		i += copy(dAtA[i:], m.Status)
	}
	if len(m.RequestSize) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RequestSize)))
		i += copy(dAtA[i:], m.RequestSize)
	}
	if len(m.ResponseSize) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ResponseSize)))
		i += copy(dAtA[i:], m.ResponseSize)
	}
	if len(m.Latency) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Latency)))
		i += copy(dAtA[i:], m.Latency)
	}
	if len(m.LocalIp) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.LocalIp)))
		i += copy(dAtA[i:], m.LocalIp)
	}
	if len(m.RemoteIp) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.RemoteIp)))
		i += copy(dAtA[i:], m.RemoteIp)
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushInterval)
	n += 1 + l + sovConfig(uint64(l))
	if m.Creds != nil {
		n += m.Creds.Size()
	}
	if len(m.MetricInfo) > 0 {
		for k, v := range m.MetricInfo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	if len(m.LogInfo) > 0 {
		for k, v := range m.LogInfo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConfig(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConfig(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConfig(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Params_AppCredentials) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Params_ApiKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.ApiKey)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *Params_ServiceAccountPath) Size() (n int) {
	var l int
	_ = l
	l = len(m.ServiceAccountPath)
	n += 1 + l + sovConfig(uint64(l))
	return n
}
func (m *Params_MetricInfo) Size() (n int) {
	var l int
	_ = l
	if m.Kind != 0 {
		n += 1 + sovConfig(uint64(m.Kind))
	}
	if m.Value != 0 {
		n += 1 + sovConfig(uint64(m.Value))
	}
	if m.Buckets != nil {
		l = m.Buckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition) Size() (n int) {
	var l int
	_ = l
	if m.Definition != nil {
		n += m.Definition.Size()
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) Size() (n int) {
	var l int
	_ = l
	if m.LinearBuckets != nil {
		l = m.LinearBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) Size() (n int) {
	var l int
	_ = l
	if m.ExponentialBuckets != nil {
		l = m.ExponentialBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) Size() (n int) {
	var l int
	_ = l
	if m.ExplicitBuckets != nil {
		l = m.ExplicitBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Size() (n int) {
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.Width != 0 {
		n += 9
	}
	if m.Offset != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Size() (n int) {
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.GrowthFactor != 0 {
		n += 9
	}
	if m.Scale != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Size() (n int) {
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		n += 1 + sovConfig(uint64(len(m.Bounds)*8)) + len(m.Bounds)*8
	}
	return n
}

func (m *Params_LogInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.LabelNames) > 0 {
		for _, s := range m.LabelNames {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.PayloadTemplate)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.HttpMapping != nil {
		l = m.HttpMapping.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_LogInfo_HttpRequestMapping) Size() (n int) {
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.RequestSize)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ResponseSize)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Latency)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.LocalIp)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.RemoteIp)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	keysForMetricInfo := make([]string, 0, len(this.MetricInfo))
	for k, _ := range this.MetricInfo {
		keysForMetricInfo = append(keysForMetricInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMetricInfo)
	mapStringForMetricInfo := "map[string]*Params_MetricInfo{"
	for _, k := range keysForMetricInfo {
		mapStringForMetricInfo += fmt.Sprintf("%v: %v,", k, this.MetricInfo[k])
	}
	mapStringForMetricInfo += "}"
	keysForLogInfo := make([]string, 0, len(this.LogInfo))
	for k, _ := range this.LogInfo {
		keysForLogInfo = append(keysForLogInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLogInfo)
	mapStringForLogInfo := "map[string]*Params_LogInfo{"
	for _, k := range keysForLogInfo {
		mapStringForLogInfo += fmt.Sprintf("%v: %v,", k, this.LogInfo[k])
	}
	mapStringForLogInfo += "}"
	s := strings.Join([]string{`&Params{`,
		`Endpoint:` + fmt.Sprintf("%v", this.Endpoint) + `,`,
		`ProjectId:` + fmt.Sprintf("%v", this.ProjectId) + `,`,
		`PushInterval:` + strings.Replace(strings.Replace(this.PushInterval.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`Creds:` + fmt.Sprintf("%v", this.Creds) + `,`,
		`MetricInfo:` + mapStringForMetricInfo + `,`,
		`LogInfo:` + mapStringForLogInfo + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_AppCredentials) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_AppCredentials{`,
		`AppCredentials:` + fmt.Sprintf("%v", this.AppCredentials) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_ApiKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_ApiKey{`,
		`ApiKey:` + fmt.Sprintf("%v", this.ApiKey) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_ServiceAccountPath) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_ServiceAccountPath{`,
		`ServiceAccountPath:` + fmt.Sprintf("%v", this.ServiceAccountPath) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Buckets:` + strings.Replace(fmt.Sprintf("%v", this.Buckets), "Params_MetricInfo_BucketsDefinition", "Params_MetricInfo_BucketsDefinition", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition{`,
		`Definition:` + fmt.Sprintf("%v", this.Definition) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_LinearBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_LinearBuckets{`,
		`LinearBuckets:` + strings.Replace(fmt.Sprintf("%v", this.LinearBuckets), "Params_MetricInfo_BucketsDefinition_Linear", "Params_MetricInfo_BucketsDefinition_Linear", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExponentialBuckets{`,
		`ExponentialBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExponentialBuckets), "Params_MetricInfo_BucketsDefinition_Exponential", "Params_MetricInfo_BucketsDefinition_Exponential", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExplicitBuckets{`,
		`ExplicitBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExplicitBuckets), "Params_MetricInfo_BucketsDefinition_Explicit", "Params_MetricInfo_BucketsDefinition_Explicit", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Linear) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Linear{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`Width:` + fmt.Sprintf("%v", this.Width) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Exponential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Exponential{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`GrowthFactor:` + fmt.Sprintf("%v", this.GrowthFactor) + `,`,
		`Scale:` + fmt.Sprintf("%v", this.Scale) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Explicit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Explicit{`,
		`Bounds:` + fmt.Sprintf("%v", this.Bounds) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo{`,
		`LabelNames:` + fmt.Sprintf("%v", this.LabelNames) + `,`,
		`PayloadTemplate:` + fmt.Sprintf("%v", this.PayloadTemplate) + `,`,
		`HttpMapping:` + strings.Replace(fmt.Sprintf("%v", this.HttpMapping), "Params_LogInfo_HttpRequestMapping", "Params_LogInfo_HttpRequestMapping", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_LogInfo_HttpRequestMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_LogInfo_HttpRequestMapping{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`Latency:` + fmt.Sprintf("%v", this.Latency) + `,`,
		`LocalIp:` + fmt.Sprintf("%v", this.LocalIp) + `,`,
		`RemoteIp:` + fmt.Sprintf("%v", this.RemoteIp) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.PushInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppCredentials", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Creds = &Params_AppCredentials{b}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Creds = &Params_ApiKey{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccountPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Creds = &Params_ServiceAccountPath{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricInfo == nil {
				m.MetricInfo = make(map[string]*Params_MetricInfo)
			}
			var mapkey string
			var mapvalue *Params_MetricInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_MetricInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MetricInfo[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogInfo == nil {
				m.LogInfo = make(map[string]*Params_LogInfo)
			}
			var mapkey string
			var mapvalue *Params_LogInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfig
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfig
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthConfig
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Params_LogInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfig(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfig
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LogInfo[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= (google_api1.MetricDescriptor_MetricKind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= (google_api1.MetricDescriptor_ValueType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Buckets == nil {
				m.Buckets = &Params_MetricInfo_BucketsDefinition{}
			}
			if err := m.Buckets.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketsDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketsDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinearBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Linear{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Exponential{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Explicit{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Linear: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Linear: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Width = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Offset = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exponential: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exponential: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrowthFactor", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.GrowthFactor = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Scale = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Explicit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Explicit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.Bounds = append(m.Bounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConfig
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.Bounds = append(m.Bounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelNames = append(m.LabelNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PayloadTemplate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PayloadTemplate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpMapping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpMapping == nil {
				m.HttpMapping = &Params_LogInfo_HttpRequestMapping{}
			}
			if err := m.HttpMapping.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_LogInfo_HttpRequestMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRequestMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRequestMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latency", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Latency = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/stackdriver/config/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 970 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0x4b, 0x6f, 0x1c, 0x45,
	0x10, 0x9e, 0xf1, 0x66, 0x5f, 0xb5, 0xeb, 0x07, 0x8d, 0x05, 0xeb, 0x41, 0x8c, 0x4d, 0x90, 0xc0,
	0x41, 0x64, 0x56, 0x5a, 0x2e, 0x11, 0x0f, 0x01, 0x8e, 0x63, 0xad, 0x71, 0x82, 0xa2, 0x49, 0x84,
	0x04, 0x97, 0xa1, 0x3d, 0xd3, 0xbb, 0xdb, 0x78, 0xb6, 0xbb, 0xe9, 0xe9, 0x71, 0xbc, 0x39, 0xa0,
	0xdc, 0xb9, 0x70, 0xe4, 0x27, 0xf0, 0x4b, 0x90, 0x8f, 0x39, 0x72, 0x02, 0xbc, 0x5c, 0x38, 0xfa,
	0x0f, 0x20, 0xa1, 0x7e, 0xac, 0xbd, 0x26, 0x80, 0x6c, 0x25, 0xa7, 0xdd, 0xaa, 0xfa, 0xaa, 0xbe,
	0x9a, 0xaf, 0xba, 0xab, 0xe1, 0xe6, 0x98, 0x1e, 0x11, 0xd9, 0xc5, 0x19, 0x16, 0x8a, 0xc8, 0x6e,
	0xa1, 0x70, 0x7a, 0x90, 0x49, 0x7a, 0x48, 0x64, 0x37, 0xe5, 0x6c, 0x40, 0x87, 0xee, 0x27, 0x12,
	0x92, 0x2b, 0x8e, 0x02, 0x07, 0x8c, 0xe6, 0x80, 0x91, 0x45, 0x04, 0xab, 0x43, 0x3e, 0xe4, 0x06,
	0xd6, 0xd5, 0xff, 0x6c, 0x46, 0xf0, 0xea, 0x90, 0xf3, 0x61, 0x4e, 0xba, 0x58, 0xd0, 0xee, 0x98,
	0x28, 0x49, 0x53, 0x17, 0x08, 0x5d, 0xc0, 0x58, 0xfb, 0xe5, 0xa0, 0x9b, 0x95, 0x12, 0x2b, 0xca,
	0x99, 0x8d, 0x5f, 0xff, 0x6b, 0x09, 0x6a, 0xf7, 0xb1, 0xc4, 0xe3, 0x02, 0x05, 0xd0, 0x20, 0x2c,
	0x13, 0x9c, 0x32, 0xd5, 0xf1, 0x37, 0xfc, 0xcd, 0x66, 0x7c, 0x66, 0xa3, 0xd7, 0x01, 0x84, 0xe4,
	0xdf, 0x90, 0x54, 0x25, 0x34, 0xeb, 0x2c, 0x98, 0x68, 0xd3, 0x79, 0x76, 0x33, 0xd4, 0x87, 0x45,
	0x51, 0x16, 0xa3, 0x84, 0x32, 0x45, 0xe4, 0x21, 0xce, 0x3b, 0x95, 0x0d, 0x7f, 0xb3, 0xd5, 0x5b,
	0x8b, 0x2c, 0x7b, 0x34, 0x63, 0x8f, 0xb6, 0x1d, 0xfb, 0x56, 0xe3, 0xf8, 0xd7, 0x75, 0xef, 0xc7,
	0xdf, 0xd6, 0xfd, 0xb8, 0xad, 0x33, 0x77, 0x5d, 0x22, 0xba, 0x01, 0xcb, 0x58, 0x88, 0x24, 0x95,
	0x24, 0x23, 0x4c, 0x51, 0x9c, 0x17, 0x9d, 0x6b, 0x1b, 0xfe, 0x66, 0xa3, 0xef, 0xc5, 0x4b, 0x58,
	0x88, 0xdb, 0xe7, 0x7e, 0xb4, 0x06, 0x75, 0x2c, 0x68, 0x72, 0x40, 0x26, 0x9d, 0xaa, 0x6e, 0xa8,
	0xef, 0xc5, 0x35, 0x2c, 0xe8, 0x1e, 0x99, 0xa0, 0x1e, 0xac, 0x16, 0x44, 0x1e, 0xd2, 0x94, 0x24,
	0x38, 0x4d, 0x79, 0xc9, 0x54, 0x22, 0xb0, 0x1a, 0x75, 0x6a, 0x0e, 0x87, 0x5c, 0xf4, 0x53, 0x1b,
	0xbc, 0x8f, 0xd5, 0x08, 0x3d, 0x80, 0x96, 0x55, 0x2e, 0xa1, 0x6c, 0xc0, 0x3b, 0x8d, 0x8d, 0xca,
	0x66, 0xab, 0xd7, 0x8b, 0xfe, 0x7b, 0x14, 0x91, 0xd5, 0x2d, 0xba, 0x67, 0xb2, 0x76, 0xd9, 0x80,
	0xdf, 0x61, 0x4a, 0x4e, 0x62, 0x18, 0x9f, 0x39, 0xd0, 0x67, 0xd0, 0xc8, 0xf9, 0xd0, 0x56, 0x6c,
	0x9a, 0x8a, 0xdd, 0x4b, 0x54, 0xbc, 0xcb, 0x87, 0xe7, 0xe5, 0xea, 0xb9, 0xb5, 0x82, 0xd3, 0x1a,
	0xc0, 0x39, 0x17, 0xfa, 0x00, 0xae, 0x1d, 0x50, 0x96, 0x99, 0x51, 0x2d, 0xf5, 0xde, 0x9e, 0x49,
	0x8d, 0x05, 0x75, 0x1d, 0x6d, 0x93, 0x22, 0x95, 0x54, 0x28, 0x2e, 0x9d, 0x63, 0x8f, 0xb2, 0x2c,
	0x36, 0x49, 0xe8, 0x43, 0xa8, 0x1e, 0xe2, 0xbc, 0x24, 0x66, 0x94, 0x4b, 0xbd, 0xb7, 0xfe, 0x37,
	0xfb, 0x0b, 0x8d, 0x7c, 0x38, 0x11, 0x24, 0xb6, 0x49, 0xe8, 0x4b, 0xa8, 0xef, 0x97, 0xe9, 0x01,
	0x51, 0x85, 0x1b, 0xf4, 0xc7, 0x57, 0x92, 0x29, 0xda, 0xb2, 0xc9, 0xdb, 0x64, 0x40, 0x19, 0xd5,
	0xc7, 0x21, 0x9e, 0xd5, 0x0b, 0xbe, 0xaf, 0xc2, 0x4b, 0xcf, 0x84, 0x11, 0x87, 0xa5, 0x9c, 0x32,
	0x82, 0x65, 0x32, 0xe3, 0xf5, 0x0d, 0xef, 0xce, 0x73, 0xf2, 0x46, 0x77, 0x4d, 0xd5, 0xbe, 0x17,
	0x2f, 0xda, 0xfa, 0x0e, 0x81, 0xbe, 0x83, 0x97, 0xc9, 0x91, 0xe0, 0xcc, 0x9e, 0xb5, 0x33, 0xd6,
	0x05, 0xc3, 0xba, 0xf7, 0xbc, 0xac, 0x77, 0xce, 0x4b, 0xeb, 0xc3, 0x38, 0xc7, 0x34, 0xe3, 0x2f,
	0x61, 0x85, 0x1c, 0x89, 0x9c, 0xa6, 0x54, 0x25, 0x17, 0xa5, 0xee, 0xbf, 0x00, 0x72, 0x53, 0xb7,
	0xef, 0xc5, 0xcb, 0x33, 0x0e, 0x87, 0x0a, 0x32, 0xa8, 0x59, 0x45, 0xd0, 0xbb, 0x80, 0x58, 0x39,
	0x4e, 0x4c, 0x16, 0xb9, 0xa0, 0x7a, 0x35, 0x5e, 0x61, 0xe5, 0x78, 0xc7, 0x04, 0x66, 0xed, 0xae,
	0x42, 0xf5, 0x11, 0xcd, 0xd4, 0xc8, 0x08, 0xe4, 0xc7, 0xd6, 0x40, 0xaf, 0x40, 0x8d, 0x0f, 0x06,
	0x05, 0x51, 0xa6, 0x75, 0x3f, 0x76, 0x56, 0x70, 0x08, 0xad, 0x39, 0x05, 0xae, 0x48, 0xf5, 0x26,
	0x2c, 0x0e, 0x25, 0x7f, 0xa4, 0x46, 0xc9, 0x00, 0xa7, 0x8a, 0x4b, 0x47, 0xd9, 0xb6, 0xce, 0x1d,
	0xe3, 0xd3, 0xfd, 0x14, 0x29, 0xce, 0x89, 0x23, 0xb6, 0x46, 0x70, 0x1d, 0x1a, 0xb3, 0x8f, 0xd7,
	0xbd, 0xed, 0xf3, 0x92, 0x65, 0x9a, 0xa8, 0xa2, 0x7b, 0xb3, 0xd6, 0x56, 0x1b, 0x20, 0x3b, 0xd3,
	0x2a, 0xc8, 0x61, 0xf9, 0x1f, 0xb7, 0x1b, 0xad, 0x40, 0x45, 0x6f, 0x1c, 0xbb, 0x20, 0xf5, 0x5f,
	0x74, 0x7b, 0xfe, 0x2e, 0xb5, 0x7a, 0x37, 0xaf, 0x34, 0x20, 0x77, 0xa5, 0xde, 0x5f, 0xb8, 0xe5,
	0x07, 0x4f, 0x2a, 0x50, 0x77, 0x57, 0x1f, 0xad, 0x43, 0x2b, 0xc7, 0xfb, 0x24, 0x4f, 0x18, 0x1e,
	0x13, 0xdb, 0x64, 0x33, 0x06, 0xe3, 0xfa, 0x5c, 0x7b, 0xd0, 0x0d, 0x58, 0x11, 0x78, 0x92, 0x73,
	0x9c, 0x25, 0x8a, 0x8c, 0x45, 0x8e, 0x15, 0x71, 0x7b, 0x79, 0xd9, 0xf9, 0x1f, 0x3a, 0x37, 0xfa,
	0x1a, 0xda, 0x23, 0xa5, 0x44, 0x32, 0xc6, 0x42, 0x50, 0x36, 0x74, 0x07, 0xe9, 0xa3, 0xcb, 0x2f,
	0xa2, 0xa8, 0xaf, 0x94, 0x88, 0xc9, 0xb7, 0x25, 0x29, 0xd4, 0x3d, 0x5b, 0x24, 0x6e, 0xe9, 0x92,
	0xce, 0x08, 0x7e, 0xf6, 0x01, 0x3d, 0x8b, 0xd1, 0x22, 0x17, 0x0a, 0xab, 0xb2, 0x70, 0x72, 0x39,
	0x0b, 0xbd, 0x01, 0x6d, 0x69, 0x91, 0x49, 0x41, 0x1f, 0xcf, 0xfa, 0x6e, 0x39, 0xdf, 0x03, 0xfa,
	0x98, 0xe8, 0x31, 0x4b, 0x52, 0x08, 0xce, 0x0a, 0x62, 0x31, 0x15, 0x83, 0x69, 0xcf, 0x9c, 0x06,
	0xd4, 0x81, 0xba, 0xfe, 0x40, 0x96, 0x4e, 0xcc, 0x23, 0xd1, 0x8c, 0x67, 0x26, 0x5a, 0xd3, 0x7b,
	0x37, 0xc5, 0x79, 0x42, 0x85, 0x7d, 0x1c, 0xf4, 0x1a, 0x4d, 0x71, 0xbe, 0x2b, 0xd0, 0x6b, 0xd0,
	0x94, 0x64, 0xcc, 0x15, 0xd1, 0xb1, 0x9a, 0x7d, 0xe7, 0xac, 0x63, 0x57, 0x04, 0x03, 0x68, 0xcf,
	0x2f, 0xdf, 0x7f, 0x99, 0xf6, 0x27, 0x17, 0xa7, 0xfd, 0xce, 0xe5, 0x55, 0x9c, 0x1b, 0xf5, 0x56,
	0x1d, 0xaa, 0xfa, 0x89, 0x2b, 0xb6, 0x6e, 0x1d, 0x9f, 0x84, 0xde, 0xd3, 0x93, 0xd0, 0xfb, 0xe5,
	0x24, 0xf4, 0x4e, 0x4f, 0x42, 0xef, 0xc9, 0x34, 0xf4, 0x7f, 0x9a, 0x86, 0xde, 0xf1, 0x34, 0xf4,
	0x9f, 0x4e, 0x43, 0xff, 0xf7, 0x69, 0xe8, 0xff, 0x39, 0x0d, 0xbd, 0xd3, 0x69, 0xe8, 0xff, 0xf0,
	0x47, 0xe8, 0x7d, 0x55, 0xb3, 0xc5, 0xf7, 0x6b, 0xe6, 0x51, 0x7d, 0xef, 0xef, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x6b, 0x6b, 0x19, 0x05, 0x5c, 0x08, 0x00, 0x00,
}
