# Istio Pilot

Istio Pilot provides platform-independent service discovery, and exposes an
interface to configure rich L7 routing features such as label based routing
across multiple service versions, fault injection, timeouts, retries,
circuit breakers. It translates these configurations into sidecar-specific
configuration and dynamically reconfigures the sidecars in the service mesh
data plane. Platform-specific eccentricities are abstracted and a
simplified service discovery interface is presented to the sidecars based
on the Envoy data plane API.

Please see
[Istio's traffic management concepts](https://istio.io/docs/concepts/traffic-management/overview.html)
to learn more about the design of Pilot and the capabilities it provides.

Istio Pilot [design](doc/design.md) gives an architectural overview of its
internal components - cluster platform abstractions, service model, and the
proxy controllers.

# Quick start

1. *Install Bazel:* [Bazel 0.6.1](https://github.com/bazelbuild/bazel/releases/tag/0.6.1) or
  higher. Debian packages are available on Linux. For OS X users, bazel is
  available via Homebrew.
  > NOTE 1: Bazel tool is still maturing, and as such has several issues that
  > makes development hard. While setting up Bazel is mostly smooth, it is
  > common to see cryptic errors that prevent you from getting
  > started. Deleting and restarting everything generally helps.

  > NOTE 2: If you are developing for the Kubernetes platform, for end-to-end
  > integration tests, you need access to a working Kubernetes cluster.

1. *Setup:* Run `make setup`. It installs the required tools and
[vendorizes](https://golang.org/cmd/go/#hdr-Vendor_Directories)
the dependencies.

1. Write code using your favorite IDE. Make sure to format code and run
   it through the Go linters, before submitting a PR.
   `make fmt` to format the code.
   `make lint` to run the linters defined in bin/check.sh

   If you add any new source files or import new packages in
   existing code, make sure to run `make gazelle` to update the Bazel BUILD
   files.

1. *Build:* Run `make build` to compile the code.

1. *Unit test:* Run `make test` to run unit tests.
   > NOTE: If you are running on OS X, //proxy/envoy:go_default_test will
   > fail. You can ignore this failure.

1. *Dockerize:* Run `make docker HUB=docker.io/<username> TAG=<sometag>`.
This will build a docker container for Pilot, the sidecar, and other
utilities.

1. *Integration test:* Run `make e2etest HUB=docker.io/<username> TAG=<sometag>`
with the same image hub and tag as the ones you used in the _dockerize_ step. This step will
run end to end integration tests on Kubernetes. To specify additional test options, define TESTOPTS variable in the
command line of `make`, for example `make e2etest TESTOPTS='-help'` to see all available options.
Run `make e2etest HUB=docker.io/<username> TAG=<sometag> TESTOPTS='-testtype <test name>'`
to run a single integration test by its name.

Detailed instructions for testing are available [here](doc/testing.md).
