package template

// RevisedTemplateTmpl defines the modified template proto with Type and InstanceParams
var RevisedTemplateTmpl = `// Copyright 2017 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

syntax = "proto3";

package {{.PackageName}};

import "mixer/v1/template/extensions.proto";
$$additional_imports$$

option (istio.mixer.v1.template.template_variety) = {{.VarietyName}};

{{if ne .VarietyName "TEMPLATE_VARIETY_ATTRIBUTE_GENERATOR"}}
{{.Comment}}
{{.TemplateMessage.Comment}}
message Type {
  {{range .TemplateMessage.Fields -}}
  {{- if valueTypeOrResMsg .ProtoType}}
  {{.Comment}}
  {{valueTypeOrResMsgFieldTypeName .ProtoType}} {{.ProtoName}} = {{.Number}};{{reportTypeUsed .ProtoType}}
  {{- end}}
  {{- end}}
}

{{range .ResourceMessages}}
{{.Comment}}
message {{getResourcMessageTypeName .Name}} {
  {{range .Fields}}
  {{- if valueTypeOrResMsg .ProtoType}}
  {{.Comment}}
  {{valueTypeOrResMsgFieldTypeName .ProtoType}} {{.ProtoName}} = {{.Number}};{{reportTypeUsed .ProtoType}}
  {{- end}}
  {{- end}}
}
{{end}}
{{end}}

message InstanceParam {
  {{range .TemplateMessage.Fields}}
  {{stringify .ProtoType}} {{.ProtoName}} = {{.Number}};
  {{end}}
  {{if eq .VarietyName "TEMPLATE_VARIETY_ATTRIBUTE_GENERATOR"}}
  // Attribute names to expression mapping. These expressions can use the fields from the output object
  // returned by the attribute producing adapters using $out.<fieldName> notation. For example:
  // source.ip : $out.source_pod_ip
  // In the above example, source.ip attribute will be added to the existing attribute list and its value will be set to
  // the value of source_pod_ip field of the output returned by the adapter.
  map<string, string> attribute_bindings = 72295728;
  {{end}}
}

{{range .ResourceMessages}}
message {{getResourcMessageInterfaceParamTypeName  .Name}} {
  {{range .Fields}}
  {{stringify .ProtoType}} {{.ProtoName}} = {{.Number}};
  {{end}}
}
{{end}}
`
