// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: bazel-out/local-fastbuild/genfiles/mixer/template/authorization/go_default_library_tmpl.proto

/*
	Package authorization is a generated protocol buffer package.

	It is generated from these files:
		bazel-out/local-fastbuild/genfiles/mixer/template/authorization/go_default_library_tmpl.proto

	It has these top-level messages:
		Type
		SubjectType
		ActionType
		InstanceParam
		SubjectInstanceParam
		ActionInstanceParam
*/
package authorization

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "istio.io/api/mixer/v1/template"
import istio_mixer_v1_config_descriptor "istio.io/api/mixer/v1/config/descriptor"

import strings "strings"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// The authorization template defines parameters for performing policy
// enforcement within Istio. It is primarily concerned with enabling Mixer
// adapters to make decisions about who is allowed to do what.
// In this template, the "who" is defined in a Subject message. The "what" is
// defined in an Action message. During a Mixer Check call, these values
// will be populated based on configuration from request attributes and
// passed to individual authorization adapters to adjudicate.
//
// Example config:
// ```
// apiVersion: "config.istio.io/v1alpha2"
// kind: authorization
// metadata:
//   name: authinfo
//   namespace: istio-system
// spec:
//  subject:
//    user: source.user | request.auth.token[user] | ""
//    groups: request.auth.token[groups]
//    properties:
//     iss: request.auth.token["iss"]
//  action:
//    namespace: target.namespace | "default"
//    service: target.service | ""
//    path: request.path | "/"
//    method: request.method | "post"
//    properties:
//      version: destination.labels[version] | ""
//  ```
type Type struct {
	// A subject contains a list of attributes that identify
	// the caller identity.
	Subject *SubjectType `protobuf:"bytes,1,opt,name=subject" json:"subject,omitempty"`
	// An action defines "how a resource is accessed".
	Action *ActionType `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorGoDefaultLibraryTmpl, []int{0} }

func (m *Type) GetSubject() *SubjectType {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *Type) GetAction() *ActionType {
	if m != nil {
		return m.Action
	}
	return nil
}

// A subject contains a list of attributes that identify
// the caller identity.
type SubjectType struct {
	// Additional attributes about the subject.
	Properties map[string]istio_mixer_v1_config_descriptor.ValueType `protobuf:"bytes,3,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.mixer.v1.config.descriptor.ValueType"`
}

func (m *SubjectType) Reset()                    { *m = SubjectType{} }
func (*SubjectType) ProtoMessage()               {}
func (*SubjectType) Descriptor() ([]byte, []int) { return fileDescriptorGoDefaultLibraryTmpl, []int{1} }

func (m *SubjectType) GetProperties() map[string]istio_mixer_v1_config_descriptor.ValueType {
	if m != nil {
		return m.Properties
	}
	return nil
}

// An action defines "how a resource is accessed".
type ActionType struct {
	// Additional data about the action for use in policy.
	Properties map[string]istio_mixer_v1_config_descriptor.ValueType `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.mixer.v1.config.descriptor.ValueType"`
}

func (m *ActionType) Reset()                    { *m = ActionType{} }
func (*ActionType) ProtoMessage()               {}
func (*ActionType) Descriptor() ([]byte, []int) { return fileDescriptorGoDefaultLibraryTmpl, []int{2} }

func (m *ActionType) GetProperties() map[string]istio_mixer_v1_config_descriptor.ValueType {
	if m != nil {
		return m.Properties
	}
	return nil
}

type InstanceParam struct {
	Subject *SubjectInstanceParam `protobuf:"bytes,1,opt,name=subject" json:"subject,omitempty"`
	Action  *ActionInstanceParam  `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorGoDefaultLibraryTmpl, []int{3}
}

func (m *InstanceParam) GetSubject() *SubjectInstanceParam {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *InstanceParam) GetAction() *ActionInstanceParam {
	if m != nil {
		return m.Action
	}
	return nil
}

type SubjectInstanceParam struct {
	User       string            `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Groups     string            `protobuf:"bytes,2,opt,name=groups,proto3" json:"groups,omitempty"`
	Properties map[string]string `protobuf:"bytes,3,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *SubjectInstanceParam) Reset()      { *m = SubjectInstanceParam{} }
func (*SubjectInstanceParam) ProtoMessage() {}
func (*SubjectInstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorGoDefaultLibraryTmpl, []int{4}
}

func (m *SubjectInstanceParam) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *SubjectInstanceParam) GetGroups() string {
	if m != nil {
		return m.Groups
	}
	return ""
}

func (m *SubjectInstanceParam) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

type ActionInstanceParam struct {
	Namespace  string            `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Service    string            `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	Method     string            `protobuf:"bytes,3,opt,name=method,proto3" json:"method,omitempty"`
	Path       string            `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ActionInstanceParam) Reset()      { *m = ActionInstanceParam{} }
func (*ActionInstanceParam) ProtoMessage() {}
func (*ActionInstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorGoDefaultLibraryTmpl, []int{5}
}

func (m *ActionInstanceParam) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ActionInstanceParam) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *ActionInstanceParam) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *ActionInstanceParam) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ActionInstanceParam) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func init() {
	proto.RegisterType((*Type)(nil), "authorization.Type")
	proto.RegisterType((*SubjectType)(nil), "authorization.SubjectType")
	proto.RegisterType((*ActionType)(nil), "authorization.ActionType")
	proto.RegisterType((*InstanceParam)(nil), "authorization.InstanceParam")
	proto.RegisterType((*SubjectInstanceParam)(nil), "authorization.SubjectInstanceParam")
	proto.RegisterType((*ActionInstanceParam)(nil), "authorization.ActionInstanceParam")
}
func (this *Type) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Type)
	if !ok {
		that2, ok := that.(Type)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Subject.Equal(that1.Subject) {
		return false
	}
	if !this.Action.Equal(that1.Action) {
		return false
	}
	return true
}
func (this *SubjectType) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SubjectType)
	if !ok {
		that2, ok := that.(SubjectType)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Properties) != len(that1.Properties) {
		return false
	}
	for i := range this.Properties {
		if this.Properties[i] != that1.Properties[i] {
			return false
		}
	}
	return true
}
func (this *ActionType) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ActionType)
	if !ok {
		that2, ok := that.(ActionType)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Properties) != len(that1.Properties) {
		return false
	}
	for i := range this.Properties {
		if this.Properties[i] != that1.Properties[i] {
			return false
		}
	}
	return true
}
func (this *InstanceParam) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*InstanceParam)
	if !ok {
		that2, ok := that.(InstanceParam)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Subject.Equal(that1.Subject) {
		return false
	}
	if !this.Action.Equal(that1.Action) {
		return false
	}
	return true
}
func (this *SubjectInstanceParam) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SubjectInstanceParam)
	if !ok {
		that2, ok := that.(SubjectInstanceParam)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Groups != that1.Groups {
		return false
	}
	if len(this.Properties) != len(that1.Properties) {
		return false
	}
	for i := range this.Properties {
		if this.Properties[i] != that1.Properties[i] {
			return false
		}
	}
	return true
}
func (this *ActionInstanceParam) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ActionInstanceParam)
	if !ok {
		that2, ok := that.(ActionInstanceParam)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.Service != that1.Service {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if len(this.Properties) != len(that1.Properties) {
		return false
	}
	for i := range this.Properties {
		if this.Properties[i] != that1.Properties[i] {
			return false
		}
	}
	return true
}
func (this *Type) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&authorization.Type{")
	if this.Subject != nil {
		s = append(s, "Subject: "+fmt.Sprintf("%#v", this.Subject)+",\n")
	}
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SubjectType) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&authorization.SubjectType{")
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]istio_mixer_v1_config_descriptor.ValueType{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%#v: %#v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	if this.Properties != nil {
		s = append(s, "Properties: "+mapStringForProperties+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ActionType) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&authorization.ActionType{")
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]istio_mixer_v1_config_descriptor.ValueType{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%#v: %#v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	if this.Properties != nil {
		s = append(s, "Properties: "+mapStringForProperties+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *InstanceParam) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&authorization.InstanceParam{")
	if this.Subject != nil {
		s = append(s, "Subject: "+fmt.Sprintf("%#v", this.Subject)+",\n")
	}
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SubjectInstanceParam) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&authorization.SubjectInstanceParam{")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]string{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%#v: %#v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	if this.Properties != nil {
		s = append(s, "Properties: "+mapStringForProperties+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ActionInstanceParam) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&authorization.ActionInstanceParam{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	s = append(s, "Method: "+fmt.Sprintf("%#v", this.Method)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]string{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%#v: %#v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	if this.Properties != nil {
		s = append(s, "Properties: "+mapStringForProperties+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGoDefaultLibraryTmpl(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Subject != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(m.Subject.Size()))
		n1, err := m.Subject.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Action != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(m.Action.Size()))
		n2, err := m.Action.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *SubjectType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubjectType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for k, _ := range m.Properties {
			dAtA[i] = 0x1a
			i++
			v := m.Properties[k]
			mapSize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + sovGoDefaultLibraryTmpl(uint64(v))
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *ActionType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActionType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for k, _ := range m.Properties {
			dAtA[i] = 0x2a
			i++
			v := m.Properties[k]
			mapSize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + sovGoDefaultLibraryTmpl(uint64(v))
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Subject != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(m.Subject.Size()))
		n3, err := m.Subject.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Action != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(m.Action.Size()))
		n4, err := m.Action.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *SubjectInstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubjectInstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Groups) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.Groups)))
		i += copy(dAtA[i:], m.Groups)
	}
	if len(m.Properties) > 0 {
		for k, _ := range m.Properties {
			dAtA[i] = 0x1a
			i++
			v := m.Properties[k]
			mapSize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + len(v) + sovGoDefaultLibraryTmpl(uint64(len(v)))
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *ActionInstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActionInstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	if len(m.Service) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.Service)))
		i += copy(dAtA[i:], m.Service)
	}
	if len(m.Method) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.Method)))
		i += copy(dAtA[i:], m.Method)
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Properties) > 0 {
		for k, _ := range m.Properties {
			dAtA[i] = 0x2a
			i++
			v := m.Properties[k]
			mapSize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + len(v) + sovGoDefaultLibraryTmpl(uint64(len(v)))
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGoDefaultLibraryTmpl(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func encodeVarintGoDefaultLibraryTmpl(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Type) Size() (n int) {
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	if m.Action != nil {
		l = m.Action.Size()
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	return n
}

func (m *SubjectType) Size() (n int) {
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for k, v := range m.Properties {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + sovGoDefaultLibraryTmpl(uint64(v))
			n += mapEntrySize + 1 + sovGoDefaultLibraryTmpl(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ActionType) Size() (n int) {
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for k, v := range m.Properties {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + sovGoDefaultLibraryTmpl(uint64(v))
			n += mapEntrySize + 1 + sovGoDefaultLibraryTmpl(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	if m.Action != nil {
		l = m.Action.Size()
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	return n
}

func (m *SubjectInstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	l = len(m.Groups)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	if len(m.Properties) > 0 {
		for k, v := range m.Properties {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + len(v) + sovGoDefaultLibraryTmpl(uint64(len(v)))
			n += mapEntrySize + 1 + sovGoDefaultLibraryTmpl(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ActionInstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovGoDefaultLibraryTmpl(uint64(l))
	}
	if len(m.Properties) > 0 {
		for k, v := range m.Properties {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGoDefaultLibraryTmpl(uint64(len(k))) + 1 + len(v) + sovGoDefaultLibraryTmpl(uint64(len(v)))
			n += mapEntrySize + 1 + sovGoDefaultLibraryTmpl(uint64(mapEntrySize))
		}
	}
	return n
}

func sovGoDefaultLibraryTmpl(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGoDefaultLibraryTmpl(x uint64) (n int) {
	return sovGoDefaultLibraryTmpl(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`Subject:` + strings.Replace(fmt.Sprintf("%v", this.Subject), "SubjectType", "SubjectType", 1) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "ActionType", "ActionType", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SubjectType) String() string {
	if this == nil {
		return "nil"
	}
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]istio_mixer_v1_config_descriptor.ValueType{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%v: %v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	s := strings.Join([]string{`&SubjectType{`,
		`Properties:` + mapStringForProperties + `,`,
		`}`,
	}, "")
	return s
}
func (this *ActionType) String() string {
	if this == nil {
		return "nil"
	}
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]istio_mixer_v1_config_descriptor.ValueType{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%v: %v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	s := strings.Join([]string{`&ActionType{`,
		`Properties:` + mapStringForProperties + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceParam{`,
		`Subject:` + strings.Replace(fmt.Sprintf("%v", this.Subject), "SubjectInstanceParam", "SubjectInstanceParam", 1) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "ActionInstanceParam", "ActionInstanceParam", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SubjectInstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]string{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%v: %v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	s := strings.Join([]string{`&SubjectInstanceParam{`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Groups:` + fmt.Sprintf("%v", this.Groups) + `,`,
		`Properties:` + mapStringForProperties + `,`,
		`}`,
	}, "")
	return s
}
func (this *ActionInstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForProperties := make([]string, 0, len(this.Properties))
	for k, _ := range this.Properties {
		keysForProperties = append(keysForProperties, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForProperties)
	mapStringForProperties := "map[string]string{"
	for _, k := range keysForProperties {
		mapStringForProperties += fmt.Sprintf("%v: %v,", k, this.Properties[k])
	}
	mapStringForProperties += "}"
	s := strings.Join([]string{`&ActionInstanceParam{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Service:` + fmt.Sprintf("%v", this.Service) + `,`,
		`Method:` + fmt.Sprintf("%v", this.Method) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Properties:` + mapStringForProperties + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGoDefaultLibraryTmpl(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &SubjectType{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Action == nil {
				m.Action = &ActionType{}
			}
			if err := m.Action.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubjectType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubjectType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubjectType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Properties == nil {
				m.Properties = make(map[string]istio_mixer_v1_config_descriptor.ValueType)
			}
			var mapkey string
			var mapvalue istio_mixer_v1_config_descriptor.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGoDefaultLibraryTmpl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_mixer_v1_config_descriptor.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Properties[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActionType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActionType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActionType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Properties == nil {
				m.Properties = make(map[string]istio_mixer_v1_config_descriptor.ValueType)
			}
			var mapkey string
			var mapvalue istio_mixer_v1_config_descriptor.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGoDefaultLibraryTmpl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_mixer_v1_config_descriptor.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Properties[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &SubjectInstanceParam{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Action == nil {
				m.Action = &ActionInstanceParam{}
			}
			if err := m.Action.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubjectInstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubjectInstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubjectInstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Properties == nil {
				m.Properties = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGoDefaultLibraryTmpl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Properties[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActionInstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActionInstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActionInstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Properties == nil {
				m.Properties = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGoDefaultLibraryTmpl
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGoDefaultLibraryTmpl
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGoDefaultLibraryTmpl
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Properties[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGoDefaultLibraryTmpl(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGoDefaultLibraryTmpl
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGoDefaultLibraryTmpl(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGoDefaultLibraryTmpl
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGoDefaultLibraryTmpl
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGoDefaultLibraryTmpl
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGoDefaultLibraryTmpl
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGoDefaultLibraryTmpl(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGoDefaultLibraryTmpl = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGoDefaultLibraryTmpl   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("bazel-out/local-fastbuild/genfiles/mixer/template/authorization/go_default_library_tmpl.proto", fileDescriptorGoDefaultLibraryTmpl)
}

var fileDescriptorGoDefaultLibraryTmpl = []byte{
	// 571 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x54, 0xcf, 0x6b, 0x13, 0x4f,
	0x1c, 0xcd, 0x24, 0x6d, 0x4a, 0x26, 0xf4, 0xfb, 0x95, 0xb1, 0xc8, 0x1a, 0x64, 0x28, 0xf1, 0x52,
	0x2d, 0xdd, 0x25, 0xa9, 0x07, 0x29, 0xf4, 0x50, 0xc1, 0x43, 0x3d, 0x95, 0x54, 0xbc, 0x49, 0x98,
	0x6c, 0x3e, 0x49, 0xa6, 0xee, 0xee, 0x0c, 0x33, 0xb3, 0xa1, 0xe9, 0xc9, 0xb3, 0x78, 0x10, 0xfc,
	0x27, 0xfc, 0x3f, 0x44, 0xf0, 0x58, 0x3c, 0x88, 0x47, 0xb3, 0x7a, 0xf0, 0xd8, 0xa3, 0x47, 0xd9,
	0xd9, 0xa4, 0xf9, 0xc1, 0x56, 0x7b, 0x11, 0xbc, 0xcd, 0xe4, 0xf3, 0xde, 0x9b, 0xbc, 0xf7, 0x79,
	0x2c, 0x7e, 0xde, 0x61, 0x67, 0x10, 0xec, 0x88, 0xd8, 0x78, 0x81, 0xf0, 0x59, 0xb0, 0xd3, 0x63,
	0xda, 0x74, 0x62, 0x1e, 0x74, 0xbd, 0x3e, 0x44, 0x3d, 0x1e, 0x80, 0xf6, 0x42, 0x7e, 0x0a, 0xca,
	0x33, 0x10, 0xca, 0x80, 0x19, 0xf0, 0x58, 0x6c, 0x06, 0x42, 0xf1, 0x33, 0x66, 0xb8, 0x88, 0xbc,
	0xbe, 0x68, 0x77, 0xa1, 0xc7, 0xe2, 0xc0, 0xb4, 0x03, 0xde, 0x51, 0x4c, 0x8d, 0xda, 0x26, 0x94,
	0x81, 0x2b, 0x95, 0x30, 0x82, 0xac, 0x2f, 0x80, 0x6b, 0xf5, 0x4c, 0x6a, 0xd8, 0x98, 0xa9, 0xc1,
	0xa9, 0x81, 0x48, 0x73, 0x11, 0xe9, 0x8c, 0x52, 0xdb, 0xbe, 0xc4, 0xf8, 0x22, 0xea, 0xf1, 0xbe,
	0xd7, 0x05, 0xed, 0x2b, 0x2e, 0x8d, 0x50, 0xde, 0x90, 0x05, 0x31, 0xb4, 0xcd, 0x48, 0x42, 0x06,
	0xae, 0x0b, 0xbc, 0xf2, 0x74, 0x24, 0x81, 0x3c, 0xc0, 0x6b, 0x3a, 0xee, 0x9c, 0x80, 0x6f, 0x1c,
	0xb4, 0x89, 0xb6, 0xaa, 0xcd, 0x9a, 0xbb, 0xf0, 0xb2, 0x7b, 0x9c, 0x4d, 0x53, 0x70, 0x6b, 0x0a,
	0x25, 0x0d, 0x5c, 0x66, 0x7e, 0x3a, 0x76, 0x8a, 0x96, 0x74, 0x7b, 0x89, 0x74, 0x60, 0x87, 0x96,
	0x33, 0x01, 0xd6, 0x3f, 0x20, 0x5c, 0x9d, 0xd3, 0x22, 0x4f, 0x30, 0x96, 0x4a, 0x48, 0x50, 0x86,
	0x83, 0x76, 0x4a, 0x9b, 0xa5, 0xad, 0x6a, 0xf3, 0xfe, 0xd5, 0x6f, 0xbb, 0x47, 0x97, 0xe0, 0xc7,
	0x91, 0x51, 0xa3, 0xd6, 0x1c, 0xbb, 0x76, 0x82, 0xff, 0x5f, 0x1a, 0x93, 0x1b, 0xb8, 0xf4, 0x02,
	0x46, 0xd6, 0x53, 0xa5, 0x95, 0x1e, 0xc9, 0x01, 0x5e, 0xb5, 0x29, 0xd8, 0xbf, 0xfc, 0x5f, 0x73,
	0xdb, 0xe5, 0xda, 0x70, 0xe1, 0xda, 0xd0, 0xdc, 0x61, 0xc3, 0xcd, 0x42, 0x73, 0x67, 0xa1, 0xb9,
	0xcf, 0x52, 0xb8, 0x35, 0x91, 0x31, 0xf7, 0x8a, 0x0f, 0x51, 0xfd, 0x3d, 0xc2, 0x78, 0x66, 0x8f,
	0x1c, 0x2e, 0xd8, 0x58, 0xb5, 0x36, 0xee, 0x5d, 0x99, 0xc6, 0x3f, 0xe3, 0xe2, 0x15, 0xc2, 0xeb,
	0x87, 0x91, 0x36, 0x2c, 0xf2, 0xe1, 0x88, 0x29, 0x16, 0x92, 0xfd, 0xe5, 0x22, 0xdc, 0xcd, 0x5f,
	0xc6, 0x02, 0x6b, 0xd6, 0x88, 0xbd, 0xa5, 0x46, 0xd4, 0x73, 0x33, 0x58, 0x24, 0x4f, 0xab, 0xf1,
	0x19, 0xe1, 0x8d, 0x3c, 0x75, 0x42, 0xf0, 0x4a, 0xac, 0x41, 0x4d, 0xfc, 0xdb, 0x33, 0xb9, 0x85,
	0xcb, 0x7d, 0x25, 0x62, 0xa9, 0xed, 0x43, 0x95, 0xd6, 0xe4, 0x46, 0x8e, 0x73, 0xfa, 0xb4, 0x7b,
	0x0d, 0x0b, 0xbf, 0x5d, 0xc9, 0xfe, 0x75, 0x56, 0xb2, 0x31, 0xbf, 0x92, 0xca, 0x7c, 0xca, 0xaf,
	0x8b, 0xf8, 0x66, 0x8e, 0x71, 0x72, 0x07, 0x57, 0x22, 0x16, 0x82, 0x96, 0xcc, 0x87, 0x89, 0xd2,
	0xec, 0x07, 0xe2, 0xe0, 0x35, 0x0d, 0x6a, 0xc8, 0xfd, 0xa9, 0xe2, 0xf4, 0x9a, 0x7a, 0x0f, 0xc1,
	0x0c, 0x44, 0xd7, 0x29, 0x65, 0xde, 0xb3, 0x5b, 0x9a, 0x93, 0x64, 0x66, 0xe0, 0xac, 0x64, 0x39,
	0xa5, 0x67, 0xd2, 0xca, 0x29, 0x66, 0xf3, 0xcf, 0x4b, 0xf9, 0x8b, 0x71, 0x3c, 0x6a, 0x9e, 0x8f,
	0x69, 0xe1, 0xcb, 0x98, 0x16, 0x2e, 0xc6, 0x14, 0xbd, 0x4c, 0x28, 0x7a, 0x97, 0x50, 0xf4, 0x31,
	0xa1, 0xe8, 0x3c, 0xa1, 0xe8, 0x6b, 0x42, 0xd1, 0x8f, 0x84, 0x16, 0x2e, 0x12, 0x8a, 0xde, 0x7c,
	0xa3, 0x85, 0x9f, 0x9f, 0xbe, 0xbf, 0x2d, 0x16, 0x3a, 0x65, 0xfb, 0xb9, 0xda, 0xfd, 0x15, 0x00,
	0x00, 0xff, 0xff, 0x4b, 0x5c, 0xec, 0x5e, 0x6f, 0x05, 0x00, 0x00,
}
