// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/kubernetes/config/config.proto

/*
	Package config is a generated protocol buffer package.

	It is generated from these files:
		mixer/adapter/kubernetes/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"

import time "time"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration parameters for the kubernetes adapter. These params
// control the manner in which the kubernetes adapter discovers and
// generates values related to pod information.
//
// The adapter works by looking up pod information by UIDs (of the
// form: "kubernetes://pod.namespace"). It expects that the UIDs will be
// supplied in an input map for three distinct traffic classes (source,
// destination, and origin).
//
// For all valid UIDs supplied, this adapter generates a map of output
// values containing information about the related pods. The generated map
// is keyed by value names generated by concatenating a pod identifier
// prefix with a value name. For example, for the pod corresponding to a
// sourceUID and the output value of pod ip, this adapter will output a map
// that includes a key of "sourcePodIP" (assuming parameter defaults).
type Params struct {
	// File path to discover kubeconfig. For in-cluster configuration,
	// this should be left unset. For local configuration, this should
	// be set to the path of a kubeconfig file that can be used to
	// reach a kubernetes API server.
	//
	// NOTE: The kubernetes adapter will use the value of the env var
	// KUBECONFIG in the case where it is set (overriding any value configured
	// through this proto).
	//
	// Default: "" (unset)
	KubeconfigPath string `protobuf:"bytes,1,opt,name=kubeconfig_path,json=kubeconfigPath,proto3" json:"kubeconfig_path,omitempty"`
	// Controls the resync period of the kubernetes cluster info cache.
	// The cache will watch for events and every so often completely resync.
	// This controls how frequently the complete resync occurs.
	//
	// Default: 5 minutes
	CacheRefreshDuration time.Duration `protobuf:"bytes,2,opt,name=cache_refresh_duration,json=cacheRefreshDuration,stdduration" json:"cache_refresh_duration"`
	// Configures how the UID for the source pod for traffic is identified
	// in the input map.
	//
	// Default: sourceUID
	SourceUidInputName string `protobuf:"bytes,3,opt,name=source_uid_input_name,json=sourceUidInputName,proto3" json:"source_uid_input_name,omitempty"`
	// Configures how the UID for the destination pod for traffic is identified
	// in the input map.
	//
	// Default: destinationUID
	DestinationUidInputName string `protobuf:"bytes,4,opt,name=destination_uid_input_name,json=destinationUidInputName,proto3" json:"destination_uid_input_name,omitempty"`
	// Configures how the UID for the origin pod for traffic is identified
	// in the input map.
	//
	// Default: originUID
	OriginUidInputName string `protobuf:"bytes,5,opt,name=origin_uid_input_name,json=originUidInputName,proto3" json:"origin_uid_input_name,omitempty"`
	// Configures how the IP for the source pod for traffic is identified
	// in the input map.
	//
	// Default: sourceIP
	SourceIpInputName string `protobuf:"bytes,20,opt,name=source_ip_input_name,json=sourceIpInputName,proto3" json:"source_ip_input_name,omitempty"`
	// Configures how the IP for the destination pod for traffic is identified
	// in the input map.
	//
	// Default: destinationIP
	DestinationIpInputName string `protobuf:"bytes,21,opt,name=destination_ip_input_name,json=destinationIpInputName,proto3" json:"destination_ip_input_name,omitempty"`
	// Configures how the IP for the origin pod for traffic is identified
	// in the input map.
	//
	// Default: originIP
	OriginIpInputName string `protobuf:"bytes,23,opt,name=origin_ip_input_name,json=originIpInputName,proto3" json:"origin_ip_input_name,omitempty"`
	// Configures the cluster domain name to use for service name normalization.
	//
	// Default: svc.cluster.local
	ClusterDomainName string `protobuf:"bytes,18,opt,name=cluster_domain_name,json=clusterDomainName,proto3" json:"cluster_domain_name,omitempty"`
	// In order to extract the service associated with a source, destination, or
	// origin, this adapter relies on pod labels. In particular, it looks for
	// the value of a specific label, as specified by this parameter.
	//
	// Default: app
	PodLabelForService string `protobuf:"bytes,6,opt,name=pod_label_for_service,json=podLabelForService,proto3" json:"pod_label_for_service,omitempty"`
	// In order to extract the service associated with a source, destination, or
	// origin, this adapter relies on pod labels. In particular, it looks for
	// the value of a specific label for istio component services, as specified
	// by this parameter.
	//
	// Default: istio
	PodLabelForIstioComponentService string `protobuf:"bytes,19,opt,name=pod_label_for_istio_component_service,json=podLabelForIstioComponentService,proto3" json:"pod_label_for_istio_component_service,omitempty"`
	// The prefix used for source pod output value names.
	//
	// Default: source
	SourcePrefix string `protobuf:"bytes,7,opt,name=source_prefix,json=sourcePrefix,proto3" json:"source_prefix,omitempty"`
	// The prefix used for destination pod output value names.
	//
	// Default: destination
	DestinationPrefix string `protobuf:"bytes,8,opt,name=destination_prefix,json=destinationPrefix,proto3" json:"destination_prefix,omitempty"`
	// The prefix used for origin pod output value names.
	//
	// Default: origin
	OriginPrefix string `protobuf:"bytes,9,opt,name=origin_prefix,json=originPrefix,proto3" json:"origin_prefix,omitempty"`
	// The value name for the pod labels output value.
	//
	// Default: Labels
	LabelsValueName string `protobuf:"bytes,10,opt,name=labels_value_name,json=labelsValueName,proto3" json:"labels_value_name,omitempty"`
	// The value name for the pod name output value.
	//
	// Default: PodName
	PodNameValueName string `protobuf:"bytes,11,opt,name=pod_name_value_name,json=podNameValueName,proto3" json:"pod_name_value_name,omitempty"`
	// The value name for the pod ip address output value.
	//
	// Default: PodIP
	PodIpValueName string `protobuf:"bytes,12,opt,name=pod_ip_value_name,json=podIpValueName,proto3" json:"pod_ip_value_name,omitempty"`
	// The value name for the pod host ip address output value.
	//
	// Default: HostIP
	HostIpValueName string `protobuf:"bytes,13,opt,name=host_ip_value_name,json=hostIpValueName,proto3" json:"host_ip_value_name,omitempty"`
	// The value name for the pod namespace output value.
	//
	// Default: Namespace
	NamespaceValueName string `protobuf:"bytes,14,opt,name=namespace_value_name,json=namespaceValueName,proto3" json:"namespace_value_name,omitempty"`
	// The value name for the pod service account name output value.
	//
	// Default: ServiceAccountName
	ServiceAccountValueName string `protobuf:"bytes,15,opt,name=service_account_value_name,json=serviceAccountValueName,proto3" json:"service_account_value_name,omitempty"`
	// The value name for the service output value.
	//
	// Default: Service
	ServiceValueName string `protobuf:"bytes,16,opt,name=service_value_name,json=serviceValueName,proto3" json:"service_value_name,omitempty"`
	// Whether or not to execute source and origin value lookup
	// for Mixer requests when Istio ingress is the destination
	// service.
	//
	// Default: false
	LookupIngressSourceAndOriginValues bool `protobuf:"varint,24,opt,name=lookup_ingress_source_and_origin_values,json=lookupIngressSourceAndOriginValues,proto3" json:"lookup_ingress_source_and_origin_values,omitempty"`
	// Istio ingress service string. This is used to identify the
	// ingress service in requests.
	//
	// Default: "ingress.istio-system.svc.cluster.local"
	FullyQualifiedIstioIngressServiceName string `protobuf:"bytes,25,opt,name=fully_qualified_istio_ingress_service_name,json=fullyQualifiedIstioIngressServiceName,proto3" json:"fully_qualified_istio_ingress_service_name,omitempty"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

func init() {
	proto.RegisterType((*Params)(nil), "adapter.kubernetes.config.Params")
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KubeconfigPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.KubeconfigPath)))
		i += copy(dAtA[i:], m.KubeconfigPath)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintConfig(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.CacheRefreshDuration)))
	n1, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.CacheRefreshDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.SourceUidInputName) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SourceUidInputName)))
		i += copy(dAtA[i:], m.SourceUidInputName)
	}
	if len(m.DestinationUidInputName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.DestinationUidInputName)))
		i += copy(dAtA[i:], m.DestinationUidInputName)
	}
	if len(m.OriginUidInputName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.OriginUidInputName)))
		i += copy(dAtA[i:], m.OriginUidInputName)
	}
	if len(m.PodLabelForService) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PodLabelForService)))
		i += copy(dAtA[i:], m.PodLabelForService)
	}
	if len(m.SourcePrefix) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SourcePrefix)))
		i += copy(dAtA[i:], m.SourcePrefix)
	}
	if len(m.DestinationPrefix) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.DestinationPrefix)))
		i += copy(dAtA[i:], m.DestinationPrefix)
	}
	if len(m.OriginPrefix) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.OriginPrefix)))
		i += copy(dAtA[i:], m.OriginPrefix)
	}
	if len(m.LabelsValueName) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.LabelsValueName)))
		i += copy(dAtA[i:], m.LabelsValueName)
	}
	if len(m.PodNameValueName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PodNameValueName)))
		i += copy(dAtA[i:], m.PodNameValueName)
	}
	if len(m.PodIpValueName) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PodIpValueName)))
		i += copy(dAtA[i:], m.PodIpValueName)
	}
	if len(m.HostIpValueName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.HostIpValueName)))
		i += copy(dAtA[i:], m.HostIpValueName)
	}
	if len(m.NamespaceValueName) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.NamespaceValueName)))
		i += copy(dAtA[i:], m.NamespaceValueName)
	}
	if len(m.ServiceAccountValueName) > 0 {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ServiceAccountValueName)))
		i += copy(dAtA[i:], m.ServiceAccountValueName)
	}
	if len(m.ServiceValueName) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ServiceValueName)))
		i += copy(dAtA[i:], m.ServiceValueName)
	}
	if len(m.ClusterDomainName) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ClusterDomainName)))
		i += copy(dAtA[i:], m.ClusterDomainName)
	}
	if len(m.PodLabelForIstioComponentService) > 0 {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.PodLabelForIstioComponentService)))
		i += copy(dAtA[i:], m.PodLabelForIstioComponentService)
	}
	if len(m.SourceIpInputName) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SourceIpInputName)))
		i += copy(dAtA[i:], m.SourceIpInputName)
	}
	if len(m.DestinationIpInputName) > 0 {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.DestinationIpInputName)))
		i += copy(dAtA[i:], m.DestinationIpInputName)
	}
	if len(m.OriginIpInputName) > 0 {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.OriginIpInputName)))
		i += copy(dAtA[i:], m.OriginIpInputName)
	}
	if m.LookupIngressSourceAndOriginValues {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x1
		i++
		if m.LookupIngressSourceAndOriginValues {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.FullyQualifiedIstioIngressServiceName) > 0 {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.FullyQualifiedIstioIngressServiceName)))
		i += copy(dAtA[i:], m.FullyQualifiedIstioIngressServiceName)
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	l = len(m.KubeconfigPath)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.CacheRefreshDuration)
	n += 1 + l + sovConfig(uint64(l))
	l = len(m.SourceUidInputName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.DestinationUidInputName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.OriginUidInputName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.PodLabelForService)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.SourcePrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.DestinationPrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.OriginPrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.LabelsValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.PodNameValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.PodIpValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.HostIpValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.NamespaceValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ServiceAccountValueName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ServiceValueName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.ClusterDomainName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.PodLabelForIstioComponentService)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.SourceIpInputName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.DestinationIpInputName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	l = len(m.OriginIpInputName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.LookupIngressSourceAndOriginValues {
		n += 3
	}
	l = len(m.FullyQualifiedIstioIngressServiceName)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`KubeconfigPath:` + fmt.Sprintf("%v", this.KubeconfigPath) + `,`,
		`CacheRefreshDuration:` + strings.Replace(strings.Replace(this.CacheRefreshDuration.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`SourceUidInputName:` + fmt.Sprintf("%v", this.SourceUidInputName) + `,`,
		`DestinationUidInputName:` + fmt.Sprintf("%v", this.DestinationUidInputName) + `,`,
		`OriginUidInputName:` + fmt.Sprintf("%v", this.OriginUidInputName) + `,`,
		`PodLabelForService:` + fmt.Sprintf("%v", this.PodLabelForService) + `,`,
		`SourcePrefix:` + fmt.Sprintf("%v", this.SourcePrefix) + `,`,
		`DestinationPrefix:` + fmt.Sprintf("%v", this.DestinationPrefix) + `,`,
		`OriginPrefix:` + fmt.Sprintf("%v", this.OriginPrefix) + `,`,
		`LabelsValueName:` + fmt.Sprintf("%v", this.LabelsValueName) + `,`,
		`PodNameValueName:` + fmt.Sprintf("%v", this.PodNameValueName) + `,`,
		`PodIpValueName:` + fmt.Sprintf("%v", this.PodIpValueName) + `,`,
		`HostIpValueName:` + fmt.Sprintf("%v", this.HostIpValueName) + `,`,
		`NamespaceValueName:` + fmt.Sprintf("%v", this.NamespaceValueName) + `,`,
		`ServiceAccountValueName:` + fmt.Sprintf("%v", this.ServiceAccountValueName) + `,`,
		`ServiceValueName:` + fmt.Sprintf("%v", this.ServiceValueName) + `,`,
		`ClusterDomainName:` + fmt.Sprintf("%v", this.ClusterDomainName) + `,`,
		`PodLabelForIstioComponentService:` + fmt.Sprintf("%v", this.PodLabelForIstioComponentService) + `,`,
		`SourceIpInputName:` + fmt.Sprintf("%v", this.SourceIpInputName) + `,`,
		`DestinationIpInputName:` + fmt.Sprintf("%v", this.DestinationIpInputName) + `,`,
		`OriginIpInputName:` + fmt.Sprintf("%v", this.OriginIpInputName) + `,`,
		`LookupIngressSourceAndOriginValues:` + fmt.Sprintf("%v", this.LookupIngressSourceAndOriginValues) + `,`,
		`FullyQualifiedIstioIngressServiceName:` + fmt.Sprintf("%v", this.FullyQualifiedIstioIngressServiceName) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KubeconfigPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KubeconfigPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheRefreshDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.CacheRefreshDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUidInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUidInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUidInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUidInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginUidInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginUidInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodLabelForService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodLabelForService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelsValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelsValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodNameValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodNameValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodIpValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodIpValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostIpValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostIpValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccountValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceAccountValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceValueName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceValueName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterDomainName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterDomainName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodLabelForIstioComponentService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodLabelForIstioComponentService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIpInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIpInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIpInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationIpInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginIpInputName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginIpInputName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookupIngressSourceAndOriginValues", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LookupIngressSourceAndOriginValues = bool(v != 0)
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FullyQualifiedIstioIngressServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FullyQualifiedIstioIngressServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/kubernetes/config/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 728 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x94, 0xcd, 0x4e, 0xdb, 0x4a,
	0x1c, 0xc5, 0xed, 0x7b, 0xb9, 0xb9, 0x61, 0xf8, 0x8c, 0x09, 0x90, 0x64, 0x61, 0x22, 0x10, 0x82,
	0xcb, 0x85, 0xb8, 0xb4, 0x9b, 0x56, 0xac, 0xa0, 0xa8, 0x52, 0xaa, 0xaa, 0xd0, 0xa0, 0x56, 0xa2,
	0x9b, 0xd1, 0xc4, 0x9e, 0x24, 0x23, 0x1c, 0xcf, 0x74, 0xc6, 0x46, 0x74, 0xd7, 0x47, 0xe8, 0xb2,
	0x8f, 0xd0, 0x47, 0x61, 0xc9, 0xb2, 0xab, 0xb6, 0x49, 0x37, 0x5d, 0xf2, 0x06, 0xad, 0x3c, 0xff,
	0x31, 0x76, 0xe8, 0x0a, 0x32, 0xe7, 0x77, 0xfe, 0x1f, 0x33, 0x47, 0x46, 0xbb, 0x43, 0x76, 0x45,
	0xa5, 0x47, 0x02, 0x22, 0x62, 0x2a, 0xbd, 0x8b, 0xa4, 0x4b, 0x65, 0x44, 0x63, 0xaa, 0x3c, 0x9f,
	0x47, 0x3d, 0xd6, 0x37, 0x7f, 0x5a, 0x42, 0xf2, 0x98, 0x3b, 0x75, 0xc3, 0xb5, 0x72, 0xae, 0x05,
	0x40, 0xa3, 0xda, 0xe7, 0x7d, 0xae, 0x29, 0x2f, 0xfd, 0x0f, 0x0c, 0x0d, 0xb7, 0xcf, 0x79, 0x3f,
	0xa4, 0x9e, 0xfe, 0xd5, 0x4d, 0x7a, 0x5e, 0x90, 0x48, 0x12, 0x33, 0x1e, 0x81, 0xbe, 0xfe, 0x6b,
	0x1a, 0x95, 0x4e, 0x89, 0x24, 0x43, 0xe5, 0x6c, 0xa1, 0x85, 0xb4, 0x2a, 0x94, 0xc3, 0x82, 0xc4,
	0x83, 0x9a, 0xdd, 0xb4, 0xb7, 0xa7, 0x3b, 0xf3, 0xf9, 0xf1, 0x29, 0x89, 0x07, 0xce, 0x39, 0x5a,
	0xf1, 0x89, 0x3f, 0xa0, 0x58, 0xd2, 0x9e, 0xa4, 0x6a, 0x80, 0xb3, 0x9a, 0xb5, 0xbf, 0x9a, 0xf6,
	0xf6, 0xcc, 0xc3, 0x7a, 0x0b, 0x9a, 0xb6, 0xb2, 0xa6, 0xad, 0x63, 0x03, 0x1c, 0x95, 0xaf, 0xbf,
	0xae, 0x59, 0x9f, 0xbe, 0xad, 0xd9, 0x9d, 0xaa, 0x2e, 0xd1, 0x81, 0x0a, 0x99, 0xee, 0xec, 0xa3,
	0x65, 0xc5, 0x13, 0xe9, 0x53, 0x9c, 0xb0, 0x00, 0xb3, 0x48, 0x24, 0x31, 0x8e, 0xc8, 0x90, 0xd6,
	0xfe, 0xd6, 0x93, 0x38, 0x20, 0xbe, 0x66, 0x41, 0x3b, 0x95, 0x5e, 0x92, 0x21, 0x75, 0x0e, 0x50,
	0x23, 0xa0, 0x2a, 0x66, 0x91, 0xae, 0x70, 0xdf, 0x37, 0xa5, 0x7d, 0xab, 0x05, 0x62, 0xc2, 0xbc,
	0x8f, 0x96, 0xb9, 0x64, 0x7d, 0xf6, 0x87, 0xef, 0x1f, 0xe8, 0x07, 0xe2, 0x7d, 0x8b, 0xe0, 0x01,
	0x0e, 0x49, 0x97, 0x86, 0xb8, 0xc7, 0x25, 0x56, 0x54, 0x5e, 0x32, 0x9f, 0xd6, 0x4a, 0x60, 0x11,
	0x3c, 0x78, 0x91, 0x6a, 0xcf, 0xb8, 0x3c, 0x03, 0xc5, 0xd9, 0x40, 0x73, 0x66, 0x2b, 0x21, 0x69,
	0x8f, 0x5d, 0xd5, 0xfe, 0xd5, 0xe8, 0x2c, 0x1c, 0x9e, 0xea, 0x33, 0x67, 0x0f, 0x39, 0xc5, 0x3d,
	0x0c, 0x59, 0xd6, 0x64, 0xa5, 0xa0, 0x18, 0x7c, 0x03, 0xcd, 0x99, 0xc9, 0x0d, 0x39, 0x0d, 0x35,
	0xe1, 0xd0, 0x40, 0x3b, 0xa8, 0xa2, 0xe7, 0x54, 0xf8, 0x92, 0x84, 0x09, 0x85, 0xd5, 0x90, 0x06,
	0x17, 0x40, 0x78, 0x93, 0x9e, 0xeb, 0xbd, 0xf6, 0xd0, 0x52, 0xba, 0x57, 0x8a, 0x14, 0xe9, 0x19,
	0x4d, 0x2f, 0x0a, 0x1e, 0xa4, 0x54, 0x8e, 0xff, 0x87, 0x2a, 0x29, 0xce, 0x44, 0x11, 0x9e, 0x85,
	0xbc, 0x08, 0x1e, 0xb4, 0x45, 0x8e, 0xfe, 0x8f, 0x9c, 0x01, 0x57, 0xf1, 0x3d, 0x76, 0x0e, 0xc6,
	0x48, 0x95, 0x22, 0xfc, 0x00, 0x55, 0x53, 0x59, 0x09, 0xe2, 0x4f, 0xcc, 0x31, 0x0f, 0xb7, 0x7b,
	0xa7, 0xe5, 0x8e, 0x03, 0xd4, 0x30, 0x4f, 0x80, 0x89, 0xef, 0xf3, 0x24, 0x8a, 0x8b, 0xbe, 0x05,
	0x08, 0x80, 0x21, 0x0e, 0x01, 0xc8, 0xcd, 0xbb, 0xc8, 0xc9, 0xcc, 0x05, 0xd3, 0x22, 0x2c, 0x6d,
	0x94, 0x9c, 0x6e, 0xa1, 0x25, 0x3f, 0x4c, 0x54, 0x4c, 0x25, 0x0e, 0xf8, 0x90, 0xb0, 0x08, 0x70,
	0x07, 0x1e, 0xc9, 0x48, 0xc7, 0x5a, 0xd1, 0xfc, 0x09, 0xda, 0x9c, 0xcc, 0x0a, 0x53, 0x31, 0xe3,
	0xd8, 0xe7, 0x43, 0xc1, 0x23, 0x1a, 0xc5, 0x77, 0xd9, 0x59, 0xd2, 0x15, 0x9a, 0x85, 0xec, 0xb4,
	0x53, 0xf2, 0x69, 0x06, 0x66, 0x49, 0xf2, 0x50, 0xd5, 0x24, 0x89, 0x89, 0x62, 0x5c, 0xab, 0x30,
	0x01, 0x68, 0x6d, 0x91, 0xa7, 0xf5, 0x09, 0xaa, 0x17, 0x53, 0x35, 0xe9, 0x5a, 0xd6, 0xae, 0x95,
	0x02, 0x50, 0xb4, 0x7a, 0xa8, 0x6a, 0x12, 0x36, 0xe9, 0x5a, 0x85, 0x5e, 0xa0, 0x15, 0x0d, 0x67,
	0x68, 0x2b, 0xe4, 0xfc, 0x22, 0x49, 0xe9, 0xbe, 0xa4, 0x4a, 0x61, 0x33, 0x2b, 0x89, 0x02, 0x6c,
	0x4a, 0xe9, 0x4b, 0x56, 0xb5, 0x5a, 0xd3, 0xde, 0x2e, 0x77, 0xd6, 0x01, 0x6f, 0x03, 0x7d, 0xa6,
	0xe1, 0xc3, 0x28, 0x38, 0xd1, 0xa8, 0xbe, 0x75, 0xe5, 0x9c, 0xa3, 0x9d, 0x5e, 0x12, 0x86, 0xef,
	0xf1, 0xbb, 0x84, 0x84, 0xac, 0xc7, 0x68, 0x60, 0x2e, 0xf1, 0xae, 0x87, 0x79, 0x3e, 0x3d, 0x5b,
	0x5d, 0xcf, 0xb6, 0xa9, 0x1d, 0xaf, 0x32, 0x83, 0xbe, 0xca, 0xac, 0x09, 0xd0, 0xe9, 0xbc, 0xcf,
	0xa7, 0xca, 0x95, 0x45, 0xe7, 0xe8, 0xf1, 0xf5, 0xc8, 0xb5, 0x6e, 0x46, 0xae, 0xf5, 0x65, 0xe4,
	0x5a, 0xb7, 0x23, 0xd7, 0xfa, 0x30, 0x76, 0xed, 0xcf, 0x63, 0xd7, 0xba, 0x1e, 0xbb, 0xf6, 0xcd,
	0xd8, 0xb5, 0xbf, 0x8f, 0x5d, 0xfb, 0xe7, 0xd8, 0xb5, 0x6e, 0xc7, 0xae, 0xfd, 0xf1, 0x87, 0x6b,
	0xbd, 0x2d, 0xc1, 0xb7, 0xb0, 0x5b, 0xd2, 0xdf, 0xb7, 0x47, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff,
	0xdf, 0x4e, 0x5c, 0x8c, 0xc3, 0x05, 0x00, 0x00,
}
