---
sidebarDepth: 0
title: Sprints
---

# Join Prefect at Sprints

Join Prefect at one of our upcoming digital events where core contributors will support new and veteran contributors during development sprints.

::: tip Already sprinting?
If you're already at a sprint and want to get started quickly, jump down to [Getting Started at Sprints](#getting-started-at-sprints).
:::

Prefect is indebted to the open source community. We'd love to meet you and work with you "in person" at one of our upcoming events. If you haven't already, you can let us know you want to get involved by talking to us on Prefect's public [Slack](https://join.slack.com/t/prefect-community/shared_invite/enQtODQ3MTA2MjI4OTgyLTliYjEyYzljNTc2OThlMDE4YmViYzk3NDU4Y2EzMWZiODM0NmU3NjM0NjIyNWY0MGIxOGQzODMxNDMxYWYyOTE), or tell us you're coming through [our sign up form](https://forms.gle/mMtATfmhbYKSwqWc9), so we can get you ready for success! **For the most recent list of digital sprints Prefect is participating in or hosting**, checkout our [Meetup page](https://www.meetup.com/Prefect-Community/).

We prioritize an inclusive community and rigorously uphold our [Code of Conduct](../code_of_conduct.html). In addition, we are happy to support new Pythonistas as well as long-developing Python gurus and have issues for any level of Python experience.

## Getting Started at Sprints

If you're at a sprint, hopefully you've already been introduced to the core contributors who are running the show. If not, please @ mention or DM one of us -- **we want to meet you**! You can also let us know you're on your way or looking to join in by finding us on our [Prefect Community Slack](https://join.slack.com/t/prefect-community/shared_invite/enQtODQ3MTA2MjI4OTgyLTliYjEyYzljNTc2OThlMDE4YmViYzk3NDU4Y2EzMWZiODM0NmU3NjM0NjIyNWY0MGIxOGQzODMxNDMxYWYyOTE) -- be sure to join the #prefect-contributors channel!

### Finding something to do

All available work for Prefect are stored as Github issues at [https://github.com/PrefectHQ/prefect/issues](https://github.com/PrefectHQ/prefect/issues). Take a browse and consider some of the open issues there. In particular, we use labels to organize issues by different categories.

Some beginner-friendly categories include:

- issues that are good for new contributors - these have the ["good first issue" label](https://github.com/PrefectHQ/prefect/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
- issues to write or update tests, which can be easy to start on if you like testing - these have the ["tests" label](https://github.com/PrefectHQ/prefect/issues?q=is%3Aopen+is%3Aissue+label%3Atests)
- issues to write or update docs, which can be a good entry point if you like to write - these have the ["docs" label](https://github.com/PrefectHQ/prefect/issues?q=is%3Aissue+is%3Aopen+label%3Adocs)

If you are already a Prefect contributor or looking for more of a challenge, consider:

- any of our bug issues - these have the ["bug" label](https://github.com/PrefectHQ/prefect/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+label%3Abug+)
- an enhancement to an existing feature in Prefect - these have the ["enhancement" label](https://github.com/PrefectHQ/prefect/issues?q=is%3Aissue+is%3Aopen+label%3Aenhancement)
- entirely new features suggested by the community or the core contributors - these have the ["feature request" label](https://github.com/PrefectHQ/prefect/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+label%3A%22feature+request%22+)

If you are interested in brainstorming new features or architecture discussion points, we are happy to develop PINs (Prefect Improvement Notices) with you. Come chat with us after taking a look at [PIN 01](../PINs/PIN-01-Introduce-PINs.html).

### Starting your development environment

Depending on what type of issue you want to tackle, you may need to set yourself up for docs development or Core development. The general directions for each are the the [docs development instructions](documentation.html#previewing-docs-locally) or [main development instructions](overview.html).

You might need to install extra dependencies depending on what type of issue you are working on. **Please** reach out to the core contributors to diagnose your development environment if the general directions are not sufficient for your case or you get stuck for any reason!

### Developing and opening PRs

We know that sprints can be fast paced and we want you to succeed. The [contributing guidelines](contributing.html) are a great reference, but if you are getting bogged down in the details feel free to grab one of the core contributors to advise at any time during development or while opening your PR against master.

## Stay in touch

Hopefully you had a good time working with us and want to continue working on your issue, or new issues, before the next sprint!

We are always reachable on Slack, and accept contributions at any time.

Welcome to the community, and happy engineering!

*-The Prefect Team*