---
sidebarDepth: 2
editLink: false
---
# Notifications and Callback Tools
---

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-notifications-notifications-callback-factory'><p class="prefect-class">prefect.utilities.notifications.notifications.callback_factory</p>(fn, check)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications/notifications.py#L26">[source]</a></span></div>
<p class="methods">Utility for generating state handlers that serve as callbacks, under arbitrary state-based checks.<br><br>**Args**:     <ul class="args"><li class="args">`fn (Callable)`: a function with signature `fn(obj, state: State) -> None`         that will be called anytime the associated state-check passes; in general,         it is expected that this function will have side effects (e.g., sends an email).  The first         argument to this function is the `Task` or `Flow` it is attached to.     </li><li class="args">`check (Callable)`: a function with signature `check(state: State) -> bool`         that is used for determining when the callback function should be called</li></ul>**Returns**:     <ul class="args"><li class="args">`state_handler (Callable)`: a state handler function that can be attached to both Tasks and Flows</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> Task<span class="token punctuation">,</span> Flow<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> callback_factory<br><br>    fn <span class="token operator">=</span> <span class="token keyword">lambda</span> obj<span class="token punctuation">,</span> state<span class="token punctuation">:</span> <span class="token builtin">print</span><span class="token punctuation">(</span>state<span class="token punctuation">)</span><br>    check <span class="token operator">=</span> <span class="token keyword">lambda</span> state<span class="token punctuation">:</span> state<span class="token operator">.</span>is_successful<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    callback <span class="token operator">=</span> callback_factory<span class="token punctuation">(</span>fn<span class="token punctuation">,</span> check<span class="token punctuation">)</span><br><br>    t <span class="token operator">=</span> Task<span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>callback<span class="token punctuation">]</span><span class="token punctuation">)</span><br>    f <span class="token operator">=</span> Flow<span class="token punctuation">(</span>tasks<span class="token operator">=</span><span class="token punctuation">[</span>t<span class="token punctuation">]</span><span class="token punctuation">,</span> state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>callback<span class="token punctuation">]</span><span class="token punctuation">)</span><br>    f<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    <span class="token comment"># prints:</span><br>    <span class="token comment"># Success("Task run succeeded.")</span><br>    <span class="token comment"># Success("All reference tasks succeeded.")</span><br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-notifications-notifications-slack-notifier'><p class="prefect-class">prefect.utilities.notifications.notifications.slack_notifier</p>(tracked_obj, old_state, new_state, ignore_states=None, only_states=None, webhook_secret=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications/notifications.py#L236">[source]</a></span></div>
<p class="methods">Slack state change handler; requires having the Prefect slack app installed. Works as a standalone state handler, or can be called from within a custom state handler.  This function is curried meaning that it can be called multiple times to partially bind any keyword arguments (see example below).<br><br>**Args**:     <ul class="args"><li class="args">`tracked_obj (Task or Flow)`: Task or Flow object the handler is         registered with     </li><li class="args">`old_state (State)`: previous state of tracked object     </li><li class="args">`new_state (State)`: new state of tracked object     </li><li class="args">`ignore_states ([State], optional)`: list of `State` classes to ignore,         e.g., `[Running, Scheduled]`. If `new_state` is an instance of one of the passed states, no notification will occur.     </li><li class="args">`only_states ([State], optional)`: similar to `ignore_states`, but         instead _only_ notifies you if the Task / Flow is in a state from the provided list of `State` classes     </li><li class="args">`webhook_secret (str, optional)`: the name of the Prefect Secret that stores your slack webhook URL;         defaults to `"SLACK_WEBHOOK_URL"`</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the `new_state` object that was provided</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the slack notification fails for any reason</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> task<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> slack_notifier<br><br>    <span class="token decorator">@task</span><span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>slack_notifier<span class="token punctuation">(</span>ignore_states<span class="token operator">=</span><span class="token punctuation">[</span>Running<span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">]</span><span class="token punctuation">)</span> <span class="token comment"># uses currying</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-notifications-notifications-gmail-notifier'><p class="prefect-class">prefect.utilities.notifications.notifications.gmail_notifier</p>(tracked_obj, old_state, new_state, ignore_states=None, only_states=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications/notifications.py#L168">[source]</a></span></div>
<p class="methods">Email state change handler - configured to work solely with Gmail; works as a standalone state handler, or can be called from within a custom state handler.  This function is curried meaning that it can be called multiple times to partially bind any keyword arguments (see example below).<br><br>The username and password Gmail credentials will be taken from your `"EMAIL_USERNAME"` and `"EMAIL_PASSWORD"` secrets, respectively; note the username will also serve as the destination email address for the notification.<br><br>**Args**:     <ul class="args"><li class="args">`tracked_obj (Task or Flow)`: Task or Flow object the handler is         registered with     </li><li class="args">`old_state (State)`: previous state of tracked object     </li><li class="args">`new_state (State)`: new state of tracked object     </li><li class="args">`ignore_states ([State], optional)`: list of `State` classes to ignore,         e.g., `[Running, Scheduled]`. If `new_state` is an instance of one of the passed states, no notification will occur.     </li><li class="args">`only_states ([State], optional)`: similar to `ignore_states`, but         instead _only_ notifies you if the Task / Flow is in a state from the provided list of `State` classes</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the `new_state` object that was provided</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the email notification fails for any reason</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> task<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> gmail_notifier<br><br>    <span class="token decorator">@task</span><span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>gmail_notifier<span class="token punctuation">(</span>ignore_states<span class="token operator">=</span><span class="token punctuation">[</span>Running<span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">]</span><span class="token punctuation">)</span> <span class="token comment"># uses currying</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-notifications-jira-notification-jira-notifier'><p class="prefect-class">prefect.utilities.notifications.jira_notification.jira_notifier</p>(tracked_obj, old_state, new_state, ignore_states=None, only_states=None, server_URL=None, options={}, assignee="-1")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications/jira_notification.py#L37">[source]</a></span></div>
<p class="methods">Jira Notifier requires a Jira account and API token.  The API token can be created at: https://id.atlassian.com/manage/api-tokens  The Jira account username ('JIRAUSER'), API token ('JIRATOKEN') should be set as part of a 'JIRASECRETS' object in Prefect Secrets. <br><br>An example 'JIRASECRETS' object looks like this: <br><pre class="language-python"><code class="language-python">JIRASECRETS <span class="token operator">=</span> <span class="token punctuation">{</span> JIRATOKEN <span class="token operator">=</span> <span class="token string">"</span><span class="token string">XXXXXXXXX</span><span class="token string">"</span><span class="token punctuation">,</span> JIRAUSER <span class="token operator">=</span> <span class="token string">"</span><span class="token string">xxxxx@yyy.com</span><span class="token string">"</span><span class="token punctuation">,</span> JIRASERVER <span class="token operator">=</span> <span class="token string">"</span><span class="token string">https://???.atlassian.net</span><span class="token string">"</span><span class="token punctuation">,</span> JIRAPROJECT <span class="token operator">=</span> <span class="token string">"</span><span class="token string">TEST</span><span class="token string">"</span> <span class="token punctuation">}</span><br></code></pre><br><br><br>The server URL can be set as part of the 'JIRASECRETS' object ('JIRASERVER') or passed to the jira notifier state handler as the "server_URL" argument. Jira Notifier works as a standalone state handler, or can be called from within a custom state handler.  This function is curried meaning that it can be called multiple times to partially bind any keyword arguments (see example below). Jira Notifier creates a new ticket with the information about the task or flow it is bound to when that task or flow is in a specific state.  (For example it will create a ticket to tell you that the flow you set it on is in a failed state.)   You should use the options dictionary to set the project name and issue type.   You can use the "assignee" argument to assign that ticket to a specific member of your team.<br><br>**Args**:     <ul class="args"><li class="args">`tracked_obj (Task or Flow)`: Task or Flow object the handler is         registered with     </li><li class="args">`old_state (State)`: previous state of tracked object     </li><li class="args">`new_state (State)`: new state of tracked object     </li><li class="args">`options (Dictionary)`: Must inlucde a 'project' key and an 'issuetype' key (e.g. options = {'project': 'TEST', 'issuetype': {'name': 'task'}}). For jira service desk tickets, the issue type should use the request type id e.g. 'issuetype':  {'id': '10010'}. A description can be added using the key 'description'. Custom fields can also be added e.g.  'customfield_10017': 'SDTS/flowdown'     </li><li class="args">`ignore_states ([State], optional)`: list of `State` classes to ignore,         e.g., `[Running, Scheduled]`. If `new_state` is an instance of one of the passed states, no notification will occur.     </li><li class="args">`only_states ([State], optional)`: similar to `ignore_states`, but         instead _only_ notifies you if the Task / Flow is in a state from the provided list of `State` classes     </li><li class="args">`server_URL (String)`: The URL of your atlassian account e.g. "https://test.atlassian.net".  Can also be set as a Prefect Secret.      </li><li class="args">`assignee`: the atlassian username of the person you want to assign the ticket to.  Defaults to "automatic" if this is not set. </li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the `new_state` object that was provided</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the jira ticket creation or assignment fails for any reason</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> task<br>    <span class="token keyword">from</span> prefect.utilities.jira_notification <span class="token keyword">import</span> jira_notifier<br><br>    <span class="token decorator">@task</span><span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>jira_notifier<span class="token punctuation">(</span>only_states<span class="token operator">=</span><span class="token punctuation">[</span>Failed<span class="token punctuation">]</span><span class="token punctuation">,</span> options<span class="token operator">=</span><span class="token punctuation">{</span><span class="token string">'</span><span class="token string">project</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token string">'</span><span class="token string">TEST</span><span class="token string">'</span><span class="token punctuation">,</span> <span class="token string">'</span><span class="token string">issuetype</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token string">'</span><span class="token string">Task</span><span class="token string">'</span><span class="token punctuation">}</span><span class="token punctuation">}</span><span class="token punctuation">,</span> assignee<span class="token operator">=</span><span class="token string">'</span><span class="token string">tester</span><span class="token string">'</span><span class="token punctuation">)</span><span class="token punctuation">]</span><span class="token punctuation">)</span> <span class="token comment"># uses currying</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br>    <br></code></pre><br></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on June 17, 2020 at 17:27 UTC</p>