---
sidebarDepth: 2
editLink: false
---
# GitHub Tasks
---
A collection of tasks for interacting with GitHub.
 ## CreateGitHubPR
 <div class='class-sig' id='prefect-tasks-github-prs-creategithubpr'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.github.prs.CreateGitHubPR</p>(repo=None, title=None, body=None, head=None, base=None, token_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/prs.py#L10">[source]</a></span></div>

Task for opening / creating new GitHub Pull Requests using the v3 version of the GitHub REST API.

**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; can also be provided to the `run` method     </li><li class="args">`title (str, optional)`: the title of the issue to create; can also be provided to the `run` method     </li><li class="args">`body (str, optional)`: the contents of the issue; can also be provided to the `run` method     </li><li class="args">`head (str, optional)`: the name of the branch where your changes are implemented; can also         be provided to the `run` method     </li><li class="args">`base (str, optional)`: the name of the branch you want the changes pulled into; can also         be provided to the `run` method     </li><li class="args">`token_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret containing your GitHub Access Token     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the standard Task init method</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-github-prs-creategithubpr-run'><p class="prefect-class">prefect.tasks.github.prs.CreateGitHubPR.run</p>(repo=None, title=None, body=None, head=None, base=None, token=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/prs.py#L51">[source]</a></span></div>
<p class="methods">Run method for this Task. Invoked by calling this Task after initialization within a Flow context, or by using `Task.bind`.<br><br>**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; defaults to the one provided at initialization     </li><li class="args">`title (str, optional)`: the title of the issue to create; defaults to the one provided at initialization     </li><li class="args">`body (str, optional)`: the contents of the issue; defaults to the one provided at initialization     </li><li class="args">`head (str, optional)`: the name of the branch where your changes are implemented;         defaults to the one provided at initialization     </li><li class="args">`base (str, optional)`: the name of the branch you want the changes pulled into;         defaults to the one provided at initialization     </li><li class="args">`token (str)`: a GitHub API token</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a `repo` was never provided     </li><li class="args">`HTTPError`: if the POST request returns a non-200 status code</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|

---
<br>

 ## OpenGitHubIssue
 <div class='class-sig' id='prefect-tasks-github-issues-opengithubissue'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.github.issues.OpenGitHubIssue</p>(repo=None, title=None, body=None, labels=None, token_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/issues.py#L10">[source]</a></span></div>

Task for opening / creating new GitHub issues using the v3 version of the GitHub REST API.

**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; can also be provided to the `run` method     </li><li class="args">`title (str, optional)`: the title of the issue to create; can also be provided to the `run` method     </li><li class="args">`body (str, optional)`: the contents of the issue; can also be provided to the `run` method     </li><li class="args">`labels (List[str], optional)`: a list of labels to apply to the newly opened issues; can also         be provided to the `run` method     </li><li class="args">`token_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret containing your GitHub Access Token     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the standard Task init method</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-github-issues-opengithubissue-run'><p class="prefect-class">prefect.tasks.github.issues.OpenGitHubIssue.run</p>(repo=None, title=None, body=None, labels=None, token=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/issues.py#L47">[source]</a></span></div>
<p class="methods">Run method for this Task. Invoked by calling this Task after initialization within a Flow context, or by using `Task.bind`.<br><br>**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; defaults to the one provided at initialization     </li><li class="args">`title (str, optional)`: the title of the issue to create; defaults to the one provided at initialization     </li><li class="args">`body (str, optional)`: the contents of the issue; defaults to the one provided at initialization     </li><li class="args">`labels (List[str], optional)`: a list of labels to apply to the newly opened issues; defaults to     the ones provided at initialization     </li><li class="args">`token (str)`: a GitHub API token</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a `repo` was never provided     </li><li class="args">`HTTPError`: if the POST request returns a non-200 status code</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|

---
<br>

 ## GetRepoInfo
 <div class='class-sig' id='prefect-tasks-github-repos-getrepoinfo'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.github.repos.GetRepoInfo</p>(repo=None, info_keys=None, token_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/repos.py#L9">[source]</a></span></div>

Task for retrieving GitHub repository information using the v3 version of the GitHub REST API.

**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name` or `user/repo_name`; can also be provided to the `run` method     </li><li class="args">`info_keys (List[str], optional)`: a list of repo attributes to pull (e.g., `["stargazers_count", "subscribers_count"]`).         A full list of available keys can be found in the official [GitHub documentation](https://developer.github.com/v3/repos/)     </li><li class="args">`token_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret containing your GitHub Access Token;     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the standard Task init method</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-github-repos-getrepoinfo-run'><p class="prefect-class">prefect.tasks.github.repos.GetRepoInfo.run</p>(repo=None, info_keys=None, token=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/repos.py#L42">[source]</a></span></div>
<p class="methods">Run method for this Task. Invoked by calling this Task after initialization within a Flow context, or by using `Task.bind`.<br><br>**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; defaults to the one provided at initialization     </li><li class="args">`info_keys (List[str], optional)`: a list of repo attributes to pull (e.g., `["stargazers_count", "subscribers_count"]`).         A full list of available keys can be found in the official [GitHub documentation](https://developer.github.com/v3/repos/)     </li><li class="args">`token (str)`: a GitHub access token</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a `repo` was never provided     </li><li class="args">`HTTPError`: if the GET request returns a non-200 status code</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: dictionary of the requested information</li></ul></p>|

---
<br>

 ## CreateBranch
 <div class='class-sig' id='prefect-tasks-github-repos-createbranch'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.github.repos.CreateBranch</p>(repo=None, base="master", branch_name=None, token_secret=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/repos.py#L94">[source]</a></span></div>

Task for creating new branches using the v3 version of the GitHub REST API.

**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to create the branch in; must be provided in the         form `organization/repo_name` or `user/repo_name`; can also be provided to the `run` method     </li><li class="args">`base (str, optional)`: the name of the branch you want to branch off; can also         be provided to the `run` method.  Defaults to "master".     </li><li class="args">`branch_name (str, optional)`: the name of the new branch; can also be provided to the `run` method     </li><li class="args">`token_secret (str, optional, DEPRECATED)`: the name of the Prefect Secret containing your GitHub Access Token;     </li><li class="args">`**kwargs (Any, optional)`: additional keyword arguments to pass to the standard Task init method</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-github-repos-createbranch-run'><p class="prefect-class">prefect.tasks.github.repos.CreateBranch.run</p>(repo=None, base=None, branch_name=None, token=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/github/repos.py#L129">[source]</a></span></div>
<p class="methods">Run method for this Task. Invoked by calling this Task after initialization within a Flow context, or by using `Task.bind`.<br><br>**Args**:     <ul class="args"><li class="args">`repo (str, optional)`: the name of the repository to open the issue in; must be provided in the         form `organization/repo_name`; defaults to the one provided at initialization     </li><li class="args">`base (str, optional)`: the name of the branch you want to branch off; if not provided here,         defaults to the one set at initialization     </li><li class="args">`branch_name (str, optional)`: the name of the new branch; if not provided here, defaults to         the one set at initialization     </li><li class="args">`token (str)`: a GitHub access token</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a `repo` or `branch_name` was never provided, or if the base branch wasn't found     </li><li class="args">`HTTPError`: if the GET request returns a non-200 status code</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: dictionary of the response (includes commit hash, etc.)</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on May 14, 2020 at 21:12 UTC</p>