---
author: Gabe Levi
hide_table_of_contents: true
---

Flow v0.19.0 was deployed today! It has a ton of changes, which the
[Changelog](https://github.com/facebook/flow/blob/master/Changelog.md#v0190)
summarizes. The Changelog can be a little concise, though, so here are some
longer explanations for some of the changes. Hope this helps!

### `@noflow`

Flow is opt-in by default (you add `@flow` to a file). However we noticed that
sometimes people would add Flow annotations to files that were missing `@flow`.
Often, these people didn't notice that the file was being ignored by Flow. So
we decided to stop allowing Flow syntax in non-Flow files. This is easily fixed
by adding either `@flow` or `@noflow` to your file. The former will make the
file a Flow file. The latter will tell Flow to completely ignore the file.

### Declaration files

Files that end with `.flow` are now treated specially. They are the preferred
provider of modules. That is if both `foo.js` and `foo.js.flow` exist, then
when you write `import Foo from './foo'`, Flow will use the type exported from
`foo.js.flow` rather than `foo.js`.

We imagine two main ways people will use `.flow` files.

<!--truncate-->

1. As interface files. Maybe you have some library `coolLibrary.js` that is
  really hard to type with inline Flow types. You could put
  `coolLibrary.js.flow` next to it and declare the types that `coolLibrary.js`
  exports.

  ```js
// coolLibrary.js.flow
declare export var coolVar: number;
declare export function coolFunction(): void;
declare export class coolClass {}
  ```

2. As the original source. Maybe you want to ship the minified, transformed
  version of `awesomeLibrary.js`, but people who use `awesomeLibrary.js` also
  use Flow. Well you could do something like

  ```bash
cp awesomeLibraryOriginalCode.js awesomeLibrary.js.flow
babel awesomeLibraryOriginalCode --out-file awesomeLibrary.js
  ```

### Order of precedence for lib files

Now your local lib files will override the builtin lib files. Is one of the
builtin flow libs wrong? Send a pull request! But then while you're waiting for
the next release, you can use your own definition! The order of precedence is
as follows:

1. Any paths supplied on the command line via --lib
2. The files found in the paths specified in the .flowconfig `[libs]` (in
  listing order)
3. The Flow core library files

For example, if I want to override the builtin definition of Array and instead
use my own version, I could update my `.flowconfig` to contain

```
// .flowconfig
[libs]
myArray.js
```

```js
// myArray.js
declare class Array<T> {
  // Put whatever you like in here!
}
```

### Deferred initialization

Previously the following code was an error, because the initialization of
`myString` happens later. Now Flow is fine with it.

```js
function foo(someFlag: boolean): string {
  var myString:string;
  if (someFlag) {
    myString = "yup";
  } else {
    myString = "nope";
  }
  return myString;
}
```
