/*  */
// @nolint

// Regular import
import {
  Something,
} from 'some-module';

// Regular import with types only
import {
} from 'some-module';

// Mixed default and named type only imports
import DefaultImport, {
} from 'some-module';

// Import types

// Typed function
async function test(x, y /*.*/ /*.*/ , z /*.*/ /*.*/ = 123) {
  // Typed expression
  return await (x);
}

// Interface

// Exported interface

// Interface extends

// Implements interface
class Bar extends Other /*.*/ {
  // Class Property with default value
  answer = 42;

  // Class Property with default value and variance
covariant = 42;

  // Class Property
  prop;

  // Class Property with variance
propCo;

  method() {
    return;
  }
}

// Class expression implements interface
var SomeClass = class BazClass {
  prop;

  method() {
    return;
  }
};

// Parametric class
class Wrapper {
  get() {
    return this.value;
  }

  map() {
    // do something
  }
}

// Extends Parametric class
class StringWrapper extends Wrapper {
  // ...
}

// Declare class

// Declare function

// Declare interface

// Declare module

// Declare type alias

// Declare variable

// Type alias

// Export type

// Export type *

// Regular export
export { Wrapper };

// Exported type alias

// Object with types within
var someObj = {
  objMethod() {
    // do nothing.
  }
}

// Example from README
import SomeClassImport from 'some-module'

export class MyClass extends SomeClassImport {

  value

  constructor(value) {
    this.value = value
  }

  get() {
    return this.value
  }

}

// Test async/await functions
async function asyncFunction(input) {
  return await t;
}

// Test read-only data

// Test covariant type variant class with constraint and default.
export class TestClassWithDefault {

  constructor() {}
}

var newline_arrow = () => 42;

var newline_arrow_2 = ()=>42;

// Test calling a function with explicit type arguments
doSomething(3);
doSomething(3);

// Test invoking a constructor with explicit type arguments
new Event();

// Test type union and intersection syntax with leading "operator"
var union;
var intersection;

// Test generic async arrow funcion
const asyncArrow = async() => {};

// Comment type annotations are preserved
var X /*: {
  version: string,
} */ = { version: '42'};

function method(param /*: string */) /*: number */ {
  // ...
}

// declared class fields
class MyClassWithDeclare {
}

// Comment type includes are not emptied out
class MyClassWithComment {
  /*:: prop: string; */
}

// Inferred predicate
function inferredPredicateWithType(arg) {
  return !!arg;
}

function inferredPredicateWithoutType(arg) {
  return !!arg;
}

// Type guards
function typeGuardFunction(x) {
  return typeof x === "boolean";
}

const typeGuardArrow = (x) => (typeof x === "boolean");

function typeGuardInComments(x /*: mixed */) /*: x is boolean */ {
  return typeof x === "boolean";
}

function typeAssertsFunction1(x) {
  if (typeof x !== "boolean") throw new Error;
}

function typeAssertsFunction2(x) {
  if (!x) throw new Error;
}

// Test function with default type parameter
function functionWithDefault() {}

// Opaque types

// Declare export

// `this` params

function thisParam1 () {}
function thisParam2 ( ...a) {}
function thisParam3 (
 ...a) {}
function thisParam4 (
) {}
function thisParam5 (
   ...a) {}
function thisParam6(
) {}
function thisParam7(
  a
) {}

function thisParam8(
  a
) {
  function thisParam9( a) {}
}

const thisConst1 = function() {}
const thisConst2 = function( ...a) {}
const thisConst3 = function(...a) {}
const thisConst4 = function(
) {}
const thisConst5 = function(a,) {}

// `as` cast
const asAny = 'any';
const asArray = [1, 2, 3];
const asBigIntLiteral = 1n;
const asBigInt = 1n;
const asBooleanLiteral = true;
const asBoolean = true;
const asComponent = (() => {});
const asComponentGeneric = (() => {});
const asComponentGenericWithDefault = (() => {});
const asEmpty = {};
const asExists = 'exists';
const asFunction = (() => {});
const asFunctionGeneric = (() => {});
const asFunctionGenericWithDefault = (() => {});
const asKeyof = 'a';
const asMixed = 'mixed';
const asNullable = null;
const asNullLiteral = null;
const asNumberLiteral = 1;
const asNumber = 1;
const asObject = { a: 'a' };
const asParametrizedGeneric = 'generic';
const asStringLiteral = 'literal';
const asString = 'string';
const asSymbol = Symbol('symbol');
const asTuple = ['a', 1];
const asTypeof = 'typeof';
const asUnion = 'union';
const asVoid = undefined;

const asConditional = 'conditional';

const asInterface = { a: 'a', b: 1 };

const asInfer = 'infer';

const asIntersection = { a: 'a', b: 1 };

const asIndexed = 'indexed';

// `as const`
's';
['s'];

// chained `as`
const chain1 = '1';
const chain2 = '1';

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
