/*
 * @flow
 * @format
 */

import type {SuiteType} from '../../../Tester';
const path = require('path');
const {suite, test} = require('../../../Tester');

module.exports = (suite(
  ({
    lspStartAndConnect,
    lspStart,
    lspRequest,
    lspInitializeParams,
    lspRequestAndWaitUntilResponse,
    addFiles,
    addSymlinkDirs,
    addCode,
    lspIgnoreStatusAndCancellation,
  }) => [
    test('textDocument/completion with autoimports', [
      addFiles(
        'nested/bar/baz.js',
        'nested/inner/node_modules/boo/package.json',
        'nested/inner/node_modules/boo/index.js',
        'nested/workspace/workspace-pkg/package.json',
        'nested/workspace/workspace-pkg/main.js',
        'node_modules/toplevel/package.json',
        'node_modules/toplevel/Toplevel.js',
        'third_party/node_modules/foo/package.json',
        'third_party/node_modules/foo/index.js',
      ),
      addSymlinkDirs(
        [
          'nested/bar/node_modules/workspace-pkg',
          '../../workspace/workspace-pkg',
        ],
        ['nested/node_modules', '../third_party/node_modules/'],
      ),
      lspStartAndConnect(),
      lspRequestAndWaitUntilResponse('textDocument/completion', {
        textDocument: {uri: '<PLACEHOLDER_PROJECT_URL>/nested/bar/baz.js'},
        position: {line: 2, character: 7},
        context: {triggerKind: 1},
      }).verifyLSPMessageSnapshot(
        path.join(
          __dirname,
          '__snapshots__',
          'completion_with_auto_imports_toplevel.json',
        ),
        [
          'textDocument/publishDiagnostics',
          'window/showStatus',
          '$/cancelRequest',
        ],
      ),
      lspRequestAndWaitUntilResponse('textDocument/completion', {
        textDocument: {uri: '<PLACEHOLDER_PROJECT_URL>/nested/bar/baz.js'},
        position: {line: 3, character: 7},
        context: {triggerKind: 1},
      }).verifyLSPMessageSnapshot(
        path.join(
          __dirname,
          '__snapshots__',
          'completion_with_auto_imports_nested.json',
        ),
        [
          'textDocument/publishDiagnostics',
          'window/showStatus',
          '$/cancelRequest',
        ],
      ),
      lspRequestAndWaitUntilResponse('textDocument/completion', {
        textDocument: {uri: '<PLACEHOLDER_PROJECT_URL>/nested/bar/baz.js'},
        position: {line: 4, character: 7},
        context: {triggerKind: 1},
      }).verifyLSPMessageSnapshot(
        path.join(
          __dirname,
          '__snapshots__',
          'completion_with_auto_imports_yarn_workspace.json',
        ),
        [
          'textDocument/publishDiagnostics',
          'window/showStatus',
          '$/cancelRequest',
        ],
      ),
    ]),
  ],
): SuiteType);
