// @generated by Thrift for thrift/compiler/test/fixtures/interactions/src/module.thrift
// This file is probably not the place you want to edit!

//! Client implementation for each service in `module`.

#![recursion_limit = "100000000"]
#![allow(non_camel_case_types, non_snake_case, non_upper_case_globals, unused_crate_dependencies, unused_imports, clippy::all)]


#[doc(inline)]
pub use :: as types;

pub mod errors;

pub(crate) use crate as client;
pub(crate) use ::::services;

pub trait MyInteraction: ::std::marker::Send {
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>>;

    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>>;

    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>>;

    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>>;
}

pub trait MyInteractionExt<T>: MyInteraction
where
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>>;
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>>;
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>>;
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> MyInteraction for S
where
    S: ::std::convert::AsRef<dyn MyInteraction + 'a>,
    S: ::std::marker::Send,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>> {
        self.as_ref().frobnicate(
        )
    }
    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>> {
        self.as_ref().ping(
        )
    }
    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>> {
        self.as_ref().truthify(
        )
    }
    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>> {
        self.as_ref().encode(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> MyInteractionExt<T> for S
where
    S: ::std::convert::AsRef<dyn MyInteraction + 'a> + ::std::convert::AsRef<dyn MyInteractionExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionExt<T>>>::as_ref(self).frobnicate_with_rpc_opts(
            rpc_options,
        )
    }
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionExt<T>>>::as_ref(self).ping_with_rpc_opts(
            rpc_options,
        )
    }
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionExt<T>>>::as_ref(self).truthify_with_rpc_opts(
            rpc_options,
        )
    }
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionExt<T>>>::as_ref(self).encode_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `MyInteraction`.
pub struct MyInteractionImpl<P, T, S = ::fbthrift::NoopSpawner> {
    #[allow(dead_code)]
    names: &'static MyInteractionNames,
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}

pub struct MyInteractionNames {
    pub service: &'static ::std::ffi::CStr,
    pub method_frobnicate: &'static ::std::ffi::CStr,
    pub method_ping: &'static ::std::ffi::CStr,
    pub method_truthify: &'static ::std::ffi::CStr,
    pub method_encode: &'static ::std::ffi::CStr,
}

impl<P, T, S> MyInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
        names: &'static MyInteractionNames,
    ) -> Self {
        Self {
            names,
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }



    fn _frobnicate_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_frobnicate;

        let args = self::Args_MyInteraction_frobnicate {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteraction.frobnicate", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyInteraction.frobnicate"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction::FrobnicateReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction::FrobnicateError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteraction.frobnicate"))
        .boxed()
    }

    fn _ping_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_ping;

        let args = self::Args_MyInteraction_ping {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteraction.ping", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyInteraction.ping"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction::PingReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction::PingError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteraction.ping"))
        .boxed()
    }

    fn _truthify_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_truthify;

        let args = self::Args_MyInteraction_truthify {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteraction.truthify", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_stream = transport
            .call_stream(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_stream", method = "MyInteraction.truthify"));

        async move {
            let (initial, stream) = call_stream.await?;

            let new_stream = stream.then(|item_res| {
                async move {
                    match item_res {
                        ::std::result::Result::Err(err) =>
                            ::std::result::Result::Err(crate::errors::my_interaction::TruthifyStreamError::from(err)),
                        ::std::result::Result::Ok(item_enc) => {
                            S::spawn(move || {
                                match item_enc {
                                    ::fbthrift::ClientStreamElement::Reply(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_interaction::TruthifyStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                    ::fbthrift::ClientStreamElement::ApplicationEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        let aexn = ::fbthrift::ApplicationException::rs_thrift_read(&mut de)?;
                                        ::std::result::Result::Ok(::std::result::Result::Err(crate::errors::my_interaction::TruthifyStreamError::ApplicationException(aexn)))
                                    }
                                    ::fbthrift::ClientStreamElement::DeclaredEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_interaction::TruthifyStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                }
                            }).await.map_err(::anyhow::Error::from)??
                        }
                    }
                }
            })
            .boxed();

            let de = P::deserializer(initial);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction::TruthifyReader, S>(de)
                .await??
                .map(move |_| new_stream);
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteraction.truthify"))
        .boxed()
    }

    fn _encode_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;
        use ::futures::TryFutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_encode;

        let args = self::Args_MyInteraction_encode {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteraction.encode", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_sink = transport
            .call_sink(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_sink", method = "MyInteraction.encode"));

        async move {
            let ::fbthrift::SinkReply {
                initial_response: _initial_response,
                sink_processor,
            } = call_sink.await?;

            let de = P::deserializer(_initial_response);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction::EncodeReader, S>(de).await?;

            let initial_response = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction::EncodeError::ApplicationException(aexn))
                }
            }?;

            let sink_helper_fn = move |stream: ::futures::stream::BoxStream<'static, ::std::result::Result<
                ::std::string::String,
                crate::errors::my_interaction::EncodeSinkError
            >>| {
                let new_stream = stream.map(|item| {
                    match item {
                        ::std::result::Result::Ok(res) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction::EncodeSinkError>(::std::result::Result::Ok(res), "MyInteraction.encode");
                            ::fbthrift::ClientStreamElement::Reply(enc)
                        }
                        ::std::result::Result::Err(crate::errors::my_interaction::EncodeSinkError::ApplicationException(aexn)) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction::EncodeSinkError>(::std::result::Result::Err(crate::errors::my_interaction::EncodeSinkError::ApplicationException(aexn)), "MyInteraction.encode");
                            ::fbthrift::ClientStreamElement::ApplicationEx(enc)
                        }
                        ::std::result::Result::Err(crate::errors::my_interaction::EncodeSinkError::ThriftError(err)) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction::EncodeSinkError>(::std::result::Result::Err(crate::errors::my_interaction::EncodeSinkError::ThriftError(err)), "MyInteraction.encode");
                            ::fbthrift::ClientStreamElement::ApplicationEx(enc)
                        }
                    }
                }).boxed();
                let sinker = sink_processor;
                async move {
                    let payload = (sinker)(new_stream).await?;
                    S::spawn(move || {
                        let mut de = P::deserializer(payload);
                        <crate::errors::my_interaction::EncodeSinkFinalReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                    }).await.map_err(::anyhow::Error::from)??
                }.boxed()
            };

            let res = Ok(::fbthrift::SinkResult::<
                ::std::collections::BTreeSet<::std::primitive::i32>,
                ::std::string::String,
                crate::errors::my_interaction::EncodeSinkError,
                ::std::vec::Vec<::std::primitive::u8>,
                crate::errors::my_interaction::EncodeSinkFinalError,
            > {
                initial_response,
                sink: Box::new(sink_helper_fn),
            });
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteraction.encode"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for MyInteractionImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_MyInteraction_frobnicate<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteraction_frobnicate<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteraction.frobnicate"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteraction_ping<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteraction_ping<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteraction.ping"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteraction_truthify<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteraction_truthify<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteraction.truthify"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteraction_encode<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteraction_encode<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteraction.encode"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> MyInteraction for MyInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>> {
        let rpc_options = T::RpcOptions::default();
        self._frobnicate_impl(
            rpc_options,
        )
    }
    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>> {
        let rpc_options = T::RpcOptions::default();
        self._ping_impl(
            rpc_options,
        )
    }
    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>> {
        let rpc_options = T::RpcOptions::default();
        self._truthify_impl(
            rpc_options,
        )
    }
    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>> {
        let rpc_options = T::RpcOptions::default();
        self._encode_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> MyInteractionExt<T> for MyInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction::FrobnicateError>> {
        self._frobnicate_impl(
            rpc_options,
        )
    }
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction::PingError>> {
        self._ping_impl(
            rpc_options,
        )
    }
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction::TruthifyStreamError>>, crate::errors::my_interaction::TruthifyError>> {
        self._truthify_impl(
            rpc_options,
        )
    }
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction::EncodeSinkFinalError,
>, crate::errors::my_interaction::EncodeError>> {
        self._encode_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

pub type MyInteractionDynClient = dyn MyInteraction + ::std::marker::Send + ::std::marker::Sync + 'static;
pub type MyInteractionClient = ::std::sync::Arc<MyInteractionDynClient>;



pub trait MyInteractionFast: ::std::marker::Send {
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>>;

    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>>;

    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>>;

    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>>;
}

pub trait MyInteractionFastExt<T>: MyInteractionFast
where
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>>;
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>>;
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>>;
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> MyInteractionFast for S
where
    S: ::std::convert::AsRef<dyn MyInteractionFast + 'a>,
    S: ::std::marker::Send,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>> {
        self.as_ref().frobnicate(
        )
    }
    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>> {
        self.as_ref().ping(
        )
    }
    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>> {
        self.as_ref().truthify(
        )
    }
    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>> {
        self.as_ref().encode(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> MyInteractionFastExt<T> for S
where
    S: ::std::convert::AsRef<dyn MyInteractionFast + 'a> + ::std::convert::AsRef<dyn MyInteractionFastExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionFastExt<T>>>::as_ref(self).frobnicate_with_rpc_opts(
            rpc_options,
        )
    }
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionFastExt<T>>>::as_ref(self).ping_with_rpc_opts(
            rpc_options,
        )
    }
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionFastExt<T>>>::as_ref(self).truthify_with_rpc_opts(
            rpc_options,
        )
    }
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>> {
        <Self as ::std::convert::AsRef<dyn MyInteractionFastExt<T>>>::as_ref(self).encode_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `MyInteractionFast`.
pub struct MyInteractionFastImpl<P, T, S = ::fbthrift::NoopSpawner> {
    #[allow(dead_code)]
    names: &'static MyInteractionFastNames,
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}

pub struct MyInteractionFastNames {
    pub service: &'static ::std::ffi::CStr,
    pub method_frobnicate: &'static ::std::ffi::CStr,
    pub method_ping: &'static ::std::ffi::CStr,
    pub method_truthify: &'static ::std::ffi::CStr,
    pub method_encode: &'static ::std::ffi::CStr,
}

impl<P, T, S> MyInteractionFastImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
        names: &'static MyInteractionFastNames,
    ) -> Self {
        Self {
            names,
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }



    fn _frobnicate_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_frobnicate;

        let args = self::Args_MyInteractionFast_frobnicate {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteractionFast.frobnicate", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyInteractionFast.frobnicate"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction_fast::FrobnicateReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction_fast::FrobnicateError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteractionFast.frobnicate"))
        .boxed()
    }

    fn _ping_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_ping;

        let args = self::Args_MyInteractionFast_ping {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteractionFast.ping", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyInteractionFast.ping"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction_fast::PingReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction_fast::PingError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteractionFast.ping"))
        .boxed()
    }

    fn _truthify_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_truthify;

        let args = self::Args_MyInteractionFast_truthify {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteractionFast.truthify", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_stream = transport
            .call_stream(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_stream", method = "MyInteractionFast.truthify"));

        async move {
            let (initial, stream) = call_stream.await?;

            let new_stream = stream.then(|item_res| {
                async move {
                    match item_res {
                        ::std::result::Result::Err(err) =>
                            ::std::result::Result::Err(crate::errors::my_interaction_fast::TruthifyStreamError::from(err)),
                        ::std::result::Result::Ok(item_enc) => {
                            S::spawn(move || {
                                match item_enc {
                                    ::fbthrift::ClientStreamElement::Reply(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_interaction_fast::TruthifyStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                    ::fbthrift::ClientStreamElement::ApplicationEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        let aexn = ::fbthrift::ApplicationException::rs_thrift_read(&mut de)?;
                                        ::std::result::Result::Ok(::std::result::Result::Err(crate::errors::my_interaction_fast::TruthifyStreamError::ApplicationException(aexn)))
                                    }
                                    ::fbthrift::ClientStreamElement::DeclaredEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_interaction_fast::TruthifyStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                }
                            }).await.map_err(::anyhow::Error::from)??
                        }
                    }
                }
            })
            .boxed();

            let de = P::deserializer(initial);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction_fast::TruthifyReader, S>(de)
                .await??
                .map(move |_| new_stream);
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteractionFast.truthify"))
        .boxed()
    }

    fn _encode_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;
        use ::futures::TryFutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_encode;

        let args = self::Args_MyInteractionFast_encode {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("MyInteractionFast.encode", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_sink = transport
            .call_sink(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_sink", method = "MyInteractionFast.encode"));

        async move {
            let ::fbthrift::SinkReply {
                initial_response: _initial_response,
                sink_processor,
            } = call_sink.await?;

            let de = P::deserializer(_initial_response);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_interaction_fast::EncodeReader, S>(de).await?;

            let initial_response = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_interaction_fast::EncodeError::ApplicationException(aexn))
                }
            }?;

            let sink_helper_fn = move |stream: ::futures::stream::BoxStream<'static, ::std::result::Result<
                ::std::string::String,
                crate::errors::my_interaction_fast::EncodeSinkError
            >>| {
                let new_stream = stream.map(|item| {
                    match item {
                        ::std::result::Result::Ok(res) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction_fast::EncodeSinkError>(::std::result::Result::Ok(res), "MyInteractionFast.encode");
                            ::fbthrift::ClientStreamElement::Reply(enc)
                        }
                        ::std::result::Result::Err(crate::errors::my_interaction_fast::EncodeSinkError::ApplicationException(aexn)) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction_fast::EncodeSinkError>(::std::result::Result::Err(crate::errors::my_interaction_fast::EncodeSinkError::ApplicationException(aexn)), "MyInteractionFast.encode");
                            ::fbthrift::ClientStreamElement::ApplicationEx(enc)
                        }
                        ::std::result::Result::Err(crate::errors::my_interaction_fast::EncodeSinkError::ThriftError(err)) => {
                            let enc = ::fbthrift::help::serialize_stream_item::<P, crate::errors::my_interaction_fast::EncodeSinkError>(::std::result::Result::Err(crate::errors::my_interaction_fast::EncodeSinkError::ThriftError(err)), "MyInteractionFast.encode");
                            ::fbthrift::ClientStreamElement::ApplicationEx(enc)
                        }
                    }
                }).boxed();
                let sinker = sink_processor;
                async move {
                    let payload = (sinker)(new_stream).await?;
                    S::spawn(move || {
                        let mut de = P::deserializer(payload);
                        <crate::errors::my_interaction_fast::EncodeSinkFinalReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                    }).await.map_err(::anyhow::Error::from)??
                }.boxed()
            };

            let res = Ok(::fbthrift::SinkResult::<
                ::std::collections::BTreeSet<::std::primitive::i32>,
                ::std::string::String,
                crate::errors::my_interaction_fast::EncodeSinkError,
                ::std::vec::Vec<::std::primitive::u8>,
                crate::errors::my_interaction_fast::EncodeSinkFinalError,
            > {
                initial_response,
                sink: Box::new(sink_helper_fn),
            });
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyInteractionFast.encode"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for MyInteractionFastImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_MyInteractionFast_frobnicate<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteractionFast_frobnicate<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteractionFast.frobnicate"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteractionFast_ping<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteractionFast_ping<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteractionFast.ping"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteractionFast_truthify<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteractionFast_truthify<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteractionFast.truthify"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyInteractionFast_encode<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyInteractionFast_encode<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyInteractionFast.encode"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> MyInteractionFast for MyInteractionFastImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>> {
        let rpc_options = T::RpcOptions::default();
        self._frobnicate_impl(
            rpc_options,
        )
    }
    fn ping(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>> {
        let rpc_options = T::RpcOptions::default();
        self._ping_impl(
            rpc_options,
        )
    }
    fn truthify(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>> {
        let rpc_options = T::RpcOptions::default();
        self._truthify_impl(
            rpc_options,
        )
    }
    fn encode(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>> {
        let rpc_options = T::RpcOptions::default();
        self._encode_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> MyInteractionFastExt<T> for MyInteractionFastImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_interaction_fast::FrobnicateError>> {
        self._frobnicate_impl(
            rpc_options,
        )
    }
    fn ping_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_interaction_fast::PingError>> {
        self._ping_impl(
            rpc_options,
        )
    }
    fn truthify_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::bool, crate::errors::my_interaction_fast::TruthifyStreamError>>, crate::errors::my_interaction_fast::TruthifyError>> {
        self._truthify_impl(
            rpc_options,
        )
    }
    fn encode_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<::fbthrift::SinkResult<
    ::std::collections::BTreeSet<::std::primitive::i32>,
    ::std::string::String,
    crate::errors::my_interaction_fast::EncodeSinkError,
    ::std::vec::Vec<::std::primitive::u8>,
    crate::errors::my_interaction_fast::EncodeSinkFinalError,
>, crate::errors::my_interaction_fast::EncodeError>> {
        self._encode_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

pub type MyInteractionFastDynClient = dyn MyInteractionFast + ::std::marker::Send + ::std::marker::Sync + 'static;
pub type MyInteractionFastClient = ::std::sync::Arc<MyInteractionFastDynClient>;



pub trait SerialInteraction: ::std::marker::Send {
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>>;
}

pub trait SerialInteractionExt<T>: SerialInteraction
where
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> SerialInteraction for S
where
    S: ::std::convert::AsRef<dyn SerialInteraction + 'a>,
    S: ::std::marker::Send,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>> {
        self.as_ref().frobnicate(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> SerialInteractionExt<T> for S
where
    S: ::std::convert::AsRef<dyn SerialInteraction + 'a> + ::std::convert::AsRef<dyn SerialInteractionExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>> {
        <Self as ::std::convert::AsRef<dyn SerialInteractionExt<T>>>::as_ref(self).frobnicate_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `SerialInteraction`.
pub struct SerialInteractionImpl<P, T, S = ::fbthrift::NoopSpawner> {
    #[allow(dead_code)]
    names: &'static SerialInteractionNames,
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}

pub struct SerialInteractionNames {
    pub service: &'static ::std::ffi::CStr,
    pub method_frobnicate: &'static ::std::ffi::CStr,
}

impl<P, T, S> SerialInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
        names: &'static SerialInteractionNames,
    ) -> Self {
        Self {
            names,
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }



    fn _frobnicate_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_frobnicate;

        let args = self::Args_SerialInteraction_frobnicate {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("SerialInteraction.frobnicate", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "SerialInteraction.frobnicate"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::serial_interaction::FrobnicateReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::serial_interaction::FrobnicateError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "SerialInteraction.frobnicate"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for SerialInteractionImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_SerialInteraction_frobnicate<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_SerialInteraction_frobnicate<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "SerialInteraction.frobnicate"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> SerialInteraction for SerialInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>> {
        let rpc_options = T::RpcOptions::default();
        self._frobnicate_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> SerialInteractionExt<T> for SerialInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn frobnicate_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::serial_interaction::FrobnicateError>> {
        self._frobnicate_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

pub type SerialInteractionDynClient = dyn SerialInteraction + ::std::marker::Send + ::std::marker::Sync + 'static;
pub type SerialInteractionClient = ::std::sync::Arc<SerialInteractionDynClient>;



pub trait BoxedInteraction: ::std::marker::Send {
    fn getABox(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>>;
}

pub trait BoxedInteractionExt<T>: BoxedInteraction
where
    T: ::fbthrift::Transport,
{
    fn getABox_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> BoxedInteraction for S
where
    S: ::std::convert::AsRef<dyn BoxedInteraction + 'a>,
    S: ::std::marker::Send,
{
    fn getABox(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>> {
        self.as_ref().getABox(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> BoxedInteractionExt<T> for S
where
    S: ::std::convert::AsRef<dyn BoxedInteraction + 'a> + ::std::convert::AsRef<dyn BoxedInteractionExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn getABox_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>> {
        <Self as ::std::convert::AsRef<dyn BoxedInteractionExt<T>>>::as_ref(self).getABox_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `BoxedInteraction`.
pub struct BoxedInteractionImpl<P, T, S = ::fbthrift::NoopSpawner> {
    #[allow(dead_code)]
    names: &'static BoxedInteractionNames,
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}

pub struct BoxedInteractionNames {
    pub service: &'static ::std::ffi::CStr,
    pub method_getABox: &'static ::std::ffi::CStr,
}

impl<P, T, S> BoxedInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
        names: &'static BoxedInteractionNames,
    ) -> Self {
        Self {
            names,
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }



    fn _getABox_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = self.names.service;
        let service_method_name = self.names.method_getABox;

        let args = self::Args_BoxedInteraction_getABox {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("BoxedInteraction.getABox", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "BoxedInteraction.getABox"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::boxed_interaction::GetABoxReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::boxed_interaction::GetABoxError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "BoxedInteraction.getABox"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for BoxedInteractionImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_BoxedInteraction_getABox<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_BoxedInteraction_getABox<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "BoxedInteraction.getABox"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> BoxedInteraction for BoxedInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn getABox(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>> {
        let rpc_options = T::RpcOptions::default();
        self._getABox_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> BoxedInteractionExt<T> for BoxedInteractionImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn getABox_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::ShouldBeBoxed, crate::errors::boxed_interaction::GetABoxError>> {
        self._getABox_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

pub type BoxedInteractionDynClient = dyn BoxedInteraction + ::std::marker::Send + ::std::marker::Sync + 'static;
pub type BoxedInteractionClient = ::std::sync::Arc<BoxedInteractionDynClient>;




pub trait MyService: ::std::marker::Send {
    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error>;

    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error>;

    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error>;

    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>>;

    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>>;

    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>>;

    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>>;
}

pub trait MyServiceExt<T>: MyService
where
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>>;
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>>;
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>>;
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> MyService for S
where
    S: ::std::convert::AsRef<dyn MyService + 'a>,
    S: ::std::marker::Send,
{
    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        self.as_ref().createMyInteraction()
    }
    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error> {
        self.as_ref().createMyInteractionFast()
    }
    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error> {
        self.as_ref().createSerialInteraction()
    }
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>> {
        self.as_ref().foo(
        )
    }
    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>> {
        self.as_ref().interact(
            arg_arg,
        )
    }
    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>> {
        self.as_ref().interactFast(
        )
    }
    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>> {
        self.as_ref().serialize(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> MyServiceExt<T> for S
where
    S: ::std::convert::AsRef<dyn MyService + 'a> + ::std::convert::AsRef<dyn MyServiceExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>> {
        <Self as ::std::convert::AsRef<dyn MyServiceExt<T>>>::as_ref(self).foo_with_rpc_opts(
            rpc_options,
        )
    }
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>> {
        <Self as ::std::convert::AsRef<dyn MyServiceExt<T>>>::as_ref(self).interact_with_rpc_opts(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>> {
        <Self as ::std::convert::AsRef<dyn MyServiceExt<T>>>::as_ref(self).interactFast_with_rpc_opts(
            rpc_options,
        )
    }
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>> {
        <Self as ::std::convert::AsRef<dyn MyServiceExt<T>>>::as_ref(self).serialize_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `MyService`.
pub struct MyServiceImpl<P, T, S = ::fbthrift::NoopSpawner> {
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}


impl<P, T, S> MyServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
    ) -> Self {
        Self {
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }

    const NAMES_MyInteraction: crate::client::MyInteractionNames = crate::client::MyInteractionNames {
        service: c"MyService",
        method_frobnicate: c"MyService.MyInteraction.frobnicate",
        method_ping: c"MyService.MyInteraction.ping",
        method_truthify: c"MyService.MyInteraction.truthify",
        method_encode: c"MyService.MyInteraction.encode",
    };
    const NAMES_MyInteractionFast: crate::client::MyInteractionFastNames = crate::client::MyInteractionFastNames {
        service: c"MyService",
        method_frobnicate: c"MyService.MyInteractionFast.frobnicate",
        method_ping: c"MyService.MyInteractionFast.ping",
        method_truthify: c"MyService.MyInteractionFast.truthify",
        method_encode: c"MyService.MyInteractionFast.encode",
    };
    const NAMES_SerialInteraction: crate::client::SerialInteractionNames = crate::client::SerialInteractionNames {
        service: c"MyService",
        method_frobnicate: c"MyService.SerialInteraction.frobnicate",
    };


    fn _foo_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"MyService";
        let service_method_name = c"MyService.foo";

        let args = self::Args_MyService_foo {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("foo", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyService.foo"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_service::FooReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_service::FooError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "MyService.foo"))
        .boxed()
    }

    fn _interact_impl(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"MyService";
        let service_method_name = c"MyService.interact";

        const INTERACTION_NAME: &::std::ffi::CStr = c"MyInteraction";
        let args = self::Args_MyService_interact {
            arg: arg_arg,
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::MyInteractionImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_MyInteraction);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("interact", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyService.interact"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_service::InteractReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_service::InteractError::ApplicationException(aexn))
                }
            };
            let interaction_client: crate::client::MyInteractionClient = ::std::sync::Arc::new(interaction_impl);
            res?;
            ::std::result::Result::Ok(interaction_client)
        }
        .instrument(::tracing::info_span!("stream", method = "MyService.interact"))
        .boxed()
    }

    fn _interactFast_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"MyService";
        let service_method_name = c"MyService.interactFast";

        const INTERACTION_NAME: &::std::ffi::CStr = c"MyInteractionFast";
        let args = self::Args_MyService_interactFast {
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::MyInteractionFastImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_MyInteractionFast);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("interactFast", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "MyService.interactFast"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_service::InteractFastReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::my_service::InteractFastError::ApplicationException(aexn))
                }
            };
            let interaction_client: crate::client::MyInteractionFastClient = ::std::sync::Arc::new(interaction_impl);
            ::std::result::Result::Ok((interaction_client, res?))
        }
        .instrument(::tracing::info_span!("stream", method = "MyService.interactFast"))
        .boxed()
    }

    fn _serialize_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;

        let service_name = c"MyService";
        let service_method_name = c"MyService.serialize";

        const INTERACTION_NAME: &::std::ffi::CStr = c"SerialInteraction";
        let args = self::Args_MyService_serialize {
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::SerialInteractionImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_SerialInteraction);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("serialize", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_stream = transport
            .call_stream(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_stream", method = "MyService.serialize"));

        async move {
            let (initial, stream) = call_stream.await?;

            let new_stream = stream.then(|item_res| {
                async move {
                    match item_res {
                        ::std::result::Result::Err(err) =>
                            ::std::result::Result::Err(crate::errors::my_service::SerializeStreamError::from(err)),
                        ::std::result::Result::Ok(item_enc) => {
                            S::spawn(move || {
                                match item_enc {
                                    ::fbthrift::ClientStreamElement::Reply(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_service::SerializeStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                    ::fbthrift::ClientStreamElement::ApplicationEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        let aexn = ::fbthrift::ApplicationException::rs_thrift_read(&mut de)?;
                                        ::std::result::Result::Ok(::std::result::Result::Err(crate::errors::my_service::SerializeStreamError::ApplicationException(aexn)))
                                    }
                                    ::fbthrift::ClientStreamElement::DeclaredEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::my_service::SerializeStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                }
                            }).await.map_err(::anyhow::Error::from)??
                        }
                    }
                }
            })
            .boxed();

            let de = P::deserializer(initial);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::my_service::SerializeReader, S>(de)
                .await??
                .map(move |initial| (initial, new_stream));
            let interaction_client: crate::client::SerialInteractionClient = ::std::sync::Arc::new(interaction_impl);
            ::std::result::Result::Ok((interaction_client, res?))
        }
        .instrument(::tracing::info_span!("stream", method = "MyService.serialize"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for MyServiceImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_MyService_foo<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyService_foo<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyService.foo"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyService_interact<'a> {
    arg: ::std::primitive::i32,
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyService_interact<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyService.interact"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_begin("arg", ::fbthrift::TType::I32, 1i16);
        ::fbthrift::Serialize::rs_thrift_write(&self.arg, p);
        p.write_field_end();
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyService_interactFast<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyService_interactFast<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyService.interactFast"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_MyService_serialize<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_MyService_serialize<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "MyService.serialize"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> MyService for MyServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{

    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::MyInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"MyInteraction")?,
                    &Self::NAMES_MyInteraction,
                )
            )
        )
    }

    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::MyInteractionFastImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"MyInteractionFast")?,
                    &Self::NAMES_MyInteractionFast,
                )
            )
        )
    }

    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::SerialInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"SerialInteraction")?,
                    &Self::NAMES_SerialInteraction,
                )
            )
        )
    }
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>> {
        let rpc_options = T::RpcOptions::default();
        self._foo_impl(
            rpc_options,
        )
    }
    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>> {
        let rpc_options = T::RpcOptions::default();
        self._interact_impl(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>> {
        let rpc_options = T::RpcOptions::default();
        self._interactFast_impl(
            rpc_options,
        )
    }
    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>> {
        let rpc_options = T::RpcOptions::default();
        self._serialize_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> MyServiceExt<T> for MyServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::my_service::FooError>> {
        self._foo_impl(
            rpc_options,
        )
    }
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::my_service::InteractError>> {
        self._interact_impl(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::my_service::InteractFastError>> {
        self._interactFast_impl(
            rpc_options,
        )
    }
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::my_service::SerializeStreamError>>)), crate::errors::my_service::SerializeError>> {
        self._serialize_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

#[derive(Clone)]
pub struct make_MyService;

/// To be called by user directly setting up a client. Avoids
/// needing ClientFactory trait in scope, avoids unidiomatic
/// make_Trait name.
///
/// ```
/// # const _: &str = stringify! {
/// use bgs::client::BuckGraphService;
///
/// let protocol = BinaryProtocol::new();
/// let transport = HttpClient::new();
/// let client = <dyn BuckGraphService>::new(protocol, transport);
/// # };
/// ```
impl dyn MyService {
    pub fn new<P, T>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl MyService + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, T, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl MyService + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(MyServiceImpl::<P, T, S>::new(transport))
    }
}

impl<T> dyn MyServiceExt<T>
where
    T: ::fbthrift::Transport,
{
    pub fn new<P>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl MyServiceExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl MyServiceExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(MyServiceImpl::<P, T, S>::new(transport))
    }
}

pub type MyServiceDynClient = <make_MyService as ::fbthrift::ClientFactory>::Api;
pub type MyServiceClient = ::std::sync::Arc<MyServiceDynClient>;

/// The same thing, but to be called from generic contexts where we are
/// working with a type parameter `C: ClientFactory` to produce clients.
impl ::fbthrift::ClientFactory for make_MyService {
    type Api = dyn MyService + ::std::marker::Send + ::std::marker::Sync + 'static;

    fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        <dyn MyService>::with_spawner(protocol, transport, spawner)
    }
}

pub trait Factories: ::std::marker::Send {
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>>;

    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>>;

    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>>;

    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>>;
}

pub trait FactoriesExt<T>: Factories
where
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>>;
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>>;
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>>;
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> Factories for S
where
    S: ::std::convert::AsRef<dyn Factories + 'a>,
    S: ::std::marker::Send,
{
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>> {
        self.as_ref().foo(
        )
    }
    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>> {
        self.as_ref().interact(
            arg_arg,
        )
    }
    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>> {
        self.as_ref().interactFast(
        )
    }
    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>> {
        self.as_ref().serialize(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> FactoriesExt<T> for S
where
    S: ::std::convert::AsRef<dyn Factories + 'a> + ::std::convert::AsRef<dyn FactoriesExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>> {
        <Self as ::std::convert::AsRef<dyn FactoriesExt<T>>>::as_ref(self).foo_with_rpc_opts(
            rpc_options,
        )
    }
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>> {
        <Self as ::std::convert::AsRef<dyn FactoriesExt<T>>>::as_ref(self).interact_with_rpc_opts(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>> {
        <Self as ::std::convert::AsRef<dyn FactoriesExt<T>>>::as_ref(self).interactFast_with_rpc_opts(
            rpc_options,
        )
    }
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>> {
        <Self as ::std::convert::AsRef<dyn FactoriesExt<T>>>::as_ref(self).serialize_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `Factories`.
pub struct FactoriesImpl<P, T, S = ::fbthrift::NoopSpawner> {
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}


impl<P, T, S> FactoriesImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
    ) -> Self {
        Self {
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }

    const NAMES_MyInteraction: crate::client::MyInteractionNames = crate::client::MyInteractionNames {
        service: c"Factories",
        method_frobnicate: c"Factories.MyInteraction.frobnicate",
        method_ping: c"Factories.MyInteraction.ping",
        method_truthify: c"Factories.MyInteraction.truthify",
        method_encode: c"Factories.MyInteraction.encode",
    };
    const NAMES_MyInteractionFast: crate::client::MyInteractionFastNames = crate::client::MyInteractionFastNames {
        service: c"Factories",
        method_frobnicate: c"Factories.MyInteractionFast.frobnicate",
        method_ping: c"Factories.MyInteractionFast.ping",
        method_truthify: c"Factories.MyInteractionFast.truthify",
        method_encode: c"Factories.MyInteractionFast.encode",
    };
    const NAMES_SerialInteraction: crate::client::SerialInteractionNames = crate::client::SerialInteractionNames {
        service: c"Factories",
        method_frobnicate: c"Factories.SerialInteraction.frobnicate",
    };


    fn _foo_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"Factories";
        let service_method_name = c"Factories.foo";

        let args = self::Args_Factories_foo {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("foo", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "Factories.foo"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::factories::FooReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::factories::FooError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "Factories.foo"))
        .boxed()
    }

    fn _interact_impl(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"Factories";
        let service_method_name = c"Factories.interact";

        const INTERACTION_NAME: &::std::ffi::CStr = c"MyInteraction";
        let args = self::Args_Factories_interact {
            arg: arg_arg,
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::MyInteractionImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_MyInteraction);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("interact", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "Factories.interact"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::factories::InteractReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::factories::InteractError::ApplicationException(aexn))
                }
            };
            let interaction_client: crate::client::MyInteractionClient = ::std::sync::Arc::new(interaction_impl);
            res?;
            ::std::result::Result::Ok(interaction_client)
        }
        .instrument(::tracing::info_span!("stream", method = "Factories.interact"))
        .boxed()
    }

    fn _interactFast_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"Factories";
        let service_method_name = c"Factories.interactFast";

        const INTERACTION_NAME: &::std::ffi::CStr = c"MyInteractionFast";
        let args = self::Args_Factories_interactFast {
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::MyInteractionFastImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_MyInteractionFast);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("interactFast", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "Factories.interactFast"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::factories::InteractFastReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::factories::InteractFastError::ApplicationException(aexn))
                }
            };
            let interaction_client: crate::client::MyInteractionFastClient = ::std::sync::Arc::new(interaction_impl);
            ::std::result::Result::Ok((interaction_client, res?))
        }
        .instrument(::tracing::info_span!("stream", method = "Factories.interactFast"))
        .boxed()
    }

    fn _serialize_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;
        use ::futures::StreamExt as _;
        use ::fbthrift::Deserialize as _;

        let service_name = c"Factories";
        let service_method_name = c"Factories.serialize";

        const INTERACTION_NAME: &::std::ffi::CStr = c"SerialInteraction";
        let args = self::Args_Factories_serialize {
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::SerialInteractionImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_SerialInteraction);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("serialize", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call_stream = transport
            .call_stream(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call_stream", method = "Factories.serialize"));

        async move {
            let (initial, stream) = call_stream.await?;

            let new_stream = stream.then(|item_res| {
                async move {
                    match item_res {
                        ::std::result::Result::Err(err) =>
                            ::std::result::Result::Err(crate::errors::factories::SerializeStreamError::from(err)),
                        ::std::result::Result::Ok(item_enc) => {
                            S::spawn(move || {
                                match item_enc {
                                    ::fbthrift::ClientStreamElement::Reply(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::factories::SerializeStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                    ::fbthrift::ClientStreamElement::ApplicationEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        let aexn = ::fbthrift::ApplicationException::rs_thrift_read(&mut de)?;
                                        ::std::result::Result::Ok(::std::result::Result::Err(crate::errors::factories::SerializeStreamError::ApplicationException(aexn)))
                                    }
                                    ::fbthrift::ClientStreamElement::DeclaredEx(payload) => {
                                        let mut de = P::deserializer(payload);
                                        <crate::errors::factories::SerializeStreamReader as ::fbthrift::help::DeserializeExn>::read_result(&mut de)
                                    }
                                }
                            }).await.map_err(::anyhow::Error::from)??
                        }
                    }
                }
            })
            .boxed();

            let de = P::deserializer(initial);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::factories::SerializeReader, S>(de)
                .await??
                .map(move |initial| (initial, new_stream));
            let interaction_client: crate::client::SerialInteractionClient = ::std::sync::Arc::new(interaction_impl);
            ::std::result::Result::Ok((interaction_client, res?))
        }
        .instrument(::tracing::info_span!("stream", method = "Factories.serialize"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for FactoriesImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_Factories_foo<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_Factories_foo<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "Factories.foo"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_Factories_interact<'a> {
    arg: ::std::primitive::i32,
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_Factories_interact<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "Factories.interact"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_begin("arg", ::fbthrift::TType::I32, 1i16);
        ::fbthrift::Serialize::rs_thrift_write(&self.arg, p);
        p.write_field_end();
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_Factories_interactFast<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_Factories_interactFast<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "Factories.interactFast"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

struct Args_Factories_serialize<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_Factories_serialize<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "Factories.serialize"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> Factories for FactoriesImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>> {
        let rpc_options = T::RpcOptions::default();
        self._foo_impl(
            rpc_options,
        )
    }
    fn interact(
        &self,
        arg_arg: ::std::primitive::i32,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>> {
        let rpc_options = T::RpcOptions::default();
        self._interact_impl(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>> {
        let rpc_options = T::RpcOptions::default();
        self._interactFast_impl(
            rpc_options,
        )
    }
    fn serialize(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>> {
        let rpc_options = T::RpcOptions::default();
        self._serialize_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> FactoriesExt<T> for FactoriesImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::factories::FooError>> {
        self._foo_impl(
            rpc_options,
        )
    }
    fn interact_with_rpc_opts(
        &self,
        arg_arg: ::std::primitive::i32,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::client::MyInteractionClient, crate::errors::factories::InteractError>> {
        self._interact_impl(
            arg_arg,
            rpc_options,
        )
    }
    fn interactFast_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::MyInteractionFastClient, ::std::primitive::i32), crate::errors::factories::InteractFastError>> {
        self._interactFast_impl(
            rpc_options,
        )
    }
    fn serialize_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::SerialInteractionClient, (::std::primitive::i32, ::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::factories::SerializeStreamError>>)), crate::errors::factories::SerializeError>> {
        self._serialize_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

#[derive(Clone)]
pub struct make_Factories;

/// To be called by user directly setting up a client. Avoids
/// needing ClientFactory trait in scope, avoids unidiomatic
/// make_Trait name.
///
/// ```
/// # const _: &str = stringify! {
/// use bgs::client::BuckGraphService;
///
/// let protocol = BinaryProtocol::new();
/// let transport = HttpClient::new();
/// let client = <dyn BuckGraphService>::new(protocol, transport);
/// # };
/// ```
impl dyn Factories {
    pub fn new<P, T>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl Factories + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, T, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl Factories + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(FactoriesImpl::<P, T, S>::new(transport))
    }
}

impl<T> dyn FactoriesExt<T>
where
    T: ::fbthrift::Transport,
{
    pub fn new<P>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl FactoriesExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl FactoriesExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(FactoriesImpl::<P, T, S>::new(transport))
    }
}

pub type FactoriesDynClient = <make_Factories as ::fbthrift::ClientFactory>::Api;
pub type FactoriesClient = ::std::sync::Arc<FactoriesDynClient>;

/// The same thing, but to be called from generic contexts where we are
/// working with a type parameter `C: ClientFactory` to produce clients.
impl ::fbthrift::ClientFactory for make_Factories {
    type Api = dyn Factories + ::std::marker::Send + ::std::marker::Sync + 'static;

    fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        <dyn Factories>::with_spawner(protocol, transport, spawner)
    }
}

pub trait Perform: ::std::marker::Send {
    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error>;

    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error>;

    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error>;

    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>>;
}

pub trait PerformExt<T>: Perform
where
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> Perform for S
where
    S: ::std::convert::AsRef<dyn Perform + 'a>,
    S: ::std::marker::Send,
{
    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        self.as_ref().createMyInteraction()
    }
    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error> {
        self.as_ref().createMyInteractionFast()
    }
    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error> {
        self.as_ref().createSerialInteraction()
    }
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>> {
        self.as_ref().foo(
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> PerformExt<T> for S
where
    S: ::std::convert::AsRef<dyn Perform + 'a> + ::std::convert::AsRef<dyn PerformExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>> {
        <Self as ::std::convert::AsRef<dyn PerformExt<T>>>::as_ref(self).foo_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `Perform`.
pub struct PerformImpl<P, T, S = ::fbthrift::NoopSpawner> {
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}


impl<P, T, S> PerformImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
    ) -> Self {
        Self {
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }

    const NAMES_MyInteraction: crate::client::MyInteractionNames = crate::client::MyInteractionNames {
        service: c"Perform",
        method_frobnicate: c"Perform.MyInteraction.frobnicate",
        method_ping: c"Perform.MyInteraction.ping",
        method_truthify: c"Perform.MyInteraction.truthify",
        method_encode: c"Perform.MyInteraction.encode",
    };
    const NAMES_MyInteractionFast: crate::client::MyInteractionFastNames = crate::client::MyInteractionFastNames {
        service: c"Perform",
        method_frobnicate: c"Perform.MyInteractionFast.frobnicate",
        method_ping: c"Perform.MyInteractionFast.ping",
        method_truthify: c"Perform.MyInteractionFast.truthify",
        method_encode: c"Perform.MyInteractionFast.encode",
    };
    const NAMES_SerialInteraction: crate::client::SerialInteractionNames = crate::client::SerialInteractionNames {
        service: c"Perform",
        method_frobnicate: c"Perform.SerialInteraction.frobnicate",
    };


    fn _foo_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"Perform";
        let service_method_name = c"Perform.foo";

        let args = self::Args_Perform_foo {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("foo", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "Perform.foo"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::perform::FooReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::perform::FooError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "Perform.foo"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for PerformImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_Perform_foo<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_Perform_foo<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "Perform.foo"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> Perform for PerformImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{

    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::MyInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"MyInteraction")?,
                    &Self::NAMES_MyInteraction,
                )
            )
        )
    }

    fn createMyInteractionFast(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionFastClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::MyInteractionFastImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"MyInteractionFast")?,
                    &Self::NAMES_MyInteractionFast,
                )
            )
        )
    }

    fn createSerialInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SerialInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::SerialInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"SerialInteraction")?,
                    &Self::NAMES_SerialInteraction,
                )
            )
        )
    }
    fn foo(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>> {
        let rpc_options = T::RpcOptions::default();
        self._foo_impl(
            rpc_options,
        )
    }
}

impl<P, T, S> PerformExt<T> for PerformImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn foo_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::perform::FooError>> {
        self._foo_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

#[derive(Clone)]
pub struct make_Perform;

/// To be called by user directly setting up a client. Avoids
/// needing ClientFactory trait in scope, avoids unidiomatic
/// make_Trait name.
///
/// ```
/// # const _: &str = stringify! {
/// use bgs::client::BuckGraphService;
///
/// let protocol = BinaryProtocol::new();
/// let transport = HttpClient::new();
/// let client = <dyn BuckGraphService>::new(protocol, transport);
/// # };
/// ```
impl dyn Perform {
    pub fn new<P, T>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl Perform + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, T, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl Perform + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(PerformImpl::<P, T, S>::new(transport))
    }
}

impl<T> dyn PerformExt<T>
where
    T: ::fbthrift::Transport,
{
    pub fn new<P>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl PerformExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl PerformExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(PerformImpl::<P, T, S>::new(transport))
    }
}

pub type PerformDynClient = <make_Perform as ::fbthrift::ClientFactory>::Api;
pub type PerformClient = ::std::sync::Arc<PerformDynClient>;

/// The same thing, but to be called from generic contexts where we are
/// working with a type parameter `C: ClientFactory` to produce clients.
impl ::fbthrift::ClientFactory for make_Perform {
    type Api = dyn Perform + ::std::marker::Send + ::std::marker::Sync + 'static;

    fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        <dyn Perform>::with_spawner(protocol, transport, spawner)
    }
}

pub trait InteractWithShared: ::std::marker::Send {
    fn do_some_similar_things(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>>;

    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error>;

    fn createshared.SharedInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SharedInteractionClient, ::anyhow::Error>;
}

pub trait InteractWithSharedExt<T>: InteractWithShared
where
    T: ::fbthrift::Transport,
{
    fn do_some_similar_things_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> InteractWithShared for S
where
    S: ::std::convert::AsRef<dyn InteractWithShared + 'a>,
    S: ::std::marker::Send,
{
    fn do_some_similar_things(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>> {
        self.as_ref().do_some_similar_things(
        )
    }
    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        self.as_ref().createMyInteraction()
    }
    fn createshared.SharedInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SharedInteractionClient, ::anyhow::Error> {
        self.as_ref().createshared.SharedInteraction()
    }
}

#[allow(deprecated)]
impl<'a, S, T> InteractWithSharedExt<T> for S
where
    S: ::std::convert::AsRef<dyn InteractWithShared + 'a> + ::std::convert::AsRef<dyn InteractWithSharedExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn do_some_similar_things_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>> {
        <Self as ::std::convert::AsRef<dyn InteractWithSharedExt<T>>>::as_ref(self).do_some_similar_things_with_rpc_opts(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `InteractWithShared`.
pub struct InteractWithSharedImpl<P, T, S = ::fbthrift::NoopSpawner> {
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}


impl<P, T, S> InteractWithSharedImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
    ) -> Self {
        Self {
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }

    const NAMES_MyInteraction: crate::client::MyInteractionNames = crate::client::MyInteractionNames {
        service: c"InteractWithShared",
        method_frobnicate: c"InteractWithShared.MyInteraction.frobnicate",
        method_ping: c"InteractWithShared.MyInteraction.ping",
        method_truthify: c"InteractWithShared.MyInteraction.truthify",
        method_encode: c"InteractWithShared.MyInteraction.encode",
    };
    const NAMES_SharedInteraction: shared__clients::SharedInteractionNames = shared__clients::SharedInteractionNames {
        service: c"InteractWithShared",
        method_init: c"InteractWithShared.SharedInteraction.init",
        method_do_something: c"InteractWithShared.SharedInteraction.do_something",
        method_tear_down: c"InteractWithShared.SharedInteraction.tear_down",
    };


    fn _do_some_similar_things_impl(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"InteractWithShared";
        let service_method_name = c"InteractWithShared.do_some_similar_things";

        let args = self::Args_InteractWithShared_do_some_similar_things {
            _phantom: ::std::marker::PhantomData,
        };

        let transport = self.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("do_some_similar_things", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "InteractWithShared.do_some_similar_things"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::interact_with_shared::DoSomeSimilarThingsReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::interact_with_shared::DoSomeSimilarThingsError::ApplicationException(aexn))
                }
            };
            res
        }
        .instrument(::tracing::info_span!("stream", method = "InteractWithShared.do_some_similar_things"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for InteractWithSharedImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_InteractWithShared_do_some_similar_things<'a> {
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_InteractWithShared_do_some_similar_things<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "InteractWithShared.do_some_similar_things"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> InteractWithShared for InteractWithSharedImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn do_some_similar_things(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>> {
        let rpc_options = T::RpcOptions::default();
        self._do_some_similar_things_impl(
            rpc_options,
        )
    }

    fn createMyInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::MyInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::MyInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"MyInteraction")?,
                    &Self::NAMES_MyInteraction,
                )
            )
        )
    }

    fn createshared.SharedInteraction(
        &self,
    ) -> ::std::result::Result<crate::client::SharedInteractionClient, ::anyhow::Error> {
        ::std::result::Result::Ok(
            ::std::sync::Arc::new(
                crate::client::SharedInteractionImpl::<P, T, S>::new(
                    self.transport().create_interaction(c"SharedInteraction")?,
                    &Self::NAMES_SharedInteraction,
                )
            )
        )
    }
}

impl<P, T, S> InteractWithSharedExt<T> for InteractWithSharedImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn do_some_similar_things_with_rpc_opts(
        &self,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<shared__types::DoSomethingResult, crate::errors::interact_with_shared::DoSomeSimilarThingsError>> {
        self._do_some_similar_things_impl(
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

#[derive(Clone)]
pub struct make_InteractWithShared;

/// To be called by user directly setting up a client. Avoids
/// needing ClientFactory trait in scope, avoids unidiomatic
/// make_Trait name.
///
/// ```
/// # const _: &str = stringify! {
/// use bgs::client::BuckGraphService;
///
/// let protocol = BinaryProtocol::new();
/// let transport = HttpClient::new();
/// let client = <dyn BuckGraphService>::new(protocol, transport);
/// # };
/// ```
impl dyn InteractWithShared {
    pub fn new<P, T>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl InteractWithShared + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, T, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl InteractWithShared + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(InteractWithSharedImpl::<P, T, S>::new(transport))
    }
}

impl<T> dyn InteractWithSharedExt<T>
where
    T: ::fbthrift::Transport,
{
    pub fn new<P>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl InteractWithSharedExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl InteractWithSharedExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(InteractWithSharedImpl::<P, T, S>::new(transport))
    }
}

pub type InteractWithSharedDynClient = <make_InteractWithShared as ::fbthrift::ClientFactory>::Api;
pub type InteractWithSharedClient = ::std::sync::Arc<InteractWithSharedDynClient>;

/// The same thing, but to be called from generic contexts where we are
/// working with a type parameter `C: ClientFactory` to produce clients.
impl ::fbthrift::ClientFactory for make_InteractWithShared {
    type Api = dyn InteractWithShared + ::std::marker::Send + ::std::marker::Sync + 'static;

    fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        <dyn InteractWithShared>::with_spawner(protocol, transport, spawner)
    }
}

pub trait BoxService: ::std::marker::Send {
    fn getABoxSession(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>>;
}

pub trait BoxServiceExt<T>: BoxService
where
    T: ::fbthrift::Transport,
{
    fn getABoxSession_with_rpc_opts(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>>;

    fn transport(&self) -> &T;
}

#[allow(deprecated)]
impl<'a, S> BoxService for S
where
    S: ::std::convert::AsRef<dyn BoxService + 'a>,
    S: ::std::marker::Send,
{
    fn getABoxSession(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>> {
        self.as_ref().getABoxSession(
            arg_req,
        )
    }
}

#[allow(deprecated)]
impl<'a, S, T> BoxServiceExt<T> for S
where
    S: ::std::convert::AsRef<dyn BoxService + 'a> + ::std::convert::AsRef<dyn BoxServiceExt<T> + 'a>,
    S: ::std::marker::Send + ::fbthrift::help::GetTransport<T>,
    T: ::fbthrift::Transport,
{
    fn getABoxSession_with_rpc_opts(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>> {
        <Self as ::std::convert::AsRef<dyn BoxServiceExt<T>>>::as_ref(self).getABoxSession_with_rpc_opts(
            arg_req,
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}
/// Client definitions for `BoxService`.
pub struct BoxServiceImpl<P, T, S = ::fbthrift::NoopSpawner> {
    transport: T,
    _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
}


impl<P, T, S> BoxServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    pub fn new(
        transport: T,
    ) -> Self {
        Self {
            transport,
            _phantom: ::std::marker::PhantomData,
        }
    }

    pub fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }

    const NAMES_BoxedInteraction: crate::client::BoxedInteractionNames = crate::client::BoxedInteractionNames {
        service: c"BoxService",
        method_getABox: c"BoxService.BoxedInteraction.getABox",
    };


    fn _getABoxSession_impl(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>> {
        use ::tracing::Instrument as _;
        use ::futures::FutureExt as _;

        let service_name = c"BoxService";
        let service_method_name = c"BoxService.getABoxSession";

        const INTERACTION_NAME: &::std::ffi::CStr = c"BoxedInteraction";
        let args = self::Args_BoxService_getABoxSession {
            req: arg_req,
            _phantom: ::std::marker::PhantomData,
        };

        let interaction_transport = match self.transport().create_interaction(INTERACTION_NAME) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };
        let interaction_impl = crate::BoxedInteractionImpl::<P, T, S>::new(interaction_transport, &Self::NAMES_BoxedInteraction);
        let transport = interaction_impl.transport();

        // need to do call setup outside of async block because T: Transport isn't Send
        let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("getABoxSession", &args) {
            ::std::result::Result::Ok(res) => res,
            ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
        };

        let call = transport
            .call(service_name, service_method_name, request_env, rpc_options)
            .instrument(::tracing::trace_span!("call", method = "BoxService.getABoxSession"));

        async move {
            let reply_env = call.await?;

            let de = P::deserializer(reply_env);
            let res = ::fbthrift::help::async_deserialize_response_envelope::<P, crate::errors::box_service::GetABoxSessionReader, S>(de).await?;

            let res = match res {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(aexn) => {
                    ::std::result::Result::Err(crate::errors::box_service::GetABoxSessionError::ApplicationException(aexn))
                }
            };
            let interaction_client: crate::client::BoxedInteractionClient = ::std::sync::Arc::new(interaction_impl);
            ::std::result::Result::Ok((interaction_client, res?))
        }
        .instrument(::tracing::info_span!("stream", method = "BoxService.getABoxSession"))
        .boxed()
    }
}

impl<P, T, S> ::fbthrift::help::GetTransport<T> for BoxServiceImpl<P, T, S>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        &self.transport
    }
}



struct Args_BoxService_getABoxSession<'a> {
    req: &'a crate::types::ShouldBeBoxed,
    _phantom: ::std::marker::PhantomData<&'a ()>,
}

impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_BoxService_getABoxSession<'a> {
    #[inline]
    #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "BoxService.getABoxSession"))]
    fn rs_thrift_write(&self, p: &mut P) {
        p.write_struct_begin("args");
        p.write_field_begin("req", ::fbthrift::TType::Struct, 1i16);
        ::fbthrift::Serialize::rs_thrift_write(&self.req, p);
        p.write_field_end();
        p.write_field_stop();
        p.write_struct_end();
    }
}

impl<P, T, S> BoxService for BoxServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn getABoxSession(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>> {
        let rpc_options = T::RpcOptions::default();
        self._getABoxSession_impl(
            arg_req,
            rpc_options,
        )
    }
}

impl<P, T, S> BoxServiceExt<T> for BoxServiceImpl<P, T, S>
where
    P: ::fbthrift::Protocol,
    T: ::fbthrift::Transport,
    P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
    ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
    P::Deserializer: ::std::marker::Send,
    S: ::fbthrift::help::Spawner,
{
    fn getABoxSession_with_rpc_opts(
        &self,
        arg_req: &crate::types::ShouldBeBoxed,
        rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(crate::client::BoxedInteractionClient, crate::types::ShouldBeBoxed), crate::errors::box_service::GetABoxSessionError>> {
        self._getABoxSession_impl(
            arg_req,
            rpc_options,
        )
    }

    fn transport(&self) -> &T {
        self.transport()
    }
}

#[derive(Clone)]
pub struct make_BoxService;

/// To be called by user directly setting up a client. Avoids
/// needing ClientFactory trait in scope, avoids unidiomatic
/// make_Trait name.
///
/// ```
/// # const _: &str = stringify! {
/// use bgs::client::BuckGraphService;
///
/// let protocol = BinaryProtocol::new();
/// let transport = HttpClient::new();
/// let client = <dyn BuckGraphService>::new(protocol, transport);
/// # };
/// ```
impl dyn BoxService {
    pub fn new<P, T>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl BoxService + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, T, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl BoxService + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(BoxServiceImpl::<P, T, S>::new(transport))
    }
}

impl<T> dyn BoxServiceExt<T>
where
    T: ::fbthrift::Transport,
{
    pub fn new<P>(
        protocol: P,
        transport: T,
    ) -> ::std::sync::Arc<impl BoxServiceExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
    {
        let spawner = ::fbthrift::help::NoopSpawner;
        Self::with_spawner(protocol, transport, spawner)
    }

    pub fn with_spawner<P, S>(
        protocol: P,
        transport: T,
        spawner: S,
    ) -> ::std::sync::Arc<impl BoxServiceExt<T> + ::std::marker::Send + ::std::marker::Sync + 'static>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        let _ = protocol;
        let _ = spawner;
        ::std::sync::Arc::new(BoxServiceImpl::<P, T, S>::new(transport))
    }
}

pub type BoxServiceDynClient = <make_BoxService as ::fbthrift::ClientFactory>::Api;
pub type BoxServiceClient = ::std::sync::Arc<BoxServiceDynClient>;

/// The same thing, but to be called from generic contexts where we are
/// working with a type parameter `C: ClientFactory` to produce clients.
impl ::fbthrift::ClientFactory for make_BoxService {
    type Api = dyn BoxService + ::std::marker::Send + ::std::marker::Sync + 'static;

    fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
    where
        P: ::fbthrift::Protocol<Frame = T>,
        T: ::fbthrift::Transport,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        <dyn BoxService>::with_spawner(protocol, transport, spawner)
    }
}

