// Autogenerated by Thrift for thrift/compiler/test/fixtures/interactions/src/module.thrift
//
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
//  @generated

package module

import (
    "context"
    "errors"
    "fmt"
    "io"
    "reflect"
    "sync"

    shared "shared"
    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift/types"
    metadata "github.com/facebook/fbthrift/thrift/lib/thrift/metadata"
)

// (needed to ensure safety because of naive import list construction)
var _ = shared.GoUnusedProtection__
var _ = context.Background
var _ = errors.New
var _ = fmt.Printf
var _ = io.EOF
var _ = reflect.Ptr
var _ = sync.OnceFunc
var _ = thrift.VOID
var _ = metadata.GoUnusedProtection__

type MyInteraction interface {
    Frobnicate(ctx context.Context) (int32, error)
    Ping(ctx context.Context) (error)
    Truthify(ctx context.Context) (func(context.Context, chan<- bool) error, error)
}

type MyInteractionClient interface {
    io.Closer
    Frobnicate(ctx context.Context) (int32, error)
    Ping(ctx context.Context) (error)
    Truthify(ctx context.Context) (<-chan bool /* elem stream */, <-chan error /* stream err */, error)
}

type myInteractionClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyInteractionClient = (*myInteractionClientImpl)(nil)

func NewMyInteractionChannelClient(channel thrift.RequestChannel) MyInteractionClient {
    return &myInteractionClientImpl{
        ch: channel,
    }
}

func (c *myInteractionClientImpl) Close() error {
    return c.ch.Close()
}

func (c *myInteractionClientImpl) Frobnicate(ctx context.Context) (int32, error) {
    fbthriftReq := &reqMyInteractionFrobnicate{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespMyInteractionFrobnicate()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "MyInteraction.frobnicate",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return 0, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return 0, fbthriftEx
    }
    return fbthriftResp.GetSuccess(), nil
}

func (c *myInteractionClientImpl) Ping(ctx context.Context) (error) {
    fbthriftReq := &reqMyInteractionPing{
    }
    return c.ch.SendRequestNoResponse(ctx, "MyInteraction.ping", fbthriftReq)
}

func (c *myInteractionClientImpl) Truthify(ctx context.Context) (<-chan bool /* elem stream */, <-chan error /* stream err */, error) {
    // Must be a cancellable context to prevent goroutine leaks
    if ctx.Done() == nil {
		return nil, nil, errors.New("context does not support cancellation")
	}
    fbthriftStreamCtx, fbthriftStreamCancel := context.WithCancel(ctx)

    fbthriftReq := &reqMyInteractionTruthify{
    }
    fbthriftResp := newRespMyInteractionTruthify()

    fbthriftChannel := c.ch

    fbthriftErrChan := make(chan error, 1)
    fbthriftElemChan := make(chan bool, thrift.DefaultStreamBufferSize)

    fbthriftOnStreamNextFn := func(d thrift.Decoder) error {
        fbthriftStreamValue := newStreamMyInteractionTruthify()
        fbthriftSpecErr := fbthriftStreamValue.Read(d)
        if fbthriftSpecErr != nil {
            return fbthriftSpecErr
        } else if fbthriftStreamEx := fbthriftStreamValue.Exception(); fbthriftStreamEx != nil {
            return fbthriftStreamEx
        }
        fbthriftElemChan <- fbthriftStreamValue.GetSuccess()
        return nil
    }
    fbthriftOnStreamErrorFn := func(err error) {
        fbthriftErrChan <- err
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }
    fbthriftOnStreamCompleteFn := func() {
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }

    fbthriftErr := fbthriftChannel.SendRequestStream(
        fbthriftStreamCtx,
        "MyInteraction.truthify",
        fbthriftReq,
        fbthriftResp,
        fbthriftOnStreamNextFn,
        fbthriftOnStreamErrorFn,
        fbthriftOnStreamCompleteFn,
    )
    if fbthriftErr != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftEx
    }
    return fbthriftElemChan, fbthriftErrChan, nil
}


type MyInteractionProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              MyInteraction
}

func NewMyInteractionProcessor(handler MyInteraction) *MyInteractionProcessor {
    p := &MyInteractionProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("MyInteraction.frobnicate", &procFuncMyInteractionFrobnicate{handler: handler})
    p.AddToProcessorFunctionMap("MyInteraction.ping", &procFuncMyInteractionPing{handler: handler})
    p.AddToProcessorFunctionMap("MyInteraction.truthify", &procFuncMyInteractionTruthify{handler: handler})
    p.AddToFunctionServiceMap("MyInteraction.frobnicate", "MyInteraction")
    p.AddToFunctionServiceMap("MyInteraction.ping", "MyInteraction")
    p.AddToFunctionServiceMap("MyInteraction.truthify", "MyInteraction")

    return p
}

func (p *MyInteractionProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *MyInteractionProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyInteractionProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *MyInteractionProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *MyInteractionProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyInteractionProcessor) PackageName() string {
    return "module"
}

func (p *MyInteractionProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyInteraction")
}


type procFuncMyInteractionFrobnicate struct {
    handler MyInteraction
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionFrobnicate)(nil)

func (p *procFuncMyInteractionFrobnicate) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionFrobnicate()
}

func (p *procFuncMyInteractionFrobnicate) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespMyInteractionFrobnicate()
    retval, err := p.handler.Frobnicate(ctx)
    if err != nil {
        switch v := err.(type) {
        case *CustomException:
            result.Ex = v
            return result, nil
        default:
            internalErr := fmt.Errorf("Internal error processing Frobnicate: %w", err)
            x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
            return x, internalErr
        }
    }

    result.Success = &retval
    return result, nil
}

type procFuncMyInteractionPing struct {
    handler MyInteraction
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionPing)(nil)

func (p *procFuncMyInteractionPing) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionPing()
}

func (p *procFuncMyInteractionPing) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    err := p.handler.Ping(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Ping: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return nil, nil
}

type procFuncMyInteractionTruthify struct {
    handler MyInteraction
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionTruthify)(nil)

func (p *procFuncMyInteractionTruthify) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionTruthify()
}

func (p *procFuncMyInteractionTruthify) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    return nil, errors.New("not supported")
}

func (p *procFuncMyInteractionTruthify) RunStreamContext(
    ctx context.Context,
    reqStruct thrift.ReadableStruct,
    onFirstResponse func(thrift.WritableStruct),
    onStreamNext func(thrift.WritableStruct),
    onStreamComplete func(),
) {
    firstResponse := newRespMyInteractionTruthify()
    elemProducerFunc, initialErr := p.handler.Truthify(ctx)
    if initialErr != nil {
        internalErr := fmt.Errorf("Internal error processing Truthify: %w", initialErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onFirstResponse(x)
        onStreamComplete()
        return
    }

    onFirstResponse(firstResponse)

    fbthriftElemChan := make(chan bool, thrift.DefaultStreamBufferSize)
    var senderWg sync.WaitGroup
    senderWg.Add(1)
    // Sender goroutine (receives elements on the channel and sends them out via onStreamNext)
    go func() {
        defer senderWg.Done()
        for elem := range fbthriftElemChan {
            streamWrapStruct := newStreamMyInteractionTruthify()
            streamWrapStruct.Success = &elem
            onStreamNext(streamWrapStruct)
        }
    }()

    streamErr := elemProducerFunc(ctx, fbthriftElemChan)
    // Stream is complete. Close the channel and wait for the sender goroutine to finish.
    close(fbthriftElemChan)
    senderWg.Wait()
    if streamErr != nil {
        internalErr := fmt.Errorf("Internal stream handler error Truthify: %w", streamErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onStreamNext(x)
    }
    onStreamComplete()
}

func (p *MyInteractionProcessor) OnTermination() {
    // If the underlying handler implements OnTermination()
    if terminable, ok := p.handler.(thrift.Terminable); ok {
        terminable.OnTermination()
    }
}

type MyInteractionFast interface {
    Frobnicate(ctx context.Context) (int32, error)
    Ping(ctx context.Context) (error)
    Truthify(ctx context.Context) (func(context.Context, chan<- bool) error, error)
}

type MyInteractionFastClient interface {
    io.Closer
    Frobnicate(ctx context.Context) (int32, error)
    Ping(ctx context.Context) (error)
    Truthify(ctx context.Context) (<-chan bool /* elem stream */, <-chan error /* stream err */, error)
}

type myInteractionFastClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyInteractionFastClient = (*myInteractionFastClientImpl)(nil)

func NewMyInteractionFastChannelClient(channel thrift.RequestChannel) MyInteractionFastClient {
    return &myInteractionFastClientImpl{
        ch: channel,
    }
}

func (c *myInteractionFastClientImpl) Close() error {
    return c.ch.Close()
}

func (c *myInteractionFastClientImpl) Frobnicate(ctx context.Context) (int32, error) {
    fbthriftReq := &reqMyInteractionFastFrobnicate{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespMyInteractionFastFrobnicate()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "MyInteractionFast.frobnicate",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return 0, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return 0, fbthriftEx
    }
    return fbthriftResp.GetSuccess(), nil
}

func (c *myInteractionFastClientImpl) Ping(ctx context.Context) (error) {
    fbthriftReq := &reqMyInteractionFastPing{
    }
    return c.ch.SendRequestNoResponse(ctx, "MyInteractionFast.ping", fbthriftReq)
}

func (c *myInteractionFastClientImpl) Truthify(ctx context.Context) (<-chan bool /* elem stream */, <-chan error /* stream err */, error) {
    // Must be a cancellable context to prevent goroutine leaks
    if ctx.Done() == nil {
		return nil, nil, errors.New("context does not support cancellation")
	}
    fbthriftStreamCtx, fbthriftStreamCancel := context.WithCancel(ctx)

    fbthriftReq := &reqMyInteractionFastTruthify{
    }
    fbthriftResp := newRespMyInteractionFastTruthify()

    fbthriftChannel := c.ch

    fbthriftErrChan := make(chan error, 1)
    fbthriftElemChan := make(chan bool, thrift.DefaultStreamBufferSize)

    fbthriftOnStreamNextFn := func(d thrift.Decoder) error {
        fbthriftStreamValue := newStreamMyInteractionFastTruthify()
        fbthriftSpecErr := fbthriftStreamValue.Read(d)
        if fbthriftSpecErr != nil {
            return fbthriftSpecErr
        } else if fbthriftStreamEx := fbthriftStreamValue.Exception(); fbthriftStreamEx != nil {
            return fbthriftStreamEx
        }
        fbthriftElemChan <- fbthriftStreamValue.GetSuccess()
        return nil
    }
    fbthriftOnStreamErrorFn := func(err error) {
        fbthriftErrChan <- err
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }
    fbthriftOnStreamCompleteFn := func() {
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }

    fbthriftErr := fbthriftChannel.SendRequestStream(
        fbthriftStreamCtx,
        "MyInteractionFast.truthify",
        fbthriftReq,
        fbthriftResp,
        fbthriftOnStreamNextFn,
        fbthriftOnStreamErrorFn,
        fbthriftOnStreamCompleteFn,
    )
    if fbthriftErr != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftEx
    }
    return fbthriftElemChan, fbthriftErrChan, nil
}


type MyInteractionFastProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              MyInteractionFast
}

func NewMyInteractionFastProcessor(handler MyInteractionFast) *MyInteractionFastProcessor {
    p := &MyInteractionFastProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("MyInteractionFast.frobnicate", &procFuncMyInteractionFastFrobnicate{handler: handler})
    p.AddToProcessorFunctionMap("MyInteractionFast.ping", &procFuncMyInteractionFastPing{handler: handler})
    p.AddToProcessorFunctionMap("MyInteractionFast.truthify", &procFuncMyInteractionFastTruthify{handler: handler})
    p.AddToFunctionServiceMap("MyInteractionFast.frobnicate", "MyInteractionFast")
    p.AddToFunctionServiceMap("MyInteractionFast.ping", "MyInteractionFast")
    p.AddToFunctionServiceMap("MyInteractionFast.truthify", "MyInteractionFast")

    return p
}

func (p *MyInteractionFastProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *MyInteractionFastProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyInteractionFastProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *MyInteractionFastProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *MyInteractionFastProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyInteractionFastProcessor) PackageName() string {
    return "module"
}

func (p *MyInteractionFastProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyInteractionFast")
}


type procFuncMyInteractionFastFrobnicate struct {
    handler MyInteractionFast
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionFastFrobnicate)(nil)

func (p *procFuncMyInteractionFastFrobnicate) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionFastFrobnicate()
}

func (p *procFuncMyInteractionFastFrobnicate) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespMyInteractionFastFrobnicate()
    retval, err := p.handler.Frobnicate(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Frobnicate: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    result.Success = &retval
    return result, nil
}

type procFuncMyInteractionFastPing struct {
    handler MyInteractionFast
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionFastPing)(nil)

func (p *procFuncMyInteractionFastPing) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionFastPing()
}

func (p *procFuncMyInteractionFastPing) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    err := p.handler.Ping(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Ping: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return nil, nil
}

type procFuncMyInteractionFastTruthify struct {
    handler MyInteractionFast
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyInteractionFastTruthify)(nil)

func (p *procFuncMyInteractionFastTruthify) NewReqArgs() thrift.ReadableStruct {
    return newReqMyInteractionFastTruthify()
}

func (p *procFuncMyInteractionFastTruthify) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    return nil, errors.New("not supported")
}

func (p *procFuncMyInteractionFastTruthify) RunStreamContext(
    ctx context.Context,
    reqStruct thrift.ReadableStruct,
    onFirstResponse func(thrift.WritableStruct),
    onStreamNext func(thrift.WritableStruct),
    onStreamComplete func(),
) {
    firstResponse := newRespMyInteractionFastTruthify()
    elemProducerFunc, initialErr := p.handler.Truthify(ctx)
    if initialErr != nil {
        internalErr := fmt.Errorf("Internal error processing Truthify: %w", initialErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onFirstResponse(x)
        onStreamComplete()
        return
    }

    onFirstResponse(firstResponse)

    fbthriftElemChan := make(chan bool, thrift.DefaultStreamBufferSize)
    var senderWg sync.WaitGroup
    senderWg.Add(1)
    // Sender goroutine (receives elements on the channel and sends them out via onStreamNext)
    go func() {
        defer senderWg.Done()
        for elem := range fbthriftElemChan {
            streamWrapStruct := newStreamMyInteractionFastTruthify()
            streamWrapStruct.Success = &elem
            onStreamNext(streamWrapStruct)
        }
    }()

    streamErr := elemProducerFunc(ctx, fbthriftElemChan)
    // Stream is complete. Close the channel and wait for the sender goroutine to finish.
    close(fbthriftElemChan)
    senderWg.Wait()
    if streamErr != nil {
        internalErr := fmt.Errorf("Internal stream handler error Truthify: %w", streamErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onStreamNext(x)
    }
    onStreamComplete()
}

func (p *MyInteractionFastProcessor) OnTermination() {
    // If the underlying handler implements OnTermination()
    if terminable, ok := p.handler.(thrift.Terminable); ok {
        terminable.OnTermination()
    }
}

type SerialInteraction interface {
    Frobnicate(ctx context.Context) (error)
}

type SerialInteractionClient interface {
    io.Closer
    Frobnicate(ctx context.Context) (error)
}

type serialInteractionClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ SerialInteractionClient = (*serialInteractionClientImpl)(nil)

func NewSerialInteractionChannelClient(channel thrift.RequestChannel) SerialInteractionClient {
    return &serialInteractionClientImpl{
        ch: channel,
    }
}

func (c *serialInteractionClientImpl) Close() error {
    return c.ch.Close()
}

func (c *serialInteractionClientImpl) Frobnicate(ctx context.Context) (error) {
    fbthriftReq := &reqSerialInteractionFrobnicate{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespSerialInteractionFrobnicate()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "SerialInteraction.frobnicate",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return fbthriftEx
    }
    return nil
}


type SerialInteractionProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              SerialInteraction
}

func NewSerialInteractionProcessor(handler SerialInteraction) *SerialInteractionProcessor {
    p := &SerialInteractionProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("SerialInteraction.frobnicate", &procFuncSerialInteractionFrobnicate{handler: handler})
    p.AddToFunctionServiceMap("SerialInteraction.frobnicate", "SerialInteraction")

    return p
}

func (p *SerialInteractionProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *SerialInteractionProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *SerialInteractionProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *SerialInteractionProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *SerialInteractionProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *SerialInteractionProcessor) PackageName() string {
    return "module"
}

func (p *SerialInteractionProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.SerialInteraction")
}


type procFuncSerialInteractionFrobnicate struct {
    handler SerialInteraction
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncSerialInteractionFrobnicate)(nil)

func (p *procFuncSerialInteractionFrobnicate) NewReqArgs() thrift.ReadableStruct {
    return newReqSerialInteractionFrobnicate()
}

func (p *procFuncSerialInteractionFrobnicate) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespSerialInteractionFrobnicate()
    err := p.handler.Frobnicate(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Frobnicate: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return result, nil
}

func (p *SerialInteractionProcessor) OnTermination() {
    // If the underlying handler implements OnTermination()
    if terminable, ok := p.handler.(thrift.Terminable); ok {
        terminable.OnTermination()
    }
}

type BoxedInteraction interface {
    GetABox(ctx context.Context) (*ShouldBeBoxed, error)
}

type BoxedInteractionClient interface {
    io.Closer
    GetABox(ctx context.Context) (*ShouldBeBoxed, error)
}

type boxedInteractionClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ BoxedInteractionClient = (*boxedInteractionClientImpl)(nil)

func NewBoxedInteractionChannelClient(channel thrift.RequestChannel) BoxedInteractionClient {
    return &boxedInteractionClientImpl{
        ch: channel,
    }
}

func (c *boxedInteractionClientImpl) Close() error {
    return c.ch.Close()
}

func (c *boxedInteractionClientImpl) GetABox(ctx context.Context) (*ShouldBeBoxed, error) {
    fbthriftReq := &reqBoxedInteractionGetABox{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespBoxedInteractionGetABox()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "BoxedInteraction.getABox",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, fbthriftEx
    }
    return fbthriftResp.GetSuccess(), nil
}


type BoxedInteractionProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              BoxedInteraction
}

func NewBoxedInteractionProcessor(handler BoxedInteraction) *BoxedInteractionProcessor {
    p := &BoxedInteractionProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("BoxedInteraction.getABox", &procFuncBoxedInteractionGetABox{handler: handler})
    p.AddToFunctionServiceMap("BoxedInteraction.getABox", "BoxedInteraction")

    return p
}

func (p *BoxedInteractionProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *BoxedInteractionProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *BoxedInteractionProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *BoxedInteractionProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *BoxedInteractionProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *BoxedInteractionProcessor) PackageName() string {
    return "module"
}

func (p *BoxedInteractionProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.BoxedInteraction")
}


type procFuncBoxedInteractionGetABox struct {
    handler BoxedInteraction
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncBoxedInteractionGetABox)(nil)

func (p *procFuncBoxedInteractionGetABox) NewReqArgs() thrift.ReadableStruct {
    return newReqBoxedInteractionGetABox()
}

func (p *procFuncBoxedInteractionGetABox) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespBoxedInteractionGetABox()
    retval, err := p.handler.GetABox(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing GetABox: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    result.Success = retval
    return result, nil
}

func (p *BoxedInteractionProcessor) OnTermination() {
    // If the underlying handler implements OnTermination()
    if terminable, ok := p.handler.(thrift.Terminable); ok {
        terminable.OnTermination()
    }
}


type MyService interface {
    Foo(ctx context.Context) (error)
    Interact(ctx context.Context, arg int32) (*MyInteractionProcessor, error)
    InteractFast(ctx context.Context) (*MyInteractionFastProcessor, int32, error)
    Serialize(ctx context.Context) (*SerialInteractionProcessor, int32, func(context.Context, chan<- int32) error, error)
}

type MyServiceClient interface {
    io.Closer
    Foo(ctx context.Context) (error)
    Interact(ctx context.Context, arg int32) (MyInteractionClient, error)
    InteractFast(ctx context.Context) (MyInteractionFastClient, int32, error)
    Serialize(ctx context.Context) (SerialInteractionClient, int32, <-chan int32 /* elem stream */, <-chan error /* stream err */, error)
}

type myServiceClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServiceClient = (*myServiceClientImpl)(nil)

func NewMyServiceChannelClient(channel thrift.RequestChannel) MyServiceClient {
    return &myServiceClientImpl{
        ch: channel,
    }
}

func (c *myServiceClientImpl) Close() error {
    return c.ch.Close()
}

func (c *myServiceClientImpl) Foo(ctx context.Context) (error) {
    fbthriftReq := &reqMyServiceFoo{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespMyServiceFoo()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "foo",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return fbthriftEx
    }
    return nil
}

func (c *myServiceClientImpl) Interact(ctx context.Context, arg int32) (MyInteractionClient, error) {
    fbthriftReq := &reqMyServiceInteract{
        Arg: arg,
    }
    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "MyInteraction")
    fbthriftInteractionClient := NewMyInteractionChannelClient(fbthriftChannel)
    fbthriftResp := newRespMyServiceInteract()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "interact",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, fbthriftEx
    }
    return fbthriftInteractionClient, nil
}

func (c *myServiceClientImpl) InteractFast(ctx context.Context) (MyInteractionFastClient, int32, error) {
    fbthriftReq := &reqMyServiceInteractFast{
    }
    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "MyInteractionFast")
    fbthriftInteractionClient := NewMyInteractionFastChannelClient(fbthriftChannel)
    fbthriftResp := newRespMyServiceInteractFast()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "interactFast",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, 0, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, 0, fbthriftEx
    }
    return fbthriftInteractionClient, fbthriftResp.GetSuccess(), nil
}

func (c *myServiceClientImpl) Serialize(ctx context.Context) (SerialInteractionClient, int32, <-chan int32 /* elem stream */, <-chan error /* stream err */, error) {
    var fbthriftRespZero int32
    // Must be a cancellable context to prevent goroutine leaks
    if ctx.Done() == nil {
		return nil, fbthriftRespZero, nil, nil, errors.New("context does not support cancellation")
	}
    fbthriftStreamCtx, fbthriftStreamCancel := context.WithCancel(ctx)

    fbthriftReq := &reqMyServiceSerialize{
    }
    fbthriftResp := newRespMyServiceSerialize()

    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "SerialInteraction")
    fbthriftInteractionClient := NewSerialInteractionChannelClient(fbthriftChannel)

    fbthriftErrChan := make(chan error, 1)
    fbthriftElemChan := make(chan int32, thrift.DefaultStreamBufferSize)

    fbthriftOnStreamNextFn := func(d thrift.Decoder) error {
        fbthriftStreamValue := newStreamMyServiceSerialize()
        fbthriftSpecErr := fbthriftStreamValue.Read(d)
        if fbthriftSpecErr != nil {
            return fbthriftSpecErr
        } else if fbthriftStreamEx := fbthriftStreamValue.Exception(); fbthriftStreamEx != nil {
            return fbthriftStreamEx
        }
        fbthriftElemChan <- fbthriftStreamValue.GetSuccess()
        return nil
    }
    fbthriftOnStreamErrorFn := func(err error) {
        fbthriftErrChan <- err
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }
    fbthriftOnStreamCompleteFn := func() {
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }

    fbthriftErr := fbthriftChannel.SendRequestStream(
        fbthriftStreamCtx,
        "serialize",
        fbthriftReq,
        fbthriftResp,
        fbthriftOnStreamNextFn,
        fbthriftOnStreamErrorFn,
        fbthriftOnStreamCompleteFn,
    )
    if fbthriftErr != nil {
        fbthriftStreamCancel()
        return nil, fbthriftRespZero, nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        fbthriftStreamCancel()
        return nil, fbthriftRespZero, nil, nil, fbthriftEx
    }
    return fbthriftInteractionClient, fbthriftResp.GetSuccess(), fbthriftElemChan, fbthriftErrChan, nil
}


type MyServiceProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              MyService
}

func NewMyServiceProcessor(handler MyService) *MyServiceProcessor {
    p := &MyServiceProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("foo", &procFuncMyServiceFoo{handler: handler})
    p.AddToProcessorFunctionMap("interact", &procFuncMyServiceInteract{handler: handler})
    p.AddToProcessorFunctionMap("interactFast", &procFuncMyServiceInteractFast{handler: handler})
    p.AddToProcessorFunctionMap("serialize", &procFuncMyServiceSerialize{handler: handler})
    p.AddToFunctionServiceMap("foo", "MyService")
    p.AddToFunctionServiceMap("interact", "MyService")
    p.AddToFunctionServiceMap("interactFast", "MyService")
    p.AddToFunctionServiceMap("serialize", "MyService")

    return p
}

func (p *MyServiceProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *MyServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *MyServiceProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *MyServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyServiceProcessor) PackageName() string {
    return "module"
}

func (p *MyServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyService")
}


type procFuncMyServiceFoo struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceFoo)(nil)

func (p *procFuncMyServiceFoo) NewReqArgs() thrift.ReadableStruct {
    return newReqMyServiceFoo()
}

func (p *procFuncMyServiceFoo) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespMyServiceFoo()
    err := p.handler.Foo(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Foo: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return result, nil
}

type procFuncMyServiceInteract struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceInteract)(nil)

func (p *procFuncMyServiceInteract) NewReqArgs() thrift.ReadableStruct {
    return newReqMyServiceInteract()
}

func (p *procFuncMyServiceInteract) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    args := reqStruct.(*reqMyServiceInteract)
    result := newRespMyServiceInteract()
    fbthriftInteraction, err := p.handler.Interact(ctx, args.Arg)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Interact: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    return result, nil
}

type procFuncMyServiceInteractFast struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceInteractFast)(nil)

func (p *procFuncMyServiceInteractFast) NewReqArgs() thrift.ReadableStruct {
    return newReqMyServiceInteractFast()
}

func (p *procFuncMyServiceInteractFast) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespMyServiceInteractFast()
    fbthriftInteraction, retval, err := p.handler.InteractFast(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing InteractFast: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    result.Success = &retval
    return result, nil
}

type procFuncMyServiceSerialize struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceSerialize)(nil)

func (p *procFuncMyServiceSerialize) NewReqArgs() thrift.ReadableStruct {
    return newReqMyServiceSerialize()
}

func (p *procFuncMyServiceSerialize) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    return nil, errors.New("not supported")
}

func (p *procFuncMyServiceSerialize) RunStreamContext(
    ctx context.Context,
    reqStruct thrift.ReadableStruct,
    onFirstResponse func(thrift.WritableStruct),
    onStreamNext func(thrift.WritableStruct),
    onStreamComplete func(),
) {
    firstResponse := newRespMyServiceSerialize()
    fbthriftInteraction, retval, elemProducerFunc, initialErr := p.handler.Serialize(ctx)
    if initialErr != nil {
        internalErr := fmt.Errorf("Internal error processing Serialize: %w", initialErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onFirstResponse(x)
        onStreamComplete()
        return
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    firstResponse.Success = &retval
    onFirstResponse(firstResponse)

    fbthriftElemChan := make(chan int32, thrift.DefaultStreamBufferSize)
    var senderWg sync.WaitGroup
    senderWg.Add(1)
    // Sender goroutine (receives elements on the channel and sends them out via onStreamNext)
    go func() {
        defer senderWg.Done()
        for elem := range fbthriftElemChan {
            streamWrapStruct := newStreamMyServiceSerialize()
            streamWrapStruct.Success = &elem
            onStreamNext(streamWrapStruct)
        }
    }()

    streamErr := elemProducerFunc(ctx, fbthriftElemChan)
    // Stream is complete. Close the channel and wait for the sender goroutine to finish.
    close(fbthriftElemChan)
    senderWg.Wait()
    if streamErr != nil {
        internalErr := fmt.Errorf("Internal stream handler error Serialize: %w", streamErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onStreamNext(x)
    }
    onStreamComplete()
}

type Factories interface {
    Foo(ctx context.Context) (error)
    Interact(ctx context.Context, arg int32) (*MyInteractionProcessor, error)
    InteractFast(ctx context.Context) (*MyInteractionFastProcessor, int32, error)
    Serialize(ctx context.Context) (*SerialInteractionProcessor, int32, func(context.Context, chan<- int32) error, error)
}

type FactoriesClient interface {
    io.Closer
    Foo(ctx context.Context) (error)
    Interact(ctx context.Context, arg int32) (MyInteractionClient, error)
    InteractFast(ctx context.Context) (MyInteractionFastClient, int32, error)
    Serialize(ctx context.Context) (SerialInteractionClient, int32, <-chan int32 /* elem stream */, <-chan error /* stream err */, error)
}

type factoriesClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ FactoriesClient = (*factoriesClientImpl)(nil)

func NewFactoriesChannelClient(channel thrift.RequestChannel) FactoriesClient {
    return &factoriesClientImpl{
        ch: channel,
    }
}

func (c *factoriesClientImpl) Close() error {
    return c.ch.Close()
}

func (c *factoriesClientImpl) Foo(ctx context.Context) (error) {
    fbthriftReq := &reqFactoriesFoo{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespFactoriesFoo()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "foo",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return fbthriftEx
    }
    return nil
}

func (c *factoriesClientImpl) Interact(ctx context.Context, arg int32) (MyInteractionClient, error) {
    fbthriftReq := &reqFactoriesInteract{
        Arg: arg,
    }
    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "MyInteraction")
    fbthriftInteractionClient := NewMyInteractionChannelClient(fbthriftChannel)
    fbthriftResp := newRespFactoriesInteract()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "interact",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, fbthriftEx
    }
    return fbthriftInteractionClient, nil
}

func (c *factoriesClientImpl) InteractFast(ctx context.Context) (MyInteractionFastClient, int32, error) {
    fbthriftReq := &reqFactoriesInteractFast{
    }
    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "MyInteractionFast")
    fbthriftInteractionClient := NewMyInteractionFastChannelClient(fbthriftChannel)
    fbthriftResp := newRespFactoriesInteractFast()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "interactFast",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, 0, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, 0, fbthriftEx
    }
    return fbthriftInteractionClient, fbthriftResp.GetSuccess(), nil
}

func (c *factoriesClientImpl) Serialize(ctx context.Context) (SerialInteractionClient, int32, <-chan int32 /* elem stream */, <-chan error /* stream err */, error) {
    var fbthriftRespZero int32
    // Must be a cancellable context to prevent goroutine leaks
    if ctx.Done() == nil {
		return nil, fbthriftRespZero, nil, nil, errors.New("context does not support cancellation")
	}
    fbthriftStreamCtx, fbthriftStreamCancel := context.WithCancel(ctx)

    fbthriftReq := &reqFactoriesSerialize{
    }
    fbthriftResp := newRespFactoriesSerialize()

    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "SerialInteraction")
    fbthriftInteractionClient := NewSerialInteractionChannelClient(fbthriftChannel)

    fbthriftErrChan := make(chan error, 1)
    fbthriftElemChan := make(chan int32, thrift.DefaultStreamBufferSize)

    fbthriftOnStreamNextFn := func(d thrift.Decoder) error {
        fbthriftStreamValue := newStreamFactoriesSerialize()
        fbthriftSpecErr := fbthriftStreamValue.Read(d)
        if fbthriftSpecErr != nil {
            return fbthriftSpecErr
        } else if fbthriftStreamEx := fbthriftStreamValue.Exception(); fbthriftStreamEx != nil {
            return fbthriftStreamEx
        }
        fbthriftElemChan <- fbthriftStreamValue.GetSuccess()
        return nil
    }
    fbthriftOnStreamErrorFn := func(err error) {
        fbthriftErrChan <- err
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }
    fbthriftOnStreamCompleteFn := func() {
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }

    fbthriftErr := fbthriftChannel.SendRequestStream(
        fbthriftStreamCtx,
        "serialize",
        fbthriftReq,
        fbthriftResp,
        fbthriftOnStreamNextFn,
        fbthriftOnStreamErrorFn,
        fbthriftOnStreamCompleteFn,
    )
    if fbthriftErr != nil {
        fbthriftStreamCancel()
        return nil, fbthriftRespZero, nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        fbthriftStreamCancel()
        return nil, fbthriftRespZero, nil, nil, fbthriftEx
    }
    return fbthriftInteractionClient, fbthriftResp.GetSuccess(), fbthriftElemChan, fbthriftErrChan, nil
}


type FactoriesProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              Factories
}

func NewFactoriesProcessor(handler Factories) *FactoriesProcessor {
    p := &FactoriesProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("foo", &procFuncFactoriesFoo{handler: handler})
    p.AddToProcessorFunctionMap("interact", &procFuncFactoriesInteract{handler: handler})
    p.AddToProcessorFunctionMap("interactFast", &procFuncFactoriesInteractFast{handler: handler})
    p.AddToProcessorFunctionMap("serialize", &procFuncFactoriesSerialize{handler: handler})
    p.AddToFunctionServiceMap("foo", "Factories")
    p.AddToFunctionServiceMap("interact", "Factories")
    p.AddToFunctionServiceMap("interactFast", "Factories")
    p.AddToFunctionServiceMap("serialize", "Factories")

    return p
}

func (p *FactoriesProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *FactoriesProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *FactoriesProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *FactoriesProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *FactoriesProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *FactoriesProcessor) PackageName() string {
    return "module"
}

func (p *FactoriesProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.Factories")
}


type procFuncFactoriesFoo struct {
    handler Factories
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFactoriesFoo)(nil)

func (p *procFuncFactoriesFoo) NewReqArgs() thrift.ReadableStruct {
    return newReqFactoriesFoo()
}

func (p *procFuncFactoriesFoo) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespFactoriesFoo()
    err := p.handler.Foo(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Foo: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return result, nil
}

type procFuncFactoriesInteract struct {
    handler Factories
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFactoriesInteract)(nil)

func (p *procFuncFactoriesInteract) NewReqArgs() thrift.ReadableStruct {
    return newReqFactoriesInteract()
}

func (p *procFuncFactoriesInteract) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    args := reqStruct.(*reqFactoriesInteract)
    result := newRespFactoriesInteract()
    fbthriftInteraction, err := p.handler.Interact(ctx, args.Arg)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Interact: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    return result, nil
}

type procFuncFactoriesInteractFast struct {
    handler Factories
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFactoriesInteractFast)(nil)

func (p *procFuncFactoriesInteractFast) NewReqArgs() thrift.ReadableStruct {
    return newReqFactoriesInteractFast()
}

func (p *procFuncFactoriesInteractFast) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespFactoriesInteractFast()
    fbthriftInteraction, retval, err := p.handler.InteractFast(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing InteractFast: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    result.Success = &retval
    return result, nil
}

type procFuncFactoriesSerialize struct {
    handler Factories
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFactoriesSerialize)(nil)

func (p *procFuncFactoriesSerialize) NewReqArgs() thrift.ReadableStruct {
    return newReqFactoriesSerialize()
}

func (p *procFuncFactoriesSerialize) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    return nil, errors.New("not supported")
}

func (p *procFuncFactoriesSerialize) RunStreamContext(
    ctx context.Context,
    reqStruct thrift.ReadableStruct,
    onFirstResponse func(thrift.WritableStruct),
    onStreamNext func(thrift.WritableStruct),
    onStreamComplete func(),
) {
    firstResponse := newRespFactoriesSerialize()
    fbthriftInteraction, retval, elemProducerFunc, initialErr := p.handler.Serialize(ctx)
    if initialErr != nil {
        internalErr := fmt.Errorf("Internal error processing Serialize: %w", initialErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onFirstResponse(x)
        onStreamComplete()
        return
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    firstResponse.Success = &retval
    onFirstResponse(firstResponse)

    fbthriftElemChan := make(chan int32, thrift.DefaultStreamBufferSize)
    var senderWg sync.WaitGroup
    senderWg.Add(1)
    // Sender goroutine (receives elements on the channel and sends them out via onStreamNext)
    go func() {
        defer senderWg.Done()
        for elem := range fbthriftElemChan {
            streamWrapStruct := newStreamFactoriesSerialize()
            streamWrapStruct.Success = &elem
            onStreamNext(streamWrapStruct)
        }
    }()

    streamErr := elemProducerFunc(ctx, fbthriftElemChan)
    // Stream is complete. Close the channel and wait for the sender goroutine to finish.
    close(fbthriftElemChan)
    senderWg.Wait()
    if streamErr != nil {
        internalErr := fmt.Errorf("Internal stream handler error Serialize: %w", streamErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onStreamNext(x)
    }
    onStreamComplete()
}

type Perform interface {
    Foo(ctx context.Context) (error)
}

type PerformClient interface {
    io.Closer
    Foo(ctx context.Context) (error)
}

type performClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ PerformClient = (*performClientImpl)(nil)

func NewPerformChannelClient(channel thrift.RequestChannel) PerformClient {
    return &performClientImpl{
        ch: channel,
    }
}

func (c *performClientImpl) Close() error {
    return c.ch.Close()
}

func (c *performClientImpl) Foo(ctx context.Context) (error) {
    fbthriftReq := &reqPerformFoo{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespPerformFoo()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "foo",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return fbthriftEx
    }
    return nil
}


type PerformProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              Perform
}

func NewPerformProcessor(handler Perform) *PerformProcessor {
    p := &PerformProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("foo", &procFuncPerformFoo{handler: handler})
    p.AddToFunctionServiceMap("foo", "Perform")

    return p
}

func (p *PerformProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *PerformProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *PerformProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *PerformProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *PerformProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *PerformProcessor) PackageName() string {
    return "module"
}

func (p *PerformProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.Perform")
}


type procFuncPerformFoo struct {
    handler Perform
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncPerformFoo)(nil)

func (p *procFuncPerformFoo) NewReqArgs() thrift.ReadableStruct {
    return newReqPerformFoo()
}

func (p *procFuncPerformFoo) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespPerformFoo()
    err := p.handler.Foo(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing Foo: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return result, nil
}

type InteractWithShared interface {
    DoSomeSimilarThings(ctx context.Context) (*shared.DoSomethingResult, error)
}

type InteractWithSharedClient interface {
    io.Closer
    DoSomeSimilarThings(ctx context.Context) (*shared.DoSomethingResult, error)
}

type interactWithSharedClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ InteractWithSharedClient = (*interactWithSharedClientImpl)(nil)

func NewInteractWithSharedChannelClient(channel thrift.RequestChannel) InteractWithSharedClient {
    return &interactWithSharedClientImpl{
        ch: channel,
    }
}

func (c *interactWithSharedClientImpl) Close() error {
    return c.ch.Close()
}

func (c *interactWithSharedClientImpl) DoSomeSimilarThings(ctx context.Context) (*shared.DoSomethingResult, error) {
    fbthriftReq := &reqInteractWithSharedDoSomeSimilarThings{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespInteractWithSharedDoSomeSimilarThings()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "do_some_similar_things",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, fbthriftEx
    }
    return fbthriftResp.GetSuccess(), nil
}


type InteractWithSharedProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              InteractWithShared
}

func NewInteractWithSharedProcessor(handler InteractWithShared) *InteractWithSharedProcessor {
    p := &InteractWithSharedProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("do_some_similar_things", &procFuncInteractWithSharedDoSomeSimilarThings{handler: handler})
    p.AddToFunctionServiceMap("do_some_similar_things", "InteractWithShared")

    return p
}

func (p *InteractWithSharedProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *InteractWithSharedProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *InteractWithSharedProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *InteractWithSharedProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *InteractWithSharedProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *InteractWithSharedProcessor) PackageName() string {
    return "module"
}

func (p *InteractWithSharedProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.InteractWithShared")
}


type procFuncInteractWithSharedDoSomeSimilarThings struct {
    handler InteractWithShared
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncInteractWithSharedDoSomeSimilarThings)(nil)

func (p *procFuncInteractWithSharedDoSomeSimilarThings) NewReqArgs() thrift.ReadableStruct {
    return newReqInteractWithSharedDoSomeSimilarThings()
}

func (p *procFuncInteractWithSharedDoSomeSimilarThings) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespInteractWithSharedDoSomeSimilarThings()
    retval, err := p.handler.DoSomeSimilarThings(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing DoSomeSimilarThings: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    result.Success = retval
    return result, nil
}

type BoxService interface {
    GetABoxSession(ctx context.Context, req *ShouldBeBoxed) (*BoxedInteractionProcessor, *ShouldBeBoxed, error)
}

type BoxServiceClient interface {
    io.Closer
    GetABoxSession(ctx context.Context, req *ShouldBeBoxed) (BoxedInteractionClient, *ShouldBeBoxed, error)
}

type boxServiceClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ BoxServiceClient = (*boxServiceClientImpl)(nil)

func NewBoxServiceChannelClient(channel thrift.RequestChannel) BoxServiceClient {
    return &boxServiceClientImpl{
        ch: channel,
    }
}

func (c *boxServiceClientImpl) Close() error {
    return c.ch.Close()
}

func (c *boxServiceClientImpl) GetABoxSession(ctx context.Context, req *ShouldBeBoxed) (BoxedInteractionClient, *ShouldBeBoxed, error) {
    fbthriftReq := &reqBoxServiceGetABoxSession{
        Req: req,
    }
    fbthriftChannel := thrift.NewInteractionChannel(c.ch, "BoxedInteraction")
    fbthriftInteractionClient := NewBoxedInteractionChannelClient(fbthriftChannel)
    fbthriftResp := newRespBoxServiceGetABoxSession()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "getABoxSession",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return nil, nil, fbthriftEx
    }
    return fbthriftInteractionClient, fbthriftResp.GetSuccess(), nil
}


type BoxServiceProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              BoxService
}

func NewBoxServiceProcessor(handler BoxService) *BoxServiceProcessor {
    p := &BoxServiceProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("getABoxSession", &procFuncBoxServiceGetABoxSession{handler: handler})
    p.AddToFunctionServiceMap("getABoxSession", "BoxService")

    return p
}

func (p *BoxServiceProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *BoxServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *BoxServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *BoxServiceProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *BoxServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *BoxServiceProcessor) PackageName() string {
    return "module"
}

func (p *BoxServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.BoxService")
}


type procFuncBoxServiceGetABoxSession struct {
    handler BoxService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncBoxServiceGetABoxSession)(nil)

func (p *procFuncBoxServiceGetABoxSession) NewReqArgs() thrift.ReadableStruct {
    return newReqBoxServiceGetABoxSession()
}

func (p *procFuncBoxServiceGetABoxSession) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    args := reqStruct.(*reqBoxServiceGetABoxSession)
    result := newRespBoxServiceGetABoxSession()
    fbthriftInteraction, retval, err := p.handler.GetABoxSession(ctx, args.Req)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing GetABoxSession: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    thrift.SetInteractionCreateProcessor(ctx, fbthriftInteraction)
    result.Success = retval
    return result, nil
}

