// @generated by Thrift for thrift/compiler/test/fixtures/bidi/src/module.thrift
// This file is probably not the place you want to edit!

//! Mock definitions for `module`.
//!
//! Client mocks. For every service, a struct TheService that implements
//! client::TheService.
//!
//! As an example of the generated API, for the following thrift service in
//! example.thrift:
//!
//! ```thrift
//! service MyService {
//!     FunctionResponse myFunction(
//!         1: FunctionRequest request,
//!     ) throws {
//!         1: StorageException s,
//!         2: NotFoundException n,
//!     ),
//!
//!     // other functions
//! }
//! ```
//!
//! we would end up with this mock object in an `example_mocks` crate:
//!
//! ```
//! # const _: &str = stringify! {
//! impl example_clients::MyService for MyService<'mock> {...}
//!
//! pub struct MyService<'mock> {
//!     pub myFunction: myFunction<'mock>,
//!     // ...
//! }
//!
//! impl myFunction<'mock> {
//!     // directly return the given success response
//!     pub fn ret(&self, value: FunctionResponse);
//!
//!     // invoke closure to compute success response
//!     pub fn mock(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> FunctionResponse + Send + Sync + 'mock,
//!     );
//!
//!     // invoke closure to compute response
//!     pub fn mock_result(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> Result<FunctionResponse, example_services::errors::MyFunctionExn> + Send + Sync + 'mock,
//!     );
//!
//!     // return one of the function's declared exceptions
//!     pub fn throw<E>(&self, exception: E)
//!     where
//!         E: Clone + Into<example_services::errors::MyFunctionExn> + Send + Sync + 'mock;
//! }
//! # };
//! ```
//!
//! The intended usage from a test would be:
//!
//! ```
//! # const _: &str = stringify! {
//! use std::sync::Arc;
//! use example_clients::MyService;
//!
//! #[tokio::test]
//! async fn test_my_client() {
//!     let mock = Arc::new(example_mocks::new::<dyn MyService>());
//!
//!     // directly return a success response
//!     let resp = FunctionResponse {...};
//!     mock.myFunction.ret(resp);
//!
//!     // or give a closure to compute the success response
//!     mock.myFunction.mock(|request| FunctionResponse {...});
//!
//!     // or throw one of the function's exceptions
//!     mock.myFunction.throw(StorageException::ItFailed);
//!
//!     // or compute a Result (useful if your exceptions aren't Clone)
//!     mock.myFunction.mock_result(|request| Err(...));
//!
//!     let out = do_the_thing(mock).await.unwrap();
//!     assert!(out.what_i_expected());
//! }
//!
//! async fn do_the_thing(
//!     client: Arc<dyn MyService + Send + Sync + 'static>,
//! ) -> Out {...}
//! # };
//! ```

#![recursion_limit = "100000000"]
#![allow(non_camel_case_types, non_snake_case, non_upper_case_globals, unused_crate_dependencies, unused_imports, clippy::all)]

pub(crate) use :: as types;
pub(crate) use :: as client;
pub(crate) use ::::errors;

pub fn new<'mock, Client>() -> Client::Mock<'mock>
where
    Client: ?::std::marker::Sized + DynClient,
{
    Client::mock()
}

pub trait DynClient {
    type Mock<'mock>;
    fn mock<'mock>() -> Self::Mock<'mock>;
}

pub struct BiDiService<'mock> {
    pub simple: r#impl::bi_di_service::simple<'mock>,
    pub response: r#impl::bi_di_service::response<'mock>,
    pub canThrow: r#impl::bi_di_service::canThrow<'mock>,
    _marker: ::std::marker::PhantomData<&'mock ()>,
}

impl crate::DynClient for dyn ::::BiDiService {
    type Mock<'mock> = BiDiService<'mock>;
    fn mock<'mock>() -> Self::Mock<'mock> {
        BiDiService {
            simple: r#impl::bi_di_service::simple::unimplemented(),
            response: r#impl::bi_di_service::response::unimplemented(),
            canThrow: r#impl::bi_di_service::canThrow::unimplemented(),
            _marker: ::std::marker::PhantomData,
        }
    }
}

impl<'mock> ::::BiDiService for BiDiService<'mock> {
    fn simple(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::SimpleError>> {
        let mut closure = self.simple.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn response(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::ResponseError>> {
        let mut closure = self.response.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn canThrow(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::CanThrowError>> {
        let mut closure = self.canThrow.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
}

impl<'mock, T> ::::BiDiServiceExt<T> for BiDiService<'mock>
where
    T: ::fbthrift::Transport,
{    fn simple_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::SimpleError>> {
        <Self as ::::BiDiService>::simple(
            self,
        )
    }
    fn response_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::ResponseError>> {
        <Self as ::::BiDiService>::response(
            self,
        )
    }
    fn canThrow_with_rpc_opts(
        &self,
        _rpc_options: T::RpcOptions,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>), crate::errors::bi_di_service::CanThrowError>> {
        <Self as ::::BiDiService>::canThrow(
            self,
        )
    }

    fn transport(&self) -> &T {
        ::fbthrift::help::GetTransport::transport(self)
    }
}

impl<'mock, T> ::fbthrift::help::GetTransport<T> for BiDiService<'mock>
where
    T: ::fbthrift::Transport,
{
    fn transport(&self) -> &T {
        unimplemented!("BiDiServiceExt::transport is not implemented for mock client")
    }
}

pub mod r#impl {
    pub mod bi_di_service {

        pub struct simple<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>),
                    ::::errors::bi_di_service::SimpleError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> simple<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "BiDiService",
                        "simple",
                    ))),
                }
            }

            pub fn ret(&self, __value: (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>)) {
                unimplemented!("Mocking bidirectional streams is not yet implemented, as value isn't cloneable");
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>) + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::SimpleStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::SimpleSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::SimpleSinkError>> + ::std::marker::Send>), ::::errors::bi_di_service::SimpleError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::bi_di_service::SimpleError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct response<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>),
                    ::::errors::bi_di_service::ResponseError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> response<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "BiDiService",
                        "response",
                    ))),
                }
            }

            pub fn ret(&self, __value: (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>)) {
                unimplemented!("Mocking bidirectional streams is not yet implemented, as value isn't cloneable");
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>) + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i16, crate::errors::bi_di_service::ResponseStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i32, crate::errors::bi_di_service::ResponseSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::ResponseSinkError>> + ::std::marker::Send>), ::::errors::bi_di_service::ResponseError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::bi_di_service::ResponseError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct canThrow<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>),
                    ::::errors::bi_di_service::CanThrowError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> canThrow<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "BiDiService",
                        "canThrow",
                    ))),
                }
            }

            pub fn ret(&self, __value: (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>)) {
                unimplemented!("Mocking bidirectional streams is not yet implemented, as value isn't cloneable");
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> (::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>) + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowStreamError>>, Box<dyn ::std::ops::FnOnce(::futures::stream::BoxStream<'static, ::std::result::Result<::std::primitive::i64, crate::errors::bi_di_service::CanThrowSinkError>>) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::bi_di_service::CanThrowSinkError>> + ::std::marker::Send>), ::::errors::bi_di_service::CanThrowError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<::::errors::bi_di_service::CanThrowError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }
    }
}
