<?hh
/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */

namespace facebook\thrift\annotation\cpp;

/**
 * Optional, defaults to Unique
 * 
 * Original thrift enum:-
 * RefType
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/RefType'))>>
enum RefType: int {
  Unique = 0;
  /**
   * `std::unique_ptr<T>`
   */
  Shared = 1;
  /**
   * `std::shared_ptr<const T> `
   */
  SharedMutable = 2;
}

class RefType_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "cpp.RefType",
        "elements" => dict[
          0 => "Unique",
          1 => "Shared",
          2 => "SharedMutable",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * Enum in C++ by default uses signed 32 bit integer. There is no need to specify
 * underlying type for signed 32 bit integer.
 * 64-bit is not supported to avoid truncation since enums are sent as 32-bit integers over the wire.
 * 
 * Original thrift enum:-
 * EnumUnderlyingType
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/EnumUnderlyingType'))>>
enum EnumUnderlyingType: int {
  /**
   * ::std::int8_t
   */
  I8 = 0;
  /**
   * ::std::uint8_t
   */
  U8 = 1;
  /**
   * ::std::int16_t
   */
  I16 = 2;
  /**
   * ::std::uint16_t
   */
  U16 = 3;
  /**
   * ::std::uint32_t
   */
  U32 = 4;
}

class EnumUnderlyingType_TEnumStaticMetadata implements \IThriftEnumStaticMetadata {
  public static function getEnumMetadata()[]: \tmeta_ThriftEnum {
    return \tmeta_ThriftEnum::fromShape(
      shape(
        "name" => "cpp.EnumUnderlyingType",
        "elements" => dict[
          0 => "I8",
          1 => "U8",
          2 => "I16",
          3 => "U16",
          4 => "U32",
        ],
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TEnumAnnotations {
    return shape(
      'enum' => dict[],
      'constants' => dict[
      ],
    );
  }
}

/**
 * Changes the name of the definition in generated C++ code.
 * In most cases a much better solution is to rename the problematic Thrift field itself. Only use the `@cpp.Name` annotation if such renaming is problematic,
 * e.g. when the field name appears in code as a string, particularly when using JSON serialization, and it is hard to change all usage sites.
 *
 * Original thrift struct:-
 * Name
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Name'))>>
class Name implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'value',
      'type' => \TType::STRING,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'value' => 1,
  ];

  const type TConstructorShape = shape(
    ?'value' => ?string,
  );

  const type TShape = shape(
    'value' => string,
  );
  const int STRUCTURAL_ID = 7890627744707884767;
  /**
   * Original thrift field:-
   * 1: string value
   */
  public string $value;

  public function __construct(?string $value = null)[] {
    $this->value = $value ?? '';
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'value'),
    );
  }

  public function getName()[]: string {
    return 'Name';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Name",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "value",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Definition' => \facebook\thrift\annotation\Definition::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['value'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'value' => $this->value,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'value') !== null) {
      $this->value = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['value']);
    }
  }

}

/**
 * Changes the native type of a Thrift object (the C++ type used in codegen) to the value of the `name` field.
 * Container types may instead provide the `template` field, in which case template parameters will be filled in by thrift.
 * (e.g. `template = "folly::sorted_vector_set"` is equivalent to `type = "folly::sorted_vector_set<T>"` on `set<T>`)
 * 
 * It is also possible to add `cpp_include` to bring in additional data structures and use them here.
 * It is required that the custom type matches the specified Thrift type even for internal container types.
 * Prefer types that can leverage `reserve(size_t)` as Thrift makes uses these optimizations.
 * *Special Case*: This annotation can be used to define a string/binary type as `IOBuf` or `unique_ptr<IOBuf>` so that you can leverage Thrift's support for zero-copy buffer manipulation through `IOBuf`.
 * During deserialization, thrift receives a buffer that is used to allocate the appropriate fields in the struct. When using smart pointers, instead of making a copy of the data, it only modifies the pointer to point to the address that is used by the buffer.
 * 
 * The custom type must provide the following methods
 * * `list`: `push_back(T)`
 * * `map`: `insert(std::pair<T1, T2>)`
 * * `set`: `insert(T)`
 *
 * Original thrift struct:-
 * Type
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Type'))>>
class Type implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'name',
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'template',
      'type' => \TType::STRING,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'name' => 1,
    'template' => 2,
  ];

  const type TConstructorShape = shape(
    ?'name' => ?string,
    ?'template' => ?string,
  );

  const type TShape = shape(
    'name' => string,
    'template' => string,
  );
  const int STRUCTURAL_ID = 1931557339649512761;
  /**
   * Original thrift field:-
   * 1: string name
   */
  public string $name;
  /**
   * Original thrift field:-
   * 2: string template
   */
  public string $template;

  public function __construct(?string $name = null, ?string $template = null)[] {
    $this->name = $name ?? '';
    $this->template = $template ?? '';
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'name'),
      Shapes::idx($shape, 'template'),
    );
  }

  public function getName()[]: string {
    return 'Type';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Type",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "name",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "template",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\FunctionParameter' => \facebook\thrift\annotation\FunctionParameter::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
        'template' => shape(
          'field' => dict[
            '\facebook\thrift\annotation\cpp\Name' => \facebook\thrift\annotation\cpp\Name::fromShape(
              shape(
                "value" => "template_",
              )
            ),
          ],
          'type' => dict[],
        ),
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['name'],
      $shape['template'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'name' => $this->name,
      'template' => $this->template,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'name') !== null) {
      $this->name = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['name']);
    }
    if (idx($parsed, 'template') !== null) {
      $this->template = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['template']);
    }
  }

}

/**
 * Allocates a field on the heap instead of inline.
 * This annotation is added to support recursive types. However, you can also use it to turn a field from a value to a smart pointer.
 * `@cpp.Ref` is equivalent having type`@cpp.RefType.Unique`.
 * 
 * NOTE: A struct may transitively contain itself as a field only if at least one of the fields in the inclusion chain is either an optional Ref field or a container. Otherwise the struct would have infinite size.
 *
 * Original thrift struct:-
 * Ref
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Ref'))>>
class Ref implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'type',
      'type' => \TType::I32,
      'enum' => \facebook\thrift\annotation\cpp\RefType::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'type' => 1,
  ];

  const type TConstructorShape = shape(
    ?'type' => ?\facebook\thrift\annotation\cpp\RefType,
  );

  const type TShape = shape(
    ?'type' => ?\facebook\thrift\annotation\cpp\RefType,
  );
  const int STRUCTURAL_ID = 9199455418205459382;
  /**
   * Original thrift field:-
   * 1: cpp.RefType type
   */
  public ?\facebook\thrift\annotation\cpp\RefType $type;

  public function __construct(?\facebook\thrift\annotation\cpp\RefType $type = null)[] {
    $this->type = $type;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'type'),
    );
  }

  public function getName()[]: string {
    return 'Ref';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Ref",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "cpp.RefType",
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'type'),
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'type' => $this->type,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'type') !== null) {
      $this->type = \facebook\thrift\annotation\cpp\RefType::coerce(HH\FIXME\UNSAFE_CAST<mixed, \facebook\thrift\annotation\cpp\RefType>($parsed['type']));
    }
  }

}

/**
 * Lazily deserialize large field on first access.
 * 
 * ```
 * FooWithLazyField foo;
 * apache::thrift::CompactSerializer::deserialize(serializedData, foo);
 * 
 * // large_field is lazy field, it will be deserialized on first access
 * // The data will be deserialized in method call large_field_ref()
 * LOG(INFO) << foo.large_field_ref()->size();
 * 
 * // Result will be cached, we won't deserialize again
 * LOG(INFO) << foo.large_field_ref()->size();
 * ```
 * 
 * Read more: /doc/fb/languages/cpp/lazy.md
 *
 * Original thrift struct:-
 * Lazy
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Lazy'))>>
class Lazy implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'ref',
      'type' => \TType::BOOL,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'ref' => 1,
  ];

  const type TConstructorShape = shape(
    ?'ref' => ?bool,
  );

  const type TShape = shape(
    'ref' => bool,
  );
  const int STRUCTURAL_ID = 8263607926442937418;
  /**
   * Original thrift field:-
   * 1: bool ref
   */
  public bool $ref;

  public function __construct(?bool $ref = null)[] {
    $this->ref = $ref ?? false;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'ref'),
    );
  }

  public function getName()[]: string {
    return 'Lazy';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Lazy",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BOOL_TYPE,
                )
              ),
              "name" => "ref",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['ref'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'ref' => $this->ref,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'ref') !== null) {
      $this->ref = HH\FIXME\UNSAFE_CAST<mixed, bool>($parsed['ref']);
    }
  }

}

/**
 * Original thrift struct:-
 * DisableLazyChecksum
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/DisableLazyChecksum'))>>
class DisableLazyChecksum implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'DisableLazyChecksum';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.DisableLazyChecksum",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Struct' => \facebook\thrift\annotation\Struct::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * An annotation that applies a C++ adapter to typedef, field, or struct.
 * 
 * For example:
 * 
 *   @cpp.Adapter{name = "::ns::IdAdapter"}
 *   typedef i64 MyI64;
 * 
 * Here the type `MyI64` has the C++ adapter `IdAdapter`.
 * 
 *   struct User {
 *     @cpp.Adapter{name = "::ns::IdAdapter"}
 *     1: i64 id;
 *   }
 * 
 * Here the field `id` has the C++ adapter `IdAdapter`.
 *
 * Original thrift struct:-
 * Adapter
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Adapter'))>>
class Adapter implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'name',
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'adaptedType',
      'type' => \TType::STRING,
    ),
    3 => shape(
      'var' => 'underlyingName',
      'type' => \TType::STRING,
    ),
    4 => shape(
      'var' => 'extraNamespace',
      'type' => \TType::STRING,
    ),
    5 => shape(
      'var' => 'moveOnly',
      'type' => \TType::BOOL,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'name' => 1,
    'adaptedType' => 2,
    'underlyingName' => 3,
    'extraNamespace' => 4,
    'moveOnly' => 5,
  ];

  const type TConstructorShape = shape(
    ?'name' => ?string,
    ?'adaptedType' => ?string,
    ?'underlyingName' => ?string,
    ?'extraNamespace' => ?string,
    ?'moveOnly' => ?bool,
  );

  const type TShape = shape(
    'name' => string,
    'adaptedType' => string,
    'underlyingName' => string,
    'extraNamespace' => string,
    'moveOnly' => bool,
  );
  const int STRUCTURAL_ID = 1598934288211608189;
  /**
   * The name of a C++ adapter type used to convert between Thrift and native
   * C++ representation.
   * 
   * The adapter can be either a Type or Field adapter, providing either of the following APIs:
   * 
   *     struct ThriftTypeAdapter {
   *       static AdaptedType fromThrift(ThriftType thrift);
   *       static {const ThriftType& | ThriftType} toThrift(const AdaptedType& native);
   *     };
   * 
   *     struct ThriftFieldAdapter {
   *       // Context is an instantiation of apache::thrift::FieldContext
   *       template <class Context>
   *       static void construct(AdaptedType& field, Context ctx);
   * 
   *       template <class Context>
   *       static AdaptedType fromThriftField(ThriftType value, Context ctx);
   * 
   *       template <class Context>
   *       static {const ThriftType& | ThriftType} toThrift(const AdaptedType& adapted, Context ctx);
   *     };
   * 
   * Original thrift field:-
   * 1: string name
   */
  public string $name;
  /**
   * It is sometimes necessary to specify AdaptedType here (in case the codegen would
   * have a circular depdenceny, which will cause the C++ build to fail).
   * 
   * Original thrift field:-
   * 2: string adaptedType
   */
  public string $adaptedType;
  /**
   * The name and/or extra namespace to use when directly adapting a type
   * (as opposed a typedef).
   * 
   * In this case, the IDL name of the type will refer to the adapted type in
   * C++ and the underlying thrift type will be generated in a nested
   * namespace and/or with a different name.
   * 
   * If neither `underlyingName` or `extraNamespace` is provided, the
   * underlying type will be generated in a nested 'detail' namespace with
   * the same name.
   * 
   * Original thrift field:-
   * 3: string underlyingName
   */
  public string $underlyingName;
  /**
   * Original thrift field:-
   * 4: string extraNamespace
   */
  public string $extraNamespace;
  /**
   * Must set to true when adapted type is not copyable.
   * 
   * Original thrift field:-
   * 5: bool moveOnly
   */
  public bool $moveOnly;

  public function __construct(?string $name = null, ?string $adaptedType = null, ?string $underlyingName = null, ?string $extraNamespace = null, ?bool $moveOnly = null)[] {
    $this->name = $name ?? '';
    $this->adaptedType = $adaptedType ?? '';
    $this->underlyingName = $underlyingName ?? '';
    $this->extraNamespace = $extraNamespace ?? '';
    $this->moveOnly = $moveOnly ?? false;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'name'),
      Shapes::idx($shape, 'adaptedType'),
      Shapes::idx($shape, 'underlyingName'),
      Shapes::idx($shape, 'extraNamespace'),
      Shapes::idx($shape, 'moveOnly'),
    );
  }

  public function getName()[]: string {
    return 'Adapter';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Adapter",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "name",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "adaptedType",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 3,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "underlyingName",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 4,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "extraNamespace",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 5,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BOOL_TYPE,
                )
              ),
              "name" => "moveOnly",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\TConst' => \facebook\thrift\annotation\TConst::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['name'],
      $shape['adaptedType'],
      $shape['underlyingName'],
      $shape['extraNamespace'],
      $shape['moveOnly'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'name' => $this->name,
      'adaptedType' => $this->adaptedType,
      'underlyingName' => $this->underlyingName,
      'extraNamespace' => $this->extraNamespace,
      'moveOnly' => $this->moveOnly,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'name') !== null) {
      $this->name = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['name']);
    }
    if (idx($parsed, 'adaptedType') !== null) {
      $this->adaptedType = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['adaptedType']);
    }
    if (idx($parsed, 'underlyingName') !== null) {
      $this->underlyingName = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['underlyingName']);
    }
    if (idx($parsed, 'extraNamespace') !== null) {
      $this->extraNamespace = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['extraNamespace']);
    }
    if (idx($parsed, 'moveOnly') !== null) {
      $this->moveOnly = HH\FIXME\UNSAFE_CAST<mixed, bool>($parsed['moveOnly']);
    }
  }

}

/**
 * Packs isset bits into fewer bytes to save space at the cost of making access more expensive.
 * Passing `atomic = false` reduces the access cost while making concurrent writes UB.
 * Read more: /doc/fb/languages/cpp/isset-bitpacking.md
 *
 * Original thrift struct:-
 * PackIsset
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/PackIsset'))>>
class PackIsset implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'atomic',
      'type' => \TType::BOOL,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'atomic' => 1,
  ];

  const type TConstructorShape = shape(
    ?'atomic' => ?bool,
  );

  const type TShape = shape(
    'atomic' => bool,
  );
  const int STRUCTURAL_ID = 246594944080831905;
  /**
   * Original thrift field:-
   * 1: bool atomic
   */
  public bool $atomic;

  public function __construct(?bool $atomic = null)[] {
    $this->atomic = $atomic ?? true;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'atomic'),
    );
  }

  public function getName()[]: string {
    return 'PackIsset';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.PackIsset",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BOOL_TYPE,
                )
              ),
              "name" => "atomic",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Struct' => \facebook\thrift\annotation\Struct::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['atomic'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'atomic' => $this->atomic,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'atomic') !== null) {
      $this->atomic = HH\FIXME\UNSAFE_CAST<mixed, bool>($parsed['atomic']);
    }
  }

}

/**
 * This annotation enables reordering of fields in the generated C++ struct to minimize padding.
 * This is achieved by placing the fields in the order of decreasing alignments. The order of fields with the same alignment is preserved.
 * 
 * ```
 * @cpp.MinimizePadding
 * struct Padded {
 *   1: byte small
 *   2: i64 big
 *   3: i16 medium
 *   4: i32 biggish
 *   5: byte tiny
 * }
 * ```
 * 
 * For example, the C++ fields for the `Padded` Thrift struct above will be generated in the following order:
 * 
 * ```
 * int64_t big;
 * int32_t biggish;
 * int16_t medium;
 * int8_t small;
 * int8_t tiny;
 * ```
 * 
 * which gives the size of 16 bytes compared to 32 bytes if `cpp.MinimizePadding` was not specified.
 *
 * Original thrift struct:-
 * MinimizePadding
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/MinimizePadding'))>>
class MinimizePadding implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'MinimizePadding';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.MinimizePadding",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Struct' => \facebook\thrift\annotation\Struct::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Exception' => \facebook\thrift\annotation\Exception::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Original thrift struct:-
 * ScopedEnumAsUnionType
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/ScopedEnumAsUnionType'))>>
class ScopedEnumAsUnionType implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'ScopedEnumAsUnionType';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.ScopedEnumAsUnionType",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Union' => \facebook\thrift\annotation\Union::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * An annotation that intercepts field access with C++ field interceptor.
 * Use with *caution* since this may introduce substantial performance overhead on each field access.
 * 
 * For example:
 * 
 *     struct Foo {
 *       @cpp.FieldInterceptor{name = "MyFieldInterceptor"}
 *       1: i64 id;
 *     }
 * 
 * The field interceptor `MyFieldInterceptor` will intercept with `interceptThriftFieldAccess`
 * when the field `id` is accessed.
 *
 * Original thrift struct:-
 * FieldInterceptor
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/FieldInterceptor'))>>
class FieldInterceptor implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'name',
      'type' => \TType::STRING,
    ),
    2 => shape(
      'var' => 'noinline',
      'type' => \TType::BOOL,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'name' => 1,
    'noinline' => 2,
  ];

  const type TConstructorShape = shape(
    ?'name' => ?string,
    ?'noinline' => ?bool,
  );

  const type TShape = shape(
    'name' => string,
    'noinline' => bool,
  );
  const int STRUCTURAL_ID = 3876858574008868465;
  /**
   * The name of a field interceptor.
   * 
   * The field interceptor provides the following API:
   * 
   *     struct ThriftFieldInterceptor {
   *       template <typename T, typename Struct, int16_t FieldId>
   *       static void interceptThriftFieldAccess(T&& field,
   *                                              apache::thrift::FieldContext<Struct, FieldId>&& ctx);
   *     };
   * 
   * The field interceptor intercepts with the field value and the field context.
   * It enforces an easily searchable function name `interceptThriftFieldAccess`.
   * 
   * Original thrift field:-
   * 1: string name
   */
  public string $name;
  /**
   * Setting to true makes compiler not inline and erase function signature for
   * the intercepting field accessor.
   * 
   * Original thrift field:-
   * 2: bool noinline
   */
  public bool $noinline;

  public function __construct(?string $name = null, ?bool $noinline = null)[] {
    $this->name = $name ?? '';
    $this->noinline = $noinline ?? false;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'name'),
      Shapes::idx($shape, 'noinline'),
    );
  }

  public function getName()[]: string {
    return 'FieldInterceptor';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.FieldInterceptor",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_STRING_TYPE,
                )
              ),
              "name" => "name",
            )
          ),
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 2,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_primitive" => \tmeta_ThriftPrimitiveType::THRIFT_BOOL_TYPE,
                )
              ),
              "name" => "noinline",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Experimental' => \facebook\thrift\annotation\Experimental::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      $shape['name'],
      $shape['noinline'],
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'name' => $this->name,
      'noinline' => $this->noinline,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'name') !== null) {
      $this->name = HH\FIXME\UNSAFE_CAST<mixed, string>($parsed['name']);
    }
    if (idx($parsed, 'noinline') !== null) {
      $this->noinline = HH\FIXME\UNSAFE_CAST<mixed, bool>($parsed['noinline']);
    }
  }

}

/**
 * Original thrift struct:-
 * UseOpEncode
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/UseOpEncode'))>>
class UseOpEncode implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'UseOpEncode';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.UseOpEncode",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Program' => \facebook\thrift\annotation\Program::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Indicates an integer type for C++ to use as the underlying type of enum, for example:
 * 
 *     @cpp.EnumType{type = cpp.EnumUnderlyingType.I8}
 *     enum Fruit {
 *       Apple = 0,
 *       Banana = 1,
 *     }
 * 
 * will be generated into the following:
 * 
 *     enum class Fruit : ::std::int8_t {
 *       Apple = 0,
 *       Banana = 1,
 *     };
 * 
 *
 * Original thrift struct:-
 * EnumType
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/EnumType'))>>
class EnumType implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
    1 => shape(
      'var' => 'type',
      'type' => \TType::I32,
      'enum' => \facebook\thrift\annotation\cpp\EnumUnderlyingType::class,
    ),
  ];
  const dict<string, int> FIELDMAP = dict[
    'type' => 1,
  ];

  const type TConstructorShape = shape(
    ?'type' => ?\facebook\thrift\annotation\cpp\EnumUnderlyingType,
  );

  const type TShape = shape(
    ?'type' => ?\facebook\thrift\annotation\cpp\EnumUnderlyingType,
  );
  const int STRUCTURAL_ID = 8371848154551322037;
  /**
   * Original thrift field:-
   * 1: cpp.EnumUnderlyingType type
   */
  public ?\facebook\thrift\annotation\cpp\EnumUnderlyingType $type;

  public function __construct(?\facebook\thrift\annotation\cpp\EnumUnderlyingType $type = null)[] {
    $this->type = $type;
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'type'),
    );
  }

  public function getName()[]: string {
    return 'EnumType';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.EnumType",
        "fields" => vec[
          \tmeta_ThriftField::fromShape(
            shape(
              "id" => 1,
              "type" => \tmeta_ThriftType::fromShape(
                shape(
                  "t_enum" => \tmeta_ThriftEnumType::fromShape(
                    shape(
                      "name" => "cpp.EnumUnderlyingType",
                    )
                  ),
                )
              ),
              "name" => "type",
            )
          ),
        ],
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Enum' => \facebook\thrift\annotation\Enum::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
      Shapes::idx($shape, 'type'),
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
      'type' => $this->type,
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

    if (idx($parsed, 'type') !== null) {
      $this->type = \facebook\thrift\annotation\cpp\EnumUnderlyingType::coerce(HH\FIXME\UNSAFE_CAST<mixed, \facebook\thrift\annotation\cpp\EnumUnderlyingType>($parsed['type']));
    }
  }

}

/**
 * Indicates that frozen types should not be generated for a given struct.
 *
 * Original thrift struct:-
 * Frozen2Exclude
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Frozen2Exclude'))>>
class Frozen2Exclude implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'Frozen2Exclude';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Frozen2Exclude",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Indicates that the container params must be complete at the time this type is instantiated.
 * Only required in rare cases where the build fails with a frozen-related assert failure.
 *
 * Original thrift struct:-
 * Frozen2RequiresCompleteContainerParams
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/Frozen2RequiresCompleteContainerParams'))>>
class Frozen2RequiresCompleteContainerParams implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'Frozen2RequiresCompleteContainerParams';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.Frozen2RequiresCompleteContainerParams",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Causes C++ handler code to run inline on the EventBase thread.
 * Disables overload protection, use with caution.
 * Cannot be applied to individual functions in interactions.
 * 
 * Causes the request to be executed on the event base thread directly instead of rescheduling onto a thread manager thread, provided the async_eb_ handler method is implemented.
 * You should only execute the request on the event base thread if it is very fast and you have measured that rescheduling is a substantial chunk of your service's CPU usage.
 * If a request executing on the event base thread blocks or takes a long time, all other requests sharing the same event base are affected and latency will increase significantly.
 * We strongly discourage the use of this annotation unless strictly necessary. You will have to implement the harder-to-use async_eb_ handler method.
 * This also disables queue timeouts, an important form of overload protection.
 *
 * Original thrift struct:-
 * ProcessInEbThreadUnsafe
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/ProcessInEbThreadUnsafe'))>>
class ProcessInEbThreadUnsafe implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'ProcessInEbThreadUnsafe';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.ProcessInEbThreadUnsafe",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\TFunction' => \facebook\thrift\annotation\TFunction::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Interaction' => \facebook\thrift\annotation\Interaction::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Causes uses of the given structured type to be replaced with `CursorSerializationWrapper` to allow use of cursor-based serialization.
 * Must add `cpp_include "thrift/lib/cpp2/protocol/CursorBasedSerializer.h"` to files that use this annotation.
 * See documentation for this class in CursorBasedSerializer.h
 * Can only be applied to top-level structs (used as return type or sole argument to an RPC or serialized directly), not to types used as struct fields or container elements.
 *
 * Original thrift struct:-
 * UseCursorSerialization
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/UseCursorSerialization'))>>
class UseCursorSerialization implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'UseCursorSerialization';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.UseCursorSerialization",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Struct' => \facebook\thrift\annotation\Struct::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Union' => \facebook\thrift\annotation\Union::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Transitive' => \facebook\thrift\annotation\Transitive::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\cpp\Adapter' => \facebook\thrift\annotation\cpp\Adapter::fromShape(
          shape(
            "name" => "::apache::thrift::CursorSerializationAdapter",
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Given either of the following Thrift service definitions:
 * 
 *     @cpp.GenerateDeprecatedHeaderClientMethods
 *     service Foo {
 *       void bar();
 *     }
 * 
 *     service Foo {
 *       @cpp.GenerateDeprecatedHeaderClientMethods
 *       void bar();
 *     }
 * 
 * This annotation instructs the compiler to generate the following (now deprecated) client method variants:
 *   - apache::thrift::Client<Foo>::header_future_bar
 *   - apache::thrift::Client<Foo>::header_semifuture_bar
 *
 * Original thrift struct:-
 * GenerateDeprecatedHeaderClientMethods
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/GenerateDeprecatedHeaderClientMethods'))>>
class GenerateDeprecatedHeaderClientMethods implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'GenerateDeprecatedHeaderClientMethods';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.GenerateDeprecatedHeaderClientMethods",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Service' => \facebook\thrift\annotation\Service::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\TFunction' => \facebook\thrift\annotation\TFunction::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Allows the field to be annotated @cpp.Ref (or cpp[2].ref[_type]) even if it
 * is not optional (or in a union, which is effectively optional).
 * 
 * This annotation is provided for a limited time, to exempt pre-existing fields
 * while rolling out a stricter enforcement of the condition above.
 * 
 * Reminder: reference fields should be optional because the corresponding smart
 * pointers (std::unique_ptr, std::shared_ptr) can always be reset or set to
 * nullptr by the clients. If the field is not optional, this leads to a
 * confusing (or non-sensical) situation, wherein a field that should always
 * have a value has nullptr instead.
 *
 * Original thrift struct:-
 * AllowLegacyNonOptionalRef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/AllowLegacyNonOptionalRef'))>>
class AllowLegacyNonOptionalRef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'AllowLegacyNonOptionalRef';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.AllowLegacyNonOptionalRef",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Changes the serialization behavior of the field to skip serialization if its value is equal to standard default
 * for bool, integers, enums, and floating points, and intrinsic default for string, binary, and containers.
 * If an unqualified field with structured type has @cpp.Ref, the serilaization skips the field if the pointer is empty.
 * 
 * This annotation is only applicable to an unqualified field with bool, integers, enums, floating points, string, binary, and containers
 * but not for structs, unions, and exceptions.
 * 
 * Note, this is a deprecated feature. Use @thrift.TerseWrite instead.
 *
 * Original thrift struct:-
 * DeprecatedTerseWrite
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/DeprecatedTerseWrite'))>>
class DeprecatedTerseWrite implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'DeprecatedTerseWrite';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.DeprecatedTerseWrite",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Allows the field to be annotated @cpp.Ref (or cpp[2].ref[_type]) even if it
 * is deprecated_terse_writes field.
 * 
 * This annotation is provided for a limited time, to exempt pre-existing fields
 * while rolling out a stricter enforcement of the condition above.
 *
 * Original thrift struct:-
 * AllowLegacyDeprecatedTerseWritesRef
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/AllowLegacyDeprecatedTerseWritesRef'))>>
class AllowLegacyDeprecatedTerseWritesRef implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'AllowLegacyDeprecatedTerseWritesRef';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.AllowLegacyDeprecatedTerseWritesRef",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Field' => \facebook\thrift\annotation\Field::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * If there are custom types in thrift structure (e.g., `std::unordered_map` field),
 * We won't define `operator<` automatically (unless URI exists, but that's about
 * to change). Note that `operator<` is always declared, unless `@cpp.NonOrderable` is used.
 * This annotation ensures the `operator<` is always defined. For types that
 * don't have `operator<`, such as `std::unordered_map`, we will convert it to
 * a sorted `std::vector<pair<K*, V*>>` to do the comparison.
 *
 * Original thrift struct:-
 * EnableCustomTypeOrdering
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/EnableCustomTypeOrdering'))>>
class EnableCustomTypeOrdering implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'EnableCustomTypeOrdering';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.EnableCustomTypeOrdering",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Program' => \facebook\thrift\annotation\Program::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * When applied to a service, this annotation will cause the thrift compiler
 * to generate the method decorator interface for the class.
 *
 * Original thrift struct:-
 * GenerateServiceMethodDecorator
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/GenerateServiceMethodDecorator'))>>
class GenerateServiceMethodDecorator implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'GenerateServiceMethodDecorator';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.GenerateServiceMethodDecorator",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Service' => \facebook\thrift\annotation\Service::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Marks a structured type as non-orderable, marking `operator<` as deleted.
 * This is useful when types should never be ordered. By default, `operator<` is
 * always declared, but depending on whether or not the type's shape is considered
 * orderable, it may or may not be defined. See `EnableCustomTypeOrdering` for more
 * details.
 * Note: The unstructured `cpp_noncomparable` annotation has priority over this one &
 * will cause `operator==` && `operator<` to *not* be declared or defined.
 *
 * Original thrift struct:-
 * NonOrderable
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/NonOrderable'))>>
class NonOrderable implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'NonOrderable';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.NonOrderable",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Declares a specialization of `std::hash` for the struct or type.
 * This is equivalent to the unstructured `cpp.declare_hash` annotation.
 * The generated code will include a forward declaration of the hash specialization in the std namespace.
 *
 * Original thrift struct:-
 * DeclareHashSpecialization
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/DeclareHashSpecialization'))>>
class DeclareHashSpecialization implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'DeclareHashSpecialization';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.DeclareHashSpecialization",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

/**
 * Declares a specialization of `std::equal_to` for the struct or type.
 * This is equivalent to the unstructured `cpp.declare_equal_to` annotation.
 * The generated code will include a forward declaration of the equal_to specialization in the std namespace.
 *
 * Original thrift struct:-
 * DeclareEqualToSpecialization
 */
<<\ThriftTypeInfo(shape('uri' => 'facebook.com/thrift/annotation/cpp/DeclareEqualToSpecialization'))>>
class DeclareEqualToSpecialization implements \IThriftSyncStruct, \IThriftStructMetadata, \IThriftShapishSyncStruct {
  use \ThriftSerializationTrait;

  const \ThriftStructTypes::TSpec SPEC = dict[
  ];
  const dict<string, int> FIELDMAP = dict[
  ];

  const type TConstructorShape = shape(
  );

  const type TShape = shape(
  );
  const int STRUCTURAL_ID = 957977401221134810;

  public function __construct()[] {
  }

  public static function withDefaultValues()[]: this {
    return new static();
  }

  public static function fromShape(self::TConstructorShape $shape)[]: this {
    return new static(
    );
  }

  public function getName()[]: string {
    return 'DeclareEqualToSpecialization';
  }

  public static function getStructMetadata()[]: \tmeta_ThriftStruct {
    return \tmeta_ThriftStruct::fromShape(
      shape(
        "name" => "cpp.DeclareEqualToSpecialization",
        "is_union" => false,
      )
    );
  }

  public static function getAllStructuredAnnotations()[write_props]: \TStructAnnotations {
    return shape(
      'struct' => dict[
        '\facebook\thrift\annotation\Structured' => \facebook\thrift\annotation\Structured::fromShape(
          shape(
          )
        ),
        '\facebook\thrift\annotation\Typedef' => \facebook\thrift\annotation\Typedef::fromShape(
          shape(
          )
        ),
      ],
      'fields' => dict[
      ],
    );
  }

  public static function __fromShape(self::TShape $shape)[]: this {
    return new static(
    );
  }

  public function __toShape()[]: self::TShape {
    return shape(
    );
  }
  public function getInstanceKey()[write_props]: string {
    return \TCompactSerializer::serialize($this);
  }

  public function readFromJson(string $jsonText): void {
    $parsed = json_decode($jsonText, true);

    if ($parsed === null || !($parsed is KeyedContainer<_, _>)) {
      throw new \TProtocolException("Cannot parse the given json string.");
    }

  }

}

