/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <thrift/compiler/sema/ast_uri_utils.h>

#include <memory>
#include <gtest/gtest.h>

#include <thrift/compiler/ast/t_enum.h>
#include <thrift/compiler/ast/t_exception.h>
#include <thrift/compiler/ast/t_struct.h>
#include <thrift/compiler/ast/t_typedef.h>
#include <thrift/compiler/ast/t_union.h>

namespace apache::thrift::compiler {

TEST(AstUriUtilsTest, ShouldHaveUri_True) {
  EXPECT_TRUE(
      AstUriUtils::shouldHaveUri(
          t_struct(/*program=*/nullptr, /*name=*/"TestStruct")));
  EXPECT_TRUE(
      AstUriUtils::shouldHaveUri(
          t_union(/*program=*/nullptr, /*name=*/"TestUnion")));
  EXPECT_TRUE(
      AstUriUtils::shouldHaveUri(
          t_exception(/*program=*/nullptr, /*name=*/"TestException")));
  EXPECT_TRUE(
      AstUriUtils::shouldHaveUri(
          t_enum(/*program=*/nullptr, /*name=*/"TestEnum")));
}

TEST(AstUriUtilsTest, ShouldHaveUri_False) {
  static const t_struct kStruct(/*program=*/nullptr, /*name=*/"TestStruct");

  EXPECT_FALSE(
      AstUriUtils::shouldHaveUri(t_typedef(
          /*program=*/nullptr, /*name=*/"TestTypedef", /*type=*/kStruct)));
}

} // namespace apache::thrift::compiler
