/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package stats

import (
	"testing"
	"time"

	"github.com/stretchr/testify/require"
)

func TestStats(t *testing.T) {
	timingConfig := NewTimingConfig(60 * time.Second)
	stats := NewServerStats(timingConfig, 60*time.Second)

	ints := stats.GetInts()
	expectedInts := map[string]int64{
		"requests.processor_panics.60": 0,
	}
	require.Equal(t, expectedInts, ints)
}
