/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

include "thrift/annotation/scope.thrift"
include "thrift/annotation/cpp.thrift"

package "facebook.com/thrift/test"

struct A {
  1: B field;
}

struct B {
  1: optional C field;
}

@TestAnnot{loc = "struct"}
struct C {
  @cpp.Type{name = "std::uint32_t"}
  1: i32 field;
}

struct NotIncluded {}

@scope.Struct
struct TestAnnot {
  1: string loc;
}
