// Autogenerated by Thrift for thrift/compiler/test/fixtures/doctext/src/module.thrift
//
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
//  @generated

// Package level doctext.

package module

import (
    "context"
    "errors"
    "fmt"
    "io"
    "reflect"
    "sync"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift/types"
    metadata "github.com/facebook/fbthrift/thrift/lib/thrift/metadata"
)

// (needed to ensure safety because of naive import list construction)
var _ = context.Background
var _ = errors.New
var _ = fmt.Printf
var _ = io.EOF
var _ = reflect.Ptr
var _ = sync.OnceFunc
var _ = thrift.VOID
var _ = metadata.GoUnusedProtection__


type C interface {
    F(ctx context.Context) (error)
    Numbers(ctx context.Context) (func(context.Context, chan<- Number) error, error)
    Thing(ctx context.Context, a int32, b string, c []int32) (string, error)
}

type CClient interface {
    io.Closer
    F(ctx context.Context) (error)
    Numbers(ctx context.Context) (<-chan Number /* elem stream */, <-chan error /* stream err */, error)
    Thing(ctx context.Context, a int32, b string, c []int32) (string, error)
}

type cClientImpl struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ CClient = (*cClientImpl)(nil)

func NewCChannelClient(channel thrift.RequestChannel) CClient {
    return &cClientImpl{
        ch: channel,
    }
}

func (c *cClientImpl) Close() error {
    return c.ch.Close()
}

func (c *cClientImpl) F(ctx context.Context) (error) {
    fbthriftReq := &reqCF{
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespCF()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "f",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return fbthriftEx
    }
    return nil
}

func (c *cClientImpl) Numbers(ctx context.Context) (<-chan Number /* elem stream */, <-chan error /* stream err */, error) {
    // Must be a cancellable context to prevent goroutine leaks
    if ctx.Done() == nil {
		return nil, nil, errors.New("context does not support cancellation")
	}
    fbthriftStreamCtx, fbthriftStreamCancel := context.WithCancel(ctx)

    fbthriftReq := &reqCNumbers{
    }
    fbthriftResp := newRespCNumbers()

    fbthriftChannel := c.ch

    fbthriftErrChan := make(chan error, 1)
    fbthriftElemChan := make(chan Number, thrift.DefaultStreamBufferSize)

    fbthriftOnStreamNextFn := func(d thrift.Decoder) error {
        fbthriftStreamValue := newStreamCNumbers()
        fbthriftSpecErr := fbthriftStreamValue.Read(d)
        if fbthriftSpecErr != nil {
            return fbthriftSpecErr
        } else if fbthriftStreamEx := fbthriftStreamValue.Exception(); fbthriftStreamEx != nil {
            return fbthriftStreamEx
        }
        fbthriftElemChan <- fbthriftStreamValue.GetSuccess()
        return nil
    }
    fbthriftOnStreamErrorFn := func(err error) {
        fbthriftErrChan <- err
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }
    fbthriftOnStreamCompleteFn := func() {
        close(fbthriftElemChan)
        close(fbthriftErrChan)
    }

    fbthriftErr := fbthriftChannel.SendRequestStream(
        fbthriftStreamCtx,
        "numbers",
        fbthriftReq,
        fbthriftResp,
        fbthriftOnStreamNextFn,
        fbthriftOnStreamErrorFn,
        fbthriftOnStreamCompleteFn,
    )
    if fbthriftErr != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        fbthriftStreamCancel()
        return nil, nil, fbthriftEx
    }
    return fbthriftElemChan, fbthriftErrChan, nil
}

func (c *cClientImpl) Thing(ctx context.Context, a int32, b string, c []int32) (string, error) {
    fbthriftReq := &reqCThing{
        A: a,
        B: b,
        C: c,
    }
    fbthriftChannel := c.ch
    fbthriftResp := newRespCThing()
    fbthriftErr := fbthriftChannel.SendRequestResponse(
        ctx,
        "thing",
        fbthriftReq,
        fbthriftResp,
    )
    if fbthriftErr != nil {
        return "", fbthriftErr
    } else if fbthriftEx := fbthriftResp.Exception(); fbthriftEx != nil {
        return "", fbthriftEx
    }
    return fbthriftResp.GetSuccess(), nil
}


type CProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler              C
}

func NewCProcessor(handler C) *CProcessor {
    p := &CProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("f", &procFuncCF{handler: handler})
    p.AddToProcessorFunctionMap("numbers", &procFuncCNumbers{handler: handler})
    p.AddToProcessorFunctionMap("thing", &procFuncCThing{handler: handler})
    p.AddToFunctionServiceMap("f", "C")
    p.AddToFunctionServiceMap("numbers", "C")
    p.AddToFunctionServiceMap("thing", "C")

    return p
}

func (p *CProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *CProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *CProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *CProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *CProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *CProcessor) PackageName() string {
    return "module"
}

func (p *CProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.C")
}


type procFuncCF struct {
    handler C
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncCF)(nil)

func (p *procFuncCF) NewReqArgs() thrift.ReadableStruct {
    return newReqCF()
}

func (p *procFuncCF) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    result := newRespCF()
    err := p.handler.F(ctx)
    if err != nil {
        internalErr := fmt.Errorf("Internal error processing F: %w", err)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        return x, internalErr
    }

    return result, nil
}

type procFuncCNumbers struct {
    handler C
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncCNumbers)(nil)

func (p *procFuncCNumbers) NewReqArgs() thrift.ReadableStruct {
    return newReqCNumbers()
}

func (p *procFuncCNumbers) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    return nil, errors.New("not supported")
}

func (p *procFuncCNumbers) RunStreamContext(
    ctx context.Context,
    reqStruct thrift.ReadableStruct,
    onFirstResponse func(thrift.WritableStruct),
    onStreamNext func(thrift.WritableStruct),
    onStreamComplete func(),
) {
    firstResponse := newRespCNumbers()
    elemProducerFunc, initialErr := p.handler.Numbers(ctx)
    if initialErr != nil {
        internalErr := fmt.Errorf("Internal error processing Numbers: %w", initialErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onFirstResponse(x)
        onStreamComplete()
        return
    }

    onFirstResponse(firstResponse)

    fbthriftElemChan := make(chan Number, thrift.DefaultStreamBufferSize)
    var senderWg sync.WaitGroup
    senderWg.Add(1)
    // Sender goroutine (receives elements on the channel and sends them out via onStreamNext)
    go func() {
        defer senderWg.Done()
        for elem := range fbthriftElemChan {
            streamWrapStruct := newStreamCNumbers()
            streamWrapStruct.Success = &elem
            onStreamNext(streamWrapStruct)
        }
    }()

    streamErr := elemProducerFunc(ctx, fbthriftElemChan)
    // Stream is complete. Close the channel and wait for the sender goroutine to finish.
    close(fbthriftElemChan)
    senderWg.Wait()
    if streamErr != nil {
        internalErr := fmt.Errorf("Internal stream handler error Numbers: %w", streamErr)
        x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
        onStreamNext(x)
    }
    onStreamComplete()
}

type procFuncCThing struct {
    handler C
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncCThing)(nil)

func (p *procFuncCThing) NewReqArgs() thrift.ReadableStruct {
    return newReqCThing()
}

func (p *procFuncCThing) RunContext(ctx context.Context, reqStruct thrift.ReadableStruct) (thrift.WritableStruct, error) {
    args := reqStruct.(*reqCThing)
    result := newRespCThing()
    retval, err := p.handler.Thing(ctx, args.A, args.B, args.C)
    if err != nil {
        switch v := err.(type) {
        case *Bang:
            result.Bang = v
            return result, nil
        default:
            internalErr := fmt.Errorf("Internal error processing Thing: %w", err)
            x := thrift.NewApplicationException(thrift.INTERNAL_ERROR, internalErr.Error())
            return x, internalErr
        }
    }

    result.Success = &retval
    return result, nil
}

