/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <thrift/lib/cpp2/server/DecoratorData.h>

namespace apache::thrift::server {

/* static */ DecoratorData DecoratorData::fromStorage(
    DecoratorDataStorage& storage) {
  return DecoratorData(storage);
}

/* static */ const DecoratorData DecoratorData::fromStorage(
    const DecoratorDataStorage& storage) {
  return DecoratorData(storage);
}

DecoratorData::DecoratorData(DecoratorDataStorage& storage)
    : decoratorData_{folly::span(storage.decoratorData.get(), storage.count)} {}

DecoratorData::DecoratorData(const DecoratorDataStorage& storage)
    : decoratorData_{folly::span(storage.decoratorData.get(), storage.count)} {}

} // namespace apache::thrift::server
