// Code generated by "go run compress_generate.go"; DO NOT EDIT.

package dns

func compressionLenHelperType(c map[string]int, r RR, initLen int) int {
	currentLen := initLen
	switch x := r.(type) {
	case *AFSDB:
		currentLen -= len(x.Hostname) + 1
		currentLen += compressionLenHelper(c, x.Hostname, currentLen)
	case *CNAME:
		currentLen -= len(x.Target) + 1
		currentLen += compressionLenHelper(c, x.Target, currentLen)
	case *DNAME:
		currentLen -= len(x.Target) + 1
		currentLen += compressionLenHelper(c, x.Target, currentLen)
	case *HIP:
		for i := range x.RendezvousServers {
			currentLen -= len(x.RendezvousServers[i]) + 1
		}
		for i := range x.RendezvousServers {
			currentLen += compressionLenHelper(c, x.RendezvousServers[i], currentLen)
		}
	case *KX:
		currentLen -= len(x.Exchanger) + 1
		currentLen += compressionLenHelper(c, x.Exchanger, currentLen)
	case *LP:
		currentLen -= len(x.Fqdn) + 1
		currentLen += compressionLenHelper(c, x.Fqdn, currentLen)
	case *MB:
		currentLen -= len(x.Mb) + 1
		currentLen += compressionLenHelper(c, x.Mb, currentLen)
	case *MD:
		currentLen -= len(x.Md) + 1
		currentLen += compressionLenHelper(c, x.Md, currentLen)
	case *MF:
		currentLen -= len(x.Mf) + 1
		currentLen += compressionLenHelper(c, x.Mf, currentLen)
	case *MG:
		currentLen -= len(x.Mg) + 1
		currentLen += compressionLenHelper(c, x.Mg, currentLen)
	case *MINFO:
		currentLen -= len(x.Rmail) + 1
		currentLen += compressionLenHelper(c, x.Rmail, currentLen)
		currentLen -= len(x.Email) + 1
		currentLen += compressionLenHelper(c, x.Email, currentLen)
	case *MR:
		currentLen -= len(x.Mr) + 1
		currentLen += compressionLenHelper(c, x.Mr, currentLen)
	case *MX:
		currentLen -= len(x.Mx) + 1
		currentLen += compressionLenHelper(c, x.Mx, currentLen)
	case *NAPTR:
		currentLen -= len(x.Replacement) + 1
		currentLen += compressionLenHelper(c, x.Replacement, currentLen)
	case *NS:
		currentLen -= len(x.Ns) + 1
		currentLen += compressionLenHelper(c, x.Ns, currentLen)
	case *NSAPPTR:
		currentLen -= len(x.Ptr) + 1
		currentLen += compressionLenHelper(c, x.Ptr, currentLen)
	case *NSEC:
		currentLen -= len(x.NextDomain) + 1
		currentLen += compressionLenHelper(c, x.NextDomain, currentLen)
	case *PTR:
		currentLen -= len(x.Ptr) + 1
		currentLen += compressionLenHelper(c, x.Ptr, currentLen)
	case *PX:
		currentLen -= len(x.Map822) + 1
		currentLen += compressionLenHelper(c, x.Map822, currentLen)
		currentLen -= len(x.Mapx400) + 1
		currentLen += compressionLenHelper(c, x.Mapx400, currentLen)
	case *RP:
		currentLen -= len(x.Mbox) + 1
		currentLen += compressionLenHelper(c, x.Mbox, currentLen)
		currentLen -= len(x.Txt) + 1
		currentLen += compressionLenHelper(c, x.Txt, currentLen)
	case *RRSIG:
		currentLen -= len(x.SignerName) + 1
		currentLen += compressionLenHelper(c, x.SignerName, currentLen)
	case *RT:
		currentLen -= len(x.Host) + 1
		currentLen += compressionLenHelper(c, x.Host, currentLen)
	case *SIG:
		currentLen -= len(x.SignerName) + 1
		currentLen += compressionLenHelper(c, x.SignerName, currentLen)
	case *SOA:
		currentLen -= len(x.Ns) + 1
		currentLen += compressionLenHelper(c, x.Ns, currentLen)
		currentLen -= len(x.Mbox) + 1
		currentLen += compressionLenHelper(c, x.Mbox, currentLen)
	case *SRV:
		currentLen -= len(x.Target) + 1
		currentLen += compressionLenHelper(c, x.Target, currentLen)
	case *TALINK:
		currentLen -= len(x.PreviousName) + 1
		currentLen += compressionLenHelper(c, x.PreviousName, currentLen)
		currentLen -= len(x.NextName) + 1
		currentLen += compressionLenHelper(c, x.NextName, currentLen)
	case *TKEY:
		currentLen -= len(x.Algorithm) + 1
		currentLen += compressionLenHelper(c, x.Algorithm, currentLen)
	case *TSIG:
		currentLen -= len(x.Algorithm) + 1
		currentLen += compressionLenHelper(c, x.Algorithm, currentLen)
	}
	return currentLen - initLen
}

func compressionLenSearchType(c map[string]int, r RR) (int, bool, int) {
	switch x := r.(type) {
	case *AFSDB:
		k1, ok1, sz1 := compressionLenSearch(c, x.Hostname)
		return k1, ok1, sz1
	case *CNAME:
		k1, ok1, sz1 := compressionLenSearch(c, x.Target)
		return k1, ok1, sz1
	case *MB:
		k1, ok1, sz1 := compressionLenSearch(c, x.Mb)
		return k1, ok1, sz1
	case *MD:
		k1, ok1, sz1 := compressionLenSearch(c, x.Md)
		return k1, ok1, sz1
	case *MF:
		k1, ok1, sz1 := compressionLenSearch(c, x.Mf)
		return k1, ok1, sz1
	case *MG:
		k1, ok1, sz1 := compressionLenSearch(c, x.Mg)
		return k1, ok1, sz1
	case *MINFO:
		k1, ok1, sz1 := compressionLenSearch(c, x.Rmail)
		k2, ok2, sz2 := compressionLenSearch(c, x.Email)
		return k1 + k2, ok1 && ok2, sz1 + sz2
	case *MR:
		k1, ok1, sz1 := compressionLenSearch(c, x.Mr)
		return k1, ok1, sz1
	case *MX:
		k1, ok1, sz1 := compressionLenSearch(c, x.Mx)
		return k1, ok1, sz1
	case *NS:
		k1, ok1, sz1 := compressionLenSearch(c, x.Ns)
		return k1, ok1, sz1
	case *PTR:
		k1, ok1, sz1 := compressionLenSearch(c, x.Ptr)
		return k1, ok1, sz1
	case *RT:
		k1, ok1, sz1 := compressionLenSearch(c, x.Host)
		return k1, ok1, sz1
	case *SOA:
		k1, ok1, sz1 := compressionLenSearch(c, x.Ns)
		k2, ok2, sz2 := compressionLenSearch(c, x.Mbox)
		return k1 + k2, ok1 && ok2, sz1 + sz2
	}
	return 0, false, 0
}
