/*
 * Copyright (c) 2015 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 *
 * This file contains configuration values translated from Rubinius.
 *
 * Copyright (c) 2007-2014, Evan Phoenix and contributors
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of Rubinius nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jruby.truffle.runtime.rubinius;

import org.jruby.truffle.runtime.RubyContext;

public class DarwinRubiniusConfiguration extends DefaultRubiniusConfiguration {

    public static void load(RubiniusConfiguration configuration, RubyContext context) {
        // Generated from tool/truffle/translate_rubinius_config.rb < ../rubinius/runtime/platform.conf
        configuration.config("rbx.platform.addrinfo.sizeof", 48);
        configuration.config("rbx.platform.addrinfo.ai_flags.offset", 0);
        configuration.config("rbx.platform.addrinfo.ai_flags.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_flags.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_family.offset", 4);
        configuration.config("rbx.platform.addrinfo.ai_family.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_family.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_socktype.offset", 8);
        configuration.config("rbx.platform.addrinfo.ai_socktype.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_socktype.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_protocol.offset", 12);
        configuration.config("rbx.platform.addrinfo.ai_protocol.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_protocol.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_addrlen.offset", 16);
        configuration.config("rbx.platform.addrinfo.ai_addrlen.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_addrlen.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_addr.offset", 32);
        configuration.config("rbx.platform.addrinfo.ai_addr.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_addr.type", string(context, "pointer"));
        configuration.config("rbx.platform.addrinfo.ai_canonname.offset", 24);
        configuration.config("rbx.platform.addrinfo.ai_canonname.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_canonname.type", string(context, "string"));
        configuration.config("rbx.platform.addrinfo.ai_next.offset", 40);
        configuration.config("rbx.platform.addrinfo.ai_next.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_next.type", string(context, "pointer"));
        configuration.config("rbx.platform.ifaddrs.sizeof", 56);
        configuration.config("rbx.platform.ifaddrs.ifa_next.offset", 0);
        configuration.config("rbx.platform.ifaddrs.ifa_next.size", 8);
        configuration.config("rbx.platform.ifaddrs.ifa_next.type", string(context, "pointer"));
        configuration.config("rbx.platform.ifaddrs.ifa_name.offset", 8);
        configuration.config("rbx.platform.ifaddrs.ifa_name.size", 8);
        configuration.config("rbx.platform.ifaddrs.ifa_name.type", string(context, "string"));
        configuration.config("rbx.platform.ifaddrs.ifa_flags.offset", 16);
        configuration.config("rbx.platform.ifaddrs.ifa_flags.size", 4);
        configuration.config("rbx.platform.ifaddrs.ifa_flags.type", string(context, "int"));
        configuration.config("rbx.platform.ifaddrs.ifa_addr.offset", 24);
        configuration.config("rbx.platform.ifaddrs.ifa_addr.size", 8);
        configuration.config("rbx.platform.ifaddrs.ifa_addr.type", string(context, "pointer"));
        configuration.config("rbx.platform.ifaddrs.ifa_netmask.offset", 32);
        configuration.config("rbx.platform.ifaddrs.ifa_netmask.size", 8);
        configuration.config("rbx.platform.ifaddrs.ifa_netmask.type", string(context, "pointer"));
        configuration.config("rbx.platform.sockaddr.sizeof", 16);
        configuration.config("rbx.platform.sockaddr.sa_data.offset", 2);
        configuration.config("rbx.platform.sockaddr.sa_data.size", 14);
        configuration.config("rbx.platform.sockaddr.sa_data.type", string(context, "char_array"));
        configuration.config("rbx.platform.sockaddr.sa_family.offset", 1);
        configuration.config("rbx.platform.sockaddr.sa_family.size", 1);
        configuration.config("rbx.platform.sockaddr.sa_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.dirent.sizeof", 1048);
        configuration.config("rbx.platform.dirent.d_ino.offset", 0);
        configuration.config("rbx.platform.dirent.d_ino.size", 8);
        configuration.config("rbx.platform.dirent.d_ino.type", string(context, "ino_t"));
        configuration.config("rbx.platform.dirent.d_reclen.offset", 16);
        configuration.config("rbx.platform.dirent.d_reclen.size", 2);
        configuration.config("rbx.platform.dirent.d_reclen.type", string(context, "ushort"));
        configuration.config("rbx.platform.dirent.d_name.offset", 21);
        configuration.config("rbx.platform.dirent.d_name.size", 1024);
        configuration.config("rbx.platform.dirent.d_name.type", string(context, "char_array"));
        configuration.config("rbx.platform.timeval.sizeof", 16);
        configuration.config("rbx.platform.timeval.tv_sec.offset", 0);
        configuration.config("rbx.platform.timeval.tv_sec.size", 8);
        configuration.config("rbx.platform.timeval.tv_sec.type", string(context, "time_t"));
        configuration.config("rbx.platform.timeval.tv_usec.offset", 8);
        configuration.config("rbx.platform.timeval.tv_usec.size", 4);
        configuration.config("rbx.platform.timeval.tv_usec.type", string(context, "suseconds_t"));
        configuration.config("rbx.platform.sockaddr_in.sizeof", 16);
        configuration.config("rbx.platform.sockaddr_in.sin_family.offset", 1);
        configuration.config("rbx.platform.sockaddr_in.sin_family.size", 1);
        configuration.config("rbx.platform.sockaddr_in.sin_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.sockaddr_in.sin_port.offset", 2);
        configuration.config("rbx.platform.sockaddr_in.sin_port.size", 2);
        configuration.config("rbx.platform.sockaddr_in.sin_port.type", string(context, "ushort"));
        configuration.config("rbx.platform.sockaddr_in.sin_addr.offset", 4);
        configuration.config("rbx.platform.sockaddr_in.sin_addr.size", 4);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.offset", 8);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.size", 8);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.type", string(context, "char_array"));
        configuration.config("rbx.platform.sockaddr_in6.sizeof", 28);
        configuration.config("rbx.platform.sockaddr_in6.sin6_family.offset", 1);
        configuration.config("rbx.platform.sockaddr_in6.sin6_family.size", 1);
        configuration.config("rbx.platform.sockaddr_in6.sin6_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.sockaddr_in6.sin6_port.offset", 2);
        configuration.config("rbx.platform.sockaddr_in6.sin6_port.size", 2);
        configuration.config("rbx.platform.sockaddr_in6.sin6_port.type", string(context, "ushort"));
        configuration.config("rbx.platform.sockaddr_in6.sin6_flowinfo.offset", 4);
        configuration.config("rbx.platform.sockaddr_in6.sin6_flowinfo.size", 4);
        configuration.config("rbx.platform.sockaddr_in6.sin6_addr.offset", 8);
        configuration.config("rbx.platform.sockaddr_in6.sin6_addr.size", 16);
        configuration.config("rbx.platform.sockaddr_in6.sin6_addr.type", string(context, "char_array"));
        configuration.config("rbx.platform.sockaddr_in6.sin6_scope_id.offset", 24);
        configuration.config("rbx.platform.sockaddr_in6.sin6_scope_id.size", 4);
        configuration.config("rbx.platform.sockaddr_un.sizeof", 106);
        configuration.config("rbx.platform.sockaddr_un.sun_family.offset", 1);
        configuration.config("rbx.platform.sockaddr_un.sun_family.size", 1);
        configuration.config("rbx.platform.sockaddr_un.sun_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.sockaddr_un.sun_path.offset", 2);
        configuration.config("rbx.platform.sockaddr_un.sun_path.size", 104);
        configuration.config("rbx.platform.sockaddr_un.sun_path.type", string(context, "char_array"));
        configuration.config("rbx.platform.linger.sizeof", 8);
        configuration.config("rbx.platform.linger.l_onoff.offset", 0);
        configuration.config("rbx.platform.linger.l_onoff.size", 4);
        configuration.config("rbx.platform.linger.l_linger.offset", 4);
        configuration.config("rbx.platform.linger.l_linger.size", 4);
        configuration.config("rbx.platform.servent.sizeof", 32);
        configuration.config("rbx.platform.servent.s_name.offset", 0);
        configuration.config("rbx.platform.servent.s_name.size", 8);
        configuration.config("rbx.platform.servent.s_name.type", string(context, "pointer"));
        configuration.config("rbx.platform.servent.s_aliases.offset", 8);
        configuration.config("rbx.platform.servent.s_aliases.size", 8);
        configuration.config("rbx.platform.servent.s_aliases.type", string(context, "pointer"));
        configuration.config("rbx.platform.servent.s_port.offset", 16);
        configuration.config("rbx.platform.servent.s_port.size", 4);
        configuration.config("rbx.platform.servent.s_port.type", string(context, "int"));
        configuration.config("rbx.platform.servent.s_proto.offset", 24);
        configuration.config("rbx.platform.servent.s_proto.size", 8);
        configuration.config("rbx.platform.servent.s_proto.type", string(context, "pointer"));
        configuration.config("rbx.platform.stat.sizeof", 144);
        configuration.config("rbx.platform.stat.st_dev.offset", 0);
        configuration.config("rbx.platform.stat.st_dev.size", 4);
        configuration.config("rbx.platform.stat.st_dev.type", string(context, "dev_t"));
        configuration.config("rbx.platform.stat.st_ino.offset", 8);
        configuration.config("rbx.platform.stat.st_ino.size", 8);
        configuration.config("rbx.platform.stat.st_ino.type", string(context, "ino_t"));
        configuration.config("rbx.platform.stat.st_mode.offset", 4);
        configuration.config("rbx.platform.stat.st_mode.size", 2);
        configuration.config("rbx.platform.stat.st_mode.type", string(context, "mode_t"));
        configuration.config("rbx.platform.stat.st_nlink.offset", 6);
        configuration.config("rbx.platform.stat.st_nlink.size", 2);
        configuration.config("rbx.platform.stat.st_nlink.type", string(context, "nlink_t"));
        configuration.config("rbx.platform.stat.st_uid.offset", 16);
        configuration.config("rbx.platform.stat.st_uid.size", 4);
        configuration.config("rbx.platform.stat.st_uid.type", string(context, "uid_t"));
        configuration.config("rbx.platform.stat.st_gid.offset", 20);
        configuration.config("rbx.platform.stat.st_gid.size", 4);
        configuration.config("rbx.platform.stat.st_gid.type", string(context, "gid_t"));
        configuration.config("rbx.platform.stat.st_rdev.offset", 24);
        configuration.config("rbx.platform.stat.st_rdev.size", 4);
        configuration.config("rbx.platform.stat.st_rdev.type", string(context, "dev_t"));
        configuration.config("rbx.platform.stat.st_size.offset", 96);
        configuration.config("rbx.platform.stat.st_size.size", 8);
        configuration.config("rbx.platform.stat.st_size.type", string(context, "off_t"));
        configuration.config("rbx.platform.stat.st_blksize.offset", 112);
        configuration.config("rbx.platform.stat.st_blksize.size", 4);
        configuration.config("rbx.platform.stat.st_blocks.offset", 104);
        configuration.config("rbx.platform.stat.st_blocks.size", 8);
        configuration.config("rbx.platform.stat.st_atime.offset", 32);
        configuration.config("rbx.platform.stat.st_atime.size", 8);
        configuration.config("rbx.platform.stat.st_atime.type", string(context, "time_t"));
        configuration.config("rbx.platform.stat.st_mtime.offset", 48);
        configuration.config("rbx.platform.stat.st_mtime.size", 8);
        configuration.config("rbx.platform.stat.st_mtime.type", string(context, "time_t"));
        configuration.config("rbx.platform.stat.st_ctime.offset", 64);
        configuration.config("rbx.platform.stat.st_ctime.size", 8);
        configuration.config("rbx.platform.stat.st_ctime.type", string(context, "time_t"));
        configuration.config("rbx.platform.rlimit.sizeof", 16);
        configuration.config("rbx.platform.rlimit.rlim_cur.offset", 0);
        configuration.config("rbx.platform.rlimit.rlim_cur.size", 8);
        configuration.config("rbx.platform.rlimit.rlim_cur.type", string(context, "rlim_t"));
        configuration.config("rbx.platform.rlimit.rlim_max.offset", 8);
        configuration.config("rbx.platform.rlimit.rlim_max.size", 8);
        configuration.config("rbx.platform.rlimit.rlim_max.type", string(context, "rlim_t"));
        configuration.config("rbx.platform.file.O_RDONLY", 0);
        configuration.config("rbx.platform.file.O_WRONLY", 1);
        configuration.config("rbx.platform.file.O_RDWR", 2);
        configuration.config("rbx.platform.file.O_CREAT", 512);
        configuration.config("rbx.platform.file.O_EXCL", 2048);
        configuration.config("rbx.platform.file.O_NOCTTY", 131072);
        configuration.config("rbx.platform.file.O_TRUNC", 1024);
        configuration.config("rbx.platform.file.O_APPEND", 8);
        configuration.config("rbx.platform.file.O_NONBLOCK", 4);
        configuration.config("rbx.platform.file.O_SYNC", 128);
        configuration.config("rbx.platform.file.S_IRUSR", 256);
        configuration.config("rbx.platform.file.S_IWUSR", 128);
        configuration.config("rbx.platform.file.S_IXUSR", 64);
        configuration.config("rbx.platform.file.S_IRGRP", 32);
        configuration.config("rbx.platform.file.S_IWGRP", 16);
        configuration.config("rbx.platform.file.S_IXGRP", 8);
        configuration.config("rbx.platform.file.S_IROTH", 4);
        configuration.config("rbx.platform.file.S_IWOTH", 2);
        configuration.config("rbx.platform.file.S_IXOTH", 1);
        configuration.config("rbx.platform.file.S_IFMT", 61440);
        configuration.config("rbx.platform.file.S_IFIFO", 4096);
        configuration.config("rbx.platform.file.S_IFCHR", 8192);
        configuration.config("rbx.platform.file.S_IFDIR", 16384);
        configuration.config("rbx.platform.file.S_IFBLK", 24576);
        configuration.config("rbx.platform.file.S_IFREG", 32768);
        configuration.config("rbx.platform.file.S_IFLNK", 40960);
        configuration.config("rbx.platform.file.S_IFSOCK", 49152);
        configuration.config("rbx.platform.file.S_IFWHT", 57344);
        configuration.config("rbx.platform.file.S_ISUID", 2048);
        configuration.config("rbx.platform.file.S_ISGID", 1024);
        configuration.config("rbx.platform.file.S_ISVTX", 512);
        configuration.config("rbx.platform.io.SEEK_SET", 0);
        configuration.config("rbx.platform.io.SEEK_CUR", 1);
        configuration.config("rbx.platform.io.SEEK_END", 2);
        configuration.config("rbx.platform.fcntl.F_GETFL", 3);
        configuration.config("rbx.platform.fcntl.F_SETFL", 4);
        configuration.config("rbx.platform.fcntl.O_ACCMODE", 3);
        configuration.config("rbx.platform.fcntl.F_GETFD", 1);
        configuration.config("rbx.platform.fcntl.F_SETFD", 2);
        configuration.config("rbx.platform.fcntl.FD_CLOEXEC", 1);
        configuration.config("rbx.platform.socket.AF_APPLETALK", 16);
        configuration.config("rbx.platform.socket.AF_ATM", 0);
        configuration.config("rbx.platform.socket.AF_AX25", 0);
        configuration.config("rbx.platform.socket.AF_CCITT", 10);
        configuration.config("rbx.platform.socket.AF_CHAOS", 5);
        configuration.config("rbx.platform.socket.AF_CNT", 21);
        configuration.config("rbx.platform.socket.AF_COIP", 20);
        configuration.config("rbx.platform.socket.AF_DATAKIT", 9);
        configuration.config("rbx.platform.socket.AF_DEC", 0);
        configuration.config("rbx.platform.socket.AF_DLI", 13);
        configuration.config("rbx.platform.socket.AF_E164", 28);
        configuration.config("rbx.platform.socket.AF_ECMA", 8);
        configuration.config("rbx.platform.socket.AF_HYLINK", 15);
        configuration.config("rbx.platform.socket.AF_IMPLINK", 3);
        configuration.config("rbx.platform.socket.AF_INET", 2);
        configuration.config("rbx.platform.socket.AF_INET6", 30);
        configuration.config("rbx.platform.socket.AF_IPX", 23);
        configuration.config("rbx.platform.socket.AF_ISDN", 28);
        configuration.config("rbx.platform.socket.AF_ISO", 7);
        configuration.config("rbx.platform.socket.AF_LAT", 14);
        configuration.config("rbx.platform.socket.AF_LINK", 18);
        configuration.config("rbx.platform.socket.AF_LOCAL", 1);
        configuration.config("rbx.platform.socket.AF_MAX", 40);
        configuration.config("rbx.platform.socket.AF_NATM", 31);
        configuration.config("rbx.platform.socket.AF_NDRV", 27);
        configuration.config("rbx.platform.socket.AF_NETBIOS", 33);
        configuration.config("rbx.platform.socket.AF_NETGRAPH", 0);
        configuration.config("rbx.platform.socket.AF_NS", 6);
        configuration.config("rbx.platform.socket.AF_OSI", 7);
        configuration.config("rbx.platform.socket.AF_PACKET", 0);
        configuration.config("rbx.platform.socket.AF_PPP", 34);
        configuration.config("rbx.platform.socket.AF_PUP", 4);
        configuration.config("rbx.platform.socket.AF_ROUTE", 17);
        configuration.config("rbx.platform.socket.AF_SIP", 24);
        configuration.config("rbx.platform.socket.AF_SNA", 11);
        configuration.config("rbx.platform.socket.AF_SYSTEM", 32);
        configuration.config("rbx.platform.socket.AF_UNIX", 1);
        configuration.config("rbx.platform.socket.AF_UNSPEC", 0);
        configuration.config("rbx.platform.socket.AI_ADDRCONFIG", 1024);
        configuration.config("rbx.platform.socket.AI_ALL", 256);
        configuration.config("rbx.platform.socket.AI_CANONNAME", 2);
        configuration.config("rbx.platform.socket.AI_DEFAULT", 1536);
        configuration.config("rbx.platform.socket.AI_MASK", 5127);
        configuration.config("rbx.platform.socket.AI_NUMERICHOST", 4);
        configuration.config("rbx.platform.socket.AI_NUMERICSERV", 4096);
        configuration.config("rbx.platform.socket.AI_PASSIVE", 1);
        configuration.config("rbx.platform.socket.AI_V4MAPPED", 2048);
        configuration.config("rbx.platform.socket.AI_V4MAPPED_CFG", 512);
        configuration.config("rbx.platform.socket.EAI_ADDRFAMILY", 1);
        configuration.config("rbx.platform.socket.EAI_AGAIN", 2);
        configuration.config("rbx.platform.socket.EAI_BADFLAGS", 3);
        configuration.config("rbx.platform.socket.EAI_BADHINTS", 12);
        configuration.config("rbx.platform.socket.EAI_FAIL", 4);
        configuration.config("rbx.platform.socket.EAI_FAMILY", 5);
        configuration.config("rbx.platform.socket.EAI_MAX", 15);
        configuration.config("rbx.platform.socket.EAI_MEMORY", 6);
        configuration.config("rbx.platform.socket.EAI_NODATA", 7);
        configuration.config("rbx.platform.socket.EAI_NONAME", 8);
        configuration.config("rbx.platform.socket.EAI_OVERFLOW", 14);
        configuration.config("rbx.platform.socket.EAI_PROTOCOL", 13);
        configuration.config("rbx.platform.socket.EAI_SERVICE", 9);
        configuration.config("rbx.platform.socket.EAI_SOCKTYPE", 10);
        configuration.config("rbx.platform.socket.EAI_SYSTEM", 11);
        configuration.config("rbx.platform.socket.IF_NAMESIZE", 0);
        configuration.config("rbx.platform.socket.IFF_802_1Q_VLAN", 0);
        configuration.config("rbx.platform.socket.IFF_ALLMULTI", 0);
        configuration.config("rbx.platform.socket.IFF_ALTPHYS", 0);
        configuration.config("rbx.platform.socket.IFF_AUTOMEDIA", 0);
        configuration.config("rbx.platform.socket.IFF_BONDING", 0);
        configuration.config("rbx.platform.socket.IFF_BRIDGE_PORT", 0);
        configuration.config("rbx.platform.socket.IFF_BROADCAST", 0);
        configuration.config("rbx.platform.socket.IFF_CANTCHANGE", 0);
        configuration.config("rbx.platform.socket.IFF_CANTCONFIG", 0);
        configuration.config("rbx.platform.socket.IFF_DEBUG", 0);
        configuration.config("rbx.platform.socket.IFF_DISABLE_NETPOLL", 0);
        configuration.config("rbx.platform.socket.IFF_DONT_BRIDGE", 0);
        configuration.config("rbx.platform.socket.IFF_DORMANT", 0);
        configuration.config("rbx.platform.socket.IFF_DRV_OACTIVE", 0);
        configuration.config("rbx.platform.socket.IFF_DRV_RUNNING", 0);
        configuration.config("rbx.platform.socket.IFF_DYING", 0);
        configuration.config("rbx.platform.socket.IFF_DYNAMIC", 0);
        configuration.config("rbx.platform.socket.IFF_EBRIDGE", 0);
        configuration.config("rbx.platform.socket.IFF_ECHO", 0);
        configuration.config("rbx.platform.socket.IFF_ISATAP", 0);
        configuration.config("rbx.platform.socket.IFF_LINK0", 0);
        configuration.config("rbx.platform.socket.IFF_LINK1", 0);
        configuration.config("rbx.platform.socket.IFF_LINK2", 0);
        configuration.config("rbx.platform.socket.IFF_LIVE_ADDR_CHANGE", 0);
        configuration.config("rbx.platform.socket.IFF_LOOPBACK", 0);
        configuration.config("rbx.platform.socket.IFF_LOWER_UP", 0);
        configuration.config("rbx.platform.socket.IFF_MACVLAN_PORT", 0);
        configuration.config("rbx.platform.socket.IFF_MASTER", 0);
        configuration.config("rbx.platform.socket.IFF_MASTER_8023AD", 0);
        configuration.config("rbx.platform.socket.IFF_MASTER_ALB", 0);
        configuration.config("rbx.platform.socket.IFF_MASTER_ARPMON", 0);
        configuration.config("rbx.platform.socket.IFF_MONITOR", 0);
        configuration.config("rbx.platform.socket.IFF_MULTICAST", 0);
        configuration.config("rbx.platform.socket.IFF_NOARP", 0);
        configuration.config("rbx.platform.socket.IFF_NOTRAILERS", 0);
        configuration.config("rbx.platform.socket.IFF_OACTIVE", 0);
        configuration.config("rbx.platform.socket.IFF_OVS_DATAPATH", 0);
        configuration.config("rbx.platform.socket.IFF_POINTOPOINT", 0);
        configuration.config("rbx.platform.socket.IFF_PORTSEL", 0);
        configuration.config("rbx.platform.socket.IFF_PPROMISC", 0);
        configuration.config("rbx.platform.socket.IFF_PROMISC", 0);
        configuration.config("rbx.platform.socket.IFF_RENAMING", 0);
        configuration.config("rbx.platform.socket.IFF_ROUTE", 0);
        configuration.config("rbx.platform.socket.IFF_RUNNING", 0);
        configuration.config("rbx.platform.socket.IFF_SIMPLEX", 0);
        configuration.config("rbx.platform.socket.IFF_SLAVE", 0);
        configuration.config("rbx.platform.socket.IFF_SLAVE_INACTIVE", 0);
        configuration.config("rbx.platform.socket.IFF_SLAVE_NEEDARP", 0);
        configuration.config("rbx.platform.socket.IFF_SMART", 0);
        configuration.config("rbx.platform.socket.IFF_STATICARP", 0);
        configuration.config("rbx.platform.socket.IFF_SUPP_NOFCS", 0);
        configuration.config("rbx.platform.socket.IFF_TEAM_PORT", 0);
        configuration.config("rbx.platform.socket.IFF_TX_SKB_SHARING", 0);
        configuration.config("rbx.platform.socket.IFF_UNICAST_FLT", 0);
        configuration.config("rbx.platform.socket.IFF_UP", 0);
        configuration.config("rbx.platform.socket.IFF_VOLATILE", 0);
        configuration.config("rbx.platform.socket.IFF_WAN_HDLC", 0);
        configuration.config("rbx.platform.socket.IFF_XMIT_DST_RELEASE", 0);
        configuration.config("rbx.platform.socket.IFNAMSIZ", 0);
        configuration.config("rbx.platform.socket.INADDR_ALLHOSTS_GROUP", 3758096385L);
        configuration.config("rbx.platform.socket.INADDR_ANY", 0);
        configuration.config("rbx.platform.socket.INADDR_BROADCAST", 4294967295L);
        configuration.config("rbx.platform.socket.INADDR_LOOPBACK", 2130706433);
        configuration.config("rbx.platform.socket.INADDR_MAX_LOCAL_GROUP", 3758096639L);
        configuration.config("rbx.platform.socket.INADDR_NONE", 4294967295L);
        configuration.config("rbx.platform.socket.INADDR_UNSPEC_GROUP", 3758096384L);
        configuration.config("rbx.platform.socket.INET6_ADDRSTRLEN", 46);
        configuration.config("rbx.platform.socket.INET_ADDRSTRLEN", 16);
        configuration.config("rbx.platform.socket.IP_ADD_MEMBERSHIP", 12);
        configuration.config("rbx.platform.socket.IP_ADD_SOURCE_MEMBERSHIP", 70);
        configuration.config("rbx.platform.socket.IP_BLOCK_SOURCE", 72);
        configuration.config("rbx.platform.socket.IP_DEFAULT_MULTICAST_LOOP", 1);
        configuration.config("rbx.platform.socket.IP_DEFAULT_MULTICAST_TTL", 1);
        configuration.config("rbx.platform.socket.IP_DONTFRAG", 0);
        configuration.config("rbx.platform.socket.IP_DROP_MEMBERSHIP", 13);
        configuration.config("rbx.platform.socket.IP_DROP_SOURCE_MEMBERSHIP", 71);
        configuration.config("rbx.platform.socket.IP_FREEBIND", 0);
        configuration.config("rbx.platform.socket.IP_HDRINCL", 2);
        configuration.config("rbx.platform.socket.IP_IPSEC_POLICY", 21);
        configuration.config("rbx.platform.socket.IP_MAX_MEMBERSHIPS", 4095);
        configuration.config("rbx.platform.socket.IP_MINTTL", 0);
        configuration.config("rbx.platform.socket.IP_MSFILTER", 74);
        configuration.config("rbx.platform.socket.IP_MTU", 0);
        configuration.config("rbx.platform.socket.IP_MTU_DISCOVER", 0);
        configuration.config("rbx.platform.socket.IP_MULTICAST_IF", 9);
        configuration.config("rbx.platform.socket.IP_MULTICAST_LOOP", 11);
        configuration.config("rbx.platform.socket.IP_MULTICAST_TTL", 10);
        configuration.config("rbx.platform.socket.IP_ONESBCAST", 0);
        configuration.config("rbx.platform.socket.IP_OPTIONS", 1);
        configuration.config("rbx.platform.socket.IP_PASSSEC", 0);
        configuration.config("rbx.platform.socket.IP_PKTINFO", 26);
        configuration.config("rbx.platform.socket.IP_PKTOPTIONS", 0);
        configuration.config("rbx.platform.socket.IP_PMTUDISC_DO", 0);
        configuration.config("rbx.platform.socket.IP_PMTUDISC_DONT", 0);
        configuration.config("rbx.platform.socket.IP_PMTUDISC_WANT", 0);
        configuration.config("rbx.platform.socket.IP_PORTRANGE", 19);
        configuration.config("rbx.platform.socket.IP_RECVDSTADDR", 7);
        configuration.config("rbx.platform.socket.IP_RECVERR", 0);
        configuration.config("rbx.platform.socket.IP_RECVIF", 20);
        configuration.config("rbx.platform.socket.IP_RECVOPTS", 5);
        configuration.config("rbx.platform.socket.IP_RECVRETOPTS", 6);
        configuration.config("rbx.platform.socket.IP_RECVSLLA", 0);
        configuration.config("rbx.platform.socket.IP_RECVTOS", 0);
        configuration.config("rbx.platform.socket.IP_RECVTTL", 24);
        configuration.config("rbx.platform.socket.IP_RETOPTS", 8);
        configuration.config("rbx.platform.socket.IP_ROUTER_ALERT", 0);
        configuration.config("rbx.platform.socket.IP_SENDSRCADDR", 0);
        configuration.config("rbx.platform.socket.IP_TOS", 3);
        configuration.config("rbx.platform.socket.IP_TTL", 4);
        configuration.config("rbx.platform.socket.IP_UNBLOCK_SOURCE", 73);
        configuration.config("rbx.platform.socket.IP_XFRM_POLICY", 0);
        configuration.config("rbx.platform.socket.IPPORT_RESERVED", 1024);
        configuration.config("rbx.platform.socket.IPPORT_USERRESERVED", 5000);
        configuration.config("rbx.platform.socket.IPPROTO_AH", 51);
        configuration.config("rbx.platform.socket.IPPROTO_BIP", 0);
        configuration.config("rbx.platform.socket.IPPROTO_DSTOPTS", 60);
        configuration.config("rbx.platform.socket.IPPROTO_EGP", 8);
        configuration.config("rbx.platform.socket.IPPROTO_EON", 80);
        configuration.config("rbx.platform.socket.IPPROTO_ESP", 50);
        configuration.config("rbx.platform.socket.IPPROTO_FRAGMENT", 44);
        configuration.config("rbx.platform.socket.IPPROTO_GGP", 3);
        configuration.config("rbx.platform.socket.IPPROTO_HELLO", 63);
        configuration.config("rbx.platform.socket.IPPROTO_HOPOPTS", 0);
        configuration.config("rbx.platform.socket.IPPROTO_ICMP", 1);
        configuration.config("rbx.platform.socket.IPPROTO_ICMPV6", 58);
        configuration.config("rbx.platform.socket.IPPROTO_IDP", 22);
        configuration.config("rbx.platform.socket.IPPROTO_IGMP", 2);
        configuration.config("rbx.platform.socket.IPPROTO_IP", 0);
        configuration.config("rbx.platform.socket.IPPROTO_IPV6", 41);
        configuration.config("rbx.platform.socket.IPPROTO_MAX", 256);
        configuration.config("rbx.platform.socket.IPPROTO_ND", 77);
        configuration.config("rbx.platform.socket.IPPROTO_NONE", 59);
        configuration.config("rbx.platform.socket.IPPROTO_PUP", 12);
        configuration.config("rbx.platform.socket.IPPROTO_RAW", 255);
        configuration.config("rbx.platform.socket.IPPROTO_ROUTING", 43);
        configuration.config("rbx.platform.socket.IPPROTO_TCP", 6);
        configuration.config("rbx.platform.socket.IPPROTO_TP", 29);
        configuration.config("rbx.platform.socket.IPPROTO_UDP", 17);
        configuration.config("rbx.platform.socket.IPPROTO_XTP", 36);
        configuration.config("rbx.platform.socket.IPV6_CHECKSUM", 26);
        configuration.config("rbx.platform.socket.IPV6_DONTFRAG", 0);
        configuration.config("rbx.platform.socket.IPV6_DSTOPTS", 0);
        configuration.config("rbx.platform.socket.IPV6_HOPLIMIT", 0);
        configuration.config("rbx.platform.socket.IPV6_HOPOPTS", 0);
        configuration.config("rbx.platform.socket.IPV6_JOIN_GROUP", 12);
        configuration.config("rbx.platform.socket.IPV6_LEAVE_GROUP", 13);
        configuration.config("rbx.platform.socket.IPV6_MULTICAST_HOPS", 10);
        configuration.config("rbx.platform.socket.IPV6_MULTICAST_IF", 9);
        configuration.config("rbx.platform.socket.IPV6_MULTICAST_LOOP", 11);
        configuration.config("rbx.platform.socket.IPV6_NEXTHOP", 0);
        configuration.config("rbx.platform.socket.IPV6_PATHMTU", 0);
        configuration.config("rbx.platform.socket.IPV6_PKTINFO", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVDSTOPTS", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVHOPLIMIT", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVHOPOPTS", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVPATHMTU", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVPKTINFO", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVRTHDR", 0);
        configuration.config("rbx.platform.socket.IPV6_RECVTCLASS", 35);
        configuration.config("rbx.platform.socket.IPV6_RTHDR", 0);
        configuration.config("rbx.platform.socket.IPV6_RTHDR_TYPE_0", 0);
        configuration.config("rbx.platform.socket.IPV6_RTHDRDSTOPTS", 0);
        configuration.config("rbx.platform.socket.IPV6_TCLASS", 36);
        configuration.config("rbx.platform.socket.IPV6_UNICAST_HOPS", 4);
        configuration.config("rbx.platform.socket.IPV6_USE_MIN_MTU", 0);
        configuration.config("rbx.platform.socket.IPV6_V6ONLY", 27);
        configuration.config("rbx.platform.socket.IPX_TYPE", 0);
        configuration.config("rbx.platform.socket.LOCAL_CONNWAIT", 0);
        configuration.config("rbx.platform.socket.LOCAL_CREDS", 0);
        configuration.config("rbx.platform.socket.LOCAL_PEERCRED", 0);
        configuration.config("rbx.platform.socket.MCAST_BLOCK_SOURCE", 84);
        configuration.config("rbx.platform.socket.MCAST_EXCLUDE", 2);
        configuration.config("rbx.platform.socket.MCAST_INCLUDE", 1);
        configuration.config("rbx.platform.socket.MCAST_JOIN_GROUP", 80);
        configuration.config("rbx.platform.socket.MCAST_JOIN_SOURCE_GROUP", 82);
        configuration.config("rbx.platform.socket.MCAST_LEAVE_GROUP", 81);
        configuration.config("rbx.platform.socket.MCAST_LEAVE_SOURCE_GROUP", 83);
        configuration.config("rbx.platform.socket.MCAST_MSFILTER", 0);
        configuration.config("rbx.platform.socket.MCAST_UNBLOCK_SOURCE", 85);
        configuration.config("rbx.platform.socket.MSG_COMPAT", 0);
        configuration.config("rbx.platform.socket.MSG_CONFIRM", 0);
        configuration.config("rbx.platform.socket.MSG_CTRUNC", 32);
        configuration.config("rbx.platform.socket.MSG_DONTROUTE", 4);
        configuration.config("rbx.platform.socket.MSG_DONTWAIT", 128);
        configuration.config("rbx.platform.socket.MSG_EOF", 256);
        configuration.config("rbx.platform.socket.MSG_EOR", 8);
        configuration.config("rbx.platform.socket.MSG_ERRQUEUE", 0);
        configuration.config("rbx.platform.socket.MSG_FASTOPEN", 0);
        configuration.config("rbx.platform.socket.MSG_FIN", 0);
        configuration.config("rbx.platform.socket.MSG_FLUSH", 1024);
        configuration.config("rbx.platform.socket.MSG_HAVEMORE", 8192);
        configuration.config("rbx.platform.socket.MSG_HOLD", 2048);
        configuration.config("rbx.platform.socket.MSG_MORE", 0);
        configuration.config("rbx.platform.socket.MSG_NOSIGNAL", 0);
        configuration.config("rbx.platform.socket.MSG_OOB", 1);
        configuration.config("rbx.platform.socket.MSG_PEEK", 2);
        configuration.config("rbx.platform.socket.MSG_PROXY", 0);
        configuration.config("rbx.platform.socket.MSG_RCVMORE", 16384);
        configuration.config("rbx.platform.socket.MSG_RST", 0);
        configuration.config("rbx.platform.socket.MSG_SEND", 4096);
        configuration.config("rbx.platform.socket.MSG_SYN", 0);
        configuration.config("rbx.platform.socket.MSG_TRUNC", 16);
        configuration.config("rbx.platform.socket.MSG_WAITALL", 64);
        configuration.config("rbx.platform.socket.NI_DGRAM", 16);
        configuration.config("rbx.platform.socket.NI_MAXHOST", 1025);
        configuration.config("rbx.platform.socket.NI_MAXSERV", 32);
        configuration.config("rbx.platform.socket.NI_NAMEREQD", 4);
        configuration.config("rbx.platform.socket.NI_NOFQDN", 1);
        configuration.config("rbx.platform.socket.NI_NUMERICHOST", 2);
        configuration.config("rbx.platform.socket.NI_NUMERICSERV", 8);
        configuration.config("rbx.platform.socket.PF_APPLETALK", 16);
        configuration.config("rbx.platform.socket.PF_ATM", 0);
        configuration.config("rbx.platform.socket.PF_AX25", 0);
        configuration.config("rbx.platform.socket.PF_CCITT", 10);
        configuration.config("rbx.platform.socket.PF_CHAOS", 5);
        configuration.config("rbx.platform.socket.PF_CNT", 21);
        configuration.config("rbx.platform.socket.PF_COIP", 20);
        configuration.config("rbx.platform.socket.PF_DATAKIT", 9);
        configuration.config("rbx.platform.socket.PF_DEC", 0);
        configuration.config("rbx.platform.socket.PF_DLI", 13);
        configuration.config("rbx.platform.socket.PF_ECMA", 8);
        configuration.config("rbx.platform.socket.PF_HYLINK", 15);
        configuration.config("rbx.platform.socket.PF_IMPLINK", 3);
        configuration.config("rbx.platform.socket.PF_INET", 2);
        configuration.config("rbx.platform.socket.PF_INET6", 30);
        configuration.config("rbx.platform.socket.PF_IPX", 23);
        configuration.config("rbx.platform.socket.PF_ISDN", 28);
        configuration.config("rbx.platform.socket.PF_ISO", 7);
        configuration.config("rbx.platform.socket.PF_KEY", 29);
        configuration.config("rbx.platform.socket.PF_LAT", 14);
        configuration.config("rbx.platform.socket.PF_LINK", 18);
        configuration.config("rbx.platform.socket.PF_LOCAL", 1);
        configuration.config("rbx.platform.socket.PF_MAX", 40);
        configuration.config("rbx.platform.socket.PF_NATM", 31);
        configuration.config("rbx.platform.socket.PF_NDRV", 27);
        configuration.config("rbx.platform.socket.PF_NETBIOS", 33);
        configuration.config("rbx.platform.socket.PF_NETGRAPH", 0);
        configuration.config("rbx.platform.socket.PF_NS", 6);
        configuration.config("rbx.platform.socket.PF_OSI", 7);
        configuration.config("rbx.platform.socket.PF_PACKET", 0);
        configuration.config("rbx.platform.socket.PF_PIP", 25);
        configuration.config("rbx.platform.socket.PF_PPP", 34);
        configuration.config("rbx.platform.socket.PF_PUP", 4);
        configuration.config("rbx.platform.socket.PF_ROUTE", 17);
        configuration.config("rbx.platform.socket.PF_RTIP", 22);
        configuration.config("rbx.platform.socket.PF_SIP", 24);
        configuration.config("rbx.platform.socket.PF_SNA", 11);
        configuration.config("rbx.platform.socket.PF_SYSTEM", 32);
        configuration.config("rbx.platform.socket.PF_UNIX", 1);
        configuration.config("rbx.platform.socket.PF_UNSPEC", 0);
        configuration.config("rbx.platform.socket.PF_XTP", 19);
        configuration.config("rbx.platform.socket.SCM_BINTIME", 0);
        configuration.config("rbx.platform.socket.SCM_CREDENTIALS", 0);
        configuration.config("rbx.platform.socket.SCM_CREDS", 3);
        configuration.config("rbx.platform.socket.SCM_RIGHTS", 1);
        configuration.config("rbx.platform.socket.SCM_TIMESTAMP", 2);
        configuration.config("rbx.platform.socket.SCM_TIMESTAMPNS", 0);
        configuration.config("rbx.platform.socket.SCM_UCRED", 0);
        configuration.config("rbx.platform.socket.SHUT_RD", 0);
        configuration.config("rbx.platform.socket.SHUT_RDWR", 2);
        configuration.config("rbx.platform.socket.SHUT_WR", 1);
        configuration.config("rbx.platform.socket.SO_ACCEPTCONN", 2);
        configuration.config("rbx.platform.socket.SO_ACCEPTFILTER", 0);
        configuration.config("rbx.platform.socket.SO_ALLZONES", 0);
        configuration.config("rbx.platform.socket.SO_ATTACH_FILTER", 0);
        configuration.config("rbx.platform.socket.SO_BINDTODEVICE", 0);
        configuration.config("rbx.platform.socket.SO_BINTIME", 0);
        configuration.config("rbx.platform.socket.SO_BROADCAST", 32);
        configuration.config("rbx.platform.socket.SO_DEBUG", 1);
        configuration.config("rbx.platform.socket.SO_DETACH_FILTER", 0);
        configuration.config("rbx.platform.socket.SO_DONTROUTE", 16);
        configuration.config("rbx.platform.socket.SO_DONTTRUNC", 8192);
        configuration.config("rbx.platform.socket.SO_ERROR", 4103);
        configuration.config("rbx.platform.socket.SO_KEEPALIVE", 8);
        configuration.config("rbx.platform.socket.SO_LINGER", 128);
        configuration.config("rbx.platform.socket.SO_MAC_EXEMPT", 0);
        configuration.config("rbx.platform.socket.SO_NKE", 4129);
        configuration.config("rbx.platform.socket.SO_NO_CHECK", 0);
        configuration.config("rbx.platform.socket.SO_NOSIGPIPE", 4130);
        configuration.config("rbx.platform.socket.SO_NREAD", 4128);
        configuration.config("rbx.platform.socket.SO_OOBINLINE", 256);
        configuration.config("rbx.platform.socket.SO_PASSCRED", 0);
        configuration.config("rbx.platform.socket.SO_PEERCRED", 0);
        configuration.config("rbx.platform.socket.SO_PEERNAME", 0);
        configuration.config("rbx.platform.socket.SO_PRIORITY", 0);
        configuration.config("rbx.platform.socket.SO_RCVBUF", 4098);
        configuration.config("rbx.platform.socket.SO_RCVLOWAT", 4100);
        configuration.config("rbx.platform.socket.SO_RCVTIMEO", 4102);
        configuration.config("rbx.platform.socket.SO_RECVUCRED", 0);
        configuration.config("rbx.platform.socket.SO_REUSEADDR", 4);
        configuration.config("rbx.platform.socket.SO_REUSEPORT", 512);
        configuration.config("rbx.platform.socket.SO_SECURITY_AUTHENTICATION", 0);
        configuration.config("rbx.platform.socket.SO_SECURITY_ENCRYPTION_NETWORK", 0);
        configuration.config("rbx.platform.socket.SO_SECURITY_ENCRYPTION_TRANSPORT", 0);
        configuration.config("rbx.platform.socket.SO_SNDBUF", 4097);
        configuration.config("rbx.platform.socket.SO_SNDLOWAT", 4099);
        configuration.config("rbx.platform.socket.SO_SNDTIMEO", 4101);
        configuration.config("rbx.platform.socket.SO_TIMESTAMP", 1024);
        configuration.config("rbx.platform.socket.SO_TIMESTAMPNS", 0);
        configuration.config("rbx.platform.socket.SO_TYPE", 4104);
        configuration.config("rbx.platform.socket.SO_USELOOPBACK", 64);
        configuration.config("rbx.platform.socket.SO_WANTMORE", 16384);
        configuration.config("rbx.platform.socket.SO_WANTOOBFLAG", 32768);
        configuration.config("rbx.platform.socket.SOCK_DGRAM", 2);
        configuration.config("rbx.platform.socket.SOCK_PACKET", 0);
        configuration.config("rbx.platform.socket.SOCK_RAW", 3);
        configuration.config("rbx.platform.socket.SOCK_RDM", 4);
        configuration.config("rbx.platform.socket.SOCK_SEQPACKET", 5);
        configuration.config("rbx.platform.socket.SOCK_STREAM", 1);
        configuration.config("rbx.platform.socket.SOL_ATALK", 0);
        configuration.config("rbx.platform.socket.SOL_AX25", 0);
        configuration.config("rbx.platform.socket.SOL_IP", 0);
        configuration.config("rbx.platform.socket.SOL_IPX", 0);
        configuration.config("rbx.platform.socket.SOL_SOCKET", 65535);
        configuration.config("rbx.platform.socket.SOL_TCP", 0);
        configuration.config("rbx.platform.socket.SOL_UDP", 0);
        configuration.config("rbx.platform.socket.SOMAXCONN", 128);
        configuration.config("rbx.platform.socket.SOPRI_BACKGROUND", 0);
        configuration.config("rbx.platform.socket.SOPRI_INTERACTIVE", 0);
        configuration.config("rbx.platform.socket.SOPRI_NORMAL", 0);
        configuration.config("rbx.platform.socket.TCP_CORK", 0);
        configuration.config("rbx.platform.socket.TCP_DEFER_ACCEPT", 0);
        configuration.config("rbx.platform.socket.TCP_FASTOPEN", 0);
        configuration.config("rbx.platform.socket.TCP_INFO", 0);
        configuration.config("rbx.platform.socket.TCP_KEEPCNT", 258);
        configuration.config("rbx.platform.socket.TCP_KEEPIDLE", 0);
        configuration.config("rbx.platform.socket.TCP_KEEPINTVL", 257);
        configuration.config("rbx.platform.socket.TCP_LINGER2", 0);
        configuration.config("rbx.platform.socket.TCP_MAXSEG", 2);
        configuration.config("rbx.platform.socket.TCP_MD5SIG", 0);
        configuration.config("rbx.platform.socket.TCP_NODELAY", 1);
        configuration.config("rbx.platform.socket.TCP_NOOPT", 8);
        configuration.config("rbx.platform.socket.TCP_NOPUSH", 4);
        configuration.config("rbx.platform.socket.TCP_QUICKACK", 0);
        configuration.config("rbx.platform.socket.TCP_SYNCNT", 0);
        configuration.config("rbx.platform.socket.TCP_WINDOW_CLAMP", 0);
        configuration.config("rbx.platform.socket.UDP_CORK", 0);
        configuration.config("rbx.platform.process.EXIT_SUCCESS", 0);
        configuration.config("rbx.platform.process.EXIT_FAILURE", 1);
        configuration.config("rbx.platform.process.WNOHANG", 1);
        configuration.config("rbx.platform.process.WUNTRACED", 2);
        configuration.config("rbx.platform.process.PRIO_PROCESS", 0);
        configuration.config("rbx.platform.process.PRIO_PGRP", 1);
        configuration.config("rbx.platform.process.PRIO_USER", 2);
        configuration.config("rbx.platform.process.RLIMIT_CPU", 0);
        configuration.config("rbx.platform.process.RLIMIT_FSIZE", 1);
        configuration.config("rbx.platform.process.RLIMIT_DATA", 2);
        configuration.config("rbx.platform.process.RLIMIT_STACK", 3);
        configuration.config("rbx.platform.process.RLIMIT_CORE", 4);
        configuration.config("rbx.platform.process.RLIMIT_RSS", 5);
        configuration.config("rbx.platform.process.RLIMIT_NPROC", 7);
        configuration.config("rbx.platform.process.RLIMIT_NOFILE", 8);
        configuration.config("rbx.platform.process.RLIMIT_MEMLOCK", 6);
        configuration.config("rbx.platform.process.RLIMIT_AS", 5);
        configuration.config("rbx.platform.process.RLIMIT_SBSIZE", 0);
        configuration.config("rbx.platform.process.RLIMIT_RTPRIO", 0);
        configuration.config("rbx.platform.process.RLIMIT_RTTIME", 0);
        configuration.config("rbx.platform.process.RLIMIT_SIGPENDING", 0);
        configuration.config("rbx.platform.process.RLIMIT_MSGQUEUE", 0);
        configuration.config("rbx.platform.process.RLIMIT_NICE", 0);
        configuration.config("rbx.platform.process.RLIM_INFINITY", 9223372036854775807L);
        configuration.config("rbx.platform.process.RLIM_SAVED_MAX", 9223372036854775807L);
        configuration.config("rbx.platform.process.RLIM_SAVED_CUR", 9223372036854775807L);
        configuration.config("rbx.platform.signal.SIGHUP", 1);
        configuration.config("rbx.platform.signal.SIGINT", 2);
        configuration.config("rbx.platform.signal.SIGQUIT", 3);
        configuration.config("rbx.platform.signal.SIGILL", 4);
        configuration.config("rbx.platform.signal.SIGTRAP", 5);
        configuration.config("rbx.platform.signal.SIGIOT", 6);
        configuration.config("rbx.platform.signal.SIGABRT", 6);
        configuration.config("rbx.platform.signal.SIGEMT", 7);
        configuration.config("rbx.platform.signal.SIGFPE", 8);
        configuration.config("rbx.platform.signal.SIGKILL", 9);
        configuration.config("rbx.platform.signal.SIGBUS", 10);
        configuration.config("rbx.platform.signal.SIGSEGV", 11);
        configuration.config("rbx.platform.signal.SIGSYS", 12);
        configuration.config("rbx.platform.signal.SIGPIPE", 13);
        configuration.config("rbx.platform.signal.SIGALRM", 14);
        configuration.config("rbx.platform.signal.SIGTERM", 15);
        configuration.config("rbx.platform.signal.SIGURG", 16);
        configuration.config("rbx.platform.signal.SIGSTOP", 17);
        configuration.config("rbx.platform.signal.SIGTSTP", 18);
        configuration.config("rbx.platform.signal.SIGCONT", 19);
        configuration.config("rbx.platform.signal.SIGCHLD", 20);
        configuration.config("rbx.platform.signal.SIGCLD", 0);
        configuration.config("rbx.platform.signal.SIGTTIN", 21);
        configuration.config("rbx.platform.signal.SIGTTOU", 22);
        configuration.config("rbx.platform.signal.SIGIO", 23);
        configuration.config("rbx.platform.signal.SIGXCPU", 24);
        configuration.config("rbx.platform.signal.SIGXFSZ", 25);
        configuration.config("rbx.platform.signal.SIGVTALRM", 26);
        configuration.config("rbx.platform.signal.SIGPROF", 27);
        configuration.config("rbx.platform.signal.SIGWINCH", 28);
        configuration.config("rbx.platform.signal.SIGUSR1", 30);
        configuration.config("rbx.platform.signal.SIGUSR2", 31);
        configuration.config("rbx.platform.signal.SIGLOST", 0);
        configuration.config("rbx.platform.signal.SIGMSG", 0);
        configuration.config("rbx.platform.signal.SIGPWR", 0);
        configuration.config("rbx.platform.signal.SIGPOLL", 0);
        configuration.config("rbx.platform.signal.SIGDANGER", 0);
        configuration.config("rbx.platform.signal.SIGMIGRATE", 0);
        configuration.config("rbx.platform.signal.SIGPRE", 0);
        configuration.config("rbx.platform.signal.SIGGRANT", 0);
        configuration.config("rbx.platform.signal.SIGRETRACT", 0);
        configuration.config("rbx.platform.signal.SIGSOUND", 0);
        configuration.config("rbx.platform.signal.SIGINFO", 29);
        configuration.config("rbx.platform.zlib.ZLIB_VERSION", string(context, "1.2.5"));
        configuration.config("rbx.platform.dlopen.RTLD_LAZY", 1);
        configuration.config("rbx.platform.dlopen.RTLD_NOW", 2);
        configuration.config("rbx.platform.dlopen.RTLD_LOCAL", 4);
        configuration.config("rbx.platform.dlopen.RTLD_GLOBAL", 8);
        configuration.config("rbx.platform.typedef.int8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.int32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int64_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.uint8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.int_least8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int_least16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.int_least32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int_least64_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.uint_least8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint_least16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint_least32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint_least64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.int_fast8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int_fast16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.int_fast32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int_fast64_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.uint_fast8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint_fast16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint_fast32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint_fast64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.__int8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.__uint8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.__int16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.__uint16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.__int32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__uint32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__int64_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.__uint64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.__darwin_intptr_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.__darwin_natural_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_ct_rune_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_ptrdiff_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.__darwin_size_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.__darwin_wchar_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_rune_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_wint_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_clock_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.__darwin_socklen_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_ssize_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.__darwin_time_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.__darwin_blkcnt_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.__darwin_blksize_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_dev_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_fsblkcnt_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_fsfilcnt_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_gid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_id_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_ino64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.__darwin_ino_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.__darwin_mach_port_name_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_mach_port_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_mode_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.__darwin_off_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.__darwin_pid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_sigset_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_suseconds_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.__darwin_uid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_useconds_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.__darwin_pthread_key_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.intptr_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uintptr_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.intmax_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uintmax_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.u_int8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.u_int16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.u_int32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.u_int64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.register_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.user_addr_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.user_size_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.user_ssize_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.user_long_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.user_ulong_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.user_time_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.user_off_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.syscall_arg_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.u_char", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.u_short", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.u_int", string(context, "uint"));
        configuration.config("rbx.platform.typedef.u_long", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.ushort", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint", string(context, "uint"));
        configuration.config("rbx.platform.typedef.u_quad_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.quad_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.qaddr_t", string(context, "pointer"));
        configuration.config("rbx.platform.typedef.caddr_t", string(context, "string"));
        configuration.config("rbx.platform.typedef.daddr_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.dev_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.fixpt_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.blkcnt_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.blksize_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.gid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.in_addr_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.in_port_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.ino_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.ino64_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.key_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.mode_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.nlink_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.id_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.pid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.off_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.segsz_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.swblk_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.uid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.clock_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.size_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.ssize_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.time_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.useconds_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.suseconds_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.rsize_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.errno_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.fd_mask", string(context, "int"));
        configuration.config("rbx.platform.typedef.pthread_key_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.fsblkcnt_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.fsfilcnt_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.sa_family_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.socklen_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.rlim_t", string(context, "ulong_long"));
    }

}
