/*
 * Copyright (c) 2013, 2015 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.Node;
import org.joda.time.DateTime;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;

public class RubyTime extends RubyBasicObject {

    private DateTime dateTime;
    private Object offset;

    private static final DateTime ZERO = new DateTime(0);

    public RubyTime(RubyClass timeClass, DateTime dateTime, Object offset) {
        super(timeClass);
        this.dateTime = dateTime;
        assert offset != null;
        this.offset = offset;
    }

    public static class TimeAllocator implements Allocator {

        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyTime(rubyClass, ZERO, context.getCoreLibrary().getNilObject());
        }

    }

    public DateTime getDateTime() {
        return dateTime;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public Object getOffset() {
        return offset;
    }

    public void setOffset(Object offset) {
        assert offset != null;
        this.offset = offset;
    }

}
