package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          304,   96,  307,  287,  287,  353,  377,  287,  306,  424, 
           88,   88,  134,  134,   83,   83,  213,  249,  249,  249, 
          674,  227,  275,  249,  249,  301,  300,  249,  229,  747, 
          644,  462,  627,  633,  694,  484,  351,  640,  573,  637, 
          259,  227,  214,  214,  713,  523,  328,  332,  229,  525, 
          637,  253,  256,   88,  700,  133,  133,  349,  722,  249, 
          637,  668,  359,  214,  495,  133,  303,  740,  673,  107, 
          291,  291,  388,  624,  291,  627,  633,  547,  569,  600, 
          290,  290,  691,  713,  290,  394,  515,  516,  214,  668, 
          808,  637,  432,  255,  625,   83,  705,  637,  770,  637, 
          133,  712,  330,  334,  712,  255,  415,  349,  830,  637, 
          430,  429,  329,  562,  637,  444,  573,  300,  657,  873, 
          772,  323,  837,  562,  668,  821,  547,  637,  511,  875, 
          868,  779,   75,  259,  568,  831,  249,    8,   88,  833, 
          946,  429,  254,  428,  862,  737,   83,    8,  668,  568, 
          133,  943,  520,  849,  254,  736, 1032,  637,  520,  313, 
          255,  441,  296,  637,  577,  781,  759,  344,  889,  102, 
          102,  375,  311,  568,  575,  562,  637,  533,  534,  577, 
          255,  774,  600,   75,  536,  562,  519,   74,  637,  541, 
          383,  384,  522,  638,  273,   81,    8,  533,  534,  535, 
          595,  375,  381,  820,  536,  464,  637,  568,  575,  254, 
          275,  375,  102,  411,  775,  637,  344,  747,  859,  274, 
           73,   86,  568,  575,  562,  374,  379,  573,  585,  254, 
          299,  600,   79,  651,  595,  760,  484, 1014,   72,   76, 
          382,   88,  807,  433,  377, 1032,   81,  714,   84,  595, 
          380,  375,  376,  813,  378,  718,  719,  637,  527,  376, 
          901,  299,  585,   77,  637,  801,  906,  751,  249,  249, 
          437,   71,  435,  727,  303,  964,  436,  585,  713,  576, 
          410,  845,  376,   79,  287,  259,  287,  287,  561,  562, 
           76,  632,  376,  946,  576,  110,  587,  102,  490,   84, 
          314,  467,  468,   82,  249,  873,  249,  249, 1047,  632, 
          249,  587,  249,  314,   77,  497,  410,   88,  303,   86, 
          875,  445,  873,   88,  868,   88,  309,  509,  314,  364, 
          747,  366,  747,  410,  249,  548,   72,  712,  712,  438, 
          549, 1077,  370,  413,  110,  573,  916,   80,  259,  410, 
          414,  291,  442,  291,   82,  286,  349,  372,  514,  443, 
          314,  290,  453,  290,   83,  823,  820,  637,  637,  562, 
          445,  388,  547,  641,  816,  645,  510, 1006,  600,  655, 
          659,  637,  498,  499,  394,  811,  249,  249,  249,  249, 
           88,  249,  249,  323,  594,  562,  302,  960,   80,  133, 
          102,   75,  637,  287,  968,  533,  534,  644,  547,  972, 
          653,  873,  536,  800,  490,  914,  747, 1016,  629,  590, 
          591,  592,  593,  249,  938,  637,   83,  249,  637,  249, 
           88,  349,  287,  249,  249,  624,   88,  810,  562,  439, 
           83,  547,  527,  490,  637,  847,  287,  629,  568,  682, 
          635,  697,  249,   88,  249,  841,  625,  490,  533,  534, 
          287,  629,   88,   75,   81,  536,  249,  665,  568,  575, 
           88,  490,  637,  834,  133,  629,  102,  600,  577,  635, 
          249,  720,  102,  843,  102,  747,  650,  747,  637, 1083, 
          650,  846,  985,  635,  661,  595,  699,  699,  323,    8, 
          713,   79,   96,  311,  568,  575, 1008,  635,   76,  249, 
          629,   88,  861,  600,  227,   83,  562,   84,   74,  287, 
          747,  229,   88,  585,  638,  273,   81,  638,  273,  695, 
          490,  595,   77,  381,  629,  711,  214,  568,  575,  249, 
          349,  275,  635,  637,  275,   78,  600, 1060,  595,  102, 
          274,   73,  110,  274,   72,  318,  374,  379,  255,  585, 
          712, 1038,  527,   79,  595,  612,  635,  458,  757,   53, 
           76,  382,   82,  920,  730,  377,  585,  427,  445,   84, 
          411,  380,  375,  133,  672,  378,  841,  778,  778,  102, 
          376,  573,  585,  576,   77,  102,   78,  314,  383,  384, 
          419,  416,  637,  103,  314,  763,  765,  254,  417,  616, 
          587,  793,  102,  510,  637,  637,   80,  385,  637,  942, 
          510,  102,  778,  420,  421,  612,  787,  314,  637,  102, 
          586,  785,  784,  425,   82,  587,  637,  791,  790,  787, 
          318,  848,  122,  426,  794,  784,  612,  793,  400,  445, 
          435,  637,  402,  403,  302,  106,  106,  449,  452,  668, 
          349,  815,  106,  106,  106,  793, 1072,  787,  106,  106, 
          102,  459,  106,  784,  249,   88,  790,  637,   80,  793, 
          819,  102,  822,  637,  822,  637,   88,  461,  460,  814, 
          476,  122,  822,  805,  227,  476,  472,  464,  106,  116, 
          478,  229, 1003,  133,  106,  478,  812,  806, 1005,  466, 
          793,  858,  527,  469,  249,  214,  214,  288,  294,  473, 
          479,  295,  458,  435,  480,   96,   97,  909,  483,  463, 
           17,  503,  637,  385,   88,  507,  897,  899,   83,  349, 
          512,  508,  902,  904,  518,  637,  650,  838,  116,  524, 
          757,  115,  645,  531,  895,  851,  852,  532,  853,  526, 
           97, 1015,  543,  247,  247,  247,  547,   88,   88,  637, 
          637,  842,  444,  582,  757,  637,  654,   97,  585,   17, 
          516,  106,  133,  106,  662,   88,  501,   88,  681,   88, 
          249,  249,  513,  684,  637,  686,  249,  249,  696,  715, 
          115,  716,  717,  778,  456,  723,  249,  516,  731,  726, 
          349,  457,  742,  743,   78,  453,  754,  925,  752,  504, 
          929,  753,   59,   60,  756,  762,  103,  318,   88, 1042, 
          113,  249,  515,  764,  102,  918,  286,  286,  122,  435, 
          286,  766,   88,   88,   88,  102,  768,  533,  534,  538, 
          533,  534,  538,  133,  536,   97,  769,  536,  107,  637, 
          103,  981,  310,  312,  930,  773,  798,  699,  286,  286, 
          782,  352,  354,  126,   96,  707,   78,  103,  783,  113, 
          555,  757,  434,  788,  789,  556,  106,  435,  799,  107, 
          637,   98,  107,  102,  435,  637,  802,  949,  809,  122, 
          976,  826,  516,  827,  820,  954,  956,  435,  958,  107, 
          959,  513,  435,  106,  106,  249,  832,  561,  562,  828, 
          435,  515,  126,  829,   88,   88,  102,  102,  860,  844, 
          907, 1000,  318,  470,  822,   88,  314,  637,  517,  314, 
          471,  637,  637,  133,  102,  908,  102,  919,  102,  106, 
          921,  106,  106,  923,  314,  106,  116,  106,  927,  505, 
          435,  563,  106,  931,  685,  932,  506,  435,  106, 1022, 
          106,  933,  693,  744,  133,  551,  552,  553,  554,  106, 
           16,  939,   17,   17,   17,  940,  944,  102,   17,   17, 
          529,   17,  947,  435,   88,   97,  948,  530,  485,  637, 
          488,  102,  102,  102,  637,  950,  637,  951,  115,  442, 
          952,   88,  133,   88,  247,  247, 1034,  516,  953,   88, 
           88,  955,  957,  744,  516,  551,  552,  553,  554,   16, 
          287,  106,  106,  106,  106,  106,  106,  106,  962,  965, 
          961,  490,  682,  822,  516,  629,  793,  967,  969,  971, 
          249,  516, 1049, 1051, 1052, 1053,  494,   97,  496,  117, 
          977,   17,  978,  979,  123,  980, 1040,  205,  106,  515, 
          635, 1009,  106, 1041,  106,  106,  515,  635,  106,  106, 
          517,  106,   17,  102,  102, 1013, 1025,  113, 1010, 1033, 
          116, 1036, 1037, 1039,  102,  103,  435,  106,  106,  106, 
          613,  286,  286,  286,  354, 1048,  286,  106,  117,  115, 
         1050,  106, 1084,  123,   17,  106,  205,  286, 1054,  286, 
          286, 1056, 1058, 1061,  126,  106,  117,  107,  502, 1067, 
          126, 1075,  247,  247,  247,  247, 1076,  595,  596,  516, 
          517, 1086,  624,  637,  435,  615,  516,  637,  513,  626, 
          625,  435,  630,  102,  106,  513,  106,  103,  515,  626, 
          613,  632,   95,   95,  630,  515,  637,  106,  637,  626, 
          102,  637,  102,  314,  277,  517,  314,  435,  102,  102, 
          314,  613,  517,  314,  106,  616,  626,  448,  616,  107, 
          374,  314,  533,  534,  540,  637,  477,  362,  314,  536, 
          675,  137,  125,  616,  728,   95,  597,  598,  599,  600, 
          601,  602,  603,  604,  605,  606,  607,  608,  609,  610, 
          611,  612,  613,  614,  615,  616,  617,  618,  619,  620, 
          621,  584,   16,   16,   16, 1074,  286,  216,   16,   16, 
          642,   16,  646,   96,  637,  986,  286,  660,  795,  872, 
           99,  125,  533,  534,  544,  721,  884,  877, 1028,  536, 
           92,   92,  135,  135,  910,  286,  124, 1027,  278,  869, 
          870, 1073,  276,    0,  118,  857, 1017,   96,    0,  286, 
          642,  692,  660,  616,    0,  286,    0,  893,    0,  894, 
           95,  896,    0,  286,   96,    0,    0,  518,    0,    0, 
          286,  286,    0,   92,  286,  120,    0,  350,    0,  119, 
            0,   16,    0,    0,  331,  124,  117,    0,    0,  106, 
          106,  123,    0,  118,  515,    0,    0,    0,  724,  725, 
          926,  106,   16,    0,  615,  533,  534,  583,    0,    0, 
          286,    0,  536,  286,  935,  936,  937,  619,    0,    0, 
            0,  101,  286,    0,  120,  518,    0,  350,  119,  106, 
            0,    0,    0,  205,   16,  205,  205,  205,  205,  205, 
            0,  482,  482,  482,  205,  121,   91,  517,  482,  106, 
          112,    0,  615,    0,  517,  516,  520,    0,   92,  615, 
          519,  100,  516,   95,  615,    0,  205,  205,  520,    0, 
            0,    0,  286,    0,  205,  205,  205,  205,    0,    0, 
           91,    0,  106,  106,  111,  615,  464,  464,  464,    0, 
          247,  294,    0,  464,  121,    0,  984,   91,    0,  112, 
          106,  294,  106,   98,  106,  106,  106, 1004,  519,    0, 
            0,  106,  106,  780,    0,    0,    0,  637,  637,  637, 
          205,  106,    0,    0,  637,    0,  521,  510,    0,  125, 
          247,  512,  114,  111,  286,  287,    0,   98,    0,   95, 
            0,    0,  616,  106,   94,   95,  106,   95,    0,    0, 
          294,    0,    0,    0,   98,  118,  510,  106,  106,  106, 
            0,   92,  470,  470,  470,  511,    0,    0,    0,  470, 
            0,  510,  286,    0,    0,  102,    0,   93,   94,    0, 
            0,  114,   96, 1043,  517, 1044,   61,   62,   63,   64, 
          616, 1045, 1046,  124,    0,   94,    0,  616,  286,    0, 
          286,  118,  616,  510,  518,    0,  619,  286,  286,    0, 
          128,  518,   95,  514,    0,    0,  474,  475,  476,  244, 
            0,  478,  521,  616,  512,  513,    0,    0,    0,  244, 
          106,  515,  120,    0,  286,    0,  119,   92,  515,  106, 
          106,    0,    0,   92,   96,   92,  127,  247,    0,    0, 
          106,  649,   95,    0,  619,    0,  120,    0,   95,  128, 
            0,  619,  518,  244,    0,    0,  615,   92,    0,  518, 
            0,    0,    0,  898,  900,   95,  350,  244,  244,  903, 
          905,    0,  244,    0,   95,    0,    0,  619,  911,  692, 
          286,  304,   95,  520,  915,  127,  119,  519,   99,    0, 
          520,    0,  121,    0,  519,  520,    0,  112,    0,  106, 
           92,    0,  520,    0,  511,   91,  612,  898,  900,  903, 
          905,    0,    0,    0,  286,    0,  106,  315,  106,    0, 
            0,    0,   99,   95,  106,  106,  378,  379,  380,  381, 
          382,  111,    0,    0,   95,  519,    0,    0,    0,   99, 
           92,  350,  519,  294,  294,  294,   92,  648,  294,  294, 
          294,  658,  294,  521,  510,  106,    0,    0,  512,    0, 
          521,  510,   98,   92,    0,  512,  612,   91,    0,  518, 
            0,    0,   92,  756,  294,  294,  294,  294,  294,  114, 
           92,   95,  612,    0,    0,    0,    0,  612,  982,    0, 
          648,    0,  511,  286,    0,    0,    0,  109,    0,  511, 
          121,    0,  112,   94,  613,  708,  710,    0,    0,  331, 
            0,  517,  865,  982,  551,  552,  553,  554,  517,  294, 
          286,   92,  294,  219,   98,    0,    0,    0,  514,    0, 
          510,    0,   92,  219,    0,    0,    0,  510,    0,    0, 
          514,    0,  612,  294,  304,  710,    0,  514,  331,  521, 
          350,  512,  513,    0,    0,    0,  521,  128,  512,  513, 
          510,  104,    0,  612,  613,   94,   91,  219,    0,    0, 
            0,  244,  244,  244,  108,  294,  244,  244,  244,    0, 
          244,  219,  219,    0,    0,  613,    0,   95,    0,    0, 
          244,  244,  111,  127,    0,  104,    0,    0,   95,  244, 
          244,    0,  244,  244,  244,  244,  244,  771,    0,    0, 
            0,    0,  104,  510,  244,    0, 1066,    0,  304,    0, 
           94,  315,    0,  286,  106,  304,    0,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,  244,    0,  244,  244, 
            0,  511,  615,    0,    0,    0,   95,  244,  511,    0, 
          244,    0,    0,  244,  315,  244,    0,   99,  106,    0, 
            0,  315,    0,    0,    0,  244,  244,  513,    0,  796, 
          350,  244,    0,    0,    0,  106,    0,  105,    0,   95, 
           95,  878,    0,  244,  878,   92,    0,  101,    0,    0, 
          888,    0,    0,    0,    0,  100,   92,   95,    0,   95, 
            0,   95,  871,  244,  874,  616,  518,  817,    0,    0, 
            0,  105,    0,  518,    0,  881,  114,    0,  649,   99, 
          880,  101,  551,  552,  553,  554,  555,    0,  105,  100, 
            0,  556,  128,  839,    0,  840,    0,    0,  101,    0, 
           95,    0,  710,  331,   92,    0,  100,    0,    0,  350, 
            0,    0,    0,  557,   95,   95,   95,  855,  619,    0, 
            0,  559,  560,  561,  562,  514,    0,    0,  520,  856, 
            0,    0,  514,    0,    0,    0,  519,   92,   92,    0, 
            0,  304,    0,  510,    0,  219,  219,  219,  304,    0, 
          219,  219,  219,  510,  219,   92,    0,   92,    0,   92, 
            0,  110,  612,    0,  219,  219,    0,  563,    0,  127, 
            0,    0,    0,  219,  219,    0,  219,  219,  219,  219, 
          350,    0,    0,    0,    0,  913,    0,  510,  219,    0, 
          104,  615,    0,    0,    0,  385,   95,   95,   92,    0, 
            0,  510,  510, 1002,  110,    0,  510,   95,    0,    0, 
          510,    0,   92,   92,   92,  113,  613,  510,  315,  934, 
            0,  219,  612,    0,  219,  315,  400,  219,    0,  219, 
          402,  403,  404,  405,  510,    0,    0,  888,    0,  615, 
          888,    0,  878,  612,  888,  219,  615,    0,    0,    0, 
            0,  615,  104,  106,  616, 1019,  744,  219,  551,  552, 
          553,  554,  555,    0,  513, 1026,   95,  556,    0, 1030, 
          135,  513,  615,    0,    0,    0,  613,  219,    0,    0, 
            0,    0,    0,   95,    0,   95,  513,    0,    0,  557, 
            0,   95,   95,    0,   92,   92,  513,  613,  983,  561, 
          562, 1001,  616,    0,    0,   92,  105,  619,  744,  616, 
          551,  552,  553,  554,  616,  106,  101,    0,  744,    0, 
          551,  552,  553,  554,  100,  331,    0,    0,    0,  888, 
          513,  888,    0,  888,    0,  616,  888,    0,    0,  135, 
            0,  745,    0,  563,  513,  513,    0,  113,    0,  513, 
            0,  745,    0,    0,    0,  619,    0,    0, 1080,  746, 
            0,  888,  619,    0,   92,  520,    0,  615,  105,    0, 
            0,    0,  520,  519,    0,    0,    0,  513,  101,    0, 
          519,   92,    0,   92,    0,    0,  100,    0,  619,   92, 
           92,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          612,  612,  612,    0,  612,  510,  510,  510,  612,  612, 
          510,  510,  510,  612,  510,  612,  612,  612,  612,  612, 
          612,  612,    0,  612,  510,  510,  612,  612,  612,  612, 
          612,  612,  612,  510,  510,  612,  510,  510,  510,  510, 
          510,    0,  612,    0,    0,  612,  612,  612,  510,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,    0,    0,  510,  510,  510,  612, 
          522,  510,  612,  612,  510,  612,  612,  510,  612,  510, 
          612,  510,  612,  510,  612,  510,  510,  510,  510,  510, 
          510,  510,  612,  510,  612,  510,    0,  612,  612,  612, 
          612,  612,  612,    0,    0,  308,  612,  510,  612,  612, 
            0,  612,  612,  612,  612,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  612,  612,  612,  510,    0,    0, 
            0,    0,    0,  613,  613,  613,    0,  613,  513,  513, 
          513,  613,  613,  513,  513,  513,  613,  513,  613,  613, 
          613,  613,  613,  613,  613,    0,  613,  513,  513,  613, 
          613,  613,  613,  613,  613,  613,  513,  513,  613,  513, 
          513,  513,  513,  513,    0,  613,    0,    0,  613,  613, 
          613,  513,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,    0,    0,  513, 
          513,  513,  613,  525,  513,  613,  613,  513,  613,  613, 
          513,  613,  513,  613,  513,  613,  513,  613,  513,  513, 
          513,  513,  513,  513,  513,  613,  513,  613,  513,    0, 
          613,  613,  613,  613,  613,  613,    0,    0,  615,  613, 
          513,  613,  613,    0,  613,  613,  613,  613,  615,    0, 
            0,    0,    0,    0,    0,    0,    0,  613,  613,  613, 
          513,    0,  539,    0,  542,  550,  545,  551,  552,  553, 
          554,  555,  545,    0,    0,  966,  556,    0,    0,  970, 
            0,    0,  615,    0,    0,  624,  624,  624,    0,    0, 
            0,  624,  624,    0,  624,    0,  615,  615,  557,  123, 
          744,  615,  551,  552,  553,  554,  559,  560,  561,  562, 
            0,  625,  625,  625,    0,    0,    0,  625,  625,    0, 
          625,    0,    0,    0,    0,    0,    0,    0,    0,  615, 
            0,    0,    0,  745,    0,    0,    0,    0,    0,    0, 
            0,  945,  310,  310,  310,    0,  310,    0,    0,    0, 
          310,  310,  563,    0,    0,  310,    0,  310,  310,  310, 
          310,  310,  310,  310,  624,    0,    0,    0,  310,  310, 
          310,  310,  310,  310,  310,    0,  616,  310,  539,    0, 
            0,    0,    0,    0,  310,  624,  616,  310,  310,  310, 
          625,  310,  310,  310,  310,  310,  310,    0,  310,  310, 
          310,  310,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  625,    0,    0,    0, 1055,    0,  624, 1057, 1059, 
          616,  310, 1062, 1063,  310,    0,  308,  310,  310,    0, 
          310,    0,    0,    0,  616,  616,  310,  125,    0,  616, 
            0,    0,    0,  625,  310,    0,    0,  741,    0,  310, 
          310,  310,  310,  310,  310,    0,    0,    0,  310,    0, 
          310,  310,    0,  310,  310,  310,  310,  616,    0,    0, 
            0, 1085, 1087, 1088, 1089,    0,  310,  310,    0,    0, 
            0,    0, 1091,    0,    0,  741,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  615,  615,  615,    0,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,    0,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,    0,  615,    0,    0, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  303, 
            0,  615,  615,  615,  615,    0,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  892,  615,  615,  615,  615,  615,  615,    0,    0, 
            0,  615,  615,  615,  615,    0,  615,  615,  615,  615, 
            0,    0,    0,    0,    0,    0,    0,  879,    0,  615, 
          615,  615,  615,  616,  616,  616,  891,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,    0,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,    0,  616,    0,    0,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,    0,    0,  616, 
          616,  616,  616,    0,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,    0, 
          616,  616,  616,  616,  616,  616,  385,    0,  619,  616, 
          616,  616,  616,    0,  616,  616,  616,  616,  619,    0, 
            0,    0,  398,  399,    0,    0,    0,  616,  616,  616, 
          616,    0,    0,    0,    0,    0,    0,  400,    0,  401, 
            0,  402,  403,  404,  405,    0,    0,  408,  892,  409, 
            0,  892,  619,  892,    0,  892,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  619,  619,    0,  124, 
            0,  619,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,  891,    9,   10,  891,    0, 1029,   11, 
          891,   12,   13,   14,   15,   16,   17,   18,    0,  619, 
            0,    0,   19,   20,   21,  234,  235,  236,  237,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  238,  239,  240,    0,  241,   35,  242,  243,  244, 
          245,  280,   40,   41,   42,   43,    0,    0,    0,    0, 
          892,    0,  892,    0,  892,    0,  305,  892,    0,    0, 
            0,    0,    0,    0,    0,  246,  305,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  281,    0,  282,    0, 
           50,    0,  892,    0,    0,  891,    0,  891,  283,  891, 
            0,    0,  891,   52,  284,   54,   55,   56,   57,    0, 
          305,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,  305,  305,    0,  891,    0,  305, 
           65,   66,  285,  385,  386,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,  385,    0,    0,    0,    0,  398, 
          399,    0,    0,    0,    0,    0,    0,  305,    0,    0, 
          398,  399,    0,    0,  400,    0,  401,    0,  402,  403, 
          404,  405,  406,  407,  408,  400,  409,  198,    0,  402, 
          403,  404,  405,    0,    0,  615,  615,  615,    0,  615, 
          619,  619,  619,  615,  615,  619,  619,  619,  615,  619, 
          615,  615,  615,  615,  615,  615,  615,    0,  619,  619, 
          619,  615,  615,  615,  615,  615,  615,  615,  619,  619, 
          615,  619,  619,  619,  619,  619,  198,  615,    0,    0, 
          615,  615,  615,  619,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  619,  619,    0, 
            0,  619,  619,  619,  615,  208,  619,  615,  615,  619, 
          615,  615,  619,  615,  619,  615,  619,  615,  619,  615, 
          619,  619,  619,  619,  619,  619,  619,  615,  619,  619, 
          619,    0,  615,  615,  615,  615,  615,  615,    0,    0, 
            0,  615,  619,  615,  615,    0,  615,  615,  615,  615, 
            0,    0,    0,    0,  208,  193,    0,    0,    0,  615, 
          615,  615,  619,  614,  614,  614,    0,  614,  305,  305, 
          305,  614,  614,  305,  305,  305,  614,  305,  614,  614, 
          614,  614,  614,  614,  614,    0,  614,  305,  305,  614, 
          614,  614,  614,  614,  614,  614,  305,  305,  614,  305, 
          305,  305,  305,  305,  193,  614,    0,    0,  614,  614, 
          614,  305,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,  305,  305,  305,    0,    0,  305, 
          305,  305,  614,    0,  305,  614,  614,  305,  614,  614, 
          305,  614,  305,  614,  305,  614,  305,  614,  305,  305, 
          305,  305,  305,  305,  305,  614,  305,  614,  305,    0, 
          614,  614,  614,  614,  614,  614,    0,    0,  620,  614, 
          305,  614,  614,    0,  614,  614,  614,  614,  620,    0, 
          880,    0,  551,  552,  553,  554,  555,  614,  614,  614, 
          305,  556,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  198,    0,  198,  198,  198,  198,  198, 
            0,    0,  620,  557,  198,    0,    0,  385,    0,    0, 
            0,  559,  560,  561,  562,  515,  620,  620,    0,    0, 
            0,  620,  515,  398,  399,    0,  198,  198,    0,    0, 
            0,    0,    0,    0,  198,  198,  198,  198,  400,    0, 
          401,    0,  402,  403,  404,  405,    0,    0,    0,  620, 
            0,    0,    0,    0,    0,    0,  550,  563,  551,  552, 
          553,  554,  555,    0,    0,    0,    0,  556,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          198,  208,    0,  208,  208,  208,  208,  208,    0,  557, 
          558,    0,  208,    0,    0,    0,  621,  559,  560,  561, 
          562,    0,    0,  517,    0,    0,  621,    0,    0,    0, 
          517,    0,    0,    0,  208,  208,    0,    0,    0,    0, 
            0,    0,  208,  208,  208,  208,    0,    0,    0,    0, 
            0,  193,    0,  193,  193,  193,  193,  193,    0,    0, 
          621,    0,  193,  563,    0,  385,    0,    0,    0,    0, 
          390,  391,    0,  518,  621,  621,    0,    0,    0,  621, 
          518,  398,  399,    0,  193,  193,    0,    0,  208,    0, 
            0,    0,  193,  193,  193,  193,  400,    0,  401,    0, 
          402,  403,  404,  405,  406,  407,  408,  621,  409,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  175,    0,    0, 
            0,    0,    0,    0,    0,  617,  617,  617,  193,  617, 
          620,  620,  620,  617,  617,  620,  620,  620,  617,  620, 
          617,  617,  617,  617,  617,  617,  617,    0,  620,  620, 
          620,  617,  617,  617,  617,  617,  617,  617,  620,  620, 
          617,  620,  620,  620,  620,  620,  175,  617,    0,    0, 
          617,  617,  617,  620,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  620,  620,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  620,    0, 
            0,  620,  620,  620,  617,  176,  620,  617,  617,  620, 
          617,  617,  620,  617,  620,  617,  620,  617,  620,  617, 
          620,  620,  620,  620,  620,  620,  620,  617,  620,  620, 
          620,    0,  617,  617,  617,  617,  617,  617,    0,    0, 
            0,  617,  620,  617,  617,    0,  617,  617,  617,  617, 
            0,    0,    0,    0,  176,  177,    0,    0,    0,  617, 
          617,  617,  620,  618,  618,  618,    0,  618,  621,  621, 
          621,  618,  618,  621,  621,  621,  618,  621,  618,  618, 
          618,  618,  618,  618,  618,    0,  621,  621,  621,  618, 
          618,  618,  618,  618,  618,  618,  621,  621,  618,  621, 
          621,  621,  621,  621,  177,  618,    0,    0,  618,  618, 
          618,  621,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,    0,    0,  621, 
          621,  621,  618,    0,  621,  618,  618,  621,  618,  618, 
          621,  618,  621,  618,  621,  618,  621,  618,  621,  621, 
          621,  621,  621,  621,  621,  618,  621,  621,  621,    0, 
          618,  618,  618,  618,  618,  618,    0,    0,  314,  618, 
          621,  618,  618,    0,  618,  618,  618,  618,  314,    0, 
            0,    0,    0,    0,    0,    0,    0,  618,  618,  618, 
          621,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  175,    0,  175,  175,  175,  175,  175, 
            0,    0,  314,    0,  175,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,  314,  314,    0,  126, 
            0,  314,  520,    0,    0,    0,  175,  175,    0,    0, 
            0,    0,    0,    0,  175,  175,  175,  175,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  314, 
            0,    0,    0,    0,    0,    0,  550,    0,  551,  552, 
          553,  554,  555,    0,    0,    0,    0,  556,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          175,  176,    0,  176,  176,  176,  176,  176,    0,  557, 
          676,    0,  176,    0,    0,    0,  434,  559,  560,  561, 
          562,    0,    0,  519,    0,    0,  434,    0,    0,    0, 
          519,    0,    0,    0,  176,  176,    0,    0,    0,    0, 
            0,    0,  176,  176,  176,  176,    0,    0,    0,    0, 
            0,  177,    0,  177,  177,  177,  177,  177,    0,    0, 
          434,    0,  177,  563,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  521,    0,  434,    0,    0,    0,  434, 
          521,    0,    0,    0,  177,  177,    0,    0,  176,    0, 
            0,    0,  177,  177,  177,  177,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  434,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  134,    0,    0, 
            0,    0,    0,    0,    0,  616,  616,  616,  177,  616, 
          314,  314,  314,  616,  616,  314,  314,  314,  616,  314, 
          616,  616,  616,  616,  616,  616,  616,    0,    0,  314, 
          314,  616,  616,  616,  616,  616,  616,  616,  314,  314, 
          616,  314,  314,  314,  314,  314,  134,  616,    0,    0, 
          616,  616,  616,  314,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  314,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,    0, 
            0,  314,  314,  314,  616,  135,  314,  616,  616,  314, 
          616,  616,  314,  616,  314,  616,  314,  616,  314,  616, 
          314,  314,  314,  314,  314,  314,  314,  616,  314,    0, 
          314,    0,  616,  616,  616,  616,  616,  616,    0,    0, 
            0,  616,  314,  616,  616,    0,  616,  616,  616,  616, 
            0,    0,    0,    0,  135,    0,    0,  104,    0,  616, 
          616,  616,  314,  281,  281,  281,    0,  281,  434,  434, 
          434,  281,  281,  434,  434,  434,  281,  434,  281,  281, 
          281,  281,  281,  281,  281,    0,  434,  434,  434,  281, 
          281,  281,  281,  281,  281,  281,  434,  434,  281,  434, 
          434,  434,  434,  434,  615,  281,    0,    0,  281,  281, 
          281,    0,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  434,  434,  434,  434,  434,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,    0,    0,  434, 
          434,  434,  281,    0,  434,  281,    0,  434,  281,  281, 
          434,  281,  434,  281,  434,  281,  434,  281,  434,  434, 
          434,  434,  434,  434,  434,  281,  434,  434,  434,    0, 
          281,  281,  281,  281,  281,  281,    0,    0,  637,  281, 
            0,  281,  281,    0,  281,  281,  281,  281,  637,    0, 
            0,    0,    0,    0,    0,    0,    0,  281,  281,  281, 
          434,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  134,    0,  134,  134,  134,  134,  134, 
            0,    0,  637,    0,  134,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  510,    0,  637,    0,    0, 
            0,  637,  510,    0,    0,    0,  134,  134,    0,    0, 
            0,    0,    0,    0,  134,  134,  134,  134,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  637, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  123,  615,    0,    0,    0,    0,    0,    0, 
          134,  135,    0,  135,  135,  135,  135,  135,    0,    0, 
            0,    0,  135,    0,    0,    0,  321,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,  321,    0,    0,    0, 
          513,    0,    0,    0,  135,  135,    0,    0,    0,    0, 
            0,  615,  135,  135,  135,  135,    0,    0,  615,    0, 
            0,    0,    0,  615,    0,    0,    0,    0,    0,    0, 
          321,    0,    0,    0,    0,    0,    0,    0,    0,  624, 
          625,    0,    0,  626,  615,  321,    0,  183,  184,  321, 
          185,  186,  187,  188,  189,  190,  191,    0,  135,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  299,    0,    0,    0,  321,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,    0,  281, 
          637,  637,  637,  281,  281,  637,  637,  637,  281,  637, 
          281,  281,  281,  281,  281,  281,  281,    0,  637,  637, 
          637,  281,  281,  281,  281,  281,  281,  281,  637,  637, 
          281,  637,  637,  637,  637,  637,    0,  281,    0,    0, 
          281,  281,  281,    0,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  637,  637,  637,  637,  637, 
          637,  637,  637,  637,  637,  637,  637,  637,  637,    0, 
            0,  637,  637,  637,  281,    0,  637,  281,    0,  637, 
          281,  281,  637,  281,  637,  281,  637,  281,  637,  281, 
          637,  637,  637,  637,  637,  637,  637,  281,  637,  637, 
          637,    0,  281,  281,  281,  281,  281,  281,    0,    0, 
            0,  281,    0,  281,  281,    0,  281,  281,  281,  281, 
            0,    0,    0,    0,    0,    0,    0,    0,  348,  281, 
          281,  281,  637,  281,  281,  281,    0,  281,  321,  321, 
          321,  281,  281,  321,  321,  321,  281,  321,  281,  281, 
          281,  281,  281,  281,  281,    0,    0,  321,  321,  281, 
          281,  281,  281,  281,  281,  281,  321,  321,  281,  321, 
          321,  321,  321,  321,    0,  281,    0,    0,  281,  281, 
          281,    0,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  321,  321,  321,  321,  321,  321,  321, 
          321,  321,  321,  321,  321,  321,  321,    0,    0,  321, 
          321,  321,  281,    0,  321,  281,    0,  321,  281,  281, 
          321,  281,  321,  281,  321,  281,  321,  281,  321,  321, 
          321,  321,  321,  321,  321,  281,  321,  510,  321,    0, 
          281,  281,  281,  281,  281,  281,    0,  510,    0,  281, 
            0,  281,  281,    0,  281,  281,  281,  281,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  281,  281,  281, 
          321,    0,    0,  385,  386,  387,  388,  389,  390,  391, 
          392,   91,  394,  395,    0,    0,    0,    0,    0,  398, 
          399,    0,    0,    0,    0,    0,  510,    0,  110,    0, 
          510,    0,    0,    0,  400,    0,  401,    0,  402,  403, 
          404,  405,  406,  407,  408,    0,  409,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  510,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          335,  336,  337,  338,    0,  513,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,  513,  339,  340,  341,    0, 
          342,   35,  343,  344,  345,  346,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   94, 
          347,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,  513,    0,  113,    0,  513,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,  513,    0,    0,    0, 
            0,    0,    0,    0,    0,   65,   66,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  612,  612,  612,    0,  612,  510, 
          510,  510,  612,  612,    0,  510,  510,  612,  510,  612, 
          612,  612,  612,  612,  612,  612,    0,  612,    0,    0, 
          612,  612,  612,  612,  612,  612,  612,  510,  510,  612, 
          510,  510,  510,  510,  510,    0,  612,    0,    0,  612, 
          612,  612,    0,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  303,    0, 
          510,  510,  510,  612,  522,    0,  612,  612,  510,  612, 
          612,    0,  612,    0,  612,  510,  612,  510,  612,  510, 
          510,  510,  510,  510,  510,  510,  612,  510,  612,  510, 
            0,  612,  612,  612,  612,  612,  612,    0,    0,    0, 
          612,    0,  612,  612,    0,  612,  612,  612,  612,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  612,  612, 
          612,  510,  613,  613,  613,    0,  613,  513,  513,  513, 
          613,  613,    0,  513,  513,  613,  513,  613,  613,  613, 
          613,  613,  613,  613,    0,  613,    0,    0,  613,  613, 
          613,  613,  613,  613,  613,  513,  513,  613,  513,  513, 
          513,  513,  513,    0,  613,    0,    0,  613,  613,  613, 
            0,  613,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,    0,    0,  513,  513, 
          513,  613,  525,    0,  613,  613,  513,  613,  613,    0, 
          613,    0,  613,  513,  613,  513,  613,  513,  513,  513, 
          513,  513,  513,  513,  613,  513,  613,  513,    0,  613, 
          613,  613,  613,  613,  613,    0,    0,  615,  613,    0, 
          613,  613,    0,  613,  613,  613,  613,  615,    0,    0, 
            0,    0,    0,    0,    0,    0,  613,  613,  613,  513, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  615,    0,  123,    0, 
          615,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,  615,    0, 
            0,   19,   20,   21,  234,  235,  236,  237,    0,    0, 
           26,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          238,  239,  240,    0,  241,   35,  242,  243,  244,  245, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  616,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,  616,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,  106, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,  616,    0,  125,    0,  616,   65, 
           66,  385,  386,  387,  388,  389,  390,  391,    0,    0, 
          394,  395,    0,    0,    0,    0,    0,  398,  399,    0, 
            0,    0,    0,    0,    0,    0,  616,    0,    0,    0, 
            0,    0,  400,    0,  401,    0,  402,  403,  404,  405, 
          406,  407,  408,    0,  409,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  615,  615,  615,    0,  615,  615, 
          615,  615,  615,  615,    0,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  303,  615,    0,    0, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,    0,  615,    0,    0,  615, 
          615,  615,    0,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,    0,  410, 
          615,  615,  615,  615,    0,  102,  615,  615,  615,  615, 
          615,    0,  615,    0,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
            0,  615,  615,  615,  615,  615,  615,    0,    0,  102, 
          615,    0,  615,  615,    0,  615,  615,  615,  615,    0, 
          410,    0,    0,    0,    0,    0,  102,    0,  615,  615, 
          615,  615,  616,  616,  616,    0,  616,  616,  616,  616, 
          616,  616,    0,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,    0,  616,  521,    0,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,    0,  616,    0,    0,  616,  616,  616, 
            0,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,    0,    0,  616,  616, 
          616,  616,    0,    0,  616,  616,  616,  616,  616,    0, 
          616,    0,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,    0,  616, 
          616,  616,  616,  616,  616,    0,    0,  619,  616,    0, 
          616,  616,    0,  616,  616,  616,  616,  619,    0,    0, 
           93,    0,    0,    0,    0,    0,  616,  616,  616,  616, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  105,    0,    0,   93,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  619,    0,  124,    0, 
          619,   93,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  385,  386,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,    0,  396,  397,    0,  619,  398, 
          399,  512,    0,    0,  102,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  400,    0,  401,    0,  402,  403, 
          404,  405,  406,  407,  408,    0,  409,    0,    0,    0, 
            0,    0,    0,    0,  385,  386,  387,  388,  389,  390, 
          391,  392,  393,  394,  395,  314,  396,  397,    0,    0, 
          398,  399,    0,  521,    0,  314,    0,    0,   92,    0, 
          521,    0,    0,    0,    0,  400,  102,  401,    0,  402, 
          403,  404,  405,  406,  407,  408,    0,  409,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  107, 
            0,    0,   92,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  314,    0,  126,    0,  314,   92, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  314,    0,    0,  511, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  615,  615,  615,    0,  615,  619, 
          619,  619,  615,  615,    0,  619,  619,  615,  619,  615, 
          615,  615,  615,  615,  615,  615,    0,  619,    0,   93, 
          615,  615,  615,  615,  615,  615,  615,  619,  619,  615, 
          619,  619,  619,  619,  619,    0,  615,    0,    0,  615, 
          615,  615,    0,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  619,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  619,  512,    0, 
          619,  619,  619,  615,    0,  512,  615,  615,  619,  615, 
          615,   93,  615,    0,  615,  619,  615,  619,  615,  619, 
          619,  619,  619,  619,  619,  619,  615,  619,  619,  619, 
            0,  615,  615,  615,  615,  615,  615,    0,    0,    0, 
          615,    0,  615,  615,  637,  615,  615,  615,  615,    0, 
            0,    0,    0,    0,  637,    0,    0,    0,  615,  615, 
          615,  619,  616,  616,  616,    0,  616,  314,  314,  314, 
          616,  616,    0,  314,  314,  616,  314,  616,  616,  616, 
          616,  616,  616,  616,    0,    0,    0,   92,  616,  616, 
          616,  616,  616,  616,  616,  314,  314,  616,  314,  314, 
          314,  314,  314,  637,  616,    0,    0,  616,  616,  616, 
            0,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,  511,    0,  314,  314, 
          314,  616,    0,  511,  616,  616,  314,  616,  616,   92, 
          616,    0,  616,  314,  616,  314,  616,  314,  314,  314, 
          314,  314,  314,  314,  616,  314,    0,  314,    0,  616, 
          616,  616,  616,  616,  616,    0,    0,  435,  616,    0, 
          616,  616,    0,  616,  616,  616,  616,  435,    0,    0, 
            0,    0,    0,    0,    0,   95,  616,  616,  616,  314, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  435,    0,    0,    0,    0,    0,    0,    0,   95, 
            0,    0,    0,    0,    0,  435,  435,    0,  122,    0, 
          435,    0,    0,    0,    0,    0,   95,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  435,    0, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   43,    0,    0,    0, 
            0,  281,  281,  281,    0,  281,  637,  637,  637,  281, 
          281,  637,  637,  637,  281,  637,  281,  281,  281,  281, 
          281,  281,  281,    0,  637,  637,  637,  281,  281,  281, 
          281,  281,  281,  281,  637,  637,  281,  637,  637,  637, 
          637,  637,    0,  281,    0,   43,  281,  281,  281,    0, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  434,  637,    0,    0,    0,    0,    0,    0,  637, 
          281,  434,    0,  281,    0,  637,  281,  281,    0,  281, 
            0,  281,    0,  281,    0,  281,    0,    0,    0,    0, 
            0,    0,    0,  281,    0,  637,  637,    0,  281,  281, 
          281,  281,  281,  281,    0,  434,    0,  281,    0,  281, 
          281,    0,  281,  281,  281,  281,    0,    0,    0,  434, 
          434,    0,    0,    0,  434,  281,  281,  281,  637,  435, 
          435,  435,    0,    0,  435,  435,  435,    0,  435,    0, 
            0,    0,    0,    0,    0,    0,    0,  435,  435,  435, 
            0,    0,  434,    0,   95,    0,    0,  435,  435,    0, 
          435,  435,  435,  435,  435,    0,    0,    0,    0,    0, 
            0,    0,  435,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  435,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,  435,  435,  435,  435,    0,  516, 
          435,  435,  435,  514,    0,  435,    0,    0,  435,  516, 
          514,  435,    0,  435,    0,  435,   95,  435,    0,  435, 
          435,  435,  435,  435,  435,  435,    0,  435,  435,  435, 
            0,    0,    0,    0,    0,    0,    0,    0,   43,   43, 
           43,  435,    0,  516,   43,   43,    0,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,    0, 
          116,  435,  516,    0,    0,    0,    0,    0,    0,   43, 
           43,   43,   43,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,    0,    0,    0,    0,    0,   43,    0,    0, 
            0,    0,    0,  434,  434,  434,    0,    0,  434,  434, 
          434,    0,  434,    0,    0,    0,    0,    0,   43,    0, 
            0,  434,  434,  434,    0,  515,    0,    0,    0,    0, 
            0,  434,  434,    0,  434,  434,  434,  434,  434,  515, 
          515,    0,  115,    0,  515,    0,  434,    0,    0,    0, 
           43,    0,    0,    0,    0,    0,    0,    0,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,  434,  515,    0,  434,  434,  434,  109,    0,  434, 
            0,    0,  434,    0,    0,  434,    0,  434,    0,  434, 
            0,  434,    0,  434,  434,  434,  434,  434,  434,  434, 
          108,  434,  434,  434,    0,    0,    0,    0,    0,    0, 
            0,  109,    0,    0,    0,  434,    0,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,    0,    0,  109,  517, 
            0,    0,    0,    0,  108,  434,    0,    0,    0,    0, 
            0,  516,  516,  516,    0,    0,  516,  516,  516,    0, 
          516,  108,    0,    0,    0,    0,    0,    0,  304,    0, 
          516,  516,    0,  517,    0,    0,    0,    0,    0,  516, 
          516,    0,  516,  516,  516,  516,  516,  517,  517,    0, 
          117,  315,  517,    0,  516,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          517,    0,  516,  516,  516,    0,  528,  516,    0,    0, 
          516,    0,    0,  516,    0,  516,    0,  516,   25,  516, 
            0,  516,  516,  516,  516,  516,  516,  516,   25,  516, 
            0,  516,  513,  515,  515,  515,    0,    0,  515,  515, 
          515,    0,  515,  516,    0,    0,    0,  513,    0,    0, 
            0,    0,  515,  515,    0,    0,    0,    0,    0,    0, 
          106,  515,  515,  516,  515,  515,  515,  515,  515,    0, 
            0,    0,    0,  105,    0,    0,  515,   25,    0,  513, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,    0,  518,  515,  515,  515,  616,  527,  515, 
            0,    0,  515,  518,    0,  515,    0,  515,    0,  515, 
          619,  515,    0,  515,  515,  515,  515,  515,  515,  515, 
            0,  515,    0,  515,    0,    0,  109,    0,    0,    0, 
            0,    0,    0,    0,    0,  515,    0,  518,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  108, 
            0,  518,  518,    0,  118,  515,  518,    0,    0,    0, 
            0,  517,  517,  517,    0,    0,  517,  517,  517,    0, 
          517,    0,    0,    0,    0,  304,    0,    0,    0,    0, 
          517,  517,  304,    0,  518,    0,    0,    0,  109,  517, 
          517,    0,  517,  517,  517,  517,  517,    0,  315,    0, 
            0,    0,    0,    0,  517,  315,    0,    0,    0,    0, 
            0,  108,    0,    0,    0,    0,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
            0,  520,  517,  517,  517,    0,  529,  517,    0,    0, 
          517,  520,    0,  517,    0,  517,    0,  517,    0,  517, 
            0,  517,  517,  517,  517,  517,  517,  517,  613,  517, 
            0,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
           25,   25,   25,  517,    0,  520,   25,   25,    0,   25, 
            0,    0,    0,    0,    0,  125,  616,    0,    0,  520, 
          520,    0,  120,  517,  520,    0,    0,    0,  124,  619, 
            0,   25,   25,   25,   25,   25,  513,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,    0,    0,  613,    0, 
            0,    0,  520,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  616,    0,  513,    0,    0,  613, 
            0,  616,    0,  519,    0,    0,  616,  619,    0,   25, 
            0,    0,    0,    0,  619,  518,  518,  518,    0,  615, 
          518,  518,  518,    0,  518,    0,    0,  616,    0,    0, 
           25,    0,    0,    0,  518,  518,    0,  519,    0,    0, 
          619,    0,    0,  518,  518,    0,  518,  518,  518,  518, 
          518,  519,  519,    0,  119,    0,  519,    0,  518,    0, 
            0,    0,   25,    0,    0,    0,    0,    0,    0,    0, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  519,    0,  518,  518,  518,    0, 
          530,  518,    0,    0,  518,    0,    0,  518,    0,  518, 
            0,  518,    0,  518,    0,  518,  518,  518,  518,  518, 
          518,  518,    0,  518,    0,  518,    0,    0,    0,    0, 
            0,    0,    0,  619,    0,    0,    0,  518,    0,    0, 
            0,  521,    0,    0,    0,    0,    0,    0,  619,    0, 
            0,  521,    0,    0,    0,    0,    0,  518,    0,    0, 
            0,    0,    0,  520,  520,  520,    0,    0,  520,  520, 
          520,    0,  520,    0,    0,    0,    0,    0,    0,    0, 
          619,    0,  520,  520,    0,  521,    0,    0,    0,    0, 
            0,  520,  520,    0,  520,  520,  520,  520,  520,  521, 
          521,    0,  121,    0,  521,    0,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  521,    0,  520,  520,  520,    0,  532,  520, 
            0,    0,  520,    0,    0,  520,    0,  520,    0,  520, 
            0,  520,    0,  520,  520,  520,  520,  520,  520,  520, 
            0,  520,    0,  520,    0,  519,  519,  519,    0,    0, 
          519,  519,  519,    0,  519,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,  519,    0,  410,    0,    0, 
            0,    0,    0,  519,  519,  520,  519,  519,  519,  519, 
          519,    0,    0,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,  512,  519,  519,  519,    0, 
          531,  519,    0,    0,  519,  512,    0,  519,    0,  519, 
            0,  519,    0,  519,    0,  519,  519,  519,  519,  519, 
          519,  519,    0,  519,    0,  519,    0,    0,    0,  619, 
            0,    0,    0,    0,    0,    0,    0,  519,    0,  512, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  512,  512,    0,  112,  519,  512,    0, 
            0,    0,    0,  521,  521,  521,    0,    0,  521,  521, 
          521,    0,  521,    0,    0,    0,    0,  619,    0,    0, 
            0,    0,  521,  521,  619,    0,  512,    0,    0,  615, 
            0,  521,  521,    0,  521,  521,  521,  521,  521,    0, 
            0,    0,    0,    0,    0,    0,  521,  619,    0,    0, 
          619,    0,    0,    0,    0,    0,    0,    0,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,    0,  511,  521,  521,  521,    0,  533,  521, 
            0,    0,  521,  511,    0,  521,    0,  521,    0,  521, 
            0,  521,    0,  521,  521,  521,  521,  521,  521,  521, 
            0,  521,    0,  521,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,    0,  511,    0,    0, 
            0,  797,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,  511,    0,  111,  521,  511,    0,    0,    0, 
            0,  385,  386,  387,  388,  389,  390,  391,  392,  393, 
          394,  395,    0,  396,  397,    0,    0,  398,  399,    0, 
            0,    0,    0,    0,  511,    0,    0,    0,    0,    0, 
            0,    0,  400,    0,  401,  514,  402,  403,  404,  405, 
          406,  407,  408,    0,  409,  514,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  512,  512,  512, 
            0,    0,  512,  512,  512,    0,  512,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  512,  512,    0,  514, 
            0,    0,    0,    0,    0,  512,  512,    0,  512,  512, 
          512,  512,  512,  514,  514,    0,  114,    0,  514,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  514,    0,  512,  512, 
          512,    0,  524,  512,    0,    0,  512,    0,    0,  512, 
            0,  512,    0,  512,    0,  512,    0,  512,  512,  512, 
          512,  512,  512,  512,  637,  512,    0,  512,    0,    0, 
            0,    0,    0,    0,  637,    0,    0,    0,    0,  512, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  512, 
            0,    0,    0,    0,    0,  511,  511,  511,  637,    0, 
          511,  511,  511,    0,  511,    0,    0,    0,    0,    0, 
            0,    0,  637,  637,  511,  511,    0,  637,    0,    0, 
            0,    0,    0,  511,  511,  863,  511,  511,  511,  511, 
          511,    0,    0,    0,    0,  876,    0,    0,  511,    0, 
            0,    0,    0,    0,    0,  637,  883,    0,    0,    0, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,    0,    0,  511,  511,  511,    0, 
          523,  511,    0,    0,  511,    0,    0,  511,    0,  511, 
            0,  511,    0,  511,    0,  511,  511,  511,  511,  511, 
          511,  511,    0,  511,    0,  511,    0,  514,  514,  514, 
            0,    0,  514,  514,  514,    0,  514,  511,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,  514,    0,    0, 
            0,    0,    0,    0,    0,  514,  514,  511,  514,  514, 
          514,  514,  514,    0,    0,    0,    0,    0,    0,   51, 
          514,    0,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,    0,    0,  514,  514, 
          514,    0,  526,  514,    0,    0,  514,    0,    0,  514, 
            0,  514,    0,  514,    0,  514,    0,  514,  514,  514, 
          514,  514,  514,  514,  304,  514,    0,  514,   51,    0, 
            0,    0,    0,    0,  304,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,  637,  637,  637,    0, 
            0,  637,  637,  637, 1018,  637, 1020,    0, 1021,  514, 
            0,    0,    0, 1023,  637,  637,  637,    0,  304,    0, 
         1031,    0,    0,    0,  637,  637,    0,  637,  637,  637, 
          637,  637,  304,  304,    0,  128,    0,  304,    0,  637, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  637,  637,  637,  637,  637,  637,  637,  637,  637, 
          637,  637,  637,  637,  637,  304,    0,  637,  637,  637, 
            0,    0,  637,    0,    0,  637,    0,    0,  637,    0, 
          637,    0,  637,  315,  637,    0,  637,  637,  637,  637, 
          637,  637,  637,  315,  637,  637,  637,    0,    0,    0, 
            0, 1078,    0,    0,    0,    0,    0, 1079,  637, 1081, 
            0,    0, 1082,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  315,  637,    0, 
            0,    0,    0,    0,    0,    0,    0, 1090,    0,    0, 
            0,  315,  315,    0,  127,    0,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  315,    0,    0,    0,    0,    0, 
            0,   51,   51,   51,    0,    0,   51,   51,   51,    0, 
           51,  455,    0,    0,    0,    0,    0,    0,    0,    0, 
           51,  455,    0,    0,    0,    0,    0,    0,    0,   51, 
           51,    0,   51,   51,   51,   51,   51,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  455,  304,  304,  304,    0, 
            0,  304,  304,  304,    0,  304,    0,    0,    0,  455, 
          455,    0,    0,    0,  455,  304,  304,    0,    0,    0, 
           51,    0,    0,    0,  304,  304,    0,  304,  304,  304, 
          304,  304,    0,    0,    0,    0,    0,    0,    0,  304, 
            0,   51,  455,    0,    0,    0,    0,    0,    0,    0, 
            0,  304,  304,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  304,  304,  304,    0,    0,  304,  304,  304, 
            0,  258,  304,   51,    0,  304,    0,    0,  304,    0, 
          304,  258,  304,    0,  304,    0,  304,  304,  304,  304, 
          304,  304,  304,    0,  304,    0,  304,    0,    0,    0, 
            0,    0,    0,    0,    0,  315,  315,  315,  304,    0, 
          315,  315,  315,    0,  315,  258,    0,    0,    0,    0, 
            0,    0,    0,    0,  315,  315,    0,    0,  304,  258, 
          258,    0,    0,  315,  315,    0,  315,  315,  315,  315, 
          315,    0,    0,    0,    0,    0,    0,    0,  315,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,    0,    0,  315,  315,  315,    0, 
            0,  315,    0,    0,  315,    0,    0,  315,    0,  315, 
            0,  315,  326,  315,    0,  315,  315,  315,  315,  315, 
          315,  315,  326,  315,    0,  315,    0,    0,    0,    0, 
            0,    0,    0,  455,  455,  455,    0,  315,  455,  455, 
          455,    0,  455,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  455,  455,    0,    0,  326,  315,    0,    0, 
            0,  455,  455,    0,  455,  455,  455,  455,  455,    0, 
          326,  326,    0,    0,    0,  326,  455,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  455,  455, 
          455,  455,  455,  455,  455,  455,  455,  455,  455,  455, 
          455,  455,    0,  326,  455,  455,  455,    0,    0,  455, 
            0,    0,  455,    0,    0,  455,    0,  455,    0,  455, 
          262,  455,    0,  455,  455,  455,  455,  455,  455,  455, 
          262,  455,    0,  455,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  455,    0,    0,    0,    0, 
            0,    0,    0,  258,  258,  258,    0,    0,  258,  258, 
          258,    0,  258,    0,  262,  455,    0,    0,    0,    0, 
            0,    0,  258,  258,    0,    0,    0,    0,  262,  262, 
            0,  258,  258,  262,  258,  258,  258,  258,  258,    0, 
            0,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  358,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  321,  258, 
            0,    0,  258,    0,    0,  258,    0,  258,  321,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  258,    0,    0,    0,    0, 
            0,    0,  321,    0,  326,  326,  326,    0,    0,  326, 
          326,  326,    0,  326,    0,  258,  321,  321,    0,    0, 
            0,  321,    0,  326,  326,    0,    0,    0,    0,    0, 
            0,    0,  326,  326,    0,  326,  326,  326,  326,  326, 
            0,    0,    0,    0,    0,    0,    0,  326,    0,  321, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  326, 
          326,  326,  326,  326,  326,  326,  326,  326,  326,  326, 
          326,  326,  326,    0,    0,  326,  326,  326,    0,    0, 
          326,    0,    0,  326,    0,    0,  326,    0,  326,    0, 
          326,  505,  326,    0,  326,  326,  326,  326,  326,  326, 
          326,  505,  326,    0,  326,    0,    0,    0,    0,    0, 
            0,    0,  262,  262,  262,    0,  326,  262,  262,  262, 
            0,  262,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  262,  262,    0,    0,  505,  326,    0,    0,    0, 
          262,  262,    0,  262,  262,  262,  262,  262,    0,  505, 
          505,    0,    0,    0,  505,  262,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  262,  262,  262, 
          262,  262,  262,  262,  262,  262,  262,  262,  358,  262, 
          262,    0,  505,  262,  262,  358,    0,    0,  262,    0, 
            0,  262,    0,    0,  262,    0,  262,    0,  262,  354, 
          262,    0,  262,  262,  262,  262,  262,  262,  262,  354, 
          262,    0,  262,    0,    0,    0,    0,    0,    0,    0, 
          321,  321,  321,    0,  262,  321,  321,  321,    0,  321, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  321, 
          321,    0,    0,  354,  262,    0,    0,    0,  321,  321, 
            0,  321,  321,  321,  321,  321,    0,    0,  354,    0, 
            0,    0,  354,  321,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  321,  321,  321,  321,  321, 
          321,  321,  321,  321,  321,  321,  321,  321,  321,    0, 
          354,  321,  321,  321,    0,    0,  321,    0,    0,  321, 
            0,    0,  321,    0,  321,    0,  321,  355,  321,    0, 
          321,  321,  321,  321,  321,  321,  321,  355,  321,    0, 
          321,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  321,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  355,  321,  505,  505,  505,    0,    0,  505,  505, 
          505,    0,  505,    0,    0,    0,  355,    0,    0,    0, 
          355,    0,  505,  505,    0,    0,    0,    0,    0,    0, 
            0,  505,  505,    0,  505,  505,  505,  505,  505,    0, 
            0,    0,    0,    0,    0,    0,  505,    0,  355,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  505, 
          505,  505,  505,  505,  505,  505,  505,  505,  505,  505, 
          505,  505,    0,    0,  505,  505,  505,    0,    0,  505, 
            0,    0,  505,    0,    0,  505,    0,  505,    0,  505, 
          318,  505,    0,  505,  505,  505,  505,  505,  505,  505, 
          318,  505,    0,  505,    0,    0,    0,    0,    0,    0, 
            0,  354,  354,  354,    0,  505,  354,  354,  354,    0, 
          354,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          354,  354,    0,    0,  318,  505,    0,    0,    0,  354, 
          354,    0,  354,  354,  354,  354,  354,    0,    0,  318, 
            0,    0,    0,  318,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  354,  354,  354,  354, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
            0,  318,  354,  354,  354,    0,    0,  354,    0,    0, 
          354,    0,    0,  354,    0,  354,    0,  354,  238,  354, 
            0,  354,  354,  354,  354,  354,  354,  354,  238,  354, 
            0,  354,    0,    0,    0,    0,    0,    0,    0,  355, 
          355,  355,    0,    0,  355,  355,  355,    0,  355,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  355,  355, 
            0,    0,  238,  354,    0,    0,    0,  355,  355,    0, 
          355,  355,  355,  355,  355,    0,  238,  238,    0,    0, 
            0,  238,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  355,  355,  355,  355,  355,  355, 
          355,  355,  355,  355,  355,  355,  355,  355,    0,    0, 
          355,  355,  355,    0,    0,  355,    0,    0,  355,    0, 
            0,  355,    0,  355,    0,  355,  235,  355,    0,  355, 
          355,  355,  355,  355,  355,  355,  235,  355,    0,  355, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,  355,  318,  318,  318,    0,    0,  318,  318,  318, 
            0,  318,    0,    0,  235,  235,    0,    0,    0,  235, 
            0,  318,  318,    0,    0,    0,    0,    0,    0,    0, 
          318,  318,    0,  318,  318,  318,  318,  318,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  318,  318,  318, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,    0,    0,  318,  318,  318,    0,  232,  318,    0, 
            0,  318,    0,    0,  318,    0,  318,  232,  318,    0, 
          318,    0,  318,  318,  318,  318,  318,  318,  318,    0, 
          318,    0,  318,    0,    0,    0,    0,    0,    0,    0, 
          238,  238,  238,    0,    0,  238,  238,  238,    0,  238, 
            0,  232,    0,    0,    0,    0,    0,    0,    0,  238, 
          238,    0,    0,    0,  318,  232,  232,    0,  238,  238, 
          232,  238,  238,  238,  238,  238,    0,    0,    0,    0, 
            0,    0,    0,  238,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  238,  238,  238,  238, 
          238,  238,  238,  238,  238,  238,    0,  238,  238,    0, 
            0,  238,  238,    0,    0,  234,  238,    0,    0,  238, 
            0,    0,  238,    0,  238,  234,  238,    0,  238,    0, 
          238,  238,  238,  238,  238,  238,  238,    0,  238,    0, 
          238,    0,    0,    0,    0,    0,    0,    0,  235,  235, 
          235,    0,  238,  235,  235,  235,    0,  235,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,  235,  235,    0, 
            0,    0,  238,  234,  234,    0,  235,  235,  234,  235, 
          235,  235,  235,  235,    0,    0,    0,    0,    0,    0, 
            0,  235,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,  235,  235,  235,  235, 
          235,  235,  235,  235,    0,  235,  235,    0,    0,  235, 
          235,    0,    0,  233,  235,    0,    0,  235,    0,    0, 
          235,    0,  235,  233,  235,    0,  235,    0,  235,  235, 
          235,  235,  235,  235,  235,    0,  235,    0,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,    0,    0,    0,    0,    0,    0,  233,    0,  232, 
          232,  232,    0,    0,  232,  232,  232,    0,  232,    0, 
          235,  233,  233,    0,    0,    0,  233,    0,  232,  232, 
            0,    0,    0,    0,    0,    0,    0,  232,  232,    0, 
          232,  232,  232,  232,  232,    0,    0,    0,    0,    0, 
            0,    0,  232,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  232,  232,  232,  232,  232, 
          232,  232,  232,  232,  232,    0,  232,  232,    0,    0, 
          232,  232,    0,    0,  236,  232,    0,    0,  232,    0, 
            0,  232,    0,  232,  236,  232,    0,  232,    0,  232, 
          232,  232,  232,  232,  232,  232,    0,  232,    0,  232, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,  234, 
            0,  232,  234,  234,  234,    0,  234,    0,  236,    0, 
            0,    0,    0,    0,    0,    0,  234,  234,    0,    0, 
            0,  232,  236,  236,    0,  234,  234,  236,  234,  234, 
          234,  234,  234,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  234,  234,  234,  234,  234,  234,  234, 
          234,  234,  234,    0,  234,  234,    0,    0,  234,  234, 
            0,    0,    0,  234,    0,    0,  234,    0,    0,  234, 
            0,  234,    0,  234,  435,  234,    0,  234,  234,  234, 
          234,  234,  234,  234,  435,  234,    0,  234,    0,    0, 
            0,    0,    0,    0,    0,  233,  233,  233,    0,  234, 
          233,  233,  233,    0,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  233,  233,    0,    0,  103,  234, 
            0,    0,    0,  233,  233,    0,  233,  233,  233,  233, 
          233,    0,    0,  435,    0,  122,    0,  435,  233,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,  233,  233,  233,  233,  233,  233,  233,  233, 
          233,    0,  233,  233,    0,  435,  233,  233,    0,    0, 
            0,  233,    0,    0,  233,    0,    0,  233,    0,  233, 
            0,  233,    0,  233,    0,  233,  233,  233,  233,  233, 
          233,  233,    0,  233,  516,  233,    0,    0,    0,    0, 
            0,    0,    0,    0,  516,    0,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,  236,  236,    0, 
            0,  236,  236,  236,    0,  236,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,  236,  236,    0,   97,    0, 
            0,    0,    0,    0,  236,  236,    0,  236,  236,  236, 
          236,  236,    0,  516,    0,  116,    0,  516,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  236,  236,  236,  236,  236,  236,  236,  236, 
          236,  236,    0,  236,  236,  516,    0,  236,  236,    0, 
            0,    0,  236,    0,    0,  236,    0,    0,  236,    0, 
          236,    0,  236,    0,  236,    0,  236,  236,  236,  236, 
          236,  236,  236,    0,  236,  515,  236,    0,    0,    0, 
            0,    0,    0,    0,    0,  515,    0,    0,  236,    0, 
            0,    0,    0,    0,    0,    0,  435,  435,  435,    0, 
            0,    0,  435,  435,    0,  435,    0,    0,  236,    0, 
            0,    0,    0,    0,  435,    0,    0,    0,    0,   96, 
            0,    0,    0,    0,  435,  435,    0,  435,  435,  435, 
          435,  435,    0,    0,  515,    0,  115,    0,  515,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  435,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,  435,    0,  515,  435,  435,  435, 
            0,    0,    0,    0,    0,  435,    0,    0,    0,    0, 
            0,    0,  435,    0,  435,    0,  435,  435,  435,  435, 
          435,  435,  435,    0,  435,  435,  435,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,  516,  516,  516,    0, 
            0,    0,  516,  516,    0,  516,    0,    0,  435,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   98,  516,  516,    0,  516,  516,  516, 
          516,  516,    0,    0,    0,    0,    0,    0,  517,    0, 
          117,    0,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,    0,    0,  516,  516,  516, 
          517,  528,    0,    0,    0,  516,    0,    0,    0,    0, 
            0,    0,  516,    0,  516,    0,  516,  516,  516,  516, 
          516,  516,  516,    0,  516,  518,  516,    0,    0,    0, 
            0,    0,    0,    0,    0,  518,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  515,  515,  515, 
            0,    0,    0,  515,  515,    0,  515,    0,  516,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   99, 
            0,    0,    0,    0,    0,  515,  515,    0,  515,  515, 
          515,  515,  515,    0,  518,    0,  118,    0,  518,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  518,    0,  515,  515, 
          515,    0,  527,    0,    0,    0,  515,    0,    0,    0, 
            0,    0,    0,  515,    0,  515,    0,  515,  515,  515, 
          515,  515,  515,  515,    0,  515,    0,  515,    0,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  517,  517,  517,    0,    0,    0,  517,  517,  515, 
          517,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,    0,    0,    0,  517, 
          517,    0,  517,  517,  517,  517,  517,    0,  520,    0, 
          120,    0,  520,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          520,    0,  517,  517,  517,    0,  529,    0,    0,    0, 
          517,    0,    0,    0,    0,    0,    0,  517,    0,  517, 
            0,  517,  517,  517,  517,  517,  517,  517,    0,  517, 
          519,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
          519,    0,    0,    0,    0,    0,    0,  518,  518,  518, 
            0,    0,    0,  518,  518,    0,  518,    0,    0,    0, 
            0,    0,    0,  517,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  100,  518,  518,    0,  518,  518, 
          518,  518,  518,    0,    0,    0,    0,    0,    0,  519, 
            0,  119,    0,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,    0,    0,  518,  518, 
          518,  519,  530,    0,    0,    0,  518,    0,    0,    0, 
            0,    0,    0,  518,    0,  518,    0,  518,  518,  518, 
          518,  518,  518,  518,    0,  518,    0,  518,    0,  521, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  521, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  520,  520,  520,    0,    0,    0,  520,  520,  518, 
          520,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,    0,    0,    0,  520, 
          520,    0,  520,  520,  520,  520,  520,    0,  521,    0, 
          121,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          521,    0,  520,  520,  520,    0,  532,    0,    0,    0, 
          520,    0,    0,    0,    0,    0,    0,  520,    0,  520, 
            0,  520,  520,  520,  520,  520,  520,  520,    0,  520, 
          512,  520,    0,    0,    0,    0,    0,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  519,  519,  519,    0,    0,    0,  519,  519, 
            0,  519,    0,  520,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   93,    0,    0,    0,    0,    0, 
          519,  519,    0,  519,  519,  519,  519,  519,    0,  512, 
            0,  112,    0,  512,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  519,  519,  519, 
          519, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          512,    0,  519,  519,  519,    0,  531,    0,    0,    0, 
          519,    0,    0,    0,    0,    0,    0,  519,    0,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  511,  519, 
            0,  519,    0,    0,    0,    0,    0,    0,  511,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          521,  521,  521,    0,    0,    0,  521,  521,    0,  521, 
            0,    0,    0,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,   92,    0,    0,    0,    0,    0,  521,  521, 
            0,  521,  521,  521,  521,  521,    0,  511,    0,  111, 
            0,  511,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  511, 
            0,  521,  521,  521,    0,  533,    0,    0,    0,  521, 
            0,    0,    0,    0,    0,    0,  521,    0,  521,    0, 
          521,  521,  521,  521,  521,  521,  521,    0,  521,  514, 
          521,    0,    0,    0,    0,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  512,  512,  512,    0,    0,    0,  512,  512,    0, 
          512,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   95,    0,    0,    0,    0,    0,  512, 
          512,    0,  512,  512,  512,  512,  512,    0,  514,    0, 
          114,    0,  514,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          514,    0,  512,  512,  512,    0,  524,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,    0,  512,    0,  512, 
            0,  512,  512,  512,  512,  512,  512,  512,  230,  512, 
            0,  512,    0,    0,    0,    0,    0,    0,  230,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          511,  511,  511,    0,    0,    0,  511,  511,    0,  511, 
            0,    0,    0,  512,    0,    0,    0,    0,    0,    0, 
            0,    0,  230,    0,    0,    0,    0,    0,  511,  511, 
            0,  511,  511,  511,  511,  511,  230,  230,    0,    0, 
            0,  230,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,    0, 
            0,  511,  511,  511,    0,  523,    0,    0,    0,  511, 
            0,    0,    0,    0,    0,    0,  511,    0,  511,    0, 
          511,  511,  511,  511,  511,  511,  511,    0,  511,  231, 
          511,    0,    0,    0,    0,    0,    0,    0,    0,  231, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  514,  514,  514,    0,    0,    0,  514,  514,    0, 
          514,    0,  511,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,  514, 
          514,    0,  514,  514,  514,  514,  514,  231,  231,    0, 
            0,    0,  231,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
            0,    0,  514,  514,  514,    0,  526,    0,    0,    0, 
          514,    0,    0,    0,    0,    0,    0,  514,    0,  514, 
            0,  514,  514,  514,  514,  514,  514,  514,  304,  514, 
            0,  514,    0,    0,    0,    0,    0,    0,  304,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          230,  230,  230,    0,    0,  230,  230,  230,    0,  230, 
            0,    0,    0,  514,    0,    0,    0,    0,    0,  230, 
          230,    0,  109,    0,    0,    0,    0,    0,  230,  230, 
            0,  230,  230,  230,  230,  230,    0,  304,    0,  128, 
            0,  304,    0,  230,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  230,  230,  230,  230, 
          230,  230,  230,  230,  230,  230,    0,  230,  230,  304, 
            0,  230,  230,    0,    0,    0,  230,    0,    0,  230, 
            0,    0,  230,    0,  230,    0,    0,    0,  230,    0, 
            0,    0,  230,  230,  230,  230,  230,    0,  230,  315, 
          230,    0,    0,    0,    0,    0,    0,    0,    0,  315, 
            0,    0,  230,    0,    0,    0,    0,    0,    0,    0, 
            0,  231,  231,  231,    0,    0,  231,  231,  231,    0, 
          231,    0,  230,    0,    0,    0,    0,    0,    0,    0, 
          231,  231,    0,  108,    0,    0,    0,    0,    0,  231, 
          231,    0,  231,  231,  231,  231,  231,    0,  315,    0, 
          127,    0,  315,    0,  231,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  231,  231,  231, 
          231,  231,  231,  231,  231,  231,  231,    0,  231,  231, 
          315,    0,  231,  231,    0,    0,    0,  231,    0,    0, 
          231,  254,    0,  231,    0,  231,    0,    0,    0,  231, 
            0,  254,    0,  231,  231,  231,  231,  231,    0,  231, 
            0,  231,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,    0, 
          304,  304,  304,    0,    0,  254,  304,  304,    0,  304, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,  254, 
          254,    0,    0,    0,  254,    0,    0,    0,  304,  304, 
            0,  304,  304,  304,  304,  304,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  304,  304,  304,  304,  304, 
          304,  304,  304,  304,  304,  304,  304,  304,  304,    0, 
            0,  304,  304,  304,    0,  255,    0,    0,    0,  304, 
            0,    0,    0,    0,    0,  255,  304,    0,  304,    0, 
          304,  304,  304,  304,  304,  304,  304,    0,  304,    0, 
          304,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  255, 
            0,  315,  315,  315,    0,    0,    0,  315,  315,    0, 
          315,    0,  304,  255,  255,    0,    0,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  315, 
          315,    0,  315,  315,  315,  315,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
            0,    0,  315,  315,  315,    0,    0,    0,    0,    0, 
          315,    0,    0,    0,    0,    0,    0,  315,    0,  315, 
            0,  315,  315,  315,  315,  315,  315,  315,    0,  315, 
            0,  315,    0,  254,  254,  254,    0,    0,  254,  254, 
          254,    0,  254,    0,  241,    0,    0,    0,    0,    0, 
            0,    0,  254,  254,  241,    0,    0,    0,    0,    0, 
            0,  254,  254,  315,  254,  254,  254,  254,  254,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  241,  254, 
          254,  254,  254,  254,  254,  254,  254,  254,  254,    0, 
          254,  254,  241,  241,  254,  254,    0,  241,    0,  254, 
            0,    0,  254,    0,    0,  254,    0,  254,    0,    0, 
            0,  254,    0,    0,    0,    0,    0,  254,  254,  254, 
            0,  254,    0,  254,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,  255,  255,  255, 
            0,    0,  255,  255,  255,    0,  255,    0,  239,    0, 
            0,    0,    0,    0,    0,  254,  255,  255,  239,    0, 
            0,    0,    0,    0,    0,  255,  255,    0,  255,  255, 
          255,  255,  255,    0,    0,    0,    0,    0,    0,    0, 
          255,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  239,  255,  255,  255,  255,  255,  255,  255, 
          255,  255,  255,    0,  255,  255,  239,  239,  255,  255, 
            0,  239,    0,  255,    0,    0,  255,    0,    0,  255, 
            0,  255,    0,    0,    0,  255,    0,    0,    0,    0, 
            0,  255,  255,  255,    0,  255,    0,  255,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  255, 
          240,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          240,    0,    0,    0,    0,    0,    0,    0,    0,  255, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,    0,  241,  241,  241,    0, 
            0,  241,  241,  241,    0,  241,    0,    0,  240,  240, 
            0,    0,    0,  240,    0,  241,  241,    0,    0,    0, 
            0,    0,    0,    0,  241,  241,    0,  241,  241,  241, 
          241,  241,    0,    0,    0,    0,    0,    0,    0,  241, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  241,  241,  241,  241,  241,  241,  241,  241, 
          241,  241,    0,  241,  241,    0,    0,    0,    0,    0, 
            0,    0,  241,    0,    0,  241,    0,    0,  241,    0, 
          241,    0,    0,    0,  241,    0,    0,    0,  246,    0, 
          241,  241,  241,    0,  241,    0,  241,    0,  246,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  241,    0, 
          239,  239,  239,    0,    0,  239,  239,  239,    0,  239, 
            0,    0,    0,    0,    0,    0,    0,    0,  241,  239, 
          239,    0,  246,    0,    0,    0,    0,    0,  239,  239, 
            0,  239,  239,  239,  239,  239,  246,  246,    0,    0, 
            0,  246,    0,  239,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  239,  239,  239,  239, 
          239,  239,  239,  239,  239,  239,    0,  239,  239,    0, 
            0,    0,    0,    0,    0,    0,  239,    0,    0,  239, 
          245,    0,  239,    0,  239,    0,    0,    0,    0,    0, 
          245,    0,    0,    0,  239,  239,  239,    0,  239,    0, 
          239,    0,  240,  240,  240,    0,    0,  240,  240,  240, 
            0,  240,  239,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,  240,    0,  245,    0,    0,    0,    0,    0, 
          240,  240,  239,  240,  240,  240,  240,  240,  245,  245, 
            0,    0,    0,  245,    0,  240,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  240,  240, 
          240,  240,  240,  240,  240,  240,  240,  240,    0,  240, 
          240,    0,    0,    0,    0,    0,    0,    0,  240,    0, 
            0,  240,    0,    0,  240,    0,  240,    0,    0,    0, 
            0,    0,    0,    0,  243,    0,  240,  240,  240,    0, 
          240,    0,  240,    0,  243,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,    0,    0,    0,  243,    0, 
          246,  246,  246,    0,    0,  246,  246,  246,    0,  246, 
            0,    0,  243,  243,    0,    0,    0,  243,    0,  246, 
          246,    0,    0,    0,    0,    0,    0,    0,  246,  246, 
            0,  246,  246,  246,  246,  246,    0,    0,    0,    0, 
            0,    0,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,  246,  246,  246, 
          246,  246,  246,  246,  246,  246,    0,  246,  246,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  246, 
            0,    0,  246,  242,  246,    0,    0,    0,    0,    0, 
            0,    0,    0,  242,  246,  246,    0,    0,    0,    0, 
          246,    0,  245,  245,  245,    0,    0,  245,  245,  245, 
            0,  245,  246,    0,    0,    0,    0,    0,    0,    0, 
            0,  245,  245,    0,    0,    0,    0,  242,    0,    0, 
          245,  245,  246,  245,  245,  245,  245,  245,    0,    0, 
            0,  242,  242,    0,    0,  245,  242,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
          245,  245,  245,  245,  245,  245,  245,  245,    0,  245, 
          245,    0,    0,    0,    0,    0,    0,    0,  245,    0, 
            0,  245,    0,    0,  245,    0,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  245,  245,  247,    0, 
            0,    0,  245,    0,    0,    0,    0,    0,  247,    0, 
            0,    0,    0,    0,  245,    0,  243,  243,  243,    0, 
            0,  243,  243,  243,    0,  243,    0,    0,    0,    0, 
            0,    0,    0,    0,  245,  243,  243,    0,    0,    0, 
            0,    0,  247,    0,  243,  243,    0,  243,  243,  243, 
          243,  243,    0,    0,    0,    0,  247,  247,    0,  243, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  243,  243,  243,  243,  243,  243,  243,  243, 
          243,  243,    0,  243,  243,    0,    0,    0,    0,    0, 
            0,    0,  243,    0,    0,  243,    0,    0,  243,    0, 
          243,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          243,  243,  248,    0,    0,    0,  243,    0,    0,    0, 
            0,    0,  248,    0,    0,    0,    0,    0,  243,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  242,  242,  242,  243,    0, 
          242,  242,  242,    0,  242,    0,  248,    0,    0,    0, 
            0,    0,    0,    0,  242,  242,    0,    0,    0,    0, 
          248,  248,    0,  242,  242,  248,  242,  242,  242,  242, 
          242,    0,    0,    0,    0,    0,    0,    0,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          249,    0,    0,    0,    0,    0,    0,  242,  242,    0, 
          249,    0,  242,  242,    0,    0,    0,    0,    0,    0, 
            0,  242,    0,    0,  242,    0,    0,  242,    0,  242, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  249,  242,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  242,  249,  249, 
          247,  247,  247,  249,    0,  247,  247,  247,    0,  247, 
            0,    0,    0,    0,    0,    0,    0,  242,    0,  247, 
          247,    0,    0,    0,    0,    0,    0,  256,  247,  247, 
            0,  247,  247,  247,  247,  247,    0,  256,    0,    0, 
            0,    0,    0,  247,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,  247,    0,    0,    0,  247,  247,    0, 
            0,  256,    0,    0,    0,    0,  247,    0,    0,  247, 
            0,    0,  247,    0,  247,  256,  256,    0,    0,    0, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,  248,  248,  248,    0,    0,  248, 
          248,  248,    0,  248,    0,    0,    0,    0,    0,  250, 
            0,    0,  247,  248,  248,    0,    0,    0,    0,  250, 
            0,    0,  248,  248,    0,  248,  248,  248,  248,  248, 
            0,    0,    0,    0,    0,    0,    0,  248,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,  248,  248,    0,    0, 
            0,  248,  248,    0,    0,    0,    0,  250,  250,    0, 
          248,    0,  250,  248,    0,    0,  248,    0,  248,    0, 
            0,    0,  249,  249,  249,    0,    0,  249,  249,  249, 
            0,  249,    0,    0,  248,    0,    0,  251,    0,    0, 
            0,  249,  249,    0,    0,    0,  248,  251,    0,    0, 
          249,  249,    0,  249,  249,  249,  249,  249,    0,    0, 
            0,    0,    0,    0,    0,  249,  248,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,  249,  249,    0,    0,    0,  249, 
          249,    0,    0,    0,    0,  251,  251,    0,  249,    0, 
          251,  249,    0,    0,  249,    0,  249,    0,    0,  256, 
          256,  256,    0,    0,  256,  256,  256,    0,  256,    0, 
            0,    0,  249,  257,    0,    0,    0,    0,  256,  256, 
            0,    0,    0,  257,  249,    0,    0,  256,  256,  217, 
          256,  256,  256,  256,  256,    0,    0,    0,    0,  217, 
            0,    0,  256,    0,  249,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  257,    0,    0, 
            0,  256,  256,    0,    0,    0,  256,  256,    0,    0, 
            0,  257,  257,  263,    0,  256,  257,    0,  256,    0, 
            0,  256,    0,  256,    0,    0,    0,    0,  217,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,  250,  250,  250,    0,    0,  250,  250,  250,    0, 
          250,  256,    0,    0,    0,  228,    0,    0,    0,    0, 
          250,  250,    0,    0,    0,  228,    0,    0,    0,  250, 
          250,  256,  250,  250,  250,  250,  250,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  228, 
            0,    0,    0,  250,  250,    0,    0,    0,  250,  250, 
            0,    0,    0,  228,  228,    0,    0,  250,  228,    0, 
          250,    0,    0,  250,    0,  250,    0,    0,    0,  251, 
          251,  251,    0,    0,  251,  251,  251,    0,  251,    0, 
          229,  250,    0,    0,    0,    0,    0,    0,  251,  251, 
          229,    0,    0,  250,    0,    0,    0,  251,  251,    0, 
          251,  251,  251,  251,  251,    0,    0,    0,    0,    0, 
            0,    0,  251,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  229,    0,    0,    0,    0,    0, 
            0,  251,  251,    0,    0,    0,  251,  251,  229,  229, 
            0,    0,    0,  229,    0,  251,    0,    0,  251,    0, 
            0,  251,    0,  251,    0,  257,  257,  257,    0,    0, 
          257,  257,  257,    0,  257,    0,  227,    0,    0,  251, 
            0,  217,  217,  217,  257,  257,  227,  217,  217,    0, 
          217,  251,    0,  257,  257,    0,  257,  257,  257,  257, 
          257,    0,    0,    0,    0,    0,    0,    0,  257,  217, 
          217,  251,  217,  217,  217,  217,    0,    0,    0,    0, 
          227,    0,    0,    0,    0,    0,    0,    0,  257,    0, 
            0,    0,  257,  257,  227,  227,    0,    0,    0,    0, 
            0,  257,    0,    0,  257,    0,    0,  257,    0,  257, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,  226,    0,    0,    0,  257,    0,  228,  228,  228, 
            0,  226,  228,  228,  228,    0,  228,  257,    0,    0, 
            0,  217,    0,    0,    0,    0,  228,  228,    0,    0, 
            0,    0,    0,    0,    0,  228,  228,  257,  228,  228, 
          228,  228,  228,    0,    0,  226,    0,    0,    0,    0, 
          228,    0,    0,  217,    0,    0,    0,    0,    0,  226, 
          226,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,    0,    0,  228,    0,    0,  228, 
            0,  228,  229,  229,  229,    0,    0,  229,  229,  229, 
            0,  229,    0,  222,    0,    0,    0,  228,    0,    0, 
            0,  229,  229,  222,    0,    0,    0,    0,    0,  228, 
          229,  229,    0,  229,  229,  229,  229,  229,    0,    0, 
            0,    0,    0,    0,    0,  229,    0,    0,    0,  228, 
            0,    0,    0,    0,    0,    0,    0,  222,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,  222,    0,    0,    0,    0,    0,  229,    0, 
            0,  229,    0,    0,  229,    0,  229,    0,  227,  227, 
          227,    0,    0,  227,  227,  227,    0,  227,    0,  223, 
            0,    0,  229,    0,    0,    0,    0,  227,  227,  223, 
            0,    0,    0,    0,  229,    0,  227,  227,    0,  227, 
          227,  227,  227,  227,    0,    0,    0,    0,    0,    0, 
            0,  227,    0,    0,  229,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,  223,    0, 
            0,    0,    0,    0,  227,    0,    0,  227,    0,    0, 
          227,    0,  227,  226,  226,  226,    0,    0,  226,  226, 
          226,    0,  226,    0,  224,    0,    0,    0,  227,    0, 
            0,    0,  226,  226,  224,    0,    0,    0,    0,    0, 
          227,  226,  226,    0,  226,  226,  226,  226,  226,    0, 
            0,    0,    0,    0,    0,    0,  226,    0,    0,    0, 
          227,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  224,  224,    0,    0,    0,    0,    0,  226, 
            0,    0,  226,    0,    0,  226,    0,  226,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,    0,  226,    0,  222,  222,  222,    0,  225, 
          222,  222,  222,    0,  222,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,  222,    0,    0,    0,    0, 
            0,    0,    0,  222,  222,  226,  222,  222,  222,  222, 
          222,    0,    0,  225,    0,    0,    0,    0,  222,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,  225,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,  222,  218,    0,  222,    0,  222, 
            0,  223,  223,  223,    0,  218,  223,  223,  223,    0, 
          223,    0,    0,    0,    0,  222,    0,    0,    0,    0, 
          223,  223,    0,    0,    0,    0,    0,  222,    0,  223, 
          223,    0,  223,  223,  223,  223,  223,    0,    0,  218, 
            0,    0,    0,    0,  223,    0,    0,  222,    0,    0, 
            0,    0,    0,  218,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
          223,    0,    0,  223,    0,  223,  224,  224,  224,    0, 
            0,  224,  224,  224,    0,  224,    0,  220,    0,    0, 
            0,  223,    0,    0,    0,  224,  224,  220,    0,    0, 
            0,    0,    0,  223,  224,  224,    0,  224,  224,  224, 
          224,  224,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,    0,  223,    0,    0,    0,  221,    0,    0, 
            0,  220,    0,    0,    0,    0,    0,  221,    0,    0, 
            0,    0,    0,    0,    0,  220,  220,    0,    0,    0, 
            0,    0,  224,    0,    0,  224,    0,    0,  224,    0, 
          224,  225,  225,  225,    0,    0,  225,  225,  225,    0, 
          225,  221,    0,    0,    0,    0,  224,    0,    0,    0, 
          225,  225,    0,    0,    0,  221,  221,    0,  224,  225, 
          225,    0,  225,  225,  225,  225,  225,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          225,  261,    0,  225,    0,  225,    0,  218,  218,  218, 
            0,  261,  218,  218,  218,    0,  218,    0,    0,    0, 
            0,  225,    0,    0,    0,    0,  218,  218,    0,    0, 
            0,    0,    0,  225,    0,  218,  218,    0,  218,  218, 
          218,  218,  218,    0,    0,  261,    0,    0,    0,    0, 
          218,    0,    0,  225,    0,    0,    0,    0,    0,  261, 
          261,    0,  263,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  263,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  218,    0,    0,  218,    0,    0,  218, 
            0,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,  218,    0,  220, 
          220,  220,    0,    0,  220,  220,  220,    0,  220,  218, 
           60,  263,    0,    0,    0,    0,    0,    0,  220,  220, 
           60,    0,    0,    0,    0,    0,    0,  220,  220,  218, 
          220,  220,  220,  220,  220,    0,    0,    0,    0,  221, 
          221,  221,  220,    0,  221,  221,  221,    0,  221,    0, 
            0,    0,    0,    0,  217,    0,    0,    0,  221,  221, 
            0,    0,    0,    0,  217,    0,    0,  221,  221,   60, 
          221,  221,  221,  221,  221,  220,    0,    0,  220,    0, 
            0,  220,  221,  220,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  286,    0,    0,    0,    0,  217,  220, 
            0,    0,    0,  286,    0,    0,    0,    0,    0,    0, 
            0,  220,  217,  217,    0,  221,    0,    0,  221,    0, 
            0,  221,    0,  221,    0,    0,    0,    0,    0,    0, 
            0,  220,    0,    0,    0,    0,    0,  286,    0,  221, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  221,  286,  261,  261,  261,    0,    0,  261,  261, 
          261,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,  221,  261,  261,    0,    0,    0,    0,    0,    0, 
            0,  261,  261,    0,  261,  261,  261,  261,  261,    0, 
            0,    0,    0,    0,    0,  288,  261,    0,    0,    0, 
            0,    0,    0,    0,    0,  288,    0,    0,    0,    0, 
            0,    0,    0,    0,  263,  263,  263,    0,    0,  263, 
          263,  263,    0,  263,    0,    0,    0,    0,    0,  261, 
            0,    0,  261,  263,  263,  261,    0,  261,    0,  288, 
            0,    0,  263,  263,    0,  263,  263,  263,  263,  263, 
            0,    0,  638,  261,  288,    0,    0,  263,    0,    0, 
            0,    0,  638,    0,    0,  261,    0,    0,    0,    0, 
            0,    0,   60,   60,   60,    0,    0,   60,   60,   60, 
            0,   60,    0,    0,    0,  261,    0,    0,    0,    0, 
          263,   60,   60,  263,    0,    0,  263,    0,  263,    0, 
           60,   60,    0,   60,   60,   60,   60,   60,    0,   62, 
            0,  638,    0,    0,  263,    0,  217,  217,  217,   62, 
            0,  217,  217,  217,    0,  217,  263,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,  217,    0,    0,    0, 
            0,    0,    0,    0,  217,  217,  263,  217,  217,  217, 
          217,   60,    0,    0,   60,  286,  286,  286,    0,  217, 
          286,  286,  286,    0,  286,    0,   64,    0,   62,    0, 
            0,    0,   60,    0,  286,  286,   64,    0,    0,    0, 
            0,    0,    0,  286,  286,    0,  286,  286,  286,  286, 
          286,    0,  217,    0,    0,  217,    0,    0,  217,    0, 
          217,    0,    0,    0,   60,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  217,    0,    0,    0, 
            0,  424,    0,    0,    0,   64,    0,    0,  217,    0, 
            0,  424,    0,    0,  286,    0,    0,  286,    0,  286, 
            0,    0,    0,    0,    0,    0,    0,    0,  217,    0, 
            0,    0,    0,    0,    0,  286,    0,  288,  288,  288, 
            0,    0,  288,  288,  288,    0,  288,    0,    0,    0, 
            0,    0,    0,   53,    0,    0,  288,  288,    0,    0, 
          424,    0,    0,   53,    0,  288,  288,  286,  288,  288, 
          288,  288,  288,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  638,  638,  638,    0,    0,  638, 
          638,  638,    0,  638,    0,    0,    0,   55,    0,    0, 
            0,    0,   53,  638,  638,    0,  288,   55,    0,  288, 
            0,  288,  638,  638,    0,  638,  638,  638,  638,  638, 
            0,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
            0,    0,    0,    0,    0,  292,    0,    0,    0,    0, 
            0,   62,   62,   62,    0,  292,   62,   62,   62,    0, 
           62,    0,  293,    0,    0,    0,   55,    0,    0,  288, 
           62,   62,  293,  638,    0,    0,  638,    0,  638,   62, 
           62,    0,   62,   62,   62,   62,   62,    0,    0,  288, 
            0,    0,    0,    0,  638,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  292,    0,  289,    0,   64,   64, 
           64,    0,    0,   64,   64,   64,    0,   64,    0,    0, 
            0,  293,    0,    0,    0,   52,  638,   64,   64,    0, 
           62,    0,    0,   62,    0,   52,   64,   64,    0,   64, 
           64,   64,   64,   64,    0,    0,    0,    0,    0,    0, 
            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  424,  424,  424,  291,    0,  424,  424, 
          424,    0,  424,    0,    0,    0,  291,    0,    0,    0, 
            0,    0,  424,   62,   52,    0,    0,   64,    0,    0, 
           64,  424,  424,    0,  424,  424,  424,  424,  424,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   64,    0, 
          286,    0,    0,    0,    0,   53,   53,   53,    0,  410, 
           53,   53,   53,    0,   53,  291,    0,    0,    0,  424, 
            0,    0,    0,    0,   53,    0,  424,    0,    0,    0, 
           64,    0,  424,   53,   53,    0,   53,   53,   53,   53, 
           53,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  424,    0,    0,    0,    0,    0,   55, 
           55,   55,    0,    0,   55,   55,   55,    0,   55,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   55,    0, 
            0,    0,    0,    0,   53,  424,    0,   55,   55,    0, 
           55,   55,   55,   55,   55,    0,    0,  292,  292,  292, 
            0,    0,  292,  292,  292,   53,  292,  129,    0,    0, 
            0,    0,    0,    0,  293,  293,  293,    0,    0,  293, 
          293,  293,    0,  293,    0,    0,    0,    0,  292,  292, 
          292,  292,  292,    0,    0,    0,    0,   53,   55,    0, 
            0,    0,    0,    0,    0,  293,  293,  293,  293,  293, 
            0,    0,    0,    0,    0,    0,  129,    0,    0,   55, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  292,    0,    0,  292,   52,   52,   52, 
            0,    0,   52,   52,   52,    0,   52,    0,  510,    0, 
          293,   55,    0,  293,    0,    0,   52,  292,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   52, 
           52,   52,   52,    0,  293,    0,    0,    0,  291,  291, 
          291,    0,    0,    0,  291,  291,    0,  291,    0,  292, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  803,  130,    0,  293,    0,    0,  291, 
          291,  291,  291,  291,    0,    0,   52,    0,    0,    0, 
            0,    0,    0,  385,  386,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,    0,  396,  397,   52,    0,  398, 
          399,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  130,  400,    0,  401,  291,  402,  403, 
          404,  405,  406,  407,  408,    0,  409,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,    0,  291,    0, 
            0,    0,    0,    0,    0,  513,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          291,    0,    0,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,    0,    0,  129,  129,    0,  129, 
          129,  129,  129,  129,  129,  129,    0,  612,    0,    0, 
          129,  129,  129,  129,  129,  129,  129,    0,    0,  129, 
            0,    0,    0,    0,    0,  129,  129,    0,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,  129,  129,    0, 
          129,  129,  129,  129,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  510,    0,    0,    0,    0, 
            0,    0,  510,  129,    0,    0,  129,  612,    0,  129, 
          129,    0,  129,    0,  129,    0,    0,    0,  129,    0, 
            0,  129,    0,  129,    0,    0,  129,    0,  612,    0, 
            0,  129,  129,  129,  129,  129,  129,    0,    0,    0, 
          129,    0,  129,  129,    0,  129,  129,  129,  129,    0, 
            0,    0,    0,  619,    0,    0,    0,    0,  129,  129, 
          130,  130,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,    0,    0,  130,  130,    0,  130,  130,  130,  130, 
          130,  130,  130,    0,  613,    0,    0,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,    0,    0,    0, 
            0,    0,  130,  130,    0,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,    0,  130,  130,  130, 
          130,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,    0,    0,    0,    0,    0,    0,  513, 
          130,    0,    0,  130,  613,    0,  130,  130,    0,  130, 
            0,  130,    0,    0,    0,  130,    0,    0,  130,    0, 
          130,    0,    0,  130,    0,  613,    0,    0,  130,  130, 
          130,  130,  130,  130,    0,    0,    0,  130,    0,  130, 
          130,    0,  130,  130,  130,  130,    0,    0,    0,    0, 
          314,    0,    0,    0,    0,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,  129,  129,    0, 
            0,  129,  129,    0,  129,  129,  129,  129,  129,  129, 
          129,    0,  619,    0,    0,  129,  129,  129,  129,  129, 
          129,  129,    0,    0,  129,    0,    0,    0,    0,    0, 
          129,  129,    0,  129,  129,  129,  129,  130,  129,  129, 
          129,  129,  129,  129,    0,  129,  129,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          619,    0,    0,    0,    0,    0,    0,  619,  129,    0, 
            0,  129,  615,    0,  129,  129,    0,  129,    0,  129, 
            0,    0,    0,  129,    0,    0,  130,    0,  129,    0, 
            0,  129,    0,  619,    0,    0,  129,  129,  129,  129, 
          129,  129,    0,    0,    0,  129,    0,  129,  129,    0, 
          129,  129,  129,  129,    0,    0,    0,    0,  315,    0, 
            0,    0,    0,  129,  129,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,  130,  130, 
            0,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
            0,  130,    0,    0,    0,    0,    0,  130,  130,    0, 
          130,  130,  130,  130,  359,  130,  130,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  314,    0,    0, 
            0,    0,    0,    0,  314,  130,    0,    0,  130,  616, 
            0,  130,  130,    0,  130,    0,  130,    0,    0,    0, 
          130,    0,    0,  359,    0,  130,    0,    0,  130,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,    0, 
            0,    0,  130,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          130,  130,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,    0,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,  306,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  315,    0,    0,    0,    0, 
            0,    0,  315,  130,    0,    0,  130,  306,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,    0,    0, 
            0,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
          359,  359,  359,  359,  359,  359,  359,  359,  359,  359, 
          359,    0,  359,  359,  359,  359,  359,  359,  359,  359, 
          359,  359,  359,    0,    0,    0,    0,  359,  359,  359, 
          359,  359,  359,  359,    0,  637,  359,    0,    0,    0, 
            0,    0,  359,  359,    0,  359,  359,  359,  359,    0, 
          359,  359,  359,  359,  359,  359,    0,  359,  359,  359, 
          359,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          359,    0,    0,  359,  637,    0,  359,  359,    0,  359, 
            0,  359,    0,    0,    0,  359,    0,    0,    0,    0, 
            0,    0,    0,  359,    0,    0,    0,    0,  359,  359, 
          359,  359,  359,  359,    0,    0,    0,  359,    0,  359, 
          359,    0,  359,  359,  359,  359,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  359,  359,    0,    0,    0, 
            0,    0,    0,    0,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,    0,    0,  306,  306,    0, 
          306,  306,  306,  306,  306,  306,  306,    0,    0,    0, 
            0,  306,  306,  306,  306,  306,  306,  306,    0,  637, 
          306,    0,    0,    0,    0,    0,  306,  306,    0,  306, 
          306,  306,  306,    0,  306,  306,  306,  306,  306,  306, 
            0,  306,  306,  306,  306,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  306,    0,    0,  306,  637,    0, 
          306,  306,    0,  306,    0,  306,    0,    0,    0,  306, 
            0,    0,    0,    0,    0,    0,    0,  306,    0,   18, 
            0,    0,  306,  306,  306,  306,  306,  306,    0,    0, 
            0,  306,    0,  306,  306,    0,  306,  306,  306,  306, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  306, 
          306,  637,  637,  637,  637,  637,  637,    0,    0,  637, 
          637,  637,    0,    0,    0,  637,    0,  637,  637,  637, 
          637,  637,  637,  637,    0,    0,    0,  255,  637,  637, 
          637,  637,  637,  637,  637,    0,    0,  637,    0,    0, 
            0,    0,    0,  637,  637,    0,  637,  637,  637,  637, 
            0,  637,  637,  637,  637,  637,  637,    0,  637,  637, 
          637,  637,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,  637,    0,    0,  637,    0,    0,  637,  637,    0, 
          637,    0,  637,    0,    0,    0,  637,    0,    0,    0, 
            0,    0,    0,    0,  637,    0,    0,    0,    0,  637, 
          637,  637,  637,  637,  637,    0,    0,    0,  637,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

          637,  637,    0,  637,  637,  637,  637,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  637,  637,    0,    0, 
            0,    0,    0,    0,    0,  637,  637,  637,  637,  637, 
          637,    0,    0,    0,  637,  637,    0,    0,    0,  637, 
            0,  637,  637,  637,  637,  637,  637,  637,    0,    0, 
            0,    0,  637,  637,  637,  637,  637,  637,  637,    0, 
            0,  637,    0,    0,    0,    0,    0,  637,  637,  652, 
          637,  637,  637,  637,    0,  637,  637,  637,  637,  637, 
          637,    0,  637,  637,  637,  637,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  637,    0,    0,  637,    0, 
            0,  637,  637,    0,  637,    0,  637,    0,    0,    0, 
          637,    0,    0,    0,    0,    0,    0,    0,  637,    0, 
            0,  637,    0,  637,  637,  637,  637,  637,  637,    0, 
            0,    0,  637,    0,  637,  637,    0,  637,  637,  637, 
          637,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
          637,  637,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  234,  235,  236,  237,    0,    0,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  238, 
          239,  240,    0,  241,   35,  242,  243,  244,  245,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
          466,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  246,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  335,  336,  337,  338,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  339,  340,  341, 
            0,  342,   35,  343,  344,  345,  346,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,  466,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  347,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   65,   66,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    7, 
          316,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    3,    4,    5,    6,    7,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,  315,    4,    5,    6,    7,  316,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,  317,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,  315, 
            4,    5,    6,    7,  316,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  234,  235,  236, 
          237,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  238,  239,  240,    0,  241,   35,  242, 
          243,  244,  245,  280,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  246,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  281,    0, 
          282,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          283,    0,    0,    0,    0,   52,  284,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,   65,   66,  285,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  234,  235,  236,  237, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  238,  239,  240,    0,  241,   35,  242,  243, 
          244,  245,  280,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  709,    0,  282, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,    0,    0,    0,   52,  284,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    0,  281,  281,  281,    0, 
          281,   65,   66,  285,  281,  281,    0,    0,    0,  281, 
            0,  281,  281,  281,  281,  281,  281,  281,    0,    0, 
            0,    0,  281,  281,  281,  281,  281,  281,  281,    0, 
            0,  281,    0,    0,    0,    0,    0,    0,  281,    0, 
            0,  281,  281,  281,    0,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,    0,    0,  281,    0, 
            0,  281,  281,    0,  281,    0,  281,    0,  281,    0, 
          281,    0,    0,    0,    0,    0,    0,    0,  281,    0, 
            0,    0,    0,  281,  281,  281,  281,  281,  281,    0, 
            0,    0,  281,    0,  281,  281,    0,  281,  281,  281, 
          281,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
          281,  281,  281,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  234,  235,  236,  237,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          238,  239,  240,    0,  241,   35,  242,  243,  244,  245, 
          280,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  281,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,   52,  284,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,   65, 
           66,  285,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  234,  235,  236,  237,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  238, 
          239,  240,    0,  241,   35,  242,  243,  244,  245,  280, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  246,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,  282,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  283,    0,    0,    0, 
            0,   52,  284,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,   65,   66, 
          285,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  234,  235,  236,  237,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  238,  239, 
          240,    0,  241,   35,  242,  243,  244,  245,  280,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  246,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  709,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  283,    0,    0,    0,    0, 
           52,  284,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,   65,   66,  285, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  234,  235,  236,  237,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  238,  239,  240, 
            0,  241,   35,  242,  243,  244,  245,  280,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  283,    0,    0,    0,    0,   52, 
          284,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            0,    4,    5,    6,    7,    8,   65,   66,  285,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    7,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  234,  235,  236,  237, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  238,  239,  240,    0,  241,   35,  242,  243, 
          244,  245,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  130, 
          501,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,  234,  235,  236,  237,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          238,  239,  240,    0,  241,   35,  242,  243,  244,  245, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  643,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  234,  235,  236,  237,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  238,  239, 
          240,    0,  241,   35,  242,  243,  244,  245,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  246,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  281,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  283,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          234,  235,  236,  237,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  238,  239,  240,    0, 
          241,   35,  242,  243,  244,  245,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  643,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  234,  235, 
          236,  237,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  238,  239,  240,    0,  241,   35, 
          242,  243,  244,  245,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,  912, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  283,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  234,  235,  236,  237, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  238,  239,  240,    0,  241,   35,  242,  243, 
          244,  245,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  709,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,  626,  626,  626,    0,  626, 
            0,   65,   66,  626,  626,    0,    0,    0,  626,    0, 
          626,  626,  626,  626,  626,  626,  626,    0,    0,    0, 
            0,  626,  626,  626,  626,  626,  626,  626,    0,    0, 
          626,    0,    0,    0,    0,    0,    0,  626,    0,    0, 
          626,  626,  626,    0,  626,  626,  626,  626,  626,  626, 
            0,  626,  626,  626,  626,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  626,    0,    0,  626,  626,    0, 
          626,  626,    0,  626,    0,    0,    0,    0,    0,  626, 
            0,    0,    0,    0,    0,    0,    0,  626,    0,    0, 
            0,    0,  626,  626,  626,  626,  626,  626,    0,    0, 
            0,  626,    0,  626,  626,    0,  626,  626,  626,  626, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,  626, 
          626,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,  234,  235,  236,  237,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  238,  239, 
          240,    0,  241,   35,  242,  243,  244,  245,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  246,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          234,  235,  236,  237,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  238,  239,  240,    0, 
          241,   35,  242,  243,  244,  245,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  283,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,  234,  235, 
          236,  237,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  238,  239,  240,    0,  241,   35, 
          242,  243,  244,  245,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  283,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,  626,  626,  626, 
            0,  626,    0,   65,   66,  626,  626,    0,    0,    0, 
          626,    0,  626,  626,  626,  626,  626,  626,  626,    0, 
            0,    0,    0,  626,  626,  626,  626,  626,  626,  626, 
            0,    0,  626,    0,    0,    0,    0,    0,    0,  626, 
            0,    0,  626,  626,  626,    0,  626,  626,  626,  626, 
          626,  626,    0,  626,  626,  626,  626,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  626,    0,    0,  626, 
            0,    0,  626,  626,    0,  626,    0,    0,    0,    0, 
            0,  626,    0,    0,    0,    0,    0,    0,    0,  626, 
            0,    0,    0,    0,  626,  626,  626,  626,  626,  626, 
            0,    0,    0,  626,    0,  626,  626,    0,  626,  626, 
          626,  626,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,  626,  626,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  113,  114,  115,  116,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          119,  120,  121,    0,  122,   35,  123,  124,  125,  126, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  128,    0,    0,  129,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  262,  263,  264,  265,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  266,  267, 
          268,    0,  269,   35,  270,  271,  272,  273,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  274,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          335,  336,  337,  338,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  339,  340,  341,    0, 
          342,   35,  343,  344,  345,  346,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          347,    0,    0,  422,    0,    0,   46,   47,    0,   48, 
            0,  423,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  113,  114, 
          115,  116,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,  118,    0,    0,  119,  120,  121,    0,  122,   35, 
          123,  124,  125,  126,    0,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  129,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  335,  336,  337,  338, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,  118, 
            0,    0,  339,  340,  341,    0,  342,   35,  343,  344, 
          345,  346,    0,   40,    0,    0,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  347,    0,    0,  422, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  113,  114,  115,  116,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          119,  120,  121,    0,  973,   35,  123,  124,  974,  126, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  975,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  987,  988,  989,  990,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  991,  992, 
          993,    0,  994,   35,  995,  996,  997,  998,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  999,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,  138, 
          139,  140,  141,  142,  143,  144,  145,   65,   66,  146, 
          147,  148,  149,  150,    0,    0,  151,  152,  153,  154, 
          155,  156,  157,    0,    0,  158,  159,  160,  218,  219, 
          220,  221,  165,  166,  167,  168,  169,  170,  171,  172, 
          173,  174,  175,  176,  222,  223,  224,    0,  225,  181, 
          305,    0,  226,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,    0,    0,  212,   52,  138,  139,  140, 
          141,  142,  143,  144,  145,    0,    0,  146,  147,  148, 
          149,  150,    0,    0,  151,  152,  153,  154,  155,  156, 
          157,    0,    0,  158,  159,  160,  218,  219,  220,  221, 
          165,  166,  167,  168,  169,  170,  171,  172,  173,  174, 
          175,  176,  222,  223,  224,    0,  225,  181,    0,    0, 
          226,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,    0,    0,  212,   52,  138,  139,  140,  141,  142, 
          143,  144,  145,    0,    0,  146,  147,  148,  149,  150, 
            0,    0,  151,  152,  153,  154,  155,  156,  157,    0, 
            0,  158,  159,  160,  161,  162,  163,  164,  165,  166, 
          167,  168,  169,  170,  171,  172,  173,  174,  175,  176, 
          177,  178,  179,    0,  180,  181,  123,  124,  182,  126, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,    0,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  198,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,    0, 
            0,  212,  138,  139,  140,  141,  142,  143,  144,  145, 
            0,    0,  146,  147,  148,  149,  150,    0,    0,  151, 
          152,  153,  154,  155,  156,  157,    0,    0,  158,  159, 
          160,  218,  219,  220,  221,  165,  166,  167,  168,  169, 
          170,  171,  172,  173,  174,  175,  176,  222,  223,  224, 
            0,  225,  181,  355,  356,  226,  357,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  199,  200,    0,  201,  202,  203,  204,  205, 
          206,  207,  208,  209,  210,  211,    0,    0,  212,  138, 
          139,  140,  141,  142,  143,  144,  145,    0,    0,  146, 
          147,  148,  149,  150,    0,    0,  151,  152,  153,  154, 
          155,  156,  157,    0,    0,  158,  159,  160,  218,  219, 
          220,  221,  165,  166,  167,  168,  169,  170,  171,  172, 
          173,  174,  175,  176,  222,  223,  224,    0,  225,  181, 
            0,    0,  226,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  630,  631,  212,    0,  632,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  638,  625, 
          212,    0,  639,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  669,  631,  212,    0,  670,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  687,  625, 
          212,    0,  688,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  689,  631,  212,    0,  690,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  701,  625, 
          212,    0,  702,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  703,  631,  212,    0,  704,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  732,  625, 
          212,    0,  733,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  734,  631,  212,    0,  735,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211, 1064,  631, 
          212,    0, 1065,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211, 1068,  625,  212,    0, 1069,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,  299,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211, 1070,  631, 
          212,    0, 1071,    0,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  299,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  638,  625,  212,    0,  639,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,    2,   28,   15,   16,   51,   74,   19,   27,   99, 
            2,    3,    4,    5,    2,    3,    6,    9,   10,   11, 
          445,    7,   14,   15,   16,   21,   21,   19,    7,  557, 
          421,  253,  413,  414,  463,  291,   49,  418,  369,  415, 
           11,   27,    6,    7,  483,  330,   47,   48,   27,  334, 
           10,   10,   11,   45,  468,    4,    5,   49,  503,   51, 
           10,  442,   52,   27,  302,   14,   10,   32,  444,    3, 
           15,   16,   59,    0,   19,  456,  457,   10,  369,   59, 
           15,   16,  458,  522,   19,   59,  324,  325,   52,  470, 
          673,   10,  118,   10,    0,   10,  472,   10,  580,   59, 
           49,  480,   47,   48,  483,   10,   91,   99,  691,   59, 
          106,  106,   47,   59,   10,   91,  447,  112,  425,  762, 
           32,   45,  705,   59,  505,  683,   59,   10,  317,  764, 
          756,  589,   10,  104,   44,  693,  128,    0,  130,   44, 
          860,  136,   59,  104,  751,  532,   61,   10,  529,   59, 
           99,  858,   10,  736,   59,  531,  969,   10,   10,   43, 
           10,  132,  340,   59,   44,  623,  305,   10,  775,    2, 
            3,  280,   10,   10,   10,   10,   59,  370,  371,   59, 
           10,  325,   10,   61,  377,   10,   44,   10,  305,  382, 
          290,  291,   44,   10,   10,   10,   59,  370,  371,  372, 
           10,  280,   10,  269,  377,  271,   59,   44,   44,   59, 
           10,  280,   45,  282,  358,   10,   59,  745,  746,   10, 
           10,   44,   59,   59,   59,   10,   10,  558,   10,   59, 
          340,   59,   10,  422,   44,  374,  492,  944,   61,   10, 
           10,  233,  667,  127,   10, 1058,   61,  485,   10,   59, 
           10,   10,  361,  678,   10,  493,  494,  374,  348,   10, 
          785,  340,   44,   10,   59,  652,  791,  558,  260,  261, 
          129,   61,  306,  511,   10,  882,  310,   59,  717,   44, 
          305,  726,  361,   61,  296,  256,  298,  299,  349,  350, 
           61,  344,  361, 1013,   59,   10,   44,  130,  299,   61, 
          310,  260,  261,   10,  296,  948,  298,  299, 1015,  362, 
          302,   59,  304,   44,   61,  308,  341,  309,   10,   44, 
          955,   10,  965,  315,  950,  317,  361,  315,   59,   32, 
          858,   32,  860,  358,  326,  372,   61,  716,  717,  256, 
          377, 1048,   32,  328,   59,  676,  804,   10,  319,  374, 
          335,  296,  328,  298,   61,   44,  348,   32,  319,  335, 
           91,  296,  267,  298,  279,  268,  269,  263,  264,  305, 
           59,  358,  305,  419,  681,  421,   91,  935,  358,  425, 
          426,  264,  375,  376,  358,  676,  378,  379,  380,  381, 
          382,  383,  384,  317,  382,  341,  340,  879,   61,  348, 
          233,  279,  362,  415,  886,  370,  371,  798,  341,  891, 
          423, 1054,  377,  651,  415,  802,  944,  945,  413,  378, 
          379,  380,  381,  415,  838,  344,  341,  419,  341,  421, 
          422,  423,  444,  425,  426,  362,  428,  675,  374,  356, 
          428,  374,  532,  444,  394,  730,  458,  442,  358,  450, 
          414,  281,  444,  445,  446,  711,  362,  458,  370,  371, 
          472,  456,  454,  341,  279,  377,  458,  438,  305,  305, 
          462,  472,  267,  695,  423,  470,  309,  305,  358,  443, 
          472,  500,  315,  721,  317, 1013,  421, 1015,  341, 1072, 
          425,  729,  917,  457,  428,  305,  467,  468,  422,  362, 
          939,  279,  503,  341,  341,  341,  935,  471,  279,  501, 
          505,  503,  750,  341,  500,  503,  341,  279,  341,  531, 
         1048,  500,  514,  305,  341,  341,  341,  344,  344,  464, 
          531,  341,  279,  341,  529,  480,  500,  374,  374,  531, 
          532,  341,  506,  338,  344,   10,  374, 1029,  358,  382, 
          341,  341,  267,  344,  279,   45,  341,  341,   10,  341, 
          939,  986,  652,  341,  374,  280,  530,   91,  569,  365, 
          341,  341,  279,  811,  519,  341,  358,  104,  267,  341, 
          282,  341,  341,  532,  443,  341,  842,  588,  589,  422, 
          341,  922,  374,  358,  341,  428,   61,  328,  290,  291, 
          337,  328,   10,   44,  335,  571,  572,   59,  335,  340, 
          358,  637,  445,  328,  263,  264,  279,  317,    0,  857, 
          335,  454,  623,   44,   61,  340,  627,  358,   10,  462, 
          372,  627,  627,   61,  341,  377,   10,  633,  633,  640, 
          130,  731,   10,  337,  640,  640,  361,  673,  348,  338, 
           91,   59,  352,  353,  340,    2,    3,   44,  310, 1040, 
          652,  680,    9,   10,   11,  691, 1042,  668,   15,   16, 
          503,  337,   19,  668,  666,  667,  671,   59,  341,  705, 
          681,  514,  683,   10,  685,   59,  678,  337,   61,  679, 
          372,   59,  693,  664,  680,  377,   91,  271,   45,   10, 
          372,  680,  924,  652,   51,  377,  677,  666,  930,   59, 
          736,   44,  802,  310,  706,  679,  680,   15,   16,  279, 
          338,   19,   91,   91,   44,  726,   10,  795,   44,  256, 
           10,  361,   59,  317,  726,  317,  782,  783,  726,  731, 
          341,  337,  788,  789,  344,   10,  681,  706,   59,  362, 
          751,   10,  798,   91,  780,  308,  309,   44,  311,  310, 
           44,   44,  372,    9,   10,   11,  372,  759,  760,  263, 
          264,  716,   91,  372,  775,  269,   44,   61,  372,   59, 
           91,  128,  731,  130,  346,  777,  340,  779,  262,  781, 
          782,  783,  319,  264,   59,  267,  788,  789,  264,  341, 
           59,   44,   44,  804,  328,  362,  798,   91,   44,  361, 
          802,  335,   32,   61,  279,  267,   44,  818,  306,  309, 
          821,  306,  375,  376,   59,   44,   10,  317,  820,   91, 
           10,  823,   91,   44,  667,  806,   15,   16,  279,  280, 
           19,   44,  834,  835,  836,  678,  306,  370,  371,  372, 
          370,  371,  372,  802,  377,   44,   44,  377,   10,  267, 
           44,  907,   41,   42,  823,   32,   61,  838,   47,   48, 
          337,   50,   51,   10,   44,  395,  341,   61,  337,   59, 
          312,  882,  128,  337,  337,  317,  233,  328,   44,   44, 
          264,   44,   44,  726,  335,  269,   44,  863,  264,  267, 
          892,  337,   91,  337,  269,  871,  872,   91,  874,   61, 
          876,   91,  280,  260,  261,  907,  264,  349,  350,  337, 
          361,   91,   59,  337,  916,  917,  759,  760,   44,  362, 
          337,  923,  422,  328,  935,  927,   91,  264,   91,   91, 
          335,  268,  269,  892,  777,  344,  779,  264,  781,  296, 
          264,  298,  299,  338,   91,  302,  267,  304,  263,  328, 
          328,  393,  309,  264,  454,  337,  335,  335,  315,  961, 
          317,  264,  462,  306,  923,  308,  309,  310,  311,  326, 
           10,   44,  262,  263,  264,  362,   44,  820,  268,  269, 
          328,  271,  341,  361,  986,  279,   44,  335,  296,  264, 
          298,  834,  835,  836,  269,   44,  271,  264,  267,  328, 
          362, 1003,  961, 1005,  260,  261,  335,  328,   44, 1011, 
         1012,   44,   44,  306,  335,  308,  309,  310,  311,   59, 
         1042,  378,  379,  380,  381,  382,  383,  384,   44,   44, 
           61, 1042, 1043, 1044,  328, 1040, 1072,   44,   44,  358, 
         1042,  335, 1018, 1019, 1020, 1021,  302,  341,  304,   10, 
          264,  341,  362,   58,   10,  264,  328,   10,  415,  328, 
         1034,  264,  419,  335,  421,  422,  335, 1041,  425,  426, 
          326,  428,  362,  916,  917,   44,  358,  267,  264,  310, 
          279,  362,  264,  310,  927,  279,  280,  444,  445,  446, 
          280,  280,  281,  282,  283,   44,  285,  454,   59,  279, 
           44,  458, 1078,   59,  394,  462,   59,  296,   44,  298, 
          299,   44,   44,   44,  279,  472,  279,  279,  307,  264, 
          267,  264,  378,  379,  380,  381,  394,  383,  384,  328, 
           91,   44,  271,  344,  328,   91,  335,  362,  328,  340, 
          271,  335,  344,  986,  501,  335,  503,  341,  328,  341, 
          340,  344,    2,    3,  362,  335,  264,  514,  341,  344, 
         1003,  358, 1005,  328,   14,  328,  328,  361, 1011, 1012, 
          335,  361,  335,  335,  531,  340,   58,  215,  340,  341, 
           70,  328,  370,  371,  372,   10,  284,   54,  335,  377, 
          446,    5,   10,  340,  514,   45,  385,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,  397,  398, 
          399,  400,  401,  402,  403,  404,  405,  406,  407,  408, 
          409,  371,  262,  263,  264, 1044,  415,    6,  268,  269, 
          419,  271,  421,   10,   59,  922,  425,  426,  640,  762, 
           44,   59,  370,  371,  372,  501,  775,  766,  967,  377, 
            2,    3,    4,    5,  795,  444,   10,  965,   14,  759, 
          760, 1043,   14,   -1,   10,  745,  950,   44,   -1,  458, 
          459,  460,  461,   91,   -1,  464,   -1,  777,   -1,  779, 
          130,  781,   -1,  472,   61,   -1,   -1,   91,   -1,   -1, 
          479,  480,   -1,   45,  483,   10,   -1,   49,   -1,   10, 
           -1,  341,   -1,   -1,   48,   59,  267,   -1,   -1,  666, 
          667,  267,   -1,   59,   91,   -1,   -1,   -1,  507,  508, 
          820,  678,  362,   -1,  280,  370,  371,  372,   -1,   -1, 
          519,   -1,  377,  522,  834,  835,  836,   91,   -1,   -1, 
           -1,   44,  531,   -1,   59,   91,   -1,   99,   59,  706, 
           -1,   -1,   -1,  306,  394,  308,  309,  310,  311,  312, 
           -1,  370,  371,  372,  317,   10,   10,  328,  377,  726, 
           10,   -1,  328,   -1,  335,  328,   91,   -1,  130,  335, 
           91,   44,  335,  233,  340,   -1,  339,  340,   91,   -1, 
           -1,   -1,  581,   -1,  347,  348,  349,  350,   -1,   -1, 
           44,   -1,  759,  760,   10,  361,  370,  371,  372,   -1, 
          666,    0,   -1,  377,   59,   -1,  916,   61,   -1,   59, 
          777,   10,  779,   10,  781,  782,  783,  927,   91,   -1, 
           -1,  788,  789,  622,   -1,   -1,   -1,  262,  263,  264, 
          393,  798,   -1,   -1,  269,   -1,   91,   91,   -1,  267, 
          706,   91,   10,   59,  643,   44,   -1,   44,   -1,  309, 
           -1,   -1,  280,  820,   10,  315,  823,  317,   -1,   -1, 
           59,   -1,   -1,   -1,   61,  279,   44,  834,  835,  836, 
           -1,  233,  370,  371,  372,   91,   -1,   -1,   -1,  377, 
           -1,   59,  681,   -1,   -1,   44,   -1,   44,   44,   -1, 
           -1,   59,  279, 1003,   91, 1005,  378,  379,  380,  381, 
          328, 1011, 1012,  267,   -1,   61,   -1,  335,  707,   -1, 
          709,  267,  340,   91,  328,   -1,  280,  716,  717,   -1, 
           10,  335,  382,   91,   -1,   -1,  280,  281,  282,    0, 
           -1,  285,   91,  361,   91,   91,   -1,   -1,   -1,   10, 
          907,  328,  267,   -1,  743,   -1,  267,  309,  335,  916, 
          917,   -1,   -1,  315,  341,  317,   10,  823,   -1,   -1, 
          927,  421,  422,   -1,  328,   -1,  279,   -1,  428,   59, 
           -1,  335,  328,   44,   -1,   -1,  340,   44,   -1,  335, 
           -1,   -1,   -1,  782,  783,  445,  348,   58,   59,  788, 
          789,   -1,   63,   -1,  454,   -1,   -1,  361,  797,  798, 
          799,   91,  462,  328,  803,   59,  279,  328,   10,   -1, 
          335,   -1,  267,   -1,  335,  328,   -1,  267,   -1,  986, 
          382,   -1,  335,   -1,   91,  279,  280,  826,  827,  828, 
          829,   -1,   -1,   -1,  833,   -1, 1003,   91, 1005,   -1, 
           -1,   -1,   44,  503, 1011, 1012,  293,  294,  295,  296, 
          297,  267,   -1,   -1,  514,  328,   -1,   -1,   -1,   61, 
          422,  423,  335,  262,  263,  264,  428,  421,  267,  268, 
          269,  425,  271,  328,  328, 1042,   -1,   -1,  328,   -1, 
          335,  335,  279,  445,   -1,  335,  340,  341,   -1,   91, 
           -1,   -1,  454,   59,  293,  294,  295,  296,  297,  267, 
          462,   44,  280,   -1,   -1,   -1,   -1,  361,  907,   -1, 
          464,   -1,  328,  912,   -1,   -1,   -1,   44,   -1,  335, 
          279,   -1,  279,  279,  280,  479,  480,   -1,   -1,  483, 
           -1,  328,  306,  932,  308,  309,  310,  311,  335,  338, 
          939,  503,  341,    0,  341,   -1,   -1,   -1,   91,   -1, 
          328,   -1,  514,   10,   -1,   -1,   -1,  335,   -1,   -1, 
          328,   -1,  340,  362,   91,  519,   -1,  335,  522,  328, 
          532,  328,  328,   -1,   -1,   -1,  335,  267,  335,  335, 
          358,   10,   -1,  361,  340,  341,   44,   44,   -1,   -1, 
           -1,  262,  263,  264,   44,  394,  267,  268,  269,   -1, 
          271,   58,   59,   -1,   -1,  361,   -1,  667,   -1,   -1, 
          281,  282,  279,  267,   -1,   44,   -1,   -1,  678,  290, 
          291,   -1,  293,  294,  295,  296,  297,  581,   -1,   -1, 
           -1,   -1,   61,   91,  305,   -1, 1035,   -1,  328,   -1, 
           44,   91,   -1, 1042,   10,  335,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,  328,   91,   -1,   -1,   -1,  726,  338,  335,   -1, 
          341,   -1,   -1,  344,  328,  346,   -1,  279,   44,   -1, 
           -1,  335,   -1,   -1,   -1,  356,  357,   91,   -1,  643, 
          652,  362,   -1,   -1,   -1,   61,   -1,   10,   -1,  759, 
          760,  766,   -1,  374,  769,  667,   -1,   10,   -1,   -1, 
          775,   -1,   -1,   -1,   -1,   10,  678,  777,   -1,  779, 
           -1,  781,  762,  394,  764,   91,  328,  681,   -1,   -1, 
           -1,   44,   -1,  335,   -1,  775,  279,   -1,  798,  341, 
          306,   44,  308,  309,  310,  311,  312,   -1,   61,   44, 
           -1,  317,  279,  707,   -1,  709,   -1,   -1,   61,   -1, 
          820,   -1,  716,  717,  726,   -1,   61,   -1,   -1,  731, 
           -1,   -1,   -1,  339,  834,  835,  836,  739,   91,   -1, 
           -1,  347,  348,  349,  350,  328,   -1,   -1,   91,  743, 
           -1,   -1,  335,   -1,   -1,   -1,   91,  759,  760,   -1, 
           -1,  328,   -1,    0,   -1,  262,  263,  264,  335,   -1, 
          267,  268,  269,   10,  271,  777,   -1,  779,   -1,  781, 
           -1,  279,  280,   -1,  281,  282,   -1,  393,   -1,  279, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          802,   -1,   -1,   -1,   -1,  799,   -1,   44,  305,   -1, 
          279,  280,   -1,   -1,   -1,  317,  916,  917,  820,   -1, 
           -1,   58,   59,  923,   61,   -1,   63,  927,   -1,   -1, 
          328,   -1,  834,  835,  836,  279,  280,  335,  328,  833, 
           -1,  338,  340,   -1,  341,  335,  348,  344,   -1,  346, 
          352,  353,  354,  355,   91,   -1,   -1,  962,   -1,  328, 
          965,   -1,  967,  361,  969,  362,  335,   -1,   -1,   -1, 
           -1,  340,  341,  279,  280,  955,  306,  374,  308,  309, 
          310,  311,  312,   -1,  328,  965,  986,  317,   -1,  969, 
          892,  335,  361,   -1,   -1,   -1,  340,  394,   -1,   -1, 
           -1,   -1,   -1, 1003,   -1, 1005,    0,   -1,   -1,  339, 
           -1, 1011, 1012,   -1,  916,  917,   10,  361,  912,  349, 
          350,  923,  328,   -1,   -1,  927,  279,  280,  306,  335, 
          308,  309,  310,  311,  340,  341,  279,   -1,  306,   -1, 
          308,  309,  310,  311,  279,  939,   -1,   -1,   -1, 1054, 
           44, 1056,   -1, 1058,   -1,  361, 1061,   -1,   -1,  961, 
           -1,  339,   -1,  393,   58,   59,   -1,   61,   -1,   63, 
           -1,  339,   -1,   -1,   -1,  328,   -1,   -1, 1058,  347, 
           -1, 1086,  335,   -1,  986,  328,   -1,  340,  341,   -1, 
           -1,   -1,  335,  328,   -1,   -1,   -1,   91,  341,   -1, 
          335, 1003,   -1, 1005,   -1,   -1,  341,   -1,  361, 1011, 
         1012,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   10,  373,  374,  375,  376, 
           -1,  378,  379,  380,  381,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  391,  392,  393,  394,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,    0,  373, 
          374,  375,  376,   -1,  378,  379,  380,  381,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393, 
          394,   -1,  361,   -1,  363,  306,  365,  308,  309,  310, 
          311,  312,  371,   -1,   -1,  883,  317,   -1,   -1,  887, 
           -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   58,   59,  339,   61, 
          306,   63,  308,  309,  310,  311,  347,  348,  349,  350, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,  393,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,  341,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,    0,  292,  477,   -1, 
           -1,   -1,   -1,   -1,  299,  362,   10,  302,  303,  304, 
          341,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1, 1023,   -1,  394, 1026, 1027, 
           44,  336, 1030, 1031,  339,   -1,  341,  342,  343,   -1, 
          345,   -1,   -1,   -1,   58,   59,  351,   61,   -1,   63, 
           -1,   -1,   -1,  394,  359,   -1,   -1,  546,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   91,   -1,   -1, 
           -1, 1079, 1080, 1081, 1082,   -1,  391,  392,   -1,   -1, 
           -1,   -1, 1090,   -1,   -1,  584,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   10, 
           -1,  333,  334,  335,  336,   -1,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  775,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  766,   -1,  391, 
          392,  393,  394,  257,  258,  259,  775,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,  317,   -1,    0,  373, 
          374,  375,  376,   -1,  378,  379,  380,  381,   10,   -1, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  391,  392,  393, 
          394,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,   -1,   -1,  358,  962,  360, 
           -1,  965,   44,  967,   -1,  969,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,  962,  265,  266,  965,   -1,  967,  270, 
          969,  272,  273,  274,  275,  276,  277,  278,   -1,   91, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
         1054,   -1, 1056,   -1, 1058,   -1,    0, 1061,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   10,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1, 1086,   -1,   -1, 1054,   -1, 1056,  359, 1058, 
           -1,   -1, 1061,  364,  365,  366,  367,  368,  369,   -1, 
           44,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,   -1,   -1,   58,   59,   -1, 1086,   -1,   63, 
          391,  392,  393,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  317,   -1,   -1,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          333,  334,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  348,  360,   10,   -1,  352, 
          353,  354,  355,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   10,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   59,   10,   -1,   -1,   -1,  391, 
          392,  393,  394,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   59,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,    0,  373, 
          374,  375,  376,   -1,  378,  379,  380,  381,   10,   -1, 
          306,   -1,  308,  309,  310,  311,  312,  391,  392,  393, 
          394,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,  312, 
           -1,   -1,   44,  339,  317,   -1,   -1,  317,   -1,   -1, 
           -1,  347,  348,  349,  350,  328,   58,   59,   -1,   -1, 
           -1,   63,  335,  333,  334,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,  348,   -1, 
          350,   -1,  352,  353,  354,  355,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  393,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          393,  306,   -1,  308,  309,  310,  311,  312,   -1,  339, 
          340,   -1,  317,   -1,   -1,   -1,    0,  347,  348,  349, 
          350,   -1,   -1,  328,   -1,   -1,   10,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           44,   -1,  317,  393,   -1,  317,   -1,   -1,   -1,   -1, 
          322,  323,   -1,  328,   58,   59,   -1,   -1,   -1,   63, 
          335,  333,  334,   -1,  339,  340,   -1,   -1,  393,   -1, 
           -1,   -1,  347,  348,  349,  350,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   91,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,  393,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   10,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   59,   10,   -1,   -1,   -1,  391, 
          392,  393,  394,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   59,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,    0,  373, 
          374,  375,  376,   -1,  378,  379,  380,  381,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393, 
          394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,  312, 
           -1,   -1,   44,   -1,  317,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   58,   59,   -1,   61, 
           -1,   63,  335,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          393,  306,   -1,  308,  309,  310,  311,  312,   -1,  339, 
          340,   -1,  317,   -1,   -1,   -1,    0,  347,  348,  349, 
          350,   -1,   -1,  328,   -1,   -1,   10,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           44,   -1,  317,  393,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   59,   -1,   -1,   -1,   63, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,  393,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,  393,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   10,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   44,   -1,  391, 
          392,  393,  394,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   91,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,    0,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393, 
          394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,  312, 
           -1,   -1,   44,   -1,  317,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   59,   -1,   -1, 
           -1,   63,  335,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
          393,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   10,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,  328,  347,  348,  349,  350,   -1,   -1,  335,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,  361,   59,   -1,  314,  315,   63, 
          317,  318,  319,  320,  321,  322,  323,   -1,  393,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   91,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  391, 
          392,  393,  394,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393, 
          394,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,   44,  326,  327,   -1,   -1,   -1,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,    0,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   10,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   10,   -1, 
          333,  334,  335,  336,  337,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392, 
          393,  394,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   91,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   10,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   44, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,  391, 
          392,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   10,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   63, 
          333,  334,  335,  336,   -1,   10,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   44, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   61,   -1,  391,  392, 
          393,  394,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   91,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   10,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   91,  333, 
          334,   91,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,    0,  329,  330,   -1,   -1, 
          333,  334,   -1,  328,   -1,   10,   -1,   -1,   10,   -1, 
          335,   -1,   -1,   -1,   -1,  348,  341,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   61, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,  279, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  328,   -1, 
          333,  334,  335,  336,   -1,  335,  339,  340,  341,  342, 
          343,  341,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,    0,  378,  379,  380,  381,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  391,  392, 
          393,  394,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   59,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   -1,  333,  334, 
          335,  336,   -1,  335,  339,  340,  341,  342,  343,  341, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  391,  392,  393,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   59,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   10,   -1,  339,   -1,  341,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   44,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  391,  392,  393,  394,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   91,   -1,  279,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,    0, 
          333,  334,  335,  328,   -1,  338,   -1,   -1,  341,   10, 
          335,  344,   -1,  346,   -1,  348,  341,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   -1,   44,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           61,  394,   63,   -1,   -1,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,  280,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
          394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,   10,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  374,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   61,   10, 
           -1,   -1,   -1,   -1,   44,  394,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   61,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           61,   91,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  374,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,  394,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  305,   59,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,    0,  333,  334,  335,   91,  337,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,  348, 
           91,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,   58,   59,   -1,   61,  394,   63,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
          281,  282,  335,   -1,   91,   -1,   -1,   -1,  341,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,  305,  335,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,    0,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   10,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,  280,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  374,   -1,   44,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  279,  280,   -1,   -1,   58, 
           59,   -1,   61,  394,   63,   -1,   -1,   -1,  279,  280, 
           -1,  293,  294,  295,  296,  297,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  328,   -1,  358,   -1,   -1,  361, 
           -1,  335,   -1,   10,   -1,   -1,  340,  328,   -1,  341, 
           -1,   -1,   -1,   -1,  335,  262,  263,  264,   -1,  340, 
          267,  268,  269,   -1,  271,   -1,   -1,  361,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
          361,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   61,   -1,   63,   -1,  305,   -1, 
           -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
          337,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  394,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,  394,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,    0,  333,  334,  335,   -1, 
          337,  338,   -1,   -1,  341,   10,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,  280, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   61,  394,   63,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,  281,  282,  335,   -1,   91,   -1,   -1,  340, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,  358,   -1,   -1, 
          361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,    0,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1,   -1, 
           -1,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,  394,   63,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,    0,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   61,   -1,   63,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   91,   -1,  333,  334, 
          335,   -1,  337,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,  281,  282,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,  754,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,  764,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  775,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
          337,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,  394,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,  337,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,   -1,  362,   59,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  953,  271,  955,   -1,  957,  394, 
           -1,   -1,   -1,  962,  280,  281,  282,   -1,   44,   -1, 
          969,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   61,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,  361,  362,   -1,   -1,   -1, 
           -1, 1050,   -1,   -1,   -1,   -1,   -1, 1056,  374, 1058, 
           -1,   -1, 1061,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  394,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1, 1086,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,  362,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,    0,  338,  394,   -1,  341,   -1,   -1,  344,   -1, 
          346,   10,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  374,   -1, 
          267,  268,  269,   -1,  271,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,  394,   58, 
           59,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,  374,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   44,  394,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           58,   59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   91,  333,  334,  335,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   44,  394,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  290,  291,   63,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  394,   58,   59,   -1,   -1, 
           -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  374,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   44,  394,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   58, 
           59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   91,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,  374,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   44,  394,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   59,   -1, 
           -1,   -1,   63,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           91,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  394,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  374,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   44,  394,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   91,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   44,  394,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  394,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,    0,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   10,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,  394,   58,   59,   -1,  290,  291, 
           63,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,    0,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   10,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  374,  267,  268,  269,   -1,  271,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  394,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   10,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          394,   58,   59,   -1,   -1,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  374,  267,  268,  269,   -1,  271,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,  394,   58,   59,   -1,  290,  291,   63,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,  394, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   59,   -1,   61,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   91,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  394,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   59,   -1,   61,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   91,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,    0,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,  394,   -1, 
           -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   91,  333,  334,  335, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,  361,  362,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,  394,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           91,  337,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,    0,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,  394,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   91,   -1,  333,  334, 
          335,   -1,  337,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,  394, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   91,  337,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,  394, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,    0,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   91, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,  350,   -1, 
           -1,   -1,  354,  355,  356,  357,  358,   -1,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           91,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,    0,   -1,  344,   -1,  346,   -1,   -1,   -1,  350, 
           -1,   10,   -1,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   44,  268,  269,   -1,  271, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,    0,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   10,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,  394,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,  394,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   58,   59,  333,  334,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  394,  281,  282,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   58,   59,  333,  334, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,  350,   -1,   -1,   -1,    0,   -1, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  394,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
            0,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,  394,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  394,   -1,   -1,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,    0,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  356,  357,   -1,   -1,   -1,   -1, 
          362,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          290,  291,  394,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   58,   59,   -1,   -1,  305,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  356,  357,    0,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  394,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,    0,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  394,   -1, 
          267,  268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  290,  291,   63,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           10,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   58,   59, 
          262,  263,  264,   63,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  394,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,    0,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,  394,  281,  282,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          338,   -1,   63,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,  362,   -1,   -1,    0,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,  374,   10,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,  394,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   58,   59,   -1,  338,   -1, 
           63,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,  362,    0,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   10,  374,   -1,   -1,  290,  291,    0, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  305,   -1,  394,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   58,   59,   44,   -1,  338,   63,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,  374,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   10,   -1,   -1,   -1,  290, 
          291,  394,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   58,   59,   -1,   -1,  338,   63,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,  374,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   58,   59, 
           -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,    0,   -1,   -1,  362, 
           -1,  262,  263,  264,  281,  282,   10,  268,  269,   -1, 
          271,  374,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,  290, 
          291,  394,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1, 
           -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,    0,   -1,   -1,   -1,  362,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,  374,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,  394,  293,  294, 
          295,  296,  297,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
          374,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
          394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,  362,   -1,  262,  263,  264,   -1,   10, 
          267,  268,  269,   -1,  271,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,  394,  293,  294,  295,  296, 
          297,   -1,   -1,   44,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,    0,   -1,  344,   -1,  346, 
           -1,  262,  263,  264,   -1,   10,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,  394,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,  374,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   44,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   58,   59,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,  394,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,    0,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  362,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  374, 
            0,   59,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  394, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  262, 
          263,  264,  305,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  290,  291,   59, 
          293,  294,  295,  296,  297,  338,   -1,   -1,  341,   -1, 
           -1,  344,  305,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   44,  362, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   58,   59,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  394,   -1,   -1,   -1,   -1,   -1,   44,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   59,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  394,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,  281,  282,  344,   -1,  346,   -1,   44, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,    0,  362,   59,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  394,   -1,   -1,   -1,   -1, 
          338,  281,  282,  341,   -1,   -1,  344,   -1,  346,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,    0, 
           -1,   59,   -1,   -1,  362,   -1,  262,  263,  264,   10, 
           -1,  267,  268,  269,   -1,  271,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,  394,  293,  294,  295, 
          296,  341,   -1,   -1,  344,  262,  263,  264,   -1,  305, 
          267,  268,  269,   -1,  271,   -1,    0,   -1,   59,   -1, 
           -1,   -1,  362,   -1,  281,  282,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   59,   -1,   -1,  374,   -1, 
           -1,   10,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  394,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,  281,  282,   -1,   -1, 
           59,   -1,   -1,   10,   -1,  290,  291,  394,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   59,  281,  282,   -1,  341,   10,   -1,  344, 
           -1,  346,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   10,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   59,   -1,   -1,  394, 
          281,  282,   10,  341,   -1,   -1,  344,   -1,  346,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,    0,  394,  281,  282,   -1, 
          341,   -1,   -1,  344,   -1,   10,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,    0,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  281,  394,   59,   -1,   -1,  341,   -1,   -1, 
          344,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           44,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   63, 
          267,  268,  269,   -1,  271,   59,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,  281,   -1,  335,   -1,   -1,   -1, 
          394,   -1,  341,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,  341,  394,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  362,  271,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,  394,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   91,   -1, 
          338,  394,   -1,  341,   -1,   -1,  281,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294, 
          295,  296,  297,   -1,  362,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  297,   10,   -1,  394,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,  362,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,  348,   -1,  350,  341,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          394,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   10,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   59,   -1,  356,   -1,   -1,  359,   -1,  361,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,  391,  392, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   -1,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   10, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,  339,  340,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   59,   -1, 
          356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   10,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   59,   -1,  356,   -1, 
           -1,  359,   -1,  361,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,  391,  392,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   10,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   59,   -1,  356,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   10,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,   59,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   10,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   59,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   10, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   59,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,  361, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391, 
          392,  256,  257,  258,  259,  260,  261,   -1,   -1,  264, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   10,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          375,  376,   -1,  378,  379,  380,  381,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   44, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          391,  392,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  391,  392, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,   -1,   -1,  257,  258,  259,  260, 
          261,   -1,  391,  392,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1, 
          391,  392,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,  256,  257,  258,  259,  260,  261,   -1,  391,  392, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,  391,  392,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  391,  392,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  391,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  391,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          391,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  391, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  391,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  391,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,   -1,   -1, 
           -1,  257,  258,  259,  260,  261,  391,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,  257, 
          258,  259,  260,  261,   -1,  391,  392,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  391,  392,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  391,  392,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  391, 
          392,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  391,  392,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  391,  392,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  391,  392,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  391,  392,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  391, 
          392,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  391,  392,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  391,  392,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  391,  392,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  391,  392,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  333,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  391, 
          392,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  391,  392,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  391,  392,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  391,  392,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  391,  392,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  391, 
          392,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  257, 
          258,  259,  260,  261,  262,  263,  264,  391,  392,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,  364,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,  364,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363, 
      };
   }

}
