import sys
from os import listdir, getcwd
from os.path import abspath, isdir, join
from argparse import ArgumentParser

sys.path.append(abspath("scripts"))
from generate_imports_helper import comment, get_importable_lines


import_line_format = "\t_ \"{beat_path}/{module}/{name}\""
include_list_path = "include/list.go"
import_template = """/*
{comment}
*/
package include

import (
\t// This list is automatically generated by `make imports`
{imports}
)
"""


def generate_and_write_to_file(go_beat_path):
    imported_beat_lines = get_importable_lines(go_beat_path, import_line_format)
    imported_lines = "\n".join(imported_beat_lines)
    list_go = import_template.format(imports=imported_lines, comment=comment)
    with open(include_list_path, "w") as output:
        output.write(list_go)


if __name__ == "__main__":
    parser = ArgumentParser(description="Generate imports for Beats packages")
    parser.add_argument("beats_path")
    args = parser.parse_args()

    generate_and_write_to_file(args.beats_path)
