// +build integration

package node

import (
	"testing"
	"time"

	"github.com/elastic/beats/libbeat/tests/compose"
	mbtest "github.com/elastic/beats/metricbeat/mb/testing"
	"github.com/elastic/beats/metricbeat/module/logstash"

	"github.com/stretchr/testify/assert"
)

func TestFetch(t *testing.T) {

	compose.EnsureUpWithTimeout(t, 120, "logstash")

	time.Sleep(1 * time.Second)
	f := mbtest.NewEventFetcher(t, logstash.GetConfig("node"))
	event, err := f.Fetch()
	if !assert.NoError(t, err) {
		t.FailNow()
	}

	assert.NotNil(t, event)
	t.Logf("%s/%s event: %+v", f.Module().Name(), f.Name(), event)
}

func TestData(t *testing.T) {
	compose.EnsureUp(t, "logstash")

	f := mbtest.NewEventFetcher(t, logstash.GetConfig("node"))
	err := mbtest.WriteEvent(f, t)
	if err != nil {
		t.Fatal("write", err)
	}
}
