/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataInputStream;
import sandbox.java.io.DataOutput;
import sandbox.java.io.DataOutputStream;
import sandbox.java.io.EOFException;
import sandbox.java.io.File;
import sandbox.java.io.FileDescriptor;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.IOException;
import sandbox.java.nio.channels.FileChannel;
import sandbox.sun.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private FileChannel channel;
    private boolean rw;
    private final String path;
    private Object closeLock;
    private volatile boolean closed;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        File file;
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            file = new File(string);
            RuntimeCostAccounter.recordJump();
        } else {
            file = null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this(file, string2);
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        String string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.channel = null;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.closeLock = new Object();
        this.closed = false;
        RuntimeCostAccounter.recordJump();
        if (file != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
            string2 = file.getPath();
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = null;
        }
        String string3 = string2;
        int n = -1;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = string.equals("r");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string.startsWith("rw");
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                n = 2;
                this.rw = true;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n2 > 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = string.equals("rws");
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        n |= 4;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                        boolean bl4 = string.equals("rwd");
                        RuntimeCostAccounter.recordJump();
                        if (bl4) {
                            n |= 8;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n = -1;
                        }
                    }
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Illegal mode \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("\" must be one of ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("\"r\", \"rw\", \"rws\",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(" or \"rwd\"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string4 = stringBuilder6.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string4);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(string3);
            RuntimeCostAccounter.recordJump();
            if (this.rw) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
                securityManager.checkWrite(string3);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (string3 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl5 = file.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/FileNotFoundException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileNotFoundException.<init>:(Ljava/lang/String;)V");
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw fileNotFoundException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileDescriptor");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.<init>:()V");
        this.fd = new FileDescriptor();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.attach:(Ljava/io/Closeable;)V");
        this.fd.attach(this);
        this.path = string3;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.open:(Ljava/lang/String;I)V");
        this.open(string3, n);
    }

    public final FileDescriptor getFD() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.fd != null) {
            return this.fd;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:()V");
        IOException iOException = new IOException();
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        RandomAccessFile randomAccessFile = this;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.channel == null) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/nio/ch/FileChannelImpl.open:(Ljava/io/FileDescriptor;Ljava/lang/String;ZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;");
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)true, (boolean)this.rw, (Object)this);
            }
            return this.channel;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    private native void open(String var1, int var2) throws FileNotFoundException;

    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read0:()I");
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readBytes:([BII)I");
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readBytes:([BII)I");
        return this.readBytes(byArray, 0, n);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readFully:([BII)V");
        this.readFully(byArray, 0, n);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:([BII)I");
            n3 = this.read(byArray, n + n4, n2 - n4);
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
                EOFException eOFException = new EOFException();
                RuntimeCostAccounter.recordThrow();
                throw eOFException;
            }
            RuntimeCostAccounter.recordJump();
        } while ((n4 += n3) < n2);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.getFilePointer:()J");
        long l = this.getFilePointer();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.length:()J");
        long l2 = this.length();
        long l3 = l + (long)n;
        RuntimeCostAccounter.recordJump();
        if (l3 > l2) {
            l3 = l2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.seek:(J)V");
        this.seek(l3);
        return (int)(l3 - l);
    }

    @Override
    public void write(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write0:(I)V");
        this.write0(n);
    }

    private native void write0(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeBytes:([BII)V");
        this.writeBytes(byArray, 0, n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeBytes:([BII)V");
        this.writeBytes(byArray, n, n2);
    }

    public native long getFilePointer() throws IOException;

    public void seek(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Negative seek offset");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.seek0:(J)V");
        this.seek0(l);
    }

    private native void seek0(long var1) throws IOException;

    public native long length() throws IOException;

    public native void setLength(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (this.channel != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.close:()V");
            this.channel.close();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/RandomAccessFile$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile$1.<init>:(Ljava/io/RandomAccessFile;)V");
        Closeable closeable = new Closeable(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void close() throws IOException {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.access$000:(Ljava/io/RandomAccessFile;)V");
                RandomAccessFile.access$000(RandomAccessFile.this);
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.closeAll:(Ljava/io/Closeable;)V");
        this.fd.closeAll(closeable);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final byte readByte() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n2 = this.read();
        RuntimeCostAccounter.recordJump();
        if ((n | n2) < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return (short)((n << 8) + (n2 << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n2 = this.read();
        RuntimeCostAccounter.recordJump();
        if ((n | n2) < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return (n << 8) + (n2 << 0);
    }

    @Override
    public final char readChar() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n2 = this.read();
        RuntimeCostAccounter.recordJump();
        if ((n | n2) < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return (char)((n << 8) + (n2 << 0));
    }

    @Override
    public final int readInt() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n2 = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n3 = this.read();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
        int n4 = this.read();
        RuntimeCostAccounter.recordJump();
        if ((n | n2 | n3 | n4) < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:()V");
            EOFException eOFException = new EOFException();
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    @Override
    public final long readLong() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readInt:()I");
        long l = (long)this.readInt() << 32;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readInt:()I");
        return l + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readInt:()I");
        int n = this.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.intBitsToFloat:(I)F");
        return Float.intBitsToFloat(n);
    }

    @Override
    public final double readDouble() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.readLong:()J");
        long l = this.readLong();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
        return Double.longBitsToDouble(l);
    }

    @Override
    public final String readLine() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 13: {
                    bl = true;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.getFilePointer:()J");
                    long l = this.getFilePointer();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.read:()I");
                    int n2 = this.read();
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 10) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.seek:(J)V");
                    this.seek(l);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                default: {
                    char c = (char)n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
                    stringBuffer.append(c);
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.length:()I");
            int n3 = stringBuffer.length();
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                return null;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readUTF:(Ljava/io/DataInput;)Ljava/lang/String;");
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        int n;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 8 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 8 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 24 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 16 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 8 & 0xFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        int n = (int)(l >>> 56) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n);
        int n2 = (int)(l >>> 48) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n2);
        int n3 = (int)(l >>> 40) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n3);
        int n4 = (int)(l >>> 32) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n4);
        int n5 = (int)(l >>> 24) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n5);
        int n6 = (int)(l >>> 16) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n6);
        int n7 = (int)(l >>> 8) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n7);
        int n8 = (int)(l >>> 0) & 0xFF;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.write:(I)V");
        this.write(n8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.floatToIntBits:(F)I");
        int n = Float.floatToIntBits(f);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeInt:(I)V");
        this.writeInt(n);
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
        long l = Double.doubleToLongBits(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeLong:(J)V");
        this.writeLong(l);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = n = string.length();
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        byte[] byArray = new byte[n2];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getBytes:(II[BI)V");
        string.getBytes(0, n, byArray, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeBytes:([BII)V");
        this.writeBytes(byArray, 0, n);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        int n3 = n = 2 * n2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
        byte[] byArray = new byte[n3];
        int n4 = n2;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)2);
        char[] cArray = new char[n4];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
        string.getChars(0, n2, cArray, 0);
        int n5 = 0;
        int n6 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n2) break;
            byArray[n6++] = (byte)(cArray[n5] >>> 8);
            byArray[n6++] = (byte)(cArray[n5] >>> 0);
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.writeBytes:([BII)V");
        this.writeBytes(byArray, 0, n);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeUTF:(Ljava/lang/String;Ljava/io/DataOutput;)I");
        DataOutputStream.writeUTF(string, this);
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    static /* synthetic */ void access$000(RandomAccessFile randomAccessFile) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.close0:()V");
        randomAccessFile.close0();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/RandomAccessFile.initIDs:()V");
        RandomAccessFile.initIDs();
    }
}

