/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.time.zone.TzdbZoneRulesProvider;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.time.zone.ZoneRulesException;
import sandbox.java.util.ArrayList;
import sandbox.java.util.HashSet;
import sandbox.java.util.Iterator;
import sandbox.java.util.NavigableMap;
import sandbox.java.util.Objects;
import sandbox.java.util.ServiceConfigurationError;
import sandbox.java.util.ServiceLoader;
import sandbox.java.util.Set;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.java.util.concurrent.CopyOnWriteArrayList;

public abstract class ZoneRulesProvider {
    private static final CopyOnWriteArrayList<ZoneRulesProvider> PROVIDERS;
    private static final ConcurrentMap<String, ZoneRulesProvider> ZONES;

    public static Set<String> getAvailableZoneIds() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.keySet:()Ljava/util/Set;");
        Set set = ZONES.keySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(Ljava/util/Collection;)V");
        return new HashSet<String>(set);
    }

    public static ZoneRules getRules(String string, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "zoneId");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.getProvider:(Ljava/lang/String;)Ljava/time/zone/ZoneRulesProvider;");
        ZoneRulesProvider zoneRulesProvider = ZoneRulesProvider.getProvider(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.provideRules:(Ljava/lang/String;Z)Ljava/time/zone/ZoneRules;");
        return zoneRulesProvider.provideRules(string, bl);
    }

    public static NavigableMap<String, ZoneRules> getVersions(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "zoneId");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.getProvider:(Ljava/lang/String;)Ljava/time/zone/ZoneRulesProvider;");
        ZoneRulesProvider zoneRulesProvider = ZoneRulesProvider.getProvider(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.provideVersions:(Ljava/lang/String;)Ljava/util/NavigableMap;");
        return zoneRulesProvider.provideVersions(string);
    }

    private static ZoneRulesProvider getProvider(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        ZoneRulesProvider zoneRulesProvider = (ZoneRulesProvider)ZONES.get(string);
        RuntimeCostAccounter.recordJump();
        if (zoneRulesProvider == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.isEmpty:()Z");
            boolean bl = ZONES.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;)V");
                ZoneRulesException zoneRulesException = new ZoneRulesException("No time-zone data files registered");
                RuntimeCostAccounter.recordThrow();
                throw zoneRulesException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unknown time-zone ID: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;)V");
            ZoneRulesException zoneRulesException = new ZoneRulesException(string2);
            RuntimeCostAccounter.recordThrow();
            throw zoneRulesException;
        }
        return zoneRulesProvider;
    }

    public static void registerProvider(ZoneRulesProvider zoneRulesProvider) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneRulesProvider, "provider");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.registerProvider0:(Ljava/time/zone/ZoneRulesProvider;)V");
        ZoneRulesProvider.registerProvider0(zoneRulesProvider);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.add:(Ljava/lang/Object;)Z");
        PROVIDERS.add(zoneRulesProvider);
    }

    private static void registerProvider0(ZoneRulesProvider zoneRulesProvider) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.provideZoneIds:()Ljava/util/Set;");
        Set<String> set = zoneRulesProvider.provideZoneIds();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<String> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            String string = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(string, "zoneId");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            ZoneRulesProvider zoneRulesProvider2 = ZONES.putIfAbsent(string, zoneRulesProvider);
            RuntimeCostAccounter.recordJump();
            if (zoneRulesProvider2 != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Unable to register zone as one already registered with that ID: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(", currently loading from provider: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(zoneRulesProvider);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;)V");
                ZoneRulesException zoneRulesException = new ZoneRulesException(string2);
                RuntimeCostAccounter.recordThrow();
                throw zoneRulesException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public static boolean refresh() {
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.iterator:()Ljava/util/Iterator;");
        Iterator<ZoneRulesProvider> iterator = PROVIDERS.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            ZoneRulesProvider zoneRulesProvider = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.provideRefresh:()Z");
            bl |= zoneRulesProvider.provideRefresh();
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    protected ZoneRulesProvider() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    protected abstract Set<String> provideZoneIds();

    protected abstract ZoneRules provideRules(String var1, boolean var2);

    protected abstract NavigableMap<String, ZoneRules> provideVersions(String var1);

    protected boolean provideRefresh() {
        return false;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CopyOnWriteArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.<init>:()V");
        PROVIDERS = new CopyOnWriteArrayList();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        ZONES = new ConcurrentHashMap<String, ZoneRulesProvider>(512, 0.75f, 2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        final ArrayList<ZoneRulesProvider> arrayList = new ArrayList<ZoneRulesProvider>();
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesProvider$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider$1.<init>:(Ljava/util/List;)V");
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Object run() {
                block3: {
                    block2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string = System.getProperty("java.time.zone.DefaultZoneRulesProvider");
                        RuntimeCostAccounter.recordJump();
                        if (string == null) break block2;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.forName:(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                            Class<?> clazz = Class.forName(string, true, classLoader);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
                            Object obj = clazz.newInstance();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.cast:(Ljava/lang/Object;)Ljava/lang/Object;");
                            ZoneRulesProvider zoneRulesProvider = (ZoneRulesProvider)ZoneRulesProvider.class.cast(obj);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.registerProvider:(Ljava/time/zone/ZoneRulesProvider;)V");
                            ZoneRulesProvider.registerProvider(zoneRulesProvider);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                            arrayList.add(zoneRulesProvider);
                        }
                        catch (Exception exception) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                            Error error = new Error(exception);
                            RuntimeCostAccounter.recordThrow();
                            throw error;
                        }
                        RuntimeCostAccounter.recordJump();
                        break block3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/time/zone/TzdbZoneRulesProvider");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/TzdbZoneRulesProvider.<init>:()V");
                    TzdbZoneRulesProvider tzdbZoneRulesProvider = new TzdbZoneRulesProvider();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.registerProvider:(Ljava/time/zone/ZoneRulesProvider;)V");
                    ZoneRulesProvider.registerProvider(tzdbZoneRulesProvider);
                }
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;Ljava/lang/ClassLoader;)Ljava/util/ServiceLoader;");
        ServiceLoader<ZoneRulesProvider> serviceLoader = ServiceLoader.load(ZoneRulesProvider.class, classLoader);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
        Iterator<ZoneRulesProvider> iterator = serviceLoader.iterator();
        while (true) {
            ZoneRulesProvider zoneRulesProvider;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                zoneRulesProvider = iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceConfigurationError.getCause:()Ljava/lang/Throwable;");
                boolean bl2 = serviceConfigurationError.getCause() instanceof SecurityException;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordThrow();
                throw serviceConfigurationError;
            }
            RuntimeCostAccounter.recordJump();
            boolean bl3 = false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
            Iterator iterator2 = arrayList.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl4 = iterator2.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                ZoneRulesProvider zoneRulesProvider2 = (ZoneRulesProvider)iterator2.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = zoneRulesProvider2.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz2 = zoneRulesProvider.getClass();
                RuntimeCostAccounter.recordJump();
                if (clazz == clazz2) {
                    bl3 = true;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.registerProvider0:(Ljava/time/zone/ZoneRulesProvider;)V");
                ZoneRulesProvider.registerProvider0(zoneRulesProvider);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(zoneRulesProvider);
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CopyOnWriteArrayList.addAll:(Ljava/util/Collection;)Z");
        PROVIDERS.addAll(arrayList);
    }
}

