/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.text.FieldPosition;
import sandbox.java.text.Format;
import sandbox.java.text.ParseException;
import sandbox.java.text.ParsePosition;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Period;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.format.DateTimeParseContext;
import sandbox.java.time.format.DateTimeParseException;
import sandbox.java.time.format.DateTimePrintContext;
import sandbox.java.time.format.DecimalStyle;
import sandbox.java.time.format.FormatStyle;
import sandbox.java.time.format.Parsed;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.format.SignStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.IsoFields;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.HashMap;
import sandbox.java.util.HashSet;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;

public final class DateTimeFormatter {
    private final DateTimeFormatterBuilder.CompositePrinterParser printerParser;
    private final Locale locale;
    private final DecimalStyle decimalStyle;
    private final ResolverStyle resolverStyle;
    private final Set<TemporalField> resolverFields;
    private final Chronology chrono;
    private final ZoneId zone;
    public static final DateTimeFormatter ISO_LOCAL_DATE;
    public static final DateTimeFormatter ISO_OFFSET_DATE;
    public static final DateTimeFormatter ISO_DATE;
    public static final DateTimeFormatter ISO_LOCAL_TIME;
    public static final DateTimeFormatter ISO_OFFSET_TIME;
    public static final DateTimeFormatter ISO_TIME;
    public static final DateTimeFormatter ISO_LOCAL_DATE_TIME;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME;
    public static final DateTimeFormatter ISO_ZONED_DATE_TIME;
    public static final DateTimeFormatter ISO_DATE_TIME;
    public static final DateTimeFormatter ISO_ORDINAL_DATE;
    public static final DateTimeFormatter ISO_WEEK_DATE;
    public static final DateTimeFormatter ISO_INSTANT;
    public static final DateTimeFormatter BASIC_ISO_DATE;
    public static final DateTimeFormatter RFC_1123_DATE_TIME;
    private static final TemporalQuery<Period> PARSED_EXCESS_DAYS;
    private static final TemporalQuery<Boolean> PARSED_LEAP_SECOND;

    public static DateTimeFormatter ofPattern(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendPattern:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendPattern(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:()Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter();
    }

    public static DateTimeFormatter ofPattern(String string, Locale locale) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendPattern:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendPattern(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter(locale);
    }

    public static DateTimeFormatter ofLocalizedDate(FormatStyle formatStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(formatStyle, "dateStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalized:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendLocalized(formatStyle, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter(ResolverStyle.SMART, IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedTime(FormatStyle formatStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(formatStyle, "timeStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalized:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendLocalized(null, formatStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter(ResolverStyle.SMART, IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(formatStyle, "dateTimeStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalized:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendLocalized(formatStyle, formatStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter(ResolverStyle.SMART, IsoChronology.INSTANCE);
    }

    public static DateTimeFormatter ofLocalizedDateTime(FormatStyle formatStyle, FormatStyle formatStyle2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(formatStyle, "dateStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(formatStyle2, "timeStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalized:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendLocalized(formatStyle, formatStyle2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return dateTimeFormatterBuilder2.toFormatter(ResolverStyle.SMART, IsoChronology.INSTANCE);
    }

    public static final TemporalQuery<Period> parsedExcessDays() {
        return PARSED_EXCESS_DAYS;
    }

    public static final TemporalQuery<Boolean> parsedLeapSecond() {
        return PARSED_LEAP_SECOND;
    }

    DateTimeFormatter(DateTimeFormatterBuilder.CompositePrinterParser compositePrinterParser, Locale locale, DecimalStyle decimalStyle, ResolverStyle resolverStyle, Set<TemporalField> set, Chronology chronology, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.printerParser = Objects.requireNonNull(compositePrinterParser, "printerParser");
        this.resolverFields = set;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.locale = Objects.requireNonNull(locale, "locale");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.decimalStyle = Objects.requireNonNull(decimalStyle, "decimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.resolverStyle = Objects.requireNonNull(resolverStyle, "resolverStyle");
        this.chrono = chronology;
        this.zone = zoneId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.locale.equals(locale);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public DecimalStyle getDecimalStyle() {
        return this.decimalStyle;
    }

    public DateTimeFormatter withDecimalStyle(DecimalStyle decimalStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.decimalStyle.equals(decimalStyle);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public Chronology getChronology() {
        return this.chrono;
    }

    public DateTimeFormatter withChronology(Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = Objects.equals(this.chrono, chronology);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, chronology, this.zone);
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public DateTimeFormatter withZone(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = Objects.equals(this.zone, zoneId);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, this.resolverFields, this.chrono, zoneId);
    }

    public ResolverStyle getResolverStyle() {
        return this.resolverStyle;
    }

    public DateTimeFormatter withResolverStyle(ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(resolverStyle, "resolverStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = Objects.equals((Object)this.resolverStyle, (Object)resolverStyle);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, resolverStyle, this.resolverFields, this.chrono, this.zone);
    }

    public Set<TemporalField> getResolverFields() {
        return this.resolverFields;
    }

    public DateTimeFormatter withResolverFields(TemporalField ... temporalFieldArray) {
        Set<TemporalField> set = null;
        RuntimeCostAccounter.recordJump();
        if (temporalFieldArray != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
            List<TemporalField> list = Arrays.asList(temporalFieldArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(Ljava/util/Collection;)V");
            HashSet<TemporalField> hashSet = new HashSet<TemporalField>(list);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
            set = Collections.unmodifiableSet(hashSet);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = Objects.equals(this.resolverFields, set);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, set, this.chrono, this.zone);
    }

    public DateTimeFormatter withResolverFields(Set<TemporalField> set) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        boolean bl = Objects.equals(this.resolverFields, set);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordJump();
        if (set != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(Ljava/util/Collection;)V");
            HashSet<TemporalField> hashSet = new HashSet<TemporalField>(set);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableSet:(Ljava/util/Set;)Ljava/util/Set;");
            set = Collections.unmodifiableSet(hashSet);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(this.printerParser, this.locale, this.decimalStyle, this.resolverStyle, set, this.chrono, this.zone);
    }

    public String format(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(32);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.formatTo:(Ljava/time/temporal/TemporalAccessor;Ljava/lang/Appendable;)V");
        this.formatTo(temporalAccessor, stringBuilder);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public void formatTo(TemporalAccessor temporalAccessor, Appendable appendable) {
        block3: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(temporalAccessor, "temporal");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(appendable, "appendable");
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimePrintContext");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.<init>:(Ljava/time/temporal/TemporalAccessor;Ljava/time/format/DateTimeFormatter;)V");
                DateTimePrintContext dateTimePrintContext = new DateTimePrintContext(temporalAccessor, this);
                boolean bl = appendable instanceof StringBuilder;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    StringBuilder stringBuilder = (StringBuilder)appendable;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
                    this.printerParser.format(dateTimePrintContext, stringBuilder);
                    RuntimeCostAccounter.recordJump();
                    break block3;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
                StringBuilder stringBuilder = new StringBuilder(32);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
                this.printerParser.format(dateTimePrintContext, stringBuilder);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Appendable.append:(Ljava/lang/CharSequence;)Ljava/lang/Appendable;");
                appendable.append(stringBuilder);
            }
            catch (IOException iOException) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.getMessage:()Ljava/lang/String;");
                String string = iOException.getMessage();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
                DateTimeException dateTimeException = new DateTimeException(string, iOException);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordJump();
    }

    public TemporalAccessor parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(charSequence, "text");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseResolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
            return this.parseResolved0(charSequence, null);
        }
        catch (DateTimeParseException dateTimeParseException) {
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.createError:(Ljava/lang/CharSequence;Ljava/lang/RuntimeException;)Ljava/time/format/DateTimeParseException;");
            DateTimeParseException dateTimeParseException = this.createError(charSequence, runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
    }

    public TemporalAccessor parse(CharSequence charSequence, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(charSequence, "text");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(parsePosition, "position");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseResolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
            return this.parseResolved0(charSequence, parsePosition);
        }
        catch (IndexOutOfBoundsException | DateTimeParseException runtimeException) {
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        catch (RuntimeException runtimeException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.createError:(Ljava/lang/CharSequence;Ljava/lang/RuntimeException;)Ljava/time/format/DateTimeParseException;");
            DateTimeParseException dateTimeParseException = this.createError(charSequence, runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
    }

    public <T> T parse(CharSequence charSequence, TemporalQuery<T> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(charSequence, "text");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalQuery, "query");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseResolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
            TemporalAccessor temporalAccessor = this.parseResolved0(charSequence, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            return temporalAccessor.query(temporalQuery);
        }
        catch (DateTimeParseException dateTimeParseException) {
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.createError:(Ljava/lang/CharSequence;Ljava/lang/RuntimeException;)Ljava/time/format/DateTimeParseException;");
            DateTimeParseException dateTimeParseException = this.createError(charSequence, runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
    }

    public TemporalAccessor parseBest(CharSequence charSequence, TemporalQuery<?> ... temporalQueryArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(charSequence, "text");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalQueryArray, "queries");
        int n = temporalQueryArray.length;
        RuntimeCostAccounter.recordJump();
        if (n < 2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("At least two queries must be specified");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseResolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
            TemporalAccessor temporalAccessor = this.parseResolved0(charSequence, null);
            TemporalQuery<?>[] temporalQueryArray2 = temporalQueryArray;
            int n2 = temporalQueryArray2.length;
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                TemporalQuery<?> temporalQuery = temporalQueryArray2[n3];
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
                    return (TemporalAccessor)temporalAccessor.query(temporalQuery);
                }
                catch (RuntimeException runtimeException) {
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Unable to convert parsed text using any of the specified queries");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        catch (DateTimeParseException dateTimeParseException) {
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
        catch (RuntimeException runtimeException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.createError:(Ljava/lang/CharSequence;Ljava/lang/RuntimeException;)Ljava/time/format/DateTimeParseException;");
            DateTimeParseException dateTimeParseException = this.createError(charSequence, runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
    }

    private DateTimeParseException createError(CharSequence charSequence, RuntimeException runtimeException) {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
        int n = charSequence.length();
        RuntimeCostAccounter.recordJump();
        if (n > 64) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
            CharSequence charSequence2 = charSequence.subSequence(0, 64);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            String string2 = charSequence2.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("...");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string = stringBuilder3.toString();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            string = charSequence.toString();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder.append("Text '");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append("' could not be parsed: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.getMessage:()Ljava/lang/String;");
        String string3 = runtimeException.getMessage();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder7.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;ILjava/lang/Throwable;)V");
        return new DateTimeParseException(string4, charSequence, 0, runtimeException);
    }

    private TemporalAccessor parseResolved0(CharSequence charSequence, ParsePosition parsePosition) {
        DateTimeParseContext dateTimeParseContext;
        block9: {
            String string;
            ParsePosition parsePosition2;
            block8: {
                ParsePosition parsePosition3;
                RuntimeCostAccounter.recordJump();
                if (parsePosition != null) {
                    parsePosition3 = parsePosition;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/text/ParsePosition");
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.<init>:(I)V");
                    parsePosition3 = new ParsePosition(0);
                }
                parsePosition2 = parsePosition3;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseUnresolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/format/DateTimeParseContext;");
                dateTimeParseContext = this.parseUnresolved0(charSequence, parsePosition2);
                RuntimeCostAccounter.recordJump();
                if (dateTimeParseContext == null) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
                int n = parsePosition2.getErrorIndex();
                RuntimeCostAccounter.recordJump();
                if (n >= 0) break block8;
                RuntimeCostAccounter.recordJump();
                if (parsePosition != null) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
                int n2 = parsePosition2.getIndex();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                int n3 = charSequence.length();
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break block9;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n = charSequence.length();
            RuntimeCostAccounter.recordJump();
            if (n > 64) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
                CharSequence charSequence2 = charSequence.subSequence(0, 64);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
                String string2 = charSequence2.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("...");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder3.toString();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
                string = charSequence.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
            int n4 = parsePosition2.getErrorIndex();
            RuntimeCostAccounter.recordJump();
            if (n4 >= 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("Text '");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("' could not be parsed at index ");
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
                int n5 = parsePosition2.getErrorIndex();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
                int n6 = parsePosition2.getErrorIndex();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
                DateTimeParseException dateTimeParseException = new DateTimeParseException(string3, charSequence, n6);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeParseException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder.append("Text '");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append("' could not be parsed, unparsed text found at index ");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
            int n7 = parsePosition2.getIndex();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append(n7);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string4 = stringBuilder11.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
            int n8 = parsePosition2.getIndex();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
            DateTimeParseException dateTimeParseException = new DateTimeParseException(string4, charSequence, n8);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.toResolved:(Ljava/time/format/ResolverStyle;Ljava/util/Set;)Ljava/time/temporal/TemporalAccessor;");
        return dateTimeParseContext.toResolved(this.resolverStyle, this.resolverFields);
    }

    public TemporalAccessor parseUnresolved(CharSequence charSequence, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseUnresolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/format/DateTimeParseContext;");
        DateTimeParseContext dateTimeParseContext = this.parseUnresolved0(charSequence, parsePosition);
        RuntimeCostAccounter.recordJump();
        if (dateTimeParseContext == null) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.toUnresolved:()Ljava/time/format/Parsed;");
        return dateTimeParseContext.toUnresolved();
    }

    private DateTimeParseContext parseUnresolved0(CharSequence charSequence, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(charSequence, "text");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(parsePosition, "position");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.<init>:(Ljava/time/format/DateTimeFormatter;)V");
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
        int n = parsePosition.getIndex();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
        n = this.printerParser.parse(dateTimeParseContext, charSequence, n);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setErrorIndex:(I)V");
            parsePosition.setErrorIndex(~n);
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setIndex:(I)V");
        parsePosition.setIndex(n);
        return dateTimeParseContext;
    }

    DateTimeFormatterBuilder.CompositePrinterParser toPrinterParser(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.withOptional:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
        return this.printerParser.withOptional(bl);
    }

    public Format toFormat() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter$ClassicFormat");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter$ClassicFormat.<init>:(Ljava/time/format/DateTimeFormatter;Ljava/time/temporal/TemporalQuery;)V");
        return new ClassicFormat(this, null);
    }

    public Format toFormat(TemporalQuery<?> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalQuery, "parseQuery");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter$ClassicFormat");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter$ClassicFormat.<init>:(Ljava/time/format/DateTimeFormatter;Ljava/time/temporal/TemporalQuery;)V");
        return new ClassicFormat(this, temporalQuery);
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.toString:()Ljava/lang/String;");
        String string2 = this.printerParser.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
        boolean bl = string2.startsWith("[");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = string2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string2.length() - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            string = string2.substring(1, n);
        }
        string2 = string;
        return string2;
    }

    static /* synthetic */ TemporalAccessor access$000(DateTimeFormatter dateTimeFormatter, CharSequence charSequence, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseResolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
        return dateTimeFormatter.parseResolved0(charSequence, parsePosition);
    }

    static /* synthetic */ DateTimeParseContext access$100(DateTimeFormatter dateTimeFormatter, CharSequence charSequence, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parseUnresolved0:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/format/DateTimeParseContext;");
        return dateTimeFormatter.parseUnresolved0(charSequence, parsePosition);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder3 = dateTimeFormatterBuilder2.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder4 = dateTimeFormatterBuilder3.appendValue(ChronoField.MONTH_OF_YEAR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder5 = dateTimeFormatterBuilder4.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder6 = dateTimeFormatterBuilder5.appendValue(ChronoField.DAY_OF_MONTH, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_LOCAL_DATE = dateTimeFormatterBuilder6.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder7 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder8 = dateTimeFormatterBuilder7.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder9 = dateTimeFormatterBuilder8.append(ISO_LOCAL_DATE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder10 = dateTimeFormatterBuilder9.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_OFFSET_DATE = dateTimeFormatterBuilder10.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder11 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder12 = dateTimeFormatterBuilder11.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder13 = dateTimeFormatterBuilder12.append(ISO_LOCAL_DATE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder14 = dateTimeFormatterBuilder13.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder15 = dateTimeFormatterBuilder14.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_DATE = dateTimeFormatterBuilder15.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder16 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder17 = dateTimeFormatterBuilder16.appendValue(ChronoField.HOUR_OF_DAY, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder18 = dateTimeFormatterBuilder17.appendLiteral(':');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder19 = dateTimeFormatterBuilder18.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder20 = dateTimeFormatterBuilder19.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder21 = dateTimeFormatterBuilder20.appendLiteral(':');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder22 = dateTimeFormatterBuilder21.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder23 = dateTimeFormatterBuilder22.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendFraction:(Ljava/time/temporal/TemporalField;IIZ)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder24 = dateTimeFormatterBuilder23.appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_LOCAL_TIME = dateTimeFormatterBuilder24.toFormatter(ResolverStyle.STRICT, null);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder25 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder26 = dateTimeFormatterBuilder25.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder27 = dateTimeFormatterBuilder26.append(ISO_LOCAL_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder28 = dateTimeFormatterBuilder27.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_OFFSET_TIME = dateTimeFormatterBuilder28.toFormatter(ResolverStyle.STRICT, null);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder29 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder30 = dateTimeFormatterBuilder29.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder31 = dateTimeFormatterBuilder30.append(ISO_LOCAL_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder32 = dateTimeFormatterBuilder31.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder33 = dateTimeFormatterBuilder32.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_TIME = dateTimeFormatterBuilder33.toFormatter(ResolverStyle.STRICT, null);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder34 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder35 = dateTimeFormatterBuilder34.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder36 = dateTimeFormatterBuilder35.append(ISO_LOCAL_DATE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder37 = dateTimeFormatterBuilder36.appendLiteral('T');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder38 = dateTimeFormatterBuilder37.append(ISO_LOCAL_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_LOCAL_DATE_TIME = dateTimeFormatterBuilder38.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder39 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder40 = dateTimeFormatterBuilder39.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder41 = dateTimeFormatterBuilder40.append(ISO_LOCAL_DATE_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder42 = dateTimeFormatterBuilder41.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_OFFSET_DATE_TIME = dateTimeFormatterBuilder42.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder43 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder44 = dateTimeFormatterBuilder43.append(ISO_OFFSET_DATE_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder45 = dateTimeFormatterBuilder44.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder46 = dateTimeFormatterBuilder45.appendLiteral('[');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseSensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder47 = dateTimeFormatterBuilder46.parseCaseSensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneRegionId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder48 = dateTimeFormatterBuilder47.appendZoneRegionId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder49 = dateTimeFormatterBuilder48.appendLiteral(']');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_ZONED_DATE_TIME = dateTimeFormatterBuilder49.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder50 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder51 = dateTimeFormatterBuilder50.append(ISO_LOCAL_DATE_TIME);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder52 = dateTimeFormatterBuilder51.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder53 = dateTimeFormatterBuilder52.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder54 = dateTimeFormatterBuilder53.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder55 = dateTimeFormatterBuilder54.appendLiteral('[');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseSensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder56 = dateTimeFormatterBuilder55.parseCaseSensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneRegionId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder57 = dateTimeFormatterBuilder56.appendZoneRegionId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder58 = dateTimeFormatterBuilder57.appendLiteral(']');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_DATE_TIME = dateTimeFormatterBuilder58.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder59 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder60 = dateTimeFormatterBuilder59.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder61 = dateTimeFormatterBuilder60.appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder62 = dateTimeFormatterBuilder61.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder63 = dateTimeFormatterBuilder62.appendValue(ChronoField.DAY_OF_YEAR, 3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder64 = dateTimeFormatterBuilder63.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder65 = dateTimeFormatterBuilder64.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_ORDINAL_DATE = dateTimeFormatterBuilder65.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder66 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder67 = dateTimeFormatterBuilder66.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder68 = dateTimeFormatterBuilder67.appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder69 = dateTimeFormatterBuilder68.appendLiteral("-W");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder70 = dateTimeFormatterBuilder69.appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder71 = dateTimeFormatterBuilder70.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder72 = dateTimeFormatterBuilder71.appendValue(ChronoField.DAY_OF_WEEK, 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder73 = dateTimeFormatterBuilder72.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffsetId:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder74 = dateTimeFormatterBuilder73.appendOffsetId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_WEEK_DATE = dateTimeFormatterBuilder74.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder75 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder76 = dateTimeFormatterBuilder75.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInstant:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder77 = dateTimeFormatterBuilder76.appendInstant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        ISO_INSTANT = dateTimeFormatterBuilder77.toFormatter(ResolverStyle.STRICT, null);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder78 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder79 = dateTimeFormatterBuilder78.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder80 = dateTimeFormatterBuilder79.appendValue(ChronoField.YEAR, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder81 = dateTimeFormatterBuilder80.appendValue(ChronoField.MONTH_OF_YEAR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder82 = dateTimeFormatterBuilder81.appendValue(ChronoField.DAY_OF_MONTH, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder83 = dateTimeFormatterBuilder82.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder84 = dateTimeFormatterBuilder83.appendOffset("+HHMMss", "Z");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        BASIC_ISO_DATE = dateTimeFormatterBuilder84.toFormatter(ResolverStyle.STRICT, IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l = 1L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l, "Mon");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l2 = 2L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l2, "Tue");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l3 = 3L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l3, "Wed");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l4 = 4L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l4, "Thu");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l5 = 5L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l5, "Fri");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l6 = 6L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l6, "Sat");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l7 = 7L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap.put(l7, "Sun");
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l8 = 1L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l8, "Jan");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l9 = 2L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l9, "Feb");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l10 = 3L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l10, "Mar");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l11 = 4L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l11, "Apr");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l12 = 5L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l12, "May");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l13 = 6L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l13, "Jun");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l14 = 7L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l14, "Jul");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l15 = 8L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l15, "Aug");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l16 = 9L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l16, "Sep");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l17 = 10L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l17, "Oct");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l18 = 11L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l18, "Nov");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l19 = 12L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        hashMap2.put(l19, "Dec");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder85 = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseCaseInsensitive:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder86 = dateTimeFormatterBuilder85.parseCaseInsensitive();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseLenient:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder87 = dateTimeFormatterBuilder86.parseLenient();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder88 = dateTimeFormatterBuilder87.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/util/Map;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder89 = dateTimeFormatterBuilder88.appendText((TemporalField)ChronoField.DAY_OF_WEEK, hashMap);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder90 = dateTimeFormatterBuilder89.appendLiteral(", ");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalEnd:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder91 = dateTimeFormatterBuilder90.optionalEnd();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder92 = dateTimeFormatterBuilder91.appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder93 = dateTimeFormatterBuilder92.appendLiteral(' ');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/util/Map;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder94 = dateTimeFormatterBuilder93.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, hashMap2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder95 = dateTimeFormatterBuilder94.appendLiteral(' ');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder96 = dateTimeFormatterBuilder95.appendValue(ChronoField.YEAR, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder97 = dateTimeFormatterBuilder96.appendLiteral(' ');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder98 = dateTimeFormatterBuilder97.appendValue(ChronoField.HOUR_OF_DAY, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder99 = dateTimeFormatterBuilder98.appendLiteral(':');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder100 = dateTimeFormatterBuilder99.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder101 = dateTimeFormatterBuilder100.optionalStart();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder102 = dateTimeFormatterBuilder101.appendLiteral(':');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder103 = dateTimeFormatterBuilder102.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalEnd:()Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder104 = dateTimeFormatterBuilder103.optionalEnd();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder105 = dateTimeFormatterBuilder104.appendLiteral(' ');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder106 = dateTimeFormatterBuilder105.appendOffset("+HHMM", "GMT");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        RFC_1123_DATE_TIME = dateTimeFormatterBuilder106.toFormatter(ResolverStyle.SMART, IsoChronology.INSTANCE);
        PARSED_EXCESS_DAYS = temporalAccessor -> {
            boolean bl = temporalAccessor instanceof Parsed;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return ((Parsed)temporalAccessor).excessDays;
            }
            return Period.ZERO;
        };
        PARSED_LEAP_SECOND = temporalAccessor -> {
            boolean bl = temporalAccessor instanceof Parsed;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                boolean bl2 = ((Parsed)temporalAccessor).leapSecond;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
                return bl2;
            }
            return Boolean.FALSE;
        };
    }

    static class ClassicFormat
    extends Format {
        private final DateTimeFormatter formatter;
        private final TemporalQuery<?> parseType;

        public ClassicFormat(DateTimeFormatter dateTimeFormatter, TemporalQuery<?> temporalQuery) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/Format.<init>:()V");
            this.formatter = dateTimeFormatter;
            this.parseType = temporalQuery;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(object, "obj");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(stringBuffer, "toAppendTo");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(fieldPosition, "pos");
            boolean bl = object instanceof TemporalAccessor;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Format target must implement TemporalAccessor");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/text/FieldPosition.setBeginIndex:(I)V");
            fieldPosition.setBeginIndex(0);
            RuntimeCostAccounter.recordMethodCall((String)"java/text/FieldPosition.setEndIndex:(I)V");
            fieldPosition.setEndIndex(0);
            try {
                TemporalAccessor temporalAccessor = (TemporalAccessor)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.formatTo:(Ljava/time/temporal/TemporalAccessor;Ljava/lang/Appendable;)V");
                this.formatter.formatTo(temporalAccessor, stringBuffer);
            }
            catch (RuntimeException runtimeException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.getMessage:()Ljava/lang/String;");
                String string = runtimeException.getMessage();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string, runtimeException);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            return stringBuffer;
        }

        @Override
        public Object parseObject(String string) throws ParseException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(string, "text");
            try {
                RuntimeCostAccounter.recordJump();
                if (this.parseType == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.access$000:(Ljava/time/format/DateTimeFormatter;Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/temporal/TemporalAccessor;");
                    return DateTimeFormatter.access$000(this.formatter, string, null);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
                return this.formatter.parse((CharSequence)string, this.parseType);
            }
            catch (DateTimeParseException dateTimeParseException) {
                RuntimeCostAccounter.recordAllocation((String)"java/text/ParseException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.getMessage:()Ljava/lang/String;");
                String string2 = dateTimeParseException.getMessage();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.getErrorIndex:()I");
                int n = dateTimeParseException.getErrorIndex();
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParseException.<init>:(Ljava/lang/String;I)V");
                ParseException parseException = new ParseException(string2, n);
                RuntimeCostAccounter.recordThrow();
                throw parseException;
            }
            catch (RuntimeException runtimeException) {
                RuntimeCostAccounter.recordAllocation((String)"java/text/ParseException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.getMessage:()Ljava/lang/String;");
                String string3 = runtimeException.getMessage();
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParseException.<init>:(Ljava/lang/String;I)V");
                ParseException parseException = new ParseException(string3, 0);
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParseException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
                ParseException parseException2 = (ParseException)parseException.initCause(runtimeException);
                RuntimeCostAccounter.recordThrow();
                throw parseException2;
            }
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            DateTimeParseContext dateTimeParseContext;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(string, "text");
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.access$100:(Ljava/time/format/DateTimeFormatter;Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/time/format/DateTimeParseContext;");
                dateTimeParseContext = DateTimeFormatter.access$100(this.formatter, string, parsePosition);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
                int n = parsePosition.getErrorIndex();
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setErrorIndex:(I)V");
                    parsePosition.setErrorIndex(0);
                }
                return null;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (dateTimeParseContext == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getErrorIndex:()I");
                int n = parsePosition.getErrorIndex();
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setErrorIndex:(I)V");
                    parsePosition.setErrorIndex(0);
                }
                return null;
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.access$200:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/ResolverStyle;");
                ResolverStyle resolverStyle = this.formatter.resolverStyle;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.access$300:(Ljava/time/format/DateTimeFormatter;)Ljava/util/Set;");
                Set set = this.formatter.resolverFields;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.toResolved:(Ljava/time/format/ResolverStyle;Ljava/util/Set;)Ljava/time/temporal/TemporalAccessor;");
                TemporalAccessor temporalAccessor = dateTimeParseContext.toResolved(resolverStyle, set);
                RuntimeCostAccounter.recordJump();
                if (this.parseType == null) {
                    return temporalAccessor;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
                return temporalAccessor.query(this.parseType);
            }
            catch (RuntimeException runtimeException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setErrorIndex:(I)V");
                parsePosition.setErrorIndex(0);
                return null;
            }
        }
    }
}

