/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.JapaneseChronology;
import sandbox.java.time.chrono.JapaneseDate;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.Objects;
import sandbox.sun.util.calendar.CalendarDate;

public final class JapaneseEra
implements Era,
Serializable {
    static final int ERA_OFFSET = 2;
    static final sandbox.sun.util.calendar.Era[] ERA_CONFIG;
    public static final JapaneseEra MEIJI;
    public static final JapaneseEra TAISHO;
    public static final JapaneseEra SHOWA;
    public static final JapaneseEra HEISEI;
    private static final int N_ERA_CONSTANTS;
    private static final long serialVersionUID = 1466499369062886794L;
    private static final JapaneseEra[] KNOWN_ERAS;
    private final transient int eraValue;
    private final transient LocalDate since;

    private JapaneseEra(int n, LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.eraValue = n;
        this.since = localDate;
    }

    sandbox.sun.util.calendar.Era getPrivateEra() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.ordinal:(I)I");
        return ERA_CONFIG[JapaneseEra.ordinal(this.eraValue)];
    }

    public static JapaneseEra of(int n) {
        block3: {
            block2: {
                int n2 = JapaneseEra.MEIJI.eraValue;
                RuntimeCostAccounter.recordJump();
                if (n < n2) break block2;
                int n3 = KNOWN_ERAS.length;
                RuntimeCostAccounter.recordJump();
                if (n + 2 - 1 < n3) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid era: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.ordinal:(I)I");
        return KNOWN_ERAS[JapaneseEra.ordinal(n)];
    }

    public static JapaneseEra valueOf(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "japaneseEra");
        JapaneseEra[] japaneseEraArray = KNOWN_ERAS;
        int n = japaneseEraArray.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            JapaneseEra japaneseEra = japaneseEraArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getName:()Ljava/lang/String;");
            String string2 = japaneseEra.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string2.equals(string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return japaneseEra;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("japaneseEra is invalid");
        RuntimeCostAccounter.recordThrow();
        throw illegalArgumentException;
    }

    public static JapaneseEra[] values() {
        int n = KNOWN_ERAS.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
        return Arrays.copyOf(KNOWN_ERAS, n);
    }

    static JapaneseEra from(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isBefore:(Ljava/time/chrono/ChronoLocalDate;)Z");
        boolean bl = localDate.isBefore(JapaneseDate.MEIJI_6_ISODATE);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("JapaneseDate before Meiji 6 are not supported");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        int n = KNOWN_ERAS.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            JapaneseEra japaneseEra = KNOWN_ERAS[n];
            LocalDate localDate2 = japaneseEra.since;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo:(Ljava/time/chrono/ChronoLocalDate;)I");
            int n2 = localDate.compareTo(localDate2);
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                return japaneseEra;
            }
            --n;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    static JapaneseEra toJapaneseEra(sandbox.sun.util.calendar.Era era) {
        int n = ERA_CONFIG.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            sandbox.sun.util.calendar.Era era2 = ERA_CONFIG[n];
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.equals:(Ljava/lang/Object;)Z");
            boolean bl = era2.equals((Object)era);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return KNOWN_ERAS[n];
            }
            --n;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    static sandbox.sun.util.calendar.Era privateEraFrom(LocalDate localDate) {
        int n = KNOWN_ERAS.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            JapaneseEra japaneseEra = KNOWN_ERAS[n];
            LocalDate localDate2 = japaneseEra.since;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo:(Ljava/time/chrono/ChronoLocalDate;)I");
            int n2 = localDate.compareTo(localDate2);
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                return ERA_CONFIG[n];
            }
            --n;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    private static int ordinal(int n) {
        return n + 2 - 1;
    }

    @Override
    public int getValue() {
        return this.eraValue;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.ERA) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            return JapaneseChronology.INSTANCE.range(ChronoField.ERA);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Era.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return Era.super.range(temporalField);
    }

    String getAbbreviation() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
        int n = this.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.ordinal:(I)I");
        int n2 = JapaneseEra.ordinal(n);
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return "";
        }
        sandbox.sun.util.calendar.Era era = ERA_CONFIG[n2];
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getAbbreviation:()Ljava/lang/String;");
        return era.getAbbreviation();
    }

    String getName() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
        int n = this.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.ordinal:(I)I");
        sandbox.sun.util.calendar.Era era = ERA_CONFIG[JapaneseEra.ordinal(n)];
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getName:()Ljava/lang/String;");
        return era.getName();
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getName:()Ljava/lang/String;");
        return this.getName();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(5, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
        int n = this.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n);
    }

    static JapaneseEra readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.of:(I)Ljava/time/chrono/JapaneseEra;");
        return JapaneseEra.of(by);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseEra");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(1868, 1, 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.<init>:(ILjava/time/LocalDate;)V");
        MEIJI = new JapaneseEra(-1, localDate);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseEra");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate2 = LocalDate.of(1912, 7, 30);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.<init>:(ILjava/time/LocalDate;)V");
        TAISHO = new JapaneseEra(0, localDate2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseEra");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate3 = LocalDate.of(1926, 12, 25);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.<init>:(ILjava/time/LocalDate;)V");
        SHOWA = new JapaneseEra(1, localDate3);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseEra");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate4 = LocalDate.of(1989, 1, 8);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.<init>:(ILjava/time/LocalDate;)V");
        HEISEI = new JapaneseEra(2, localDate4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
        N_ERA_CONSTANTS = HEISEI.getValue() + 2 + 1;
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.getEras:()[Lsun/util/calendar/Era;");
        ERA_CONFIG = JapaneseChronology.JCAL.getEras();
        int n = ERA_CONFIG.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        KNOWN_ERAS = new JapaneseEra[n];
        JapaneseEra.KNOWN_ERAS[0] = MEIJI;
        JapaneseEra.KNOWN_ERAS[1] = TAISHO;
        JapaneseEra.KNOWN_ERAS[2] = SHOWA;
        JapaneseEra.KNOWN_ERAS[3] = HEISEI;
        int n2 = N_ERA_CONSTANTS;
        while (true) {
            int n3 = ERA_CONFIG.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            sandbox.sun.util.calendar.Era era = ERA_CONFIG[n2];
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
            CalendarDate calendarDate = era.getSinceDate();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getYear:()I");
            int n4 = calendarDate.getYear();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getMonth:()I");
            int n5 = calendarDate.getMonth();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getDayOfMonth:()I");
            int n6 = calendarDate.getDayOfMonth();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
            LocalDate localDate5 = LocalDate.of(n4, n5, n6);
            RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseEra");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.<init>:(ILjava/time/LocalDate;)V");
            JapaneseEra.KNOWN_ERAS[n2] = new JapaneseEra(n2 - 2, localDate5);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }
}

