/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectStreamException;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.List;
import sandbox.java.util.Objects;

final class ChronoPeriodImpl
implements ChronoPeriod,
Serializable {
    private static final long serialVersionUID = 57387258289L;
    private static final List<TemporalUnit> SUPPORTED_UNITS;
    private final Chronology chrono;
    final int years;
    final int months;
    final int days;

    ChronoPeriodImpl(Chronology chronology, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(chronology, "chrono");
        this.chrono = chronology;
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.YEARS) {
            return this.years;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.MONTHS) {
            return this.months;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.days;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
        UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
        RuntimeCostAccounter.recordThrow();
        throw unsupportedTemporalTypeException;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Chronology getChronology() {
        return this.chrono;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isZero() {
        RuntimeCostAccounter.recordJump();
        if (this.years != 0) return false;
        RuntimeCostAccounter.recordJump();
        if (this.months != 0) return false;
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNegative() {
        RuntimeCostAccounter.recordJump();
        if (this.years >= 0) {
            RuntimeCostAccounter.recordJump();
            if (this.months >= 0) {
                RuntimeCostAccounter.recordJump();
                if (this.days >= 0) return false;
            }
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    @Override
    public ChronoPeriod plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.validateAmount:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoPeriodImpl;");
        ChronoPeriodImpl chronoPeriodImpl = this.validateAmount(temporalAmount);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
        int n = chronoPeriodImpl.years;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n2 = Math.addExact(this.years, n);
        int n3 = chronoPeriodImpl.months;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n4 = Math.addExact(this.months, n3);
        int n5 = chronoPeriodImpl.days;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n6 = Math.addExact(this.days, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
        return new ChronoPeriodImpl(this.chrono, n2, n4, n6);
    }

    @Override
    public ChronoPeriod minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.validateAmount:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoPeriodImpl;");
        ChronoPeriodImpl chronoPeriodImpl = this.validateAmount(temporalAmount);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
        int n = chronoPeriodImpl.years;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n2 = Math.subtractExact(this.years, n);
        int n3 = chronoPeriodImpl.months;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n4 = Math.subtractExact(this.months, n3);
        int n5 = chronoPeriodImpl.days;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(II)I");
        int n6 = Math.subtractExact(this.days, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
        return new ChronoPeriodImpl(this.chrono, n2, n4, n6);
    }

    private ChronoPeriodImpl validateAmount(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amount");
        boolean bl = temporalAmount instanceof ChronoPeriodImpl;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoPeriod from TemporalAmount: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAmount.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        ChronoPeriodImpl chronoPeriodImpl = (ChronoPeriodImpl)temporalAmount;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = chronoPeriodImpl.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.chrono.equals(chronology);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Chronology mismatch, expected: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string = this.chrono.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(", actual: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology2 = chronoPeriodImpl.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string2 = chronology2.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException(string3);
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        return chronoPeriodImpl;
    }

    @Override
    public ChronoPeriod multipliedBy(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.isZero:()Z");
                boolean bl = this.isZero();
                RuntimeCostAccounter.recordJump();
                if (bl) break block2;
                RuntimeCostAccounter.recordJump();
                if (n != 1) break block3;
            }
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n2 = Math.multiplyExact(this.years, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n3 = Math.multiplyExact(this.months, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(II)I");
        int n4 = Math.multiplyExact(this.days, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
        return new ChronoPeriodImpl(this.chrono, n2, n3, n4);
    }

    @Override
    public ChronoPeriod normalized() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.monthRange:()J");
        long l = this.monthRange();
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            long l2 = (long)this.years * l + (long)this.months;
            long l3 = l2 / l;
            int n = (int)(l2 % l);
            long l4 = l3 - (long)this.years;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 == false) {
                RuntimeCostAccounter.recordJump();
                if (n == this.months) {
                    return this;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
            int n2 = Math.toIntExact(l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
            return new ChronoPeriodImpl(this.chrono, n2, n, this.days);
        }
        return this;
    }

    private long monthRange() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.chrono.range(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isFixed:()Z");
        boolean bl = valueRange.isFixed();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isIntValue:()Z");
            boolean bl2 = valueRange.isIntValue();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l = valueRange.getMaximum();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                return l - valueRange.getMinimum() + 1L;
            }
        }
        return -1L;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.validateChrono:(Ljava/time/temporal/TemporalAccessor;)V");
        this.validateChrono(temporal);
        RuntimeCostAccounter.recordJump();
        if (this.months == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.years != 0) {
                long l = this.years;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.plus(l, ChronoUnit.YEARS);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.monthRange:()J");
            long l = this.monthRange();
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                long l2 = (long)this.years * l + (long)this.months;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.plus(l2, ChronoUnit.MONTHS);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.years != 0) {
                    long l3 = this.years;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                    temporal = temporal.plus(l3, ChronoUnit.YEARS);
                }
                long l4 = this.months;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.plus(l4, ChronoUnit.MONTHS);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            long l = this.days;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.plus(l, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.validateChrono:(Ljava/time/temporal/TemporalAccessor;)V");
        this.validateChrono(temporal);
        RuntimeCostAccounter.recordJump();
        if (this.months == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.years != 0) {
                long l = this.years;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.minus(l, ChronoUnit.YEARS);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.monthRange:()J");
            long l = this.monthRange();
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                long l2 = (long)this.years * l + (long)this.months;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.minus(l2, ChronoUnit.MONTHS);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.years != 0) {
                    long l3 = this.years;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                    temporal = temporal.minus(l3, ChronoUnit.YEARS);
                }
                long l4 = this.months;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                temporal = temporal.minus(l4, ChronoUnit.MONTHS);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            long l = this.days;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.minus(l, ChronoUnit.DAYS);
        }
        return temporal;
    }

    private void validateChrono(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
            boolean bl = this.chrono.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Chronology mismatch, expected: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                String string = this.chrono.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(", actual: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                String string2 = chronology.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string3);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ChronoPeriodImpl;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ChronoPeriodImpl chronoPeriodImpl = (ChronoPeriodImpl)object;
        int n = chronoPeriodImpl.years;
        RuntimeCostAccounter.recordJump();
        if (this.years != n) return false;
        int n2 = chronoPeriodImpl.months;
        RuntimeCostAccounter.recordJump();
        if (this.months != n2) return false;
        int n3 = chronoPeriodImpl.days;
        RuntimeCostAccounter.recordJump();
        if (this.days != n3) return false;
        Chronology chronology = chronoPeriodImpl.chrono;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.chrono.equals(chronology);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        int n = this.years + Integer.rotateLeft(this.months, 8);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        int n2 = n + Integer.rotateLeft(this.days, 16);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.hashCode:()I");
        return n2 ^ this.chrono.hashCode();
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.isZero:()Z");
        boolean bl = this.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology = this.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.toString:()Ljava/lang/String;");
            String string = chronology.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(" P0D");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder3.toString();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.toString:()Ljava/lang/String;");
        String string = chronology.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(' ');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder5.append('P');
        RuntimeCostAccounter.recordJump();
        if (this.years != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append(this.years);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder6.append('Y');
        }
        RuntimeCostAccounter.recordJump();
        if (this.months != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder.append(this.months);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder7.append('M');
        }
        RuntimeCostAccounter.recordJump();
        if (this.days != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder.append(this.days);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder8.append('D');
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    protected Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(9, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ObjectStreamException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
        String string = this.chrono.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeUTF:(Ljava/lang/String;)V");
        dataOutput.writeUTF(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.years);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.months);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.days);
    }

    static ChronoPeriodImpl readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readUTF:()Ljava/lang/String;");
        String string = dataInput.readUTF();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.of:(Ljava/lang/String;)Ljava/time/chrono/Chronology;");
        Chronology chronology = Chronology.of(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n2 = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n3 = dataInput.readInt();
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
        return new ChronoPeriodImpl(chronology, n, n2, n3);
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
        TemporalUnit[] temporalUnitArray = new TemporalUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        List<TemporalUnit> list = Arrays.asList(temporalUnitArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
        SUPPORTED_UNITS = Collections.unmodifiableList(list);
    }
}

