<?php

namespace Appwrite\Auth\Phone;

use Appwrite\Auth\Phone;

// Reference Material
// https://www.twilio.com/docs/sms/api

class Telesign extends Phone
{
    /**
     * @var string
     */
    private string $endpoint = 'https://rest-api.telesign.com/v1/messaging';

    /**
     * @param string $from
     * @param string $to
     * @param string $message
     * @return void
     * @throws \Appwrite\Extend\Exception
     */
    public function send(string $from, string $to, string $message): void
    {
        $to = ltrim($to, '+');

        $this->request(
            method: 'POST',
            url: $this->endpoint,
            payload: \http_build_query([
                'message' => $message,
                'message_type' => 'otp',
                'phone_number' => $to
            ]),
            userpwd: "{$this->user}:{$this->secret}"
        );
    }
}
