<?php

return [
    '/' => [
        'key' => 'homepage',
        'name' => 'Homepage',
        'subtitle' => '',
        'description' => '',
        'controller' => 'web/home.php',
        'sdk' => false,
        'docs' => false,
        'docsUrl' => '',
        'tests' => false,
        'optional' => false,
        'icon' => '',
    ],
    'console' => [
        'key' => 'console',
        'name' => 'Console',
        'subtitle' => '',
        'description' => '',
        'controller' => 'web/console.php',
        'sdk' => false,
        'docs' => false,
        'docsUrl' => '',
        'tests' => false,
        'optional' => false,
        'icon' => '',
    ],
    'account' => [
        'key' => 'account',
        'name' => 'Account',
        'subtitle' => 'The Account service allows you to authenticate and manage a user account.',
        'description' => '/docs/services/account.md',
        'controller' => 'api/account.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/account',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/account.png',
    ],
    'avatars' => [
        'key' => 'avatars',
        'name' => 'Avatars',
        'subtitle' => 'The Avatars service aims to help you complete everyday tasks related to your app image, icons, and avatars.',
        'description' => '/docs/services/avatars.md',
        'controller' => 'api/avatars.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/avatars',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/avatars.png',
    ],
    'databases' => [
        'key' => 'databases',
        'name' => 'Databases',
        'subtitle' => 'The Databases service allows you to create structured collections of documents, query and filter lists of documents',
        'description' => '/docs/services/databases.md',
        'controller' => 'api/databases.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/databases',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/databases.png',
        'globalAttributes' => [
            'databaseId'
        ]
    ],
    'locale' => [
        'key' => 'locale',
        'name' => 'Locale',
        'subtitle' => 'The Locale service allows you to customize your app based on your users\' location.',
        'description' => '/docs/services/locale.md',
        'controller' => 'api/locale.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/locale',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/locale.png',
    ],
    'health' => [
        'key' => 'health',
        'name' => 'Health',
        'subtitle' => 'The Health service allows you to both validate and monitor your Appwrite server\'s health.',
        'description' => '/docs/services/health.md',
        'controller' => 'api/health.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/server/health',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/health.png',
    ],
    'projects' => [
        'key' => 'projects',
        'name' => 'Projects',
        'subtitle' => 'The Project service allows you to manage all the projects in your Appwrite server.',
        'description' => '',
        'controller' => 'api/projects.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => '',
        'tests' => false,
        'optional' => false,
        'icon' => '',
    ],
    'storage' => [
        'key' => 'storage',
        'name' => 'Storage',
        'subtitle' => 'The Storage service allows you to manage your project files.',
        'description' => '/docs/services/storage.md',
        'controller' => 'api/storage.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/storage',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/storage.png',
    ],
    'teams' => [
        'key' => 'teams',
        'name' => 'Teams',
        'subtitle' => 'The Teams service allows you to group users of your project and to enable them to share read and write access to your project resources',
        'description' => '/docs/services/teams.md',
        'controller' => 'api/teams.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/client/teams',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/teams.png',
    ],
    'users' => [
        'key' => 'users',
        'name' => 'Users',
        'subtitle' => 'The Users service allows you to manage your project users.',
        'description' => '/docs/services/users.md',
        'controller' => 'api/users.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/server/users',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/users.png',
    ],
    'functions' => [
        'key' => 'functions',
        'name' => 'Functions',
        'subtitle' => 'The Functions Service allows you view, create and manage your Cloud Functions.',
        'description' => '/docs/services/functions.md',
        'controller' => 'api/functions.php',
        'sdk' => true,
        'docs' => true,
        'docsUrl' => 'https://appwrite.io/docs/functions',
        'tests' => false,
        'optional' => true,
        'icon' => '/images/services/functions.png',
    ],
    'mock' => [
        'key' => 'mock',
        'name' => 'Mock',
        'subtitle' => '',
        'description' => '',
        'controller' => 'mock.php',
        'sdk' => false,
        'docs' => false,
        'docsUrl' => '',
        'tests' => true,
        'optional' => false,
        'icon' => '',
    ],
    'graphql' => [
        'key' => 'graphql',
        'name' => 'GraphQL',
        'subtitle' => 'Appwrite\'s GraphQL Endpoint',
        'description' => 'GraphQL Endpoint',
        'controller' => 'api/graphql.php',
        'sdk' => false,
        'docs' => false,
        'docsUrl' => '',
        'tests' => true,
        'optional' => false,
        'icon' => '',
    ],
];
