<p align="center">
  <a href="https://imgit.dev" target="_blank" rel="noopener noreferrer">
    <img width="200" src="https://github.com/elringus/imgit/raw/main/docs/public/favicon.svg" alt="imgit logo">
  </a>
</p>
<br/>
<p align="center">
  <a href="https://www.npmjs.com/package/imgit"><img src="https://img.shields.io/npm/v/imgit" alt="npm"></a>
  <a href="https://codefactor.io/repository/github/elringus/imgit/overview/main"><img src="https://codefactor.io/repository/github/elringus/imgit/badge/main" alt="codefactor"></a>
  <a href="https://codecov.io/gh/elringus/imgit"><img src="https://codecov.io/gh/elringus/imgit/graph/badge.svg?token=3JvjXxyfag" alt="codecov"/></a>
  <a href="https://github.com/elringus/imgit/actions/workflows/codeql.yml"><img src="https://github.com/elringus/imgit/actions/workflows/codeql.yml/badge.svg" alt="codeql"></a>
</p>
<br/>

# Convert media links to optimized HTML

Images, video and YouTube: fetch, encode, scale, lazyload – for best UX and [Web Vitals](https://web.dev/vitals).

✨ Builds optimized HTML for arbitrary image, video and YouTube syntax, such as URLs, markdown or JSX tags.

⚡ Encodes to the modern AV1/AVIF format compressing by up to 90% without noticeable quality loss. Supports GPU acceleration.

♻️ Works with most known media formats: JPEG, PNG, APNG, SVG, GIF, WEBP, WEBM, MP4, AVI, MOV, MKV, BMP, TIFF, TGA and even PSD.

🌊 Generates tiny blurred covers from the source content to be beautifully crossfaded into HD originals once lazy-loaded.

📐 Optionally scales down the content to specified threshold while preserving high-resolution variants for high-DPI displays.

🌐 Fetches from remote sources, such as image hostings. Uploads optimized content to designated endpoint, such as CDN.

🗺️ Built-in plugins for Astro, SvelteKit, SolidStart, VitePress, Nuxt and Remix. Adapters for Node, Deno and Bun runtimes.

### 🎬 Get Started

http://imgit.dev/guide
