const { app, BrowserWindow } = require('electron/main')

function createWindow () {
  const onlineStatusWindow = new BrowserWindow({
    width: 300,
    height: 200
  })

  onlineStatusWindow.loadFile('index.html')
}

app.whenReady().then(() => {
  createWindow()

  app.on('activate', () => {
    if (BrowserWindow.getAllWindows().length === 0) {
      createWindow()
    }
  })
})

app.on('window-all-closed', () => {
  if (process.platform !== 'darwin') {
    app.quit()
  }
})
