/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import sun.swing.text.UndoableEditLockSupport;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        for (UndoableEdit e : this.edits) {
            e.die();
        }
        this.edits = new Vector();
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int size;
        if (this.limit >= 0 && (size = this.edits.size()) > this.limit) {
            int halfLimit = this.limit / 2;
            int keepTo = this.indexOfNextAdd - 1 + halfLimit;
            int keepFrom = this.indexOfNextAdd - 1 - halfLimit;
            if (keepTo - keepFrom + 1 > this.limit) {
                ++keepFrom;
            }
            if (keepFrom < 0) {
                keepTo -= keepFrom;
                keepFrom = 0;
            }
            if (keepTo >= size) {
                int delta = size - keepTo - 1;
                keepTo += delta;
                keepFrom += delta;
            }
            this.trimEdits(keepTo + 1, size - 1);
            this.trimEdits(0, keepFrom - 1);
        }
    }

    protected void trimEdits(int from, int to) {
        if (from <= to) {
            for (int i = to; from <= i; --i) {
                UndoableEdit e = (UndoableEdit)this.edits.elementAt(i);
                e.die();
                this.edits.removeElementAt(i);
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    public synchronized void setLimit(int l) {
        if (!this.inProgress) {
            throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
        }
        this.limit = l;
        this.trimForLimit();
    }

    protected UndoableEdit editToBeUndone() {
        int i = this.indexOfNextAdd;
        while (i > 0) {
            UndoableEdit edit;
            if (!(edit = (UndoableEdit)this.edits.elementAt(--i)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int count = this.edits.size();
        int i = this.indexOfNextAdd;
        while (i < count) {
            UndoableEdit edit;
            if (!(edit = (UndoableEdit)this.edits.elementAt(i++)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        boolean done = false;
        while (!done) {
            UndoableEdit next = (UndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            next.undo();
            done = next == edit;
        }
    }

    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        boolean done = false;
        while (!done) {
            UndoableEdit next = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            next.redo();
            done = next == edit;
        }
    }

    public void undoOrRedo() throws CannotRedoException, CannotUndoException {
        this.tryUndoOrRedo(Action.ANY);
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.tryUndoOrRedo(Action.UNDO);
    }

    @Override
    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeUndone();
            return edit != null && edit.canUndo();
        }
        return super.canUndo();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.tryUndoOrRedo(Action.REDO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void tryUndoOrRedo(Action action) {
        lockSupport = null;
        var4_3 = this;
        // MONITORENTER : var4_3
        if (action == Action.ANY) {
            undo = this.indexOfNextAdd == this.edits.size();
        } else {
            v0 = undo = action == Action.UNDO;
        }
        if (this.inProgress) {
            v1 = edit = undo != false ? this.editToBeUndone() : this.editToBeRedone();
            if (edit == null) {
                if (undo) {
                    v2 /* !! */  = new CannotUndoException();
                    throw v2 /* !! */ ;
                }
                v2 /* !! */  = new CannotRedoException();
                throw v2 /* !! */ ;
            }
            lockSupport = this.getEditLockSupport(edit);
            if (lockSupport == null) {
                if (undo) {
                    this.undoTo(edit);
                    return;
                }
                this.redoTo(edit);
                // MONITOREXIT : var4_3
                return;
            }
        } else {
            if (undo) {
                super.undo();
                return;
            }
            super.redo();
            // MONITOREXIT : var4_3
            return;
        }
        // MONITOREXIT : var4_3
        while (true) lbl-1000:
        // 2 sources

        {
            lockSupport.lockEdit();
            editLockSupport = null;
            var5_5 = this;
            // MONITORENTER : var5_5
            if (action == Action.ANY) {
                v3 = undo = this.indexOfNextAdd == this.edits.size();
            }
            if (this.inProgress) {
                v4 = edit = undo != false ? this.editToBeUndone() : this.editToBeRedone();
                if (edit == null) {
                    if (undo) {
                        v5 /* !! */  = new CannotUndoException();
                        throw v5 /* !! */ ;
                    }
                    v5 /* !! */  = new CannotRedoException();
                    throw v5 /* !! */ ;
                }
                editLockSupport = this.getEditLockSupport(edit);
                if (editLockSupport == null || editLockSupport == lockSupport) {
                    if (undo) {
                        this.undoTo(edit);
                    } else {
                        this.redoTo(edit);
                    }
                    // MONITOREXIT : var5_5
                    if (lockSupport != null) {
                        lockSupport.unlockEdit();
                    }
                    lockSupport = editLockSupport;
                    return;
                }
                break block30;
            }
            if (!undo) break block31;
            break;
        }
        catch (Throwable var8_7) {
            if (lockSupport != null) {
                lockSupport.unlockEdit();
            }
            lockSupport = editLockSupport;
            throw var8_7;
        }
        {
            block30: {
                block32: {
                    block31: {
                        super.undo();
                        break block32;
                    }
                    super.redo();
                }
                // MONITOREXIT : var5_5
                if (lockSupport != null) {
                    lockSupport.unlockEdit();
                }
                lockSupport = editLockSupport;
                return;
            }
            if (lockSupport != null) {
                lockSupport.unlockEdit();
            }
            lockSupport = editLockSupport;
            ** while (true)
        }
    }

    private UndoableEditLockSupport getEditLockSupport(UndoableEdit anEdit) {
        return anEdit instanceof UndoableEditLockSupport ? (UndoableEditLockSupport)anEdit : null;
    }

    @Override
    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeRedone();
            return edit != null && edit.canRedo();
        }
        return super.canRedo();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean retVal = super.addEdit(anEdit);
        if (this.inProgress) {
            retVal = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return retVal;
    }

    @Override
    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    @Override
    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return super.getUndoPresentationName();
    }

    @Override
    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return super.getRedoPresentationName();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEdit(e.getEdit());
    }

    @Override
    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }

    private static enum Action {
        UNDO,
        REDO,
        ANY;

    }
}

