/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.beans.BeanProperty;
import java.util.Enumeration;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public abstract class AbstractLayoutCache
implements RowMapper {
    protected NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected boolean rootVisible;
    protected int rowHeight;

    public void setNodeDimensions(NodeDimensions nd) {
        this.nodeDimensions = nd;
    }

    public NodeDimensions getNodeDimensions() {
        return this.nodeDimensions;
    }

    public void setModel(TreeModel newModel) {
        this.treeModel = newModel;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    @BeanProperty(description="Whether or not the root node from the TreeModel is visible.")
    public void setRootVisible(boolean rootVisible) {
        this.rootVisible = rootVisible;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    @BeanProperty(description="The height of each cell.")
    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelectionModel(TreeSelectionModel newLSM) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = newLSM;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public int getPreferredHeight() {
        Rectangle bounds;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (bounds = this.getBounds(this.getPathForRow(rowCount - 1), null)) != null) {
            return bounds.y + bounds.height;
        }
        return 0;
    }

    public int getPreferredWidth(Rectangle bounds) {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            int endY;
            TreePath firstPath;
            if (bounds == null) {
                firstPath = this.getPathForRow(0);
                endY = Integer.MAX_VALUE;
            } else {
                firstPath = this.getPathClosestTo(bounds.x, bounds.y);
                endY = bounds.height + bounds.y;
            }
            Enumeration<TreePath> paths = this.getVisiblePathsFrom(firstPath);
            if (paths != null && paths.hasMoreElements()) {
                int width;
                Rectangle pBounds = this.getBounds(paths.nextElement(), null);
                if (pBounds != null) {
                    width = pBounds.x + pBounds.width;
                    if (pBounds.y >= endY) {
                        return width;
                    }
                } else {
                    width = 0;
                }
                while (pBounds != null && paths.hasMoreElements()) {
                    pBounds = this.getBounds(paths.nextElement(), pBounds);
                    if (pBounds != null && pBounds.y < endY) {
                        width = Math.max(width, pBounds.x + pBounds.width);
                        continue;
                    }
                    pBounds = null;
                }
                return width;
            }
        }
        return 0;
    }

    public abstract boolean isExpanded(TreePath var1);

    public abstract Rectangle getBounds(TreePath var1, Rectangle var2);

    public abstract TreePath getPathForRow(int var1);

    public abstract int getRowForPath(TreePath var1);

    public abstract TreePath getPathClosestTo(int var1, int var2);

    public abstract Enumeration<TreePath> getVisiblePathsFrom(TreePath var1);

    public abstract int getVisibleChildCount(TreePath var1);

    public abstract void setExpandedState(TreePath var1, boolean var2);

    public abstract boolean getExpandedState(TreePath var1);

    public abstract int getRowCount();

    public abstract void invalidateSizes();

    public abstract void invalidatePathBounds(TreePath var1);

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    @Override
    public int[] getRowsForPaths(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        int numPaths = paths.length;
        int[] rows = new int[numPaths];
        for (int counter = 0; counter < numPaths; ++counter) {
            rows[counter] = this.getRowForPath(paths[counter]);
        }
        return rows;
    }

    protected Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle placeIn) {
        NodeDimensions nd = this.getNodeDimensions();
        if (nd != null) {
            return nd.getNodeDimensions(value, row, depth, expanded, placeIn);
        }
        return null;
    }

    protected boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public static abstract class NodeDimensions {
        public abstract Rectangle getNodeDimensions(Object var1, int var2, int var3, boolean var4, Rectangle var5);
    }
}

