/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    Vector<TableRow> rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element elem) {
        super(elem, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    protected TableRow createTableRow(Element elem) {
        return new TableRow(elem);
    }

    @Deprecated
    protected TableCell createTableCell(Element elem) {
        return new TableCell(elem);
    }

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getColumnSpan(int col) {
        return this.columnSpans[col];
    }

    int getRowCount() {
        return this.rows.size();
    }

    int getRowSpan(int row) {
        TableRow rv = this.getRow(row);
        if (rv != null) {
            return (int)((View)rv).getPreferredSpan(1);
        }
        return 0;
    }

    TableRow getRow(int row) {
        if (row < this.rows.size()) {
            return this.rows.elementAt(row);
        }
        return null;
    }

    int getColumnsOccupied(View v) {
        AttributeSet a = v.getElement().getAttributes();
        String s = (String)a.getAttribute(HTML.Attribute.COLSPAN);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    int getRowsOccupied(View v) {
        AttributeSet a = v.getElement().getAttributes();
        String s = (String)a.getAttribute(HTML.Attribute.ROWSPAN);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    void invalidateGrid() {
        this.gridValid = false;
    }

    @Override
    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
        Container c;
        super.forwardUpdate(ec, e, a, f);
        if (a != null && (c = this.getContainer()) != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
        }
    }

    @Override
    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.invalidateGrid();
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.rows.removeAllElements();
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                if (!(v instanceof TableRow)) continue;
                this.rows.addElement((TableRow)v);
                TableRow rv = (TableRow)v;
                rv.clearFilledColumns();
                rv.setRow(i);
            }
            int maxColumns = 0;
            int nrows = this.rows.size();
            for (int row = 0; row < nrows; ++row) {
                TableRow rv = this.getRow(row);
                int col = 0;
                int cell = 0;
                while (cell < rv.getViewCount()) {
                    View cv = rv.getView(cell);
                    while (rv.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = this.getRowsOccupied(cv);
                    int colSpan = this.getColumnsOccupied(cv);
                    if (colSpan > 1 || rowSpan > 1) {
                        int rowLimit = row + rowSpan;
                        int colLimit = col + colSpan;
                        for (int i = row; i < rowLimit; ++i) {
                            for (int j = col; j < colLimit; ++j) {
                                if (i == row && j == col) continue;
                                this.addFill(i, j);
                            }
                        }
                        if (colSpan > 1) {
                            col += colSpan - 1;
                        }
                    }
                    ++cell;
                    ++col;
                }
                maxColumns = Math.max(maxColumns, col);
            }
            this.columnSpans = new int[maxColumns];
            this.columnOffsets = new int[maxColumns];
            this.columnRequirements = new SizeRequirements[maxColumns];
            for (int i = 0; i < maxColumns; ++i) {
                this.columnRequirements[i] = new SizeRequirements();
            }
            this.gridValid = true;
        }
    }

    void addFill(int row, int col) {
        TableRow rv = this.getRow(row);
        if (rv != null) {
            rv.fillColumn(col);
        }
    }

    protected void layoutColumns(int targetSpan, int[] offsets, int[] spans, SizeRequirements[] reqs) {
        SizeRequirements.calculateTiledPositions(targetSpan, null, reqs, offsets, spans);
    }

    @Override
    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.updateGrid();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow row = this.getRow(i);
            row.layoutChanged(axis);
        }
        this.layoutColumns(targetSpan, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        this.updateGrid();
        this.calculateColumnRequirements(axis);
        if (r == null) {
            r = new SizeRequirements();
        }
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        for (SizeRequirements req : this.columnRequirements) {
            min += (long)req.minimum;
            pref += (long)req.preferred;
            max += (long)req.maximum;
        }
        r.minimum = (int)min;
        r.preferred = (int)pref;
        r.maximum = (int)max;
        r.alignment = 0.0f;
        this.totalColumnRequirements.minimum = r.minimum;
        this.totalColumnRequirements.preferred = r.preferred;
        this.totalColumnRequirements.maximum = r.maximum;
        return r;
    }

    void calculateColumnRequirements(int axis) {
        View cv;
        int cell;
        int ncells;
        int col;
        TableRow row;
        int i;
        for (SizeRequirements req : this.columnRequirements) {
            req.minimum = 0;
            req.preferred = 0;
            req.maximum = Integer.MAX_VALUE;
        }
        boolean hasMultiColumn = false;
        int nrows = this.getRowCount();
        for (i = 0; i < nrows; ++i) {
            row = this.getRow(i);
            col = 0;
            ncells = row.getViewCount();
            cell = 0;
            while (cell < ncells) {
                cv = row.getView(cell);
                while (row.isFilled(col)) {
                    ++col;
                }
                int rowSpan = this.getRowsOccupied(cv);
                int colSpan = this.getColumnsOccupied(cv);
                if (colSpan == 1) {
                    this.checkSingleColumnCell(axis, col, cv);
                } else {
                    hasMultiColumn = true;
                    col += colSpan - 1;
                }
                ++cell;
                ++col;
            }
        }
        if (hasMultiColumn) {
            for (i = 0; i < nrows; ++i) {
                row = this.getRow(i);
                col = 0;
                ncells = row.getViewCount();
                cell = 0;
                while (cell < ncells) {
                    cv = row.getView(cell);
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int colSpan = this.getColumnsOccupied(cv);
                    if (colSpan > 1) {
                        this.checkMultiColumnCell(axis, col, colSpan, cv);
                        col += colSpan - 1;
                    }
                    ++cell;
                    ++col;
                }
            }
        }
    }

    void checkSingleColumnCell(int axis, int col, View v) {
        SizeRequirements req = this.columnRequirements[col];
        req.minimum = Math.max((int)v.getMinimumSpan(axis), req.minimum);
        req.preferred = Math.max((int)v.getPreferredSpan(axis), req.preferred);
        req.maximum = Math.max((int)v.getMaximumSpan(axis), req.maximum);
    }

    void checkMultiColumnCell(int axis, int col, int ncols, View v) {
        int cpref;
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        for (int i = 0; i < ncols; ++i) {
            SizeRequirements req = this.columnRequirements[col + i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
            max += (long)req.maximum;
        }
        int cmin = (int)v.getMinimumSpan(axis);
        if ((long)cmin > min) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements r = reqs[i] = this.columnRequirements[col + i];
                r.maximum = Math.max(r.maximum, (int)v.getMaximumSpan(axis));
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cmin, null, reqs, offsets, spans);
            for (int i2 = 0; i2 < ncols; ++i2) {
                SizeRequirements req = reqs[i2];
                req.minimum = Math.max(spans[i2], req.minimum);
                req.preferred = Math.max(req.minimum, req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
        if ((long)(cpref = (int)v.getPreferredSpan(axis)) > pref) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements i2 = reqs[i] = this.columnRequirements[col + i];
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cpref, null, reqs, offsets, spans);
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements req = reqs[i];
                req.preferred = Math.max(spans[i], req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
    }

    @Override
    protected View getViewAtPosition(int pos, Rectangle a) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            if (pos < p0 || pos >= p1) continue;
            if (a != null) {
                this.childAllocation(i, a);
            }
            return v;
        }
        if (pos == this.getEndOffset()) {
            View v = this.getView(n - 1);
            if (a != null) {
                this.childAllocation(n - 1, a);
            }
            return v;
        }
        return null;
    }

    static interface GridCell {
        public void setGridLocation(int var1, int var2);

        public int getGridRow();

        public int getGridColumn();

        public int getColumnCount();

        public int getRowCount();
    }

    @Deprecated
    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;

        public TableCell(Element elem) {
            super(elem, 1);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public void setGridLocation(int row, int col) {
            this.row = row;
            this.col = col;
        }

        @Override
        public int getGridRow() {
            return this.row;
        }

        @Override
        public int getGridColumn() {
            return this.col;
        }
    }

    public class TableRow
    extends BoxView {
        BitSet fillColumns;
        int row;

        public TableRow(Element elem) {
            super(elem, 0);
            this.fillColumns = new BitSet();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int col) {
            this.fillColumns.set(col);
        }

        boolean isFilled(int col) {
            return this.fillColumns.get(col);
        }

        int getRow() {
            return this.row;
        }

        void setRow(int row) {
            this.row = row;
        }

        int getColumnCount() {
            int nfill = 0;
            int n = this.fillColumns.size();
            for (int i = 0; i < n; ++i) {
                if (!this.fillColumns.get(i)) continue;
                ++nfill;
            }
            return this.getViewCount() + nfill;
        }

        @Override
        public void replace(int offset, int length, View[] views) {
            super.replace(offset, length, views);
            TableView.this.invalidateGrid();
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = new SizeRequirements();
            req.minimum = TableView.this.totalColumnRequirements.minimum;
            req.maximum = TableView.this.totalColumnRequirements.maximum;
            req.preferred = TableView.this.totalColumnRequirements.preferred;
            req.alignment = 0.0f;
            return req;
        }

        @Override
        public float getMinimumSpan(int axis) {
            float value = axis == 0 ? (float)(TableView.this.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(axis);
            return value;
        }

        @Override
        public float getMaximumSpan(int axis) {
            float value = axis == 0 ? 2.1474836E9f : super.getMaximumSpan(axis);
            return value;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float value = axis == 0 ? (float)(TableView.this.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(axis);
            return value;
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int col = 0;
            int ncells = this.getViewCount();
            int cell = 0;
            while (cell < ncells) {
                View cv = this.getView(cell);
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = TableView.this.getColumnsOccupied(cv);
                spans[cell] = TableView.this.columnSpans[col];
                offsets[cell] = TableView.this.columnOffsets[col];
                if (colSpan > 1) {
                    int n = TableView.this.columnSpans.length;
                    for (int j = 1; j < colSpan; ++j) {
                        if (col + j >= n) continue;
                        int n2 = cell;
                        spans[n2] = spans[n2] + TableView.this.columnSpans[col + j];
                    }
                    col += colSpan - 1;
                }
                ++cell;
                ++col;
            }
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            int col = 0;
            int ncells = this.getViewCount();
            int cell = 0;
            while (cell < ncells) {
                View cv = this.getView(cell);
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = TableView.this.getColumnsOccupied(cv);
                int rowSpan = TableView.this.getRowsOccupied(cv);
                if (rowSpan > 1) {
                    for (int j = 1; j < rowSpan; ++j) {
                        int row = this.getRow() + j;
                        if (row >= TableView.this.getViewCount()) continue;
                        int span = TableView.this.getSpan(1, this.getRow() + j);
                        int n = cell;
                        spans[n] = spans[n] + span;
                    }
                }
                if (colSpan > 1) {
                    col += colSpan - 1;
                }
                ++cell;
                ++col;
            }
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        protected View getViewAtPosition(int pos, Rectangle a) {
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                int p0 = v.getStartOffset();
                int p1 = v.getEndOffset();
                if (pos < p0 || pos >= p1) continue;
                if (a != null) {
                    this.childAllocation(i, a);
                }
                return v;
            }
            if (pos == this.getEndOffset()) {
                View v = this.getView(n - 1);
                if (a != null) {
                    this.childAllocation(n - 1, a);
                }
                return v;
            }
            return null;
        }
    }
}

