/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.BeanProperty;
import java.beans.PropertyChangeListener;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.awt.AWTAccessor;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    private static final String uiClassID = "TableHeaderUI";
    protected JTable table;
    protected TableColumnModel columnModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;
    private TableCellRenderer defaultRenderer;
    private transient boolean updateInProgress;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel cm) {
        if (cm == null) {
            cm = this.createDefaultColumnModel();
        }
        this.setColumnModel(cm);
        this.initializeLocalVars();
        this.updateUI();
    }

    @BeanProperty(description="The table associated with this header.")
    public void setTable(JTable table) {
        JTable old = this.table;
        this.table = table;
        this.firePropertyChange("table", old, table);
    }

    public JTable getTable() {
        return this.table;
    }

    @BeanProperty(description="Whether the user can drag column headers to reorder columns.")
    public void setReorderingAllowed(boolean reorderingAllowed) {
        boolean old = this.reorderingAllowed;
        this.reorderingAllowed = reorderingAllowed;
        this.firePropertyChange("reorderingAllowed", old, reorderingAllowed);
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    @BeanProperty(description="Whether the user can resize columns by dragging between headers.")
    public void setResizingAllowed(boolean resizingAllowed) {
        boolean old = this.resizingAllowed;
        this.resizingAllowed = resizingAllowed;
        this.firePropertyChange("resizingAllowed", old, resizingAllowed);
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setUpdateTableInRealTime(boolean flag) {
        this.updateTableInRealTime = flag;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    @Transient
    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public int columnAtPoint(Point point) {
        int x = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            x = this.getWidthInRightToLeft() - x - 1;
        }
        return this.getColumnModel().getColumnIndexAtX(x);
    }

    public Rectangle getHeaderRect(int column) {
        Rectangle r = new Rectangle();
        TableColumnModel cm = this.getColumnModel();
        r.height = this.getHeight();
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidthInRightToLeft();
            }
        } else if (column >= cm.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
        } else {
            for (int i = 0; i < column; ++i) {
                r.x += cm.getColumn(i).getWidth();
            }
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidthInRightToLeft() - r.x - cm.getColumn(column).getWidth();
            }
            r.width = cm.getColumn(column).getWidth();
        }
        return r;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip = null;
        Point p = event.getPoint();
        int column = this.columnAtPoint(p);
        if (column != -1) {
            Component component;
            TableColumn aColumn = this.columnModel.getColumn(column);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.defaultRenderer;
            }
            if ((component = renderer.getTableCellRendererComponent(this.getTable(), aColumn.getHeaderValue(), false, false, -1, column)) instanceof JComponent) {
                Rectangle cellRect = this.getHeaderRect(column);
                p.translate(-cellRect.x, -cellRect.y);
                MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
                AWTAccessor.MouseEventAccessor meAccessor = AWTAccessor.getMouseEventAccessor();
                meAccessor.setCausedByTouchEvent(newEvent, meAccessor.isCausedByTouchEvent(event));
                tip = ((JComponent)component).getToolTipText(newEvent);
            }
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        Dimension preferredSize = super.getPreferredSize();
        if (this.isPreferredSizeSet() && this.ui != null && (size = this.ui.getPreferredSize(this)) != null) {
            preferredSize.width = size.width;
        }
        return preferredSize;
    }

    @Override
    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        if (!this.updateInProgress) {
            this.updateInProgress = true;
            try {
                this.setUI((TableHeaderUI)UIManager.getUI(this));
                TableCellRenderer renderer = this.getDefaultRenderer();
                if (renderer instanceof Component) {
                    SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
                }
            }
            finally {
                this.updateInProgress = false;
            }
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @BeanProperty(description="The object governing the way columns appear in the view.")
    public void setColumnModel(TableColumnModel columnModel) {
        if (columnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel old = this.columnModel;
        if (columnModel != old) {
            if (old != null) {
                old.removeColumnModelListener(this);
            }
            this.columnModel = columnModel;
            columnModel.addColumnModelListener(this);
            this.firePropertyChange("columnModel", old, columnModel);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.resizeAndRepaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.resizeAndRepaint();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.resizeAndRepaint();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultTableCellHeaderRenderer();
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.resizingColumn = null;
        this.updateTableInRealTime = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setDefaultRenderer(this.createDefaultRenderer());
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setDraggedColumn(TableColumn aColumn) {
        this.draggedColumn = aColumn;
    }

    public void setDraggedDistance(int distance) {
        this.draggedDistance = distance;
    }

    public void setResizingColumn(TableColumn aColumn) {
        this.resizingColumn = aColumn;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private int getWidthInRightToLeft() {
        if (this.table != null && this.table.getAutoResizeMode() != 0) {
            return this.table.getWidth();
        }
        return super.getWidth();
    }

    @Override
    protected String paramString() {
        String reorderingAllowedString = this.reorderingAllowed ? "true" : "false";
        String resizingAllowedString = this.resizingAllowed ? "true" : "false";
        String updateTableInRealTimeString = this.updateTableInRealTime ? "true" : "false";
        return super.paramString() + ",draggedDistance=" + this.draggedDistance + ",reorderingAllowed=" + reorderingAllowedString + ",resizingAllowed=" + resizingAllowedString + ",updateTableInRealTime=" + updateTableInRealTimeString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTableHeader();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        protected AccessibleJTableHeader() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int column = JTableHeader.this.columnAtPoint(p);
            if (column != -1) {
                TableColumn aColumn = JTableHeader.this.columnModel.getColumn(column);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    if (JTableHeader.this.defaultRenderer != null) {
                        renderer = JTableHeader.this.defaultRenderer;
                    } else {
                        return null;
                    }
                }
                Component component = renderer.getTableCellRendererComponent(JTableHeader.this.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
                return new AccessibleJTableHeaderEntry(column, JTableHeader.this, JTableHeader.this.table);
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return JTableHeader.this.columnModel.getColumnCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            TableColumn aColumn = JTableHeader.this.columnModel.getColumn(i);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                if (JTableHeader.this.defaultRenderer != null) {
                    renderer = JTableHeader.this.defaultRenderer;
                } else {
                    return null;
                }
            }
            Component component = renderer.getTableCellRendererComponent(JTableHeader.this.getTable(), aColumn.getHeaderValue(), false, false, -1, i);
            return new AccessibleJTableHeaderEntry(i, JTableHeader.this, JTableHeader.this.table);
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTableHeader parent;
            private int column;
            private JTable table;

            public AccessibleJTableHeaderEntry(int c, JTableHeader p, JTable t) {
                this.parent = p;
                this.column = c;
                this.table = t;
                this.setAccessibleParent(this.parent);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                TableColumnModel tcm = this.table.getColumnModel();
                if (tcm != null) {
                    Component c;
                    if (this.column < 0 || this.column >= tcm.getColumnCount()) {
                        return null;
                    }
                    TableColumn aColumn = tcm.getColumn(this.column);
                    TableCellRenderer renderer = aColumn.getHeaderRenderer();
                    if (renderer == null) {
                        if (JTableHeader.this.defaultRenderer != null) {
                            renderer = JTableHeader.this.defaultRenderer;
                        } else {
                            return null;
                        }
                    }
                    if ((c = renderer.getTableCellRendererComponent(JTableHeader.this.getTable(), aColumn.getHeaderValue(), false, false, -1, this.column)) instanceof Accessible) {
                        return ((Accessible)((Object)c)).getAccessibleContext();
                    }
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumnModel tcm = this.table.getColumnModel();
                if (tcm != null) {
                    if (this.column < 0 || this.column >= tcm.getColumnCount()) {
                        return null;
                    }
                    TableColumn aColumn = tcm.getColumn(this.column);
                    TableCellRenderer renderer = aColumn.getHeaderRenderer();
                    if (renderer == null) {
                        if (JTableHeader.this.defaultRenderer != null) {
                            renderer = JTableHeader.this.defaultRenderer;
                        } else {
                            return null;
                        }
                    }
                    return renderer.getTableCellRendererComponent(JTableHeader.this.getTable(), aColumn.getHeaderValue(), false, false, -1, this.column);
                }
                return null;
            }

            @Override
            public String getAccessibleName() {
                String name;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && (name = ac.getAccessibleName()) != null && name != "") {
                    return name;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                name = (String)JTableHeader.this.getClientProperty("AccessibleName");
                if (name != null) {
                    return name;
                }
                return this.table.getColumnName(this.column);
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                } else {
                    super.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    super.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return AccessibleRole.COLUMN_HEADER;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    AccessibleStateSet states = ac.getAccessibleStateSet();
                    if (this.isShowing()) {
                        states.add(AccessibleState.SHOWING);
                    }
                    return states;
                }
                return new AccessibleStateSet();
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.column;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                } else {
                    super.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                } else {
                    super.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isVisible();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isVisible();
                }
                return false;
            }

            @Override
            public void setVisible(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setVisible(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setVisible(b);
                    }
                }
            }

            @Override
            public boolean isShowing() {
                return this.isVisible() && JTableHeader.this.isShowing();
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point parentLocation = this.parent.getLocationOnScreen();
                    Point componentLocation = this.getLocation();
                    componentLocation.translate(parentLocation.x, parentLocation.y);
                    return componentLocation;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.getLocation();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.getLocation();
                }
                return this.getBounds().getLocation();
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                Rectangle r = this.table.getCellRect(-1, this.column, false);
                r.y = 0;
                return r;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setBounds(r);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }
        }
    }
}

