/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthIcon;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SynthTreeUI
extends BasicTreeUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle cellStyle;
    private SynthContext paintContext;
    private boolean drawHorizontalLines;
    private boolean drawVerticalLines;
    private Object linesStyle;
    private int padding;
    private boolean useTreeColors;
    private Icon expandedIconWrapper = new ExpandedIconWrapper();

    public static ComponentUI createUI(JComponent x) {
        return new SynthTreeUI();
    }

    @Override
    public Icon getExpandedIcon() {
        return this.expandedIconWrapper;
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.tree);
    }

    private void updateStyle(JTree tree) {
        SynthContext context = this.getContext((JComponent)tree, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.setExpandedIcon(this.style.getIcon(context, "Tree.expandedIcon"));
            this.setCollapsedIcon(this.style.getIcon(context, "Tree.collapsedIcon"));
            this.setLeftChildIndent(this.style.getInt(context, "Tree.leftChildIndent", 0));
            this.setRightChildIndent(this.style.getInt(context, "Tree.rightChildIndent", 0));
            this.drawHorizontalLines = this.style.getBoolean(context, "Tree.drawHorizontalLines", true);
            this.drawVerticalLines = this.style.getBoolean(context, "Tree.drawVerticalLines", true);
            this.linesStyle = this.style.get(context, "Tree.linesStyle");
            Object value = this.style.get(context, "Tree.rowHeight");
            if (value != null) {
                LookAndFeel.installProperty(tree, "rowHeight", value);
            }
            LookAndFeel.installProperty(tree, "scrollsOnExpand", (value = this.style.get(context, "Tree.scrollsOnExpand")) != null ? value : Boolean.TRUE);
            this.padding = this.style.getInt(context, "Tree.padding", 0);
            this.largeModel = tree.isLargeModel() && tree.getRowHeight() > 0;
            this.useTreeColors = this.style.getBoolean(context, "Tree.rendererUseTreeColors", true);
            Boolean showsRootHandles = this.style.getBoolean(context, "Tree.showsRootHandles", Boolean.TRUE);
            LookAndFeel.installProperty(tree, "showsRootHandles", showsRootHandles);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context = this.getContext(tree, Region.TREE_CELL, 1);
        this.cellStyle = SynthLookAndFeel.updateStyle(context, this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addPropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        return SynthContext.getContext(c, region, this.cellStyle, state);
    }

    private int getComponentState(JComponent c, Region region) {
        return 513;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        TreeCellRenderer renderer = this.tree.getCellRenderer();
        SynthTreeCellEditor editor = renderer != null && renderer instanceof DefaultTreeCellRenderer ? new SynthTreeCellEditor(this.tree, (DefaultTreeCellRenderer)renderer) : new SynthTreeCellEditor(this.tree, null);
        return editor;
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SynthTreeCellRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.tree, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
        context = this.getContext(this.tree, Region.TREE_CELL, 1);
        this.cellStyle.uninstallDefaults(context);
        this.cellStyle = null;
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tree.removePropertyChangeListener(this);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTreeBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTreeBorder(context, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        this.paintContext = context;
        this.updateLeadSelectionRow();
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        TreeModel treeModel = this.tree.getModel();
        SynthContext cellContext = this.getContext((JComponent)this.tree, Region.TREE_CELL);
        this.drawingCache.clear();
        this.setHashColor(context.getStyle().getColor(context, ColorType.FOREGROUND));
        if (paintingEnumerator != null) {
            boolean isExpanded;
            boolean hasBeenExpanded;
            boolean isLeaf;
            Rectangle bounds;
            TreePath path;
            boolean done = false;
            Rectangle rowBounds = new Rectangle(0, 0, this.tree.getWidth(), 0);
            TreeCellRenderer renderer = this.tree.getCellRenderer();
            DefaultTreeCellRenderer dtcr = renderer instanceof DefaultTreeCellRenderer ? (DefaultTreeCellRenderer)renderer : null;
            this.configureRenderer(cellContext);
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                bounds = this.getPathBounds(this.tree, path);
                if (path != null && bounds != null) {
                    isLeaf = treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    rowBounds.y = bounds.y;
                    rowBounds.height = bounds.height;
                    this.paintRow(renderer, dtcr, context, cellContext, g, paintBounds, insets, bounds, rowBounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
            boolean rootVisible = this.tree.isRootVisible();
            TreePath parentPath = initialPath;
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            done = false;
            paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                bounds = this.getPathBounds(this.tree, path);
                if (path != null && bounds != null) {
                    isLeaf = treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.paintDropLine(g);
        this.rendererPane.removeAll();
        this.paintContext = null;
    }

    private void configureRenderer(SynthContext context) {
        TreeCellRenderer renderer = this.tree.getCellRenderer();
        if (renderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)renderer;
            SynthStyle style = context.getStyle();
            context.setComponentState(513);
            Color color = r.getTextSelectionColor();
            if (color == null || color instanceof UIResource) {
                r.setTextSelectionColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
            }
            if ((color = r.getBackgroundSelectionColor()) == null || color instanceof UIResource) {
                r.setBackgroundSelectionColor(style.getColor(context, ColorType.TEXT_BACKGROUND));
            }
            context.setComponentState(1);
            color = r.getTextNonSelectionColor();
            if (color == null || color instanceof UIResource) {
                r.setTextNonSelectionColor(style.getColorForState(context, ColorType.TEXT_FOREGROUND));
            }
            if ((color = r.getBackgroundNonSelectionColor()) == null || color instanceof UIResource) {
                r.setBackgroundNonSelectionColor(style.getColorForState(context, ColorType.TEXT_BACKGROUND));
            }
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.drawHorizontalLines) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.horizontalLine", g, left, y, right, y, this.linesStyle);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.drawVerticalLines) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.verticalLine", g, x, top, x, bottom, this.linesStyle);
    }

    private void paintRow(TreeCellRenderer renderer, DefaultTreeCellRenderer dtcr, SynthContext treeContext, SynthContext cellContext, Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, Rectangle rowBounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean selected = this.tree.isRowSelected(row);
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        boolean isDrop = dropLocation != null && dropLocation.getChildIndex() == -1 && path == dropLocation.getPath();
        int state = 1;
        if (selected || isDrop) {
            state |= 0x200;
        }
        if (this.tree.isFocusOwner() && row == this.getLeadSelectionRow()) {
            state |= 0x100;
        }
        cellContext.setComponentState(state);
        if (dtcr != null && dtcr.getBorderSelectionColor() instanceof UIResource) {
            dtcr.setBorderSelectionColor(this.style.getColor(cellContext, ColorType.FOCUS));
        }
        SynthLookAndFeel.updateSubregion(cellContext, g, rowBounds);
        cellContext.getPainter().paintTreeCellBackground(cellContext, g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
        cellContext.getPainter().paintTreeCellBorder(cellContext, g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = renderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), selected, isExpanded, isLeaf, row, leadIndex == row);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    private int findCenteredX(int x, int iconWidth) {
        return this.tree.getComponentOrientation().isLeftToRight() ? x - (int)Math.ceil((double)iconWidth / 2.0) : x - (int)Math.floor((double)iconWidth / 2.0);
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isSelected = this.tree.getSelectionModel().isPathSelected(path);
        int state = this.paintContext.getComponentState();
        if (isSelected) {
            this.paintContext.setComponentState(state | 0x200);
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        this.paintContext.setComponentState(state);
    }

    @Override
    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        int w = SynthGraphicsUtils.getIconWidth(icon, this.paintContext);
        int h = SynthGraphicsUtils.getIconHeight(icon, this.paintContext);
        SynthGraphicsUtils.paintIcon(icon, this.paintContext, graphics, this.findCenteredX(x, w), y - h / 2, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (SynthLookAndFeel.shouldUpdateStyle(event)) {
            this.updateStyle((JTree)event.getSource());
        }
        if ("dropLocation" == event.getPropertyName()) {
            JTree.DropLocation oldValue = (JTree.DropLocation)event.getOldValue();
            this.repaintDropLocation(oldValue);
            this.repaintDropLocation(this.tree.getDropLocation());
        }
    }

    @Override
    protected void paintDropLine(Graphics g) {
        JTree.DropLocation loc = this.tree.getDropLocation();
        if (!this.isDropLine(loc)) {
            return;
        }
        Color c = (Color)this.style.get(this.paintContext, "Tree.dropLineColor");
        if (c != null) {
            g.setColor(c);
            Rectangle rect = this.getDropLineRect(loc);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void repaintDropLocation(JTree.DropLocation loc) {
        Rectangle r;
        if (loc == null) {
            return;
        }
        if (this.isDropLine(loc)) {
            r = this.getDropLineRect(loc);
        } else {
            r = this.tree.getPathBounds(loc.getPath());
            if (r != null) {
                r.x = 0;
                r.width = this.tree.getWidth();
            }
        }
        if (r != null) {
            this.tree.repaint(r);
        }
    }

    @Override
    protected int getRowX(int row, int depth) {
        return super.getRowX(row, depth) + this.padding;
    }

    private class ExpandedIconWrapper
    implements SynthIcon {
        private ExpandedIconWrapper() {
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            if (context == null) {
                context = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                SynthGraphicsUtils.paintIcon(SynthTreeUI.this.expandedIcon, context, g, x, y, w, h);
            } else {
                SynthGraphicsUtils.paintIcon(SynthTreeUI.this.expandedIcon, context, g, x, y, w, h);
            }
        }

        @Override
        public int getIconWidth(SynthContext context) {
            int width;
            if (context == null) {
                context = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                width = SynthGraphicsUtils.getIconWidth(SynthTreeUI.this.expandedIcon, context);
            } else {
                width = SynthGraphicsUtils.getIconWidth(SynthTreeUI.this.expandedIcon, context);
            }
            return width;
        }

        @Override
        public int getIconHeight(SynthContext context) {
            int height;
            if (context == null) {
                context = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                height = SynthGraphicsUtils.getIconHeight(SynthTreeUI.this.expandedIcon, context);
            } else {
                height = SynthGraphicsUtils.getIconHeight(SynthTreeUI.this.expandedIcon, context);
            }
            return height;
        }
    }

    private static class SynthTreeCellEditor
    extends DefaultTreeCellEditor {
        public SynthTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.setBorderSelectionColor(null);
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            JTextField tf = new JTextField(){

                @Override
                public String getName() {
                    return "Tree.cellEditor";
                }
            };
            DefaultCellEditor editor = new DefaultCellEditor(tf);
            editor.setClickCountToStart(1);
            return editor;
        }
    }

    private class SynthTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        SynthTreeCellRenderer() {
        }

        @Override
        public String getName() {
            return "Tree.cellRenderer";
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!SynthTreeUI.this.useTreeColors && (sel || hasFocus)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), sel, hasFocus, tree.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        @Override
        public void paint(Graphics g) {
            this.paintComponent(g);
            if (this.hasFocus) {
                SynthContext context = SynthTreeUI.this.getContext((JComponent)SynthTreeUI.this.tree, Region.TREE_CELL);
                if (context.getStyle() == null) {
                    assert (false) : "SynthTreeCellRenderer is being used outside of UI that created it";
                    return;
                }
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null && this.getText() != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (this.selected) {
                    context.setComponentState(513);
                } else {
                    context.setComponentState(1);
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    context.getPainter().paintTreeCellFocus(context, g, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
                } else {
                    context.getPainter().paintTreeCellFocus(context, g, 0, 0, this.getWidth() - imageOffset, this.getHeight());
                }
            }
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

