/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthSplitPaneDivider;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthSplitPaneUI
extends BasicSplitPaneUI
implements PropertyChangeListener,
SynthUI {
    private Set<KeyStroke> managingFocusForwardTraversalKeys;
    private Set<KeyStroke> managingFocusBackwardTraversalKeys;
    private SynthStyle style;
    private SynthStyle dividerStyle;

    public static ComponentUI createUI(JComponent x) {
        return new SynthSplitPaneUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.splitPane);
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (this.managingFocusForwardTraversalKeys == null) {
            this.managingFocusForwardTraversalKeys = new HashSet<KeyStroke>();
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, this.managingFocusForwardTraversalKeys);
        if (this.managingFocusBackwardTraversalKeys == null) {
            this.managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>();
            this.managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, this.managingFocusBackwardTraversalKeys);
    }

    private void updateStyle(JSplitPane splitPane) {
        SynthContext context = this.getContext(splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        SynthStyle oldDividerStyle = this.dividerStyle;
        this.dividerStyle = SynthLookAndFeel.updateStyle(context, this);
        context = this.getContext((JComponent)splitPane, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Object value = this.style.get(context, "SplitPane.size");
            if (value == null) {
                value = 6;
            }
            LookAndFeel.installProperty(splitPane, "dividerSize", value);
            this.dividerSize = ((Number)value).intValue();
            value = this.style.get(context, "SplitPane.oneTouchExpandable");
            if (value != null) {
                LookAndFeel.installProperty(splitPane, "oneTouchExpandable", value);
            }
            if (this.divider != null) {
                splitPane.remove(this.divider);
                this.divider.setDividerSize(splitPane.getDividerSize());
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        if (this.style != oldStyle || this.dividerStyle != oldDividerStyle) {
            if (this.divider != null) {
                splitPane.remove(this.divider);
            }
            this.divider = this.createDefaultDivider();
            this.divider.setBasicSplitPaneUI(this);
            splitPane.add((Component)this.divider, "divider");
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.splitPane, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
        context = this.getContext(this.splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle.uninstallDefaults(context);
        this.dividerStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        if (region == Region.SPLIT_PANE_DIVIDER) {
            return SynthContext.getContext(c, region, this.dividerStyle, state);
        }
        return SynthContext.getContext(c, region, this.style, state);
    }

    private int getComponentState(JComponent c, Region subregion) {
        int state = SynthLookAndFeel.getComponentState(c);
        if (this.divider.isMouseOver()) {
            state |= 2;
        }
        return state;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JSplitPane)e.getSource());
        }
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        SynthSplitPaneDivider divider = new SynthSplitPaneDivider(this);
        divider.setDividerSize(this.splitPane.getDividerSize());
        return divider;
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics g) {
                SynthSplitPaneUI.this.paintDragDivider(g, 0, 0, this.getWidth(), this.getHeight());
            }
        };
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintSplitPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        super.paint(g, this.splitPane);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintSplitPaneBorder(context, g, x, y, w, h);
    }

    private void paintDragDivider(Graphics g, int x, int y, int w, int h) {
        SynthContext context = this.getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        context.setComponentState((context.getComponentState() | 2) ^ 2 | 4);
        Shape oldClip = g.getClip();
        g.clipRect(x, y, w, h);
        context.getPainter().paintSplitPaneDragDivider(context, g, x, y, w, h, this.splitPane.getOrientation());
        g.setClip(oldClip);
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (jc == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            if (jc.getOrientation() == 1) {
                this.paintDragDivider(g, this.getLastDragLocation(), 0, this.dividerSize - 1, this.splitPane.getHeight() - 1);
            } else {
                this.paintDragDivider(g, 0, this.getLastDragLocation(), this.splitPane.getWidth() - 1, this.dividerSize - 1);
            }
        }
    }
}

