/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class State<T extends JComponent> {
    static final Map<String, StandardState> standardStates = new HashMap<String, StandardState>(7);
    static final State<JComponent> Enabled = new StandardState(1);
    static final State<JComponent> MouseOver = new StandardState(2);
    static final State<JComponent> Pressed = new StandardState(4);
    static final State<JComponent> Disabled = new StandardState(8);
    static final State<JComponent> Focused = new StandardState(256);
    static final State<JComponent> Selected = new StandardState(512);
    static final State<JComponent> Default = new StandardState(1024);
    private String name;

    protected State(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    boolean isInState(T c, int s) {
        return this.isInState(c);
    }

    protected abstract boolean isInState(T var1);

    String getName() {
        return this.name;
    }

    static boolean isStandardStateName(String name) {
        return standardStates.containsKey(name);
    }

    static StandardState getStandardState(String name) {
        return standardStates.get(name);
    }

    static final class StandardState
    extends State<JComponent> {
        private int state;

        private StandardState(int state) {
            super(StandardState.toString(state));
            this.state = state;
            standardStates.put(this.getName(), this);
        }

        public int getState() {
            return this.state;
        }

        @Override
        boolean isInState(JComponent c, int s) {
            return (s & this.state) == this.state;
        }

        @Override
        protected boolean isInState(JComponent c) {
            throw new AssertionError((Object)"This method should never be called");
        }

        private static String toString(int state) {
            StringBuilder sb = new StringBuilder();
            if ((state & 0x400) == 1024) {
                sb.append("Default");
            }
            if ((state & 8) == 8) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("Disabled");
            }
            if ((state & 1) == 1) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("Enabled");
            }
            if ((state & 0x100) == 256) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("Focused");
            }
            if ((state & 2) == 2) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("MouseOver");
            }
            if ((state & 4) == 4) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("Pressed");
            }
            if ((state & 0x200) == 512) {
                if (sb.length() > 0) {
                    sb.append("+");
                }
                sb.append("Selected");
            }
            return sb.toString();
        }
    }
}

