/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener metalPropertyChangeListener = new MetalPropertyChangeHandler();
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String IS_PALETTE_KEY = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";

    public MetalInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalInternalFrameUI((JInternalFrame)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object paletteProp = c.getClientProperty(IS_PALETTE_KEY);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        Container content = this.frame.getContentPane();
        this.stripContentBorder(content);
    }

    @Override
    public void uninstallUI(JComponent c) {
        JComponent content;
        this.frame = (JInternalFrame)c;
        Container cont = ((JInternalFrame)c).getContentPane();
        if (cont instanceof JComponent && (content = (JComponent)cont).getBorder() == handyEmptyBorder) {
            content.setBorder(null);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(metalPropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(metalPropertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap map = SwingUtilities.getUIActionMap(this.frame);
        if (map != null) {
            map.remove("showSystemMenu");
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    private void stripContentBorder(Object c) {
        JComponent contentComp;
        Border contentBorder;
        if (c instanceof JComponent && ((contentBorder = (contentComp = (JComponent)c).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentComp.setBorder(handyEmptyBorder);
        }
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        return new MetalInternalFrameTitlePane(w);
    }

    private void setFrameType(String frameType) {
        if (frameType.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(false);
        } else if (frameType.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            ((MetalInternalFrameTitlePane)this.titlePane).setPalette(false);
        }
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        ((MetalInternalFrameTitlePane)this.titlePane).setPalette(isPalette);
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new BorderListener1();
    }

    private class BorderListener1
    extends BasicInternalFrameUI.BorderListener
    implements SwingConstants {
        private BorderListener1() {
            super(MetalInternalFrameUI.this);
        }

        Rectangle getIconBounds() {
            boolean leftToRight = MetalUtils.isLeftToRight(MetalInternalFrameUI.this.frame);
            int xOffset = leftToRight ? 5 : MetalInternalFrameUI.this.titlePane.getWidth() - 5;
            Rectangle rect = null;
            Icon icon = MetalInternalFrameUI.this.frame.getFrameIcon();
            if (icon != null) {
                if (!leftToRight) {
                    xOffset -= icon.getIconWidth();
                }
                int iconY = MetalInternalFrameUI.this.titlePane.getHeight() / 2 - icon.getIconHeight() / 2;
                rect = new Rectangle(xOffset, iconY, icon.getIconWidth(), icon.getIconHeight());
            }
            return rect;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getSource() == MetalInternalFrameUI.this.getNorthPane() && MetalInternalFrameUI.this.frame.isClosable() && !MetalInternalFrameUI.this.frame.isIcon()) {
                Rectangle rect = this.getIconBounds();
                if (rect != null && rect.contains(e.getX(), e.getY())) {
                    MetalInternalFrameUI.this.frame.doDefaultCloseAction();
                } else {
                    super.mouseClicked(e);
                }
            } else {
                super.mouseClicked(e);
            }
        }
    }

    private static class MetalPropertyChangeHandler
    implements PropertyChangeListener {
        private MetalPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof MetalInternalFrameUI)) {
                return;
            }
            MetalInternalFrameUI ui = (MetalInternalFrameUI)jif.getUI();
            if (name.equals(FRAME_TYPE)) {
                if (e.getNewValue() instanceof String) {
                    ui.setFrameType((String)e.getNewValue());
                }
            } else if (name.equals(IS_PALETTE_KEY)) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder(e.getNewValue());
            }
        }
    }
}

