/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.java.swing.SwingUtilities3;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.SubRegionShowable;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;
import sun.util.logging.PlatformLogger;

class BufferStrategyPaintManager
extends RepaintManager.PaintManager {
    private static final PlatformLogger LOGGER = PlatformLogger.getLogger("javax.swing.BufferStrategyPaintManager");
    private ArrayList<BufferInfo> bufferInfos = new ArrayList(1);
    private boolean painting;
    private boolean showing;
    private int accumulatedX;
    private int accumulatedY;
    private int accumulatedMaxX;
    private int accumulatedMaxY;
    private JComponent rootJ;
    private int xOffset;
    private int yOffset;
    private Graphics bsg;
    private BufferStrategy bufferStrategy;
    private BufferInfo bufferInfo;
    private boolean disposeBufferOnEnd;

    BufferStrategyPaintManager() {
    }

    @Override
    protected void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<BufferInfo> bufferInfos;
                BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
                synchronized (bufferStrategyPaintManager) {
                    while (BufferStrategyPaintManager.this.showing) {
                        try {
                            BufferStrategyPaintManager.this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    bufferInfos = BufferStrategyPaintManager.this.bufferInfos;
                    BufferStrategyPaintManager.this.bufferInfos = null;
                }
                BufferStrategyPaintManager.this.dispose(bufferInfos);
            }
        });
    }

    private void dispose(List<BufferInfo> bufferInfos) {
        if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
            LOGGER.finer("BufferStrategyPaintManager disposed", new RuntimeException());
        }
        if (bufferInfos != null) {
            for (BufferInfo bufferInfo : bufferInfos) {
                bufferInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean show(Container c, int x, int y, int w, int h) {
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            if (this.painting) {
                return false;
            }
            this.showing = true;
        }
        try {
            BufferStrategy bufferStrategy;
            BufferInfo info = this.getBufferInfo(c);
            if (info != null && info.isInSync() && (bufferStrategy = info.getBufferStrategy(false)) != null) {
                SubRegionShowable bsSubRegion = (SubRegionShowable)((Object)bufferStrategy);
                boolean paintAllOnExpose = info.getPaintAllOnExpose();
                info.setPaintAllOnExpose(false);
                if (bsSubRegion.showIfNotLost(x, y, x + w, y + h)) {
                    boolean bl = !paintAllOnExpose;
                    return bl;
                }
                this.bufferInfo.setContentsLostDuringExpose(true);
            }
        }
        finally {
            BufferStrategyPaintManager bufferStrategyPaintManager2 = this;
            synchronized (bufferStrategyPaintManager2) {
                this.showing = false;
                this.notifyAll();
            }
        }
        return false;
    }

    @Override
    public boolean paint(JComponent paintingComponent, JComponent bufferComponent, Graphics g, int x, int y, int w, int h) {
        Container root = this.fetchRoot(paintingComponent);
        if (this.prepare(paintingComponent, root, true, x, y, w, h)) {
            if (g instanceof SunGraphics2D && ((SunGraphics2D)g).getDestination() == root) {
                int cx = ((SunGraphics2D)this.bsg).constrainX;
                int cy = ((SunGraphics2D)this.bsg).constrainY;
                if (cx != 0 || cy != 0) {
                    this.bsg.translate(-cx, -cy);
                }
                ((SunGraphics2D)this.bsg).constrain(this.xOffset + cx, this.yOffset + cy, x + w, y + h);
                this.bsg.setClip(x, y, w, h);
                paintingComponent.paintToOffscreen(this.bsg, x, y, w, h, x + w, y + h);
                this.accumulate(this.xOffset + x, this.yOffset + y, w, h);
                return true;
            }
            this.bufferInfo.setInSync(false);
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
            LOGGER.finer("prepare failed");
        }
        return super.paint(paintingComponent, bufferComponent, g, x, y, w, h);
    }

    @Override
    public void copyArea(JComponent c, Graphics g, int x, int y, int w, int h, int deltaX, int deltaY, boolean clip) {
        Container root = this.fetchRoot(c);
        if (this.prepare(c, root, false, 0, 0, 0, 0) && this.bufferInfo.isInSync()) {
            if (clip) {
                Rectangle cBounds = c.getVisibleRect();
                int relX = this.xOffset + x;
                int relY = this.yOffset + y;
                this.bsg.clipRect(this.xOffset + cBounds.x, this.yOffset + cBounds.y, cBounds.width, cBounds.height);
                this.bsg.copyArea(relX, relY, w, h, deltaX, deltaY);
            } else {
                this.bsg.copyArea(this.xOffset + x, this.yOffset + y, w, h, deltaX, deltaY);
            }
            this.accumulate(x + this.xOffset + deltaX, y + this.yOffset + deltaY, w, h);
        } else {
            if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                LOGGER.finer("copyArea: prepare failed or not in sync");
            }
            if (!this.flushAccumulatedRegion()) {
                this.rootJ.repaint();
            } else {
                super.copyArea(c, g, x, y, w, h, deltaX, deltaY, clip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginPaint() {
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = true;
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.FINEST)) {
            LOGGER.finest("beginPaint");
        }
        this.resetAccumulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endPaint() {
        if (LOGGER.isLoggable(PlatformLogger.Level.FINEST)) {
            LOGGER.finest("endPaint: region " + this.accumulatedX + " " + this.accumulatedY + " " + this.accumulatedMaxX + " " + this.accumulatedMaxY);
        }
        if (this.painting && !this.flushAccumulatedRegion()) {
            if (!this.isRepaintingRoot()) {
                this.repaintRoot(this.rootJ);
            } else {
                this.resetDoubleBufferPerWindow();
                this.rootJ.repaint();
            }
        }
        BufferInfo toDispose = null;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = false;
            if (this.disposeBufferOnEnd) {
                this.disposeBufferOnEnd = false;
                toDispose = this.bufferInfo;
                this.bufferInfos.remove(toDispose);
            }
        }
        if (toDispose != null) {
            toDispose.dispose();
        }
    }

    private boolean flushAccumulatedRegion() {
        boolean success = true;
        if (this.accumulatedX != Integer.MAX_VALUE) {
            SubRegionShowable bsSubRegion = (SubRegionShowable)((Object)this.bufferStrategy);
            boolean contentsLost = this.bufferStrategy.contentsLost();
            if (!contentsLost) {
                bsSubRegion.show(this.accumulatedX, this.accumulatedY, this.accumulatedMaxX, this.accumulatedMaxY);
                contentsLost = this.bufferStrategy.contentsLost();
            }
            if (contentsLost) {
                if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                    LOGGER.finer("endPaint: contents lost");
                }
                this.bufferInfo.setInSync(false);
                success = false;
            }
        }
        this.resetAccumulated();
        return success;
    }

    private void resetAccumulated() {
        this.accumulatedX = Integer.MAX_VALUE;
        this.accumulatedY = Integer.MAX_VALUE;
        this.accumulatedMaxX = 0;
        this.accumulatedMaxY = 0;
    }

    @Override
    public void doubleBufferingChanged(final JRootPane rootPane) {
        if (!(rootPane.isDoubleBuffered() && rootPane.getUseTrueDoubleBuffering() || rootPane.getParent() == null)) {
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable updater = new Runnable(){

                    @Override
                    public void run() {
                        BufferStrategyPaintManager.this.doubleBufferingChanged0(rootPane);
                    }
                };
                SwingUtilities.invokeLater(updater);
            } else {
                this.doubleBufferingChanged0(rootPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleBufferingChanged0(JRootPane rootPane) {
        BufferInfo info;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            info = this.getBufferInfo(rootPane.getParent());
            if (this.painting && this.bufferInfo == info) {
                this.disposeBufferOnEnd = true;
                info = null;
            } else if (info != null) {
                this.bufferInfos.remove(info);
            }
        }
        if (info != null) {
            info.dispose();
        }
    }

    private boolean prepare(JComponent c, Container root, boolean isPaint, int x, int y, int w, int h) {
        if (this.bsg != null) {
            this.bsg.dispose();
            this.bsg = null;
        }
        this.bufferStrategy = null;
        if (root != null) {
            boolean contentsLost = false;
            BufferInfo bufferInfo = this.getBufferInfo(root);
            if (bufferInfo == null) {
                contentsLost = true;
                bufferInfo = new BufferInfo(root);
                this.bufferInfos.add(bufferInfo);
                if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                    LOGGER.finer("prepare: new BufferInfo: " + root);
                }
            }
            this.bufferInfo = bufferInfo;
            if (!bufferInfo.hasBufferStrategyChanged()) {
                this.bufferStrategy = bufferInfo.getBufferStrategy(true);
                if (this.bufferStrategy != null) {
                    this.bsg = this.bufferStrategy.getDrawGraphics();
                    if (this.bufferStrategy.contentsRestored()) {
                        contentsLost = true;
                        if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                            LOGGER.finer("prepare: contents restored in prepare");
                        }
                    }
                } else {
                    return false;
                }
                if (bufferInfo.getContentsLostDuringExpose()) {
                    contentsLost = true;
                    bufferInfo.setContentsLostDuringExpose(false);
                    if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                        LOGGER.finer("prepare: contents lost on expose");
                    }
                }
                if (isPaint && c == this.rootJ && x == 0 && y == 0 && c.getWidth() == w && c.getHeight() == h) {
                    bufferInfo.setInSync(true);
                } else if (contentsLost) {
                    bufferInfo.setInSync(false);
                    if (!this.isRepaintingRoot()) {
                        this.repaintRoot(this.rootJ);
                    } else {
                        this.resetDoubleBufferPerWindow();
                    }
                }
                return this.bufferInfos != null;
            }
        }
        return false;
    }

    private Container fetchRoot(JComponent c) {
        boolean encounteredHW = false;
        this.rootJ = c;
        Container root = c;
        this.yOffset = 0;
        this.xOffset = 0;
        while (root != null && !(root instanceof Window) && !SunToolkit.isInstanceOf(root, "java.applet.Applet")) {
            this.xOffset += root.getX();
            this.yOffset += root.getY();
            if ((root = root.getParent()) == null) continue;
            if (root instanceof JComponent) {
                this.rootJ = (JComponent)root;
                continue;
            }
            if (root.isLightweight()) continue;
            if (!encounteredHW) {
                encounteredHW = true;
                continue;
            }
            return null;
        }
        if (root instanceof RootPaneContainer && this.rootJ instanceof JRootPane && this.rootJ.isDoubleBuffered() && ((JRootPane)this.rootJ).getUseTrueDoubleBuffering()) {
            return root;
        }
        return null;
    }

    private void resetDoubleBufferPerWindow() {
        if (this.bufferInfos != null) {
            this.dispose(this.bufferInfos);
            this.bufferInfos = null;
            this.repaintManager.setPaintManager(null);
        }
    }

    private BufferInfo getBufferInfo(Container root) {
        for (int counter = this.bufferInfos.size() - 1; counter >= 0; --counter) {
            BufferInfo bufferInfo = this.bufferInfos.get(counter);
            Container biRoot = bufferInfo.getRoot();
            if (biRoot == null) {
                this.bufferInfos.remove(counter);
                if (!LOGGER.isLoggable(PlatformLogger.Level.FINER)) continue;
                LOGGER.finer("BufferInfo pruned, root null");
                continue;
            }
            if (biRoot != root) continue;
            return bufferInfo;
        }
        return null;
    }

    private void accumulate(int x, int y, int w, int h) {
        this.accumulatedX = Math.min(x, this.accumulatedX);
        this.accumulatedY = Math.min(y, this.accumulatedY);
        this.accumulatedMaxX = Math.max(this.accumulatedMaxX, x + w);
        this.accumulatedMaxY = Math.max(this.accumulatedMaxY, y + h);
    }

    private class BufferInfo
    extends ComponentAdapter
    implements WindowListener {
        private WeakReference<BufferStrategy> weakBS;
        private WeakReference<Container> root;
        private boolean inSync;
        private boolean contentsLostDuringExpose;
        private boolean paintAllOnExpose;

        public BufferInfo(Container root) {
            this.root = new WeakReference<Container>(root);
            root.addComponentListener(this);
            if (root instanceof Window) {
                ((Window)root).addWindowListener(this);
            }
        }

        public void setPaintAllOnExpose(boolean paintAllOnExpose) {
            this.paintAllOnExpose = paintAllOnExpose;
        }

        public boolean getPaintAllOnExpose() {
            return this.paintAllOnExpose;
        }

        public void setContentsLostDuringExpose(boolean value) {
            this.contentsLostDuringExpose = value;
        }

        public boolean getContentsLostDuringExpose() {
            return this.contentsLostDuringExpose;
        }

        public void setInSync(boolean inSync) {
            this.inSync = inSync;
        }

        public boolean isInSync() {
            return this.inSync;
        }

        public Container getRoot() {
            return this.root == null ? null : (Container)this.root.get();
        }

        public BufferStrategy getBufferStrategy(boolean create) {
            BufferStrategy bs;
            BufferStrategy bufferStrategy = bs = this.weakBS == null ? null : (BufferStrategy)this.weakBS.get();
            if (bs == null && create) {
                bs = this.createBufferStrategy();
                if (bs != null) {
                    this.weakBS = new WeakReference<BufferStrategy>(bs);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                    LOGGER.finer("getBufferStrategy: created bs: " + bs);
                }
            }
            return bs;
        }

        public boolean hasBufferStrategyChanged() {
            Container root = this.getRoot();
            if (root != null) {
                BufferStrategy ourBS = null;
                BufferStrategy componentBS = null;
                componentBS = root instanceof Window ? ((Window)root).getBufferStrategy() : AWTAccessor.getComponentAccessor().getBufferStrategy(root);
                if (componentBS != (ourBS = this.getBufferStrategy(false))) {
                    if (ourBS != null) {
                        ourBS.dispose();
                    }
                    this.weakBS = null;
                    return true;
                }
            }
            return false;
        }

        private BufferStrategy createBufferStrategy() {
            Container root = this.getRoot();
            if (root == null) {
                return null;
            }
            BufferStrategy bs = null;
            if (SwingUtilities3.isVsyncRequested(root)) {
                bs = this.createBufferStrategy(root, true);
                if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                    LOGGER.finer("createBufferStrategy: using vsynced strategy");
                }
            }
            if (bs == null) {
                bs = this.createBufferStrategy(root, false);
            }
            if (!(bs instanceof SubRegionShowable)) {
                bs = null;
            }
            return bs;
        }

        private BufferStrategy createBufferStrategy(Container root, boolean isVsynced) {
            BufferStrategy bs;
            block6: {
                BufferCapabilities caps = isVsynced ? new ExtendedBufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED, ExtendedBufferCapabilities.VSyncType.VSYNC_ON) : new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), null);
                bs = null;
                if (SunToolkit.isInstanceOf(root, "java.applet.Applet")) {
                    try {
                        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
                        componentAccessor.createBufferStrategy(root, 2, caps);
                        bs = componentAccessor.getBufferStrategy(root);
                    }
                    catch (AWTException e) {
                        if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                            LOGGER.finer("createBufferStratety failed", e);
                        }
                        break block6;
                    }
                }
                try {
                    ((Window)root).createBufferStrategy(2, caps);
                    bs = ((Window)root).getBufferStrategy();
                }
                catch (AWTException e) {
                    if (!LOGGER.isLoggable(PlatformLogger.Level.FINER)) break block6;
                    LOGGER.finer("createBufferStratety failed", e);
                }
            }
            return bs;
        }

        public void dispose() {
            Container root = this.getRoot();
            if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                LOGGER.finer("disposed BufferInfo for: " + root);
            }
            if (root != null) {
                BufferStrategy bs;
                root.removeComponentListener(this);
                if (root instanceof Window) {
                    ((Window)root).removeWindowListener(this);
                }
                if ((bs = this.getBufferStrategy(false)) != null) {
                    bs.dispose();
                }
            }
            this.root = null;
            this.weakBS = null;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Container root = this.getRoot();
            if (root != null && root.isVisible()) {
                root.repaint();
            } else {
                this.setPaintAllOnExpose(true);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.setPaintAllOnExpose(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent e) {
            BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
            synchronized (bufferStrategyPaintManager) {
                while (BufferStrategyPaintManager.this.showing) {
                    try {
                        BufferStrategyPaintManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferStrategyPaintManager.this.bufferInfos.remove(this);
            }
            this.dispose();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

