/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.CloseableDisposerRecord;
import com.sun.imageio.stream.StreamFinalizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;
import sun.java2d.Disposer;

public class FileImageInputStream
extends ImageInputStreamImpl {
    private RandomAccessFile raf;
    private final Object disposerReferent;
    private final CloseableDisposerRecord disposerRecord;

    public FileImageInputStream(File f) throws FileNotFoundException, IOException {
        this(f == null ? null : new RandomAccessFile(f, "r"));
    }

    public FileImageInputStream(RandomAccessFile raf) {
        if (raf == null) {
            throw new IllegalArgumentException("raf == null!");
        }
        this.raf = raf;
        this.disposerRecord = new CloseableDisposerRecord(raf);
        if (this.getClass() == FileImageInputStream.class) {
            this.disposerReferent = new Object();
            Disposer.addRecord(this.disposerReferent, this.disposerRecord);
        } else {
            this.disposerReferent = new StreamFinalizer(this);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.raf.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int nbytes = this.raf.read(b, off, len);
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.raf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.raf.seek(pos);
        this.streamPos = this.raf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.disposerRecord.dispose();
        this.raf = null;
    }

    @Override
    @Deprecated(since="9")
    protected void finalize() throws Throwable {
    }
}

