/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.SunWritableRaster;

abstract class TexturePaintContext
implements PaintContext {
    public static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    public static ColorModel argbmodel = ColorModel.getRGBdefault();
    ColorModel colorModel;
    int bWidth;
    int bHeight;
    int maxWidth;
    WritableRaster outRas;
    double xOrg;
    double yOrg;
    double incXAcross;
    double incYAcross;
    double incXDown;
    double incYDown;
    int colincx;
    int colincy;
    int colincxerr;
    int colincyerr;
    int rowincx;
    int rowincy;
    int rowincxerr;
    int rowincyerr;
    private static WeakReference<Raster> xrgbRasRef;
    private static WeakReference<Raster> argbRasRef;
    private static WeakReference<Raster> byteRasRef;

    public static PaintContext getContext(BufferedImage bufImg, AffineTransform xform, RenderingHints hints, Rectangle devBounds) {
        ByteInterleavedRaster bir;
        boolean filter;
        WritableRaster raster = bufImg.getRaster();
        ColorModel cm = bufImg.getColorModel();
        int maxw = devBounds.width;
        Object val = hints.get(RenderingHints.KEY_INTERPOLATION);
        boolean bl = val == null ? hints.get(RenderingHints.KEY_RENDERING) == RenderingHints.VALUE_RENDER_QUALITY : (filter = val != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        if (raster instanceof IntegerInterleavedRaster && (!filter || TexturePaintContext.isFilterableDCM(cm))) {
            IntegerInterleavedRaster iir = (IntegerInterleavedRaster)raster;
            if (iir.getNumDataElements() == 1 && iir.getPixelStride() == 1) {
                return new Int(iir, cm, xform, maxw, filter);
            }
        } else if (raster instanceof ByteInterleavedRaster && (bir = (ByteInterleavedRaster)raster).getNumDataElements() == 1 && bir.getPixelStride() == 1) {
            if (filter) {
                if (TexturePaintContext.isFilterableICM(cm)) {
                    return new ByteFilter(bir, cm, xform, maxw);
                }
            } else {
                return new Byte(bir, cm, xform, maxw);
            }
        }
        return new Any(raster, cm, xform, maxw, filter);
    }

    public static boolean isFilterableICM(ColorModel cm) {
        IndexColorModel icm;
        return cm instanceof IndexColorModel && (icm = (IndexColorModel)cm).getMapSize() <= 256;
    }

    public static boolean isFilterableDCM(ColorModel cm) {
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            return TexturePaintContext.isMaskOK(dcm.getAlphaMask(), true) && TexturePaintContext.isMaskOK(dcm.getRedMask(), false) && TexturePaintContext.isMaskOK(dcm.getGreenMask(), false) && TexturePaintContext.isMaskOK(dcm.getBlueMask(), false);
        }
        return false;
    }

    public static boolean isMaskOK(int mask, boolean canbezero) {
        if (canbezero && mask == 0) {
            return true;
        }
        return mask == 255 || mask == 65280 || mask == 0xFF0000 || mask == -16777216;
    }

    public static ColorModel getInternedColorModel(ColorModel cm) {
        if (xrgbmodel == cm || xrgbmodel.equals(cm)) {
            return xrgbmodel;
        }
        if (argbmodel == cm || argbmodel.equals(cm)) {
            return argbmodel;
        }
        return cm;
    }

    TexturePaintContext(ColorModel cm, AffineTransform xform, int bWidth, int bHeight, int maxw) {
        this.colorModel = TexturePaintContext.getInternedColorModel(cm);
        this.bWidth = bWidth;
        this.bHeight = bHeight;
        this.maxWidth = maxw;
        try {
            xform = xform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            xform.setToScale(0.0, 0.0);
        }
        this.incXAcross = TexturePaintContext.mod(xform.getScaleX(), bWidth);
        this.incYAcross = TexturePaintContext.mod(xform.getShearY(), bHeight);
        this.incXDown = TexturePaintContext.mod(xform.getShearX(), bWidth);
        this.incYDown = TexturePaintContext.mod(xform.getScaleY(), bHeight);
        this.xOrg = xform.getTranslateX();
        this.yOrg = xform.getTranslateY();
        this.colincx = (int)this.incXAcross;
        this.colincy = (int)this.incYAcross;
        this.colincxerr = TexturePaintContext.fractAsInt(this.incXAcross);
        this.colincyerr = TexturePaintContext.fractAsInt(this.incYAcross);
        this.rowincx = (int)this.incXDown;
        this.rowincy = (int)this.incYDown;
        this.rowincxerr = TexturePaintContext.fractAsInt(this.incXDown);
        this.rowincyerr = TexturePaintContext.fractAsInt(this.incYDown);
    }

    static int fractAsInt(double d) {
        return (int)(d % 1.0 * 2.147483647E9);
    }

    static double mod(double num, double den) {
        if ((num %= den) < 0.0 && (num += den) >= den) {
            num = 0.0;
        }
        return num;
    }

    @Override
    public void dispose() {
        TexturePaintContext.dropRaster(this.colorModel, this.outRas);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (this.outRas == null || this.outRas.getWidth() < w || this.outRas.getHeight() < h) {
            this.outRas = this.makeRaster(h == 1 ? Math.max(w, this.maxWidth) : w, h);
        }
        double X = TexturePaintContext.mod(this.xOrg + (double)x * this.incXAcross + (double)y * this.incXDown, this.bWidth);
        double Y = TexturePaintContext.mod(this.yOrg + (double)x * this.incYAcross + (double)y * this.incYDown, this.bHeight);
        this.setRaster((int)X, (int)Y, TexturePaintContext.fractAsInt(X), TexturePaintContext.fractAsInt(Y), w, h, this.bWidth, this.bHeight, this.colincx, this.colincxerr, this.colincy, this.colincyerr, this.rowincx, this.rowincxerr, this.rowincy, this.rowincyerr);
        SunWritableRaster.markDirty(this.outRas);
        return this.outRas;
    }

    static synchronized WritableRaster makeRaster(ColorModel cm, Raster srcRas, int w, int h) {
        if (xrgbmodel == cm) {
            WritableRaster wr;
            if (xrgbRasRef != null && (wr = (WritableRaster)xrgbRasRef.get()) != null && wr.getWidth() >= w && wr.getHeight() >= h) {
                xrgbRasRef = null;
                return wr;
            }
            if (w <= 32 && h <= 32) {
                h = 32;
                w = 32;
            }
        } else if (argbmodel == cm) {
            WritableRaster wr;
            if (argbRasRef != null && (wr = (WritableRaster)argbRasRef.get()) != null && wr.getWidth() >= w && wr.getHeight() >= h) {
                argbRasRef = null;
                return wr;
            }
            if (w <= 32 && h <= 32) {
                h = 32;
                w = 32;
            }
        }
        if (srcRas != null) {
            return srcRas.createCompatibleWritableRaster(w, h);
        }
        return cm.createCompatibleWritableRaster(w, h);
    }

    static synchronized void dropRaster(ColorModel cm, Raster outRas) {
        if (outRas == null) {
            return;
        }
        if (xrgbmodel == cm) {
            xrgbRasRef = new WeakReference<Raster>(outRas);
        } else if (argbmodel == cm) {
            argbRasRef = new WeakReference<Raster>(outRas);
        }
    }

    static synchronized WritableRaster makeByteRaster(Raster srcRas, int w, int h) {
        WritableRaster wr;
        if (byteRasRef != null && (wr = (WritableRaster)byteRasRef.get()) != null && wr.getWidth() >= w && wr.getHeight() >= h) {
            byteRasRef = null;
            return wr;
        }
        if (w <= 32 && h <= 32) {
            h = 32;
            w = 32;
        }
        return srcRas.createCompatibleWritableRaster(w, h);
    }

    static synchronized void dropByteRaster(Raster outRas) {
        if (outRas == null) {
            return;
        }
        byteRasRef = new WeakReference<Raster>(outRas);
    }

    public abstract WritableRaster makeRaster(int var1, int var2);

    public abstract void setRaster(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static int blend(int[] rgbs, int xmul, int ymul) {
        xmul >>>= 19;
        ymul >>>= 19;
        int accumB = 0;
        int accumG = 0;
        int accumR = 0;
        int accumA = 0;
        for (int i = 0; i < 4; ++i) {
            int factor;
            int rgb = rgbs[i];
            xmul = 4096 - xmul;
            if ((i & 1) == 0) {
                ymul = 4096 - ymul;
            }
            if ((factor = xmul * ymul) == 0) continue;
            accumA += (rgb >>> 24) * factor;
            accumR += (rgb >>> 16 & 0xFF) * factor;
            accumG += (rgb >>> 8 & 0xFF) * factor;
            accumB += (rgb & 0xFF) * factor;
        }
        return accumA + 0x800000 >>> 24 << 24 | accumR + 0x800000 >>> 24 << 16 | accumG + 0x800000 >>> 24 << 8 | accumB + 0x800000 >>> 24;
    }

    static class Any
    extends TexturePaintContext {
        WritableRaster srcRas;
        boolean filter;

        public Any(WritableRaster srcRas, ColorModel cm, AffineTransform xform, int maxw, boolean filter) {
            super(cm, xform, srcRas.getWidth(), srcRas.getHeight(), maxw);
            this.srcRas = srcRas;
            this.filter = filter;
        }

        @Override
        public WritableRaster makeRaster(int w, int h) {
            return Any.makeRaster(this.colorModel, this.srcRas, w, h);
        }

        @Override
        public void setRaster(int x, int y, int xerr, int yerr, int w, int h, int bWidth, int bHeight, int colincx, int colincxerr, int colincy, int colincyerr, int rowincx, int rowincxerr, int rowincy, int rowincyerr) {
            Object data = null;
            int rowx = x;
            int rowy = y;
            int rowxerr = xerr;
            int rowyerr = yerr;
            WritableRaster srcRas = this.srcRas;
            WritableRaster outRas = this.outRas;
            int[] rgbs = this.filter ? new int[4] : null;
            for (int j = 0; j < h; ++j) {
                x = rowx;
                y = rowy;
                xerr = rowxerr;
                yerr = rowyerr;
                for (int i = 0; i < w; ++i) {
                    data = srcRas.getDataElements(x, y, data);
                    if (this.filter) {
                        int nexty;
                        int nextx = x + 1;
                        if (nextx >= bWidth) {
                            nextx = 0;
                        }
                        if ((nexty = y + 1) >= bHeight) {
                            nexty = 0;
                        }
                        rgbs[0] = this.colorModel.getRGB(data);
                        data = srcRas.getDataElements(nextx, y, data);
                        rgbs[1] = this.colorModel.getRGB(data);
                        data = srcRas.getDataElements(x, nexty, data);
                        rgbs[2] = this.colorModel.getRGB(data);
                        data = srcRas.getDataElements(nextx, nexty, data);
                        rgbs[3] = this.colorModel.getRGB(data);
                        int rgb = TexturePaintContext.blend(rgbs, xerr, yerr);
                        data = this.colorModel.getDataElements(rgb, data);
                    }
                    outRas.setDataElements(i, j, data);
                    if ((xerr += colincxerr) < 0) {
                        xerr &= Integer.MAX_VALUE;
                        ++x;
                    }
                    if ((x += colincx) >= bWidth) {
                        x -= bWidth;
                    }
                    if ((yerr += colincyerr) < 0) {
                        yerr &= Integer.MAX_VALUE;
                        ++y;
                    }
                    if ((y += colincy) < bHeight) continue;
                    y -= bHeight;
                }
                if ((rowxerr += rowincxerr) < 0) {
                    rowxerr &= Integer.MAX_VALUE;
                    ++rowx;
                }
                if ((rowx += rowincx) >= bWidth) {
                    rowx -= bWidth;
                }
                if ((rowyerr += rowincyerr) < 0) {
                    rowyerr &= Integer.MAX_VALUE;
                    ++rowy;
                }
                if ((rowy += rowincy) < bHeight) continue;
                rowy -= bHeight;
            }
        }
    }

    static class ByteFilter
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        int[] inPalette = new int[256];
        byte[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;

        public ByteFilter(ByteInterleavedRaster srcRas, ColorModel cm, AffineTransform xform, int maxw) {
            super(cm.getTransparency() == 1 ? xrgbmodel : argbmodel, xform, srcRas.getWidth(), srcRas.getHeight(), maxw);
            ((IndexColorModel)cm).getRGBs(this.inPalette);
            this.srcRas = srcRas;
            this.inData = srcRas.getDataStorage();
            this.inSpan = srcRas.getScanlineStride();
            this.inOff = srcRas.getDataOffset(0);
        }

        @Override
        public WritableRaster makeRaster(int w, int h) {
            WritableRaster ras = ByteFilter.makeRaster(this.colorModel, null, w, h);
            IntegerInterleavedRaster iiRas = (IntegerInterleavedRaster)ras;
            this.outData = iiRas.getDataStorage();
            this.outSpan = iiRas.getScanlineStride();
            this.outOff = iiRas.getDataOffset(0);
            return ras;
        }

        @Override
        public void setRaster(int x, int y, int xerr, int yerr, int w, int h, int bWidth, int bHeight, int colincx, int colincxerr, int colincy, int colincyerr, int rowincx, int rowincxerr, int rowincy, int rowincyerr) {
            byte[] inData = this.inData;
            int[] outData = this.outData;
            int out = this.outOff;
            int inSpan = this.inSpan;
            int inOff = this.inOff;
            int outSpan = this.outSpan;
            int rowx = x;
            int rowy = y;
            int rowxerr = xerr;
            int rowyerr = yerr;
            int[] rgbs = new int[4];
            for (int j = 0; j < h; ++j) {
                x = rowx;
                y = rowy;
                xerr = rowxerr;
                yerr = rowyerr;
                for (int i = 0; i < w; ++i) {
                    int nexty;
                    int nextx = x + 1;
                    if (nextx >= bWidth) {
                        nextx = 0;
                    }
                    if ((nexty = y + 1) >= bHeight) {
                        nexty = 0;
                    }
                    rgbs[0] = this.inPalette[0xFF & inData[inOff + x + inSpan * y]];
                    rgbs[1] = this.inPalette[0xFF & inData[inOff + nextx + inSpan * y]];
                    rgbs[2] = this.inPalette[0xFF & inData[inOff + x + inSpan * nexty]];
                    rgbs[3] = this.inPalette[0xFF & inData[inOff + nextx + inSpan * nexty]];
                    outData[out + i] = TexturePaintContext.blend(rgbs, xerr, yerr);
                    if ((xerr += colincxerr) < 0) {
                        xerr &= Integer.MAX_VALUE;
                        ++x;
                    }
                    if ((x += colincx) >= bWidth) {
                        x -= bWidth;
                    }
                    if ((yerr += colincyerr) < 0) {
                        yerr &= Integer.MAX_VALUE;
                        ++y;
                    }
                    if ((y += colincy) < bHeight) continue;
                    y -= bHeight;
                }
                if ((rowxerr += rowincxerr) < 0) {
                    rowxerr &= Integer.MAX_VALUE;
                    ++rowx;
                }
                if ((rowx += rowincx) >= bWidth) {
                    rowx -= bWidth;
                }
                if ((rowyerr += rowincyerr) < 0) {
                    rowyerr &= Integer.MAX_VALUE;
                    ++rowy;
                }
                if ((rowy += rowincy) >= bHeight) {
                    rowy -= bHeight;
                }
                out += outSpan;
            }
        }
    }

    static class Byte
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        byte[] inData;
        int inOff;
        int inSpan;
        byte[] outData;
        int outOff;
        int outSpan;

        public Byte(ByteInterleavedRaster srcRas, ColorModel cm, AffineTransform xform, int maxw) {
            super(cm, xform, srcRas.getWidth(), srcRas.getHeight(), maxw);
            this.srcRas = srcRas;
            this.inData = srcRas.getDataStorage();
            this.inSpan = srcRas.getScanlineStride();
            this.inOff = srcRas.getDataOffset(0);
        }

        @Override
        public WritableRaster makeRaster(int w, int h) {
            WritableRaster ras = Byte.makeByteRaster(this.srcRas, w, h);
            ByteInterleavedRaster biRas = (ByteInterleavedRaster)ras;
            this.outData = biRas.getDataStorage();
            this.outSpan = biRas.getScanlineStride();
            this.outOff = biRas.getDataOffset(0);
            return ras;
        }

        @Override
        public void dispose() {
            Byte.dropByteRaster(this.outRas);
        }

        @Override
        public void setRaster(int x, int y, int xerr, int yerr, int w, int h, int bWidth, int bHeight, int colincx, int colincxerr, int colincy, int colincyerr, int rowincx, int rowincxerr, int rowincy, int rowincyerr) {
            byte[] inData = this.inData;
            byte[] outData = this.outData;
            int out = this.outOff;
            int inSpan = this.inSpan;
            int inOff = this.inOff;
            int outSpan = this.outSpan;
            boolean normalx = colincx == 1 && colincxerr == 0 && colincy == 0 && colincyerr == 0;
            int rowx = x;
            int rowy = y;
            int rowxerr = xerr;
            int rowyerr = yerr;
            if (normalx) {
                outSpan -= w;
            }
            for (int j = 0; j < h; ++j) {
                if (normalx) {
                    int i;
                    int in = inOff + rowy * inSpan + bWidth;
                    x = bWidth - rowx;
                    out += w;
                    if (bWidth >= 32) {
                        int copyw;
                        for (i = w; i > 0; i -= copyw) {
                            copyw = i < x ? i : x;
                            System.arraycopy(inData, in - x, outData, out - i, copyw);
                            if ((x -= copyw) != 0) continue;
                            x = bWidth;
                        }
                    } else {
                        for (i = w; i > 0; --i) {
                            outData[out - i] = inData[in - x];
                            if (--x != 0) continue;
                            x = bWidth;
                        }
                    }
                } else {
                    x = rowx;
                    y = rowy;
                    xerr = rowxerr;
                    yerr = rowyerr;
                    for (int i = 0; i < w; ++i) {
                        outData[out + i] = inData[inOff + y * inSpan + x];
                        if ((xerr += colincxerr) < 0) {
                            xerr &= Integer.MAX_VALUE;
                            ++x;
                        }
                        if ((x += colincx) >= bWidth) {
                            x -= bWidth;
                        }
                        if ((yerr += colincyerr) < 0) {
                            yerr &= Integer.MAX_VALUE;
                            ++y;
                        }
                        if ((y += colincy) < bHeight) continue;
                        y -= bHeight;
                    }
                }
                if ((rowxerr += rowincxerr) < 0) {
                    rowxerr &= Integer.MAX_VALUE;
                    ++rowx;
                }
                if ((rowx += rowincx) >= bWidth) {
                    rowx -= bWidth;
                }
                if ((rowyerr += rowincyerr) < 0) {
                    rowyerr &= Integer.MAX_VALUE;
                    ++rowy;
                }
                if ((rowy += rowincy) >= bHeight) {
                    rowy -= bHeight;
                }
                out += outSpan;
            }
        }
    }

    static class Int
    extends TexturePaintContext {
        IntegerInterleavedRaster srcRas;
        int[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;
        boolean filter;

        public Int(IntegerInterleavedRaster srcRas, ColorModel cm, AffineTransform xform, int maxw, boolean filter) {
            super(cm, xform, srcRas.getWidth(), srcRas.getHeight(), maxw);
            this.srcRas = srcRas;
            this.inData = srcRas.getDataStorage();
            this.inSpan = srcRas.getScanlineStride();
            this.inOff = srcRas.getDataOffset(0);
            this.filter = filter;
        }

        @Override
        public WritableRaster makeRaster(int w, int h) {
            WritableRaster ras = Int.makeRaster(this.colorModel, this.srcRas, w, h);
            IntegerInterleavedRaster iiRas = (IntegerInterleavedRaster)ras;
            this.outData = iiRas.getDataStorage();
            this.outSpan = iiRas.getScanlineStride();
            this.outOff = iiRas.getDataOffset(0);
            return ras;
        }

        @Override
        public void setRaster(int x, int y, int xerr, int yerr, int w, int h, int bWidth, int bHeight, int colincx, int colincxerr, int colincy, int colincyerr, int rowincx, int rowincxerr, int rowincy, int rowincyerr) {
            int[] inData = this.inData;
            int[] outData = this.outData;
            int out = this.outOff;
            int inSpan = this.inSpan;
            int inOff = this.inOff;
            int outSpan = this.outSpan;
            boolean filter = this.filter;
            boolean normalx = colincx == 1 && colincxerr == 0 && colincy == 0 && colincyerr == 0 && !filter;
            int rowx = x;
            int rowy = y;
            int rowxerr = xerr;
            int rowyerr = yerr;
            if (normalx) {
                outSpan -= w;
            }
            int[] rgbs = filter ? new int[4] : null;
            for (int j = 0; j < h; ++j) {
                if (normalx) {
                    int i;
                    int in = inOff + rowy * inSpan + bWidth;
                    x = bWidth - rowx;
                    out += w;
                    if (bWidth >= 32) {
                        int copyw;
                        for (i = w; i > 0; i -= copyw) {
                            copyw = i < x ? i : x;
                            System.arraycopy(inData, in - x, outData, out - i, copyw);
                            if ((x -= copyw) != 0) continue;
                            x = bWidth;
                        }
                    } else {
                        for (i = w; i > 0; --i) {
                            outData[out - i] = inData[in - x];
                            if (--x != 0) continue;
                            x = bWidth;
                        }
                    }
                } else {
                    x = rowx;
                    y = rowy;
                    xerr = rowxerr;
                    yerr = rowyerr;
                    for (int i = 0; i < w; ++i) {
                        if (filter) {
                            int nexty;
                            int nextx = x + 1;
                            if (nextx >= bWidth) {
                                nextx = 0;
                            }
                            if ((nexty = y + 1) >= bHeight) {
                                nexty = 0;
                            }
                            rgbs[0] = inData[inOff + y * inSpan + x];
                            rgbs[1] = inData[inOff + y * inSpan + nextx];
                            rgbs[2] = inData[inOff + nexty * inSpan + x];
                            rgbs[3] = inData[inOff + nexty * inSpan + nextx];
                            outData[out + i] = TexturePaintContext.blend(rgbs, xerr, yerr);
                        } else {
                            outData[out + i] = inData[inOff + y * inSpan + x];
                        }
                        if ((xerr += colincxerr) < 0) {
                            xerr &= Integer.MAX_VALUE;
                            ++x;
                        }
                        if ((x += colincx) >= bWidth) {
                            x -= bWidth;
                        }
                        if ((yerr += colincyerr) < 0) {
                            yerr &= Integer.MAX_VALUE;
                            ++y;
                        }
                        if ((y += colincy) < bHeight) continue;
                        y -= bHeight;
                    }
                }
                if ((rowxerr += rowincxerr) < 0) {
                    rowxerr &= Integer.MAX_VALUE;
                    ++rowx;
                }
                if ((rowx += rowincx) >= bWidth) {
                    rowx -= bWidth;
                }
                if ((rowyerr += rowincyerr) < 0) {
                    rowyerr &= Integer.MAX_VALUE;
                    ++rowy;
                }
                if ((rowy += rowincy) >= bHeight) {
                    rowy -= bHeight;
                }
                out += outSpan;
            }
        }
    }
}

