/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaIcon;
import com.apple.laf.AquaMenuItemUI;
import com.apple.laf.ScreenMenuItem;
import com.apple.laf.ScreenMenuItemUI;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.plaf.ButtonUI;
import sun.awt.AWTAccessor;
import sun.lwawt.macosx.CCheckboxMenuItem;
import sun.lwawt.macosx.CMenuItem;

final class ScreenMenuItemCheckbox
extends CheckboxMenuItem
implements ActionListener,
ComponentListener,
ScreenMenuPropertyHandler,
ItemListener {
    JMenuItem fMenuItem;
    MenuContainer fParent;
    ScreenMenuPropertyListener fPropertyListener;

    ScreenMenuItemCheckbox(JCheckBoxMenuItem mi) {
        super(mi.getText(), mi.getState());
        this.init(mi);
    }

    ScreenMenuItemCheckbox(JRadioButtonMenuItem mi) {
        super(mi.getText(), mi.getModel().isSelected());
        this.init(mi);
    }

    public void init(JMenuItem mi) {
        this.fMenuItem = mi;
        this.setEnabled(this.fMenuItem.isEnabled());
    }

    @Override
    public void addNotify() {
        String tooltipText;
        super.addNotify();
        CCheckboxMenuItem ccb = (CCheckboxMenuItem)AWTAccessor.getMenuComponentAccessor().getPeer(this);
        ccb.setAutoToggle(false);
        this.fMenuItem.addComponentListener(this);
        this.fPropertyListener = new ScreenMenuPropertyListener(this);
        this.fMenuItem.addPropertyChangeListener(this.fPropertyListener);
        this.addActionListener(this);
        this.addItemListener(this);
        this.fMenuItem.addItemListener(this);
        this.setIndeterminate(AquaMenuItemUI.IndeterminateListener.isIndeterminate(this.fMenuItem));
        this.setAccelerator(this.fMenuItem.getAccelerator());
        Icon icon = this.fMenuItem.getIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        if ((tooltipText = this.fMenuItem.getToolTipText()) != null) {
            this.setToolTipText(tooltipText);
        }
        this.fMenuItem.addItemListener(this);
        ButtonUI ui = this.fMenuItem.getUI();
        if (ui instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)ui)).updateListenersForScreenMenuItem();
        }
        if (this.fMenuItem instanceof JCheckBoxMenuItem) {
            this.forceSetState(this.fMenuItem.isSelected());
        } else {
            this.forceSetState(this.fMenuItem.getModel().isSelected());
        }
    }

    @Override
    public void removeNotify() {
        this.fMenuItem.removeComponentListener(this);
        this.fMenuItem.removePropertyChangeListener(this.fPropertyListener);
        this.fPropertyListener = null;
        this.removeActionListener(this);
        this.removeItemListener(this);
        this.fMenuItem.removeItemListener(this);
        super.removeNotify();
    }

    @Override
    public synchronized void setLabel(String label) {
        ScreenMenuItem.syncLabelAndKS(this, label, this.fMenuItem.getAccelerator());
    }

    @Override
    public void setAccelerator(KeyStroke ks) {
        ScreenMenuItem.syncLabelAndKS(this, this.fMenuItem.getText(), ks);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fMenuItem.doClick(0);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setVisible(false);
    }

    @Override
    public void setToolTipText(String text) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(this);
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        ((CMenuItem)peer).setToolTipText(text);
    }

    @Override
    public void setIcon(Icon i) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(this);
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        Image img = null;
        if (i != null && i.getIconWidth() > 0 && i.getIconHeight() > 0) {
            img = AquaIcon.getImageForIcon(i);
        }
        cmi.setImage(img);
    }

    public void setVisible(boolean b) {
        if (this.fParent == null) {
            this.fParent = this.getParent();
        }
        ((ScreenMenuPropertyHandler)((Object)this.fParent)).setChildVisible(this.fMenuItem, b);
    }

    @Override
    public void setChildVisible(JMenuItem child, boolean b) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this) {
            this.fMenuItem.doClick(0);
            return;
        }
        switch (e.getStateChange()) {
            case 1: {
                this.forceSetState(true);
                break;
            }
            case 2: {
                this.forceSetState(false);
            }
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(this);
        if (peer instanceof CCheckboxMenuItem) {
            ((CCheckboxMenuItem)peer).setIsIndeterminate(indeterminate);
        }
    }

    @Override
    public synchronized void setState(boolean b) {
    }

    private void forceSetState(boolean b) {
        super.setState(b);
    }
}

