/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaTabbedPaneUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaTabbedPaneContrastUI
extends AquaTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new AquaTabbedPaneContrastUI();
    }

    @Override
    protected void paintTitle(Graphics2D g2d, Font font, FontMetrics metrics, Rectangle textRect, int tabIndex, String title) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g2d, textRect);
            return;
        }
        if (title == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(tabIndex);
        if (color instanceof UIResource) {
            g2d.setColor(AquaTabbedPaneContrastUI.getNonSelectedTabTitleColor());
            if (this.tabPane.getSelectedIndex() == tabIndex) {
                boolean pressed = this.isPressedAt(tabIndex);
                boolean enabled = this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex);
                Color textColor = AquaTabbedPaneContrastUI.getSelectedTabTitleColor(enabled, pressed);
                Color shadowColor = AquaTabbedPaneContrastUI.getSelectedTabTitleShadowColor(enabled);
                AquaUtils.paintDropShadowText(g2d, this.tabPane, font, metrics, textRect.x, textRect.y, 0, 1, textColor, shadowColor, title);
                return;
            }
        } else {
            g2d.setColor(color);
        }
        g2d.setFont(font);
        SwingUtilities2.drawString((JComponent)this.tabPane, (Graphics)g2d, title, textRect.x, textRect.y + metrics.getAscent());
    }

    protected static Color getSelectedTabTitleColor(boolean enabled, boolean pressed) {
        if (enabled && pressed) {
            return UIManager.getColor("TabbedPane.selectedTabTitlePressedColor");
        }
        if (!enabled) {
            return UIManager.getColor("TabbedPane.selectedTabTitleDisabledColor");
        }
        return UIManager.getColor("TabbedPane.selectedTabTitleNormalColor");
    }

    protected static Color getSelectedTabTitleShadowColor(boolean enabled) {
        return enabled ? UIManager.getColor("TabbedPane.selectedTabTitleShadowNormalColor") : UIManager.getColor("TabbedPane.selectedTabTitleShadowDisabledColor");
    }

    protected static Color getNonSelectedTabTitleColor() {
        return UIManager.getColor("TabbedPane.nonSelectedTabTitleNormalColor");
    }

    protected boolean isPressedAt(int index) {
        return ((AquaTabbedPaneUI.MouseHandler)this.mouseListener).trackingTab == index;
    }

    @Override
    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return true;
    }

    @Override
    protected JRSUIConstants.State getState(int index, boolean frameActive, boolean isSelected) {
        if (!frameActive) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!this.tabPane.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.pressedTab == index) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    protected JRSUIConstants.SegmentTrailingSeparator getSegmentTrailingSeparator(int index, int selectedIndex, boolean isLeftToRight) {
        if (this.isTabBeforeSelectedTab(index, selectedIndex, isLeftToRight)) {
            return JRSUIConstants.SegmentTrailingSeparator.NO;
        }
        return JRSUIConstants.SegmentTrailingSeparator.YES;
    }

    @Override
    protected JRSUIConstants.SegmentLeadingSeparator getSegmentLeadingSeparator(int index, int selectedIndex, boolean isLeftToRight) {
        if (index == selectedIndex) {
            return JRSUIConstants.SegmentLeadingSeparator.YES;
        }
        return JRSUIConstants.SegmentLeadingSeparator.NO;
    }
}

