/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class AquaOptionPaneUI
extends BasicOptionPaneUI {
    private static final int kOKCancelButtonWidth = 79;
    private static final int kButtonHeight = 23;
    private static final int kDialogSmallPadding = 4;
    private static final int kDialogLargePadding = 23;

    public static ComponentUI createUI(JComponent x) {
        return new AquaOptionPaneUI();
    }

    @Override
    protected Container createButtonArea() {
        Container bottom = super.createButtonArea();
        bottom.setLayout(new AquaButtonAreaLayout(true, 4));
        return bottom;
    }

    @Override
    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        top.setLayout(new BoxLayout(top, 0));
        JPanel body = new JPanel();
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setVerticalAlignment(1);
            JPanel iconPanel = new JPanel();
            iconPanel.add(iconLabel);
            top.add(iconPanel);
            top.add(Box.createHorizontalStrut(23));
        }
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add(body);
        return top;
    }

    public static class AquaButtonAreaLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        public AquaButtonAreaLayout(boolean syncAllWidths, int padding) {
            super(true, padding);
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children == null || 0 >= children.length) {
                return;
            }
            int numChildren = children.length;
            int yLocation = container.getInsets().top;
            Dimension maxSize = new Dimension(79, 23);
            for (int i = 0; i < numChildren; ++i) {
                Dimension sizes = children[i].getPreferredSize();
                maxSize.width = Math.max(maxSize.width, sizes.width);
                maxSize.height = Math.max(maxSize.height, sizes.height);
            }
            int xLocation = container.getSize().width - (maxSize.width * numChildren + (numChildren - 1) * this.padding);
            int xOffset = maxSize.width + this.padding;
            for (int i = numChildren - 1; i >= 0; --i) {
                children[i].setBounds(xLocation, yLocation, maxSize.width, maxSize.height);
                xLocation += xOffset;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                Insets cInsets = c.getInsets();
                int extraHeight = cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int okCancelButtonWidth = extraWidth + 79 * numChildren + (numChildren - 1) * this.padding;
                int okbuttonHeight = extraHeight + 23;
                Dimension minSize = super.minimumLayoutSize(c);
                return new Dimension(Math.max(minSize.width, okCancelButtonWidth), Math.max(minSize.height, okbuttonHeight));
            }
            return new Dimension(0, 0);
        }
    }
}

